/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.AwardStatus;
import org.kuali.kra.award.home.AwardTemplateComment;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.award.home.AwardTemplateReportTerm;
import org.kuali.kra.award.home.AwardTemplateTerm;

public class AwardTemplate
extends KcPersistableBusinessObjectBase {
    private static final long serialVersionUID = -3038831932003349194L;
    private String statusCode;
    private String description;
    private AwardStatus awardTemplateStatus;
    private Integer templateCode;
    private String primeSponsorCode;
    private String nonCompetingContPrpslDueCode;
    private String competingRenewalPrpslDueCode;
    private String basisOfPaymentCode;
    private String methodOfPaymentCode;
    private Sponsor primeSponsor;
    private AwardBasisOfPayment awardBasisOfPayment;
    private AwardMethodOfPayment awardMethodOfPayment;
    private List<AwardTemplateReportTerm> templateReportTerms;
    private List<AwardTemplateComment> templateComments;
    private List<AwardTemplateContact> templateContacts = new ArrayList<AwardTemplateContact>();
    private List<AwardTemplateTerm> templateTerms;

    public AwardTemplate() {
        this.templateComments = new ArrayList<AwardTemplateComment>();
        this.templateTerms = new ArrayList<AwardTemplateTerm>();
        this.templateReportTerms = new ArrayList<AwardTemplateReportTerm>();
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public AwardStatus getAwardTemplateStatus() {
        return this.awardTemplateStatus;
    }

    public void setAwardTemplateStatus(AwardStatus awardTemplateStatus) {
        this.awardTemplateStatus = awardTemplateStatus;
    }

    public List<AwardTemplateReportTerm> getTemplateReportTerms() {
        return this.templateReportTerms;
    }

    public void setTemplateReportTerms(List<AwardTemplateReportTerm> templateReportTerms) {
        this.templateReportTerms = templateReportTerms;
    }

    public List<AwardTemplateContact> getTemplateContacts() {
        return this.templateContacts;
    }

    public void setTemplateContacts(List<AwardTemplateContact> templateContacts) {
        this.templateContacts = templateContacts;
    }

    public List<AwardTemplateComment> getTemplateComments() {
        return this.templateComments;
    }

    public void setTemplateComments(List<AwardTemplateComment> templateComments) {
        this.templateComments = templateComments;
    }

    public List<AwardTemplateTerm> getTemplateTerms() {
        if (this.templateTerms != null) {
            Collections.sort(this.templateTerms, new Comparator(){

                public int compare(Object o1, Object o2) {
                    AwardTemplateTerm templateTermFirst = (AwardTemplateTerm)o1;
                    AwardTemplateTerm templateTermSecond = (AwardTemplateTerm)o2;
                    String sponsorTermTypeCodeFirst = null;
                    String sponsorTermTypeCodeSecond = null;
                    if (templateTermFirst == null || templateTermSecond == null) {
                        return 0;
                    }
                    if (templateTermFirst.isNewCollectionRecord() || templateTermSecond.isNewCollectionRecord()) {
                        return 0;
                    }
                    if (templateTermFirst.getSponsorTerm() == null || templateTermSecond.getSponsorTerm() == null) {
                        return 0;
                    }
                    if (templateTermFirst.getSponsorTerm() != null) {
                        sponsorTermTypeCodeFirst = templateTermFirst.getSponsorTerm().getSponsorTermTypeCode();
                    }
                    if (templateTermSecond.getSponsorTerm() != null) {
                        sponsorTermTypeCodeSecond = templateTermSecond.getSponsorTerm().getSponsorTermTypeCode();
                    }
                    return sponsorTermTypeCodeFirst.compareTo(sponsorTermTypeCodeSecond);
                }
            });
        }
        return this.templateTerms;
    }

    public void setTemplateTerms(List<AwardTemplateTerm> templateTerms) {
        this.templateTerms = templateTerms;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AwardTemplateComment> getAwardComments() {
        return this.getTemplateComments();
    }

    public List<AwardTemplateReportTerm> getAwardReportTermItems() {
        return this.getTemplateReportTerms();
    }

    public List<AwardTemplateTerm> getAwardSponsorTerms() {
        return this.getTemplateTerms();
    }

    public List<AwardTemplateContact> getSponsorContacts() {
        return this.getTemplateContacts();
    }

    public Integer getTemplateCode() {
        return this.templateCode;
    }

    public void setTemplateCode(Integer templateCode) {
        this.templateCode = templateCode;
    }

    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
    }

    public String getNonCompetingContPrpslDueCode() {
        return this.nonCompetingContPrpslDueCode;
    }

    public void setNonCompetingContPrpslDueCode(String nonCompetingContPrpslDueCode) {
        this.nonCompetingContPrpslDueCode = nonCompetingContPrpslDueCode;
    }

    public String getCompetingRenewalPrpslDueCode() {
        return this.competingRenewalPrpslDueCode;
    }

    public void setCompetingRenewalPrpslDueCode(String competingRenewalPrpslDueCode) {
        this.competingRenewalPrpslDueCode = competingRenewalPrpslDueCode;
    }

    public String getBasisOfPaymentCode() {
        return this.basisOfPaymentCode;
    }

    public void setBasisOfPaymentCode(String basisOfPaymentCode) {
        this.basisOfPaymentCode = basisOfPaymentCode;
    }

    public String getMethodOfPaymentCode() {
        return this.methodOfPaymentCode;
    }

    public void setMethodOfPaymentCode(String methodOfPaymentCode) {
        this.methodOfPaymentCode = methodOfPaymentCode;
    }

    public AwardBasisOfPayment getAwardBasisOfPayment() {
        return this.awardBasisOfPayment;
    }

    public void setAwardBasisOfPayment(AwardBasisOfPayment awardBasisOfPayment) {
        this.awardBasisOfPayment = awardBasisOfPayment;
    }

    public AwardMethodOfPayment getAwardMethodOfPayment() {
        return this.awardMethodOfPayment;
    }

    public void setAwardMethodOfPayment(AwardMethodOfPayment awardMethodOfPayment) {
        this.awardMethodOfPayment = awardMethodOfPayment;
    }

    public Sponsor getPrimeSponsor() {
        return this.primeSponsor;
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getTemplateTerms());
        managedLists.add(this.getAwardComments());
        managedLists.add(this.getTemplateReportTerms());
        managedLists.add(this.getTemplateContacts());
        ArrayList rcpts = new ArrayList();
        for (AwardTemplateReportTerm rt : this.getTemplateReportTerms()) {
            rcpts.addAll(rt.getAwardReportTermRecipients());
        }
        managedLists.add(rcpts);
        return managedLists;
    }

    public void processAfterCopy() {
        this.setTemplateCode(null);
        for (AwardTemplateReportTerm tempReportTerm : this.getTemplateReportTerms()) {
            tempReportTerm.setTemplateReportTermId(null);
        }
        for (AwardTemplateComment tempComment : this.getTemplateComments()) {
            tempComment.setTemplateCommentsId(null);
        }
        for (AwardTemplateContact tempContact : this.getTemplateContacts()) {
            tempContact.setTemplateContactId(null);
        }
        for (AwardTemplateTerm tempTerm : this.getTemplateTerms()) {
            tempTerm.setAwardTemplateTermId(null);
        }
    }

    public void removeInactiveItems() {
        this.setTemplateTerms(this.getTemplateTerms().stream().filter(AwardTemplateTerm::isActive).collect(Collectors.toList()));
    }
}

