/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.distribution;

import java.util.Iterator;
import java.util.List;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.impl.core.ValidationHelper;
import org.kuali.coeus.common.budget.impl.distribution.AddBudgetUnrecoveredFandAEvent;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetUnrecoveredFandARule")
public class BudgetUnrecoveredFandARuleImpl {
    private static final String ADD_ERROR_KEY = "error.custom";
    @Autowired
    @Qualifier(value="validationHelper")
    private ValidationHelper validationHelper;

    @KcEventMethod
    public boolean processAddBudgetUnrecoveredFandABusinessRules(AddBudgetUnrecoveredFandAEvent event) {
        return !this.areDuplicatesPresent(event.getBudget(), event.getBudgetUnrecoveredFandA());
    }

    private boolean areDuplicatesPresent(Budget budget, BudgetUnrecoveredFandA testBudgetUnrecoveredFandA) {
        BudgetUnrecoveredFandA budgetUnrecoveredFandA;
        boolean duplicate = false;
        if (testBudgetUnrecoveredFandA == null) {
            return duplicate;
        }
        List<BudgetUnrecoveredFandA> budgetUnrecoveredFandAs = budget.getBudgetUnrecoveredFandAs();
        Iterator<BudgetUnrecoveredFandA> iterator = budgetUnrecoveredFandAs.iterator();
        while (iterator.hasNext() && !(duplicate = this.checkForDuplicateFields(testBudgetUnrecoveredFandA, budgetUnrecoveredFandA = iterator.next()))) {
        }
        return duplicate;
    }

    private boolean checkForDuplicateFields(BudgetUnrecoveredFandA testBudgetUnrecoveredFandA, BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        boolean duplicate = testBudgetUnrecoveredFandA.equals(budgetUnrecoveredFandA);
        if (duplicate) {
            GlobalVariables.getMessageMap().putError("newUnrecoveredFandA.*", ADD_ERROR_KEY, new String[]{"A duplicate Unrecovered F&A exists in the table"});
        }
        return duplicate;
    }

    public ValidationHelper getValidationHelper() {
        return this.validationHelper;
    }

    public void setValidationHelper(ValidationHelper validationHelper) {
        this.validationHelper = validationHelper;
    }
}

