/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.auth;

import java.util.HashMap;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="unitAuthorizationService")
public class UnitAuthorizationServiceImpl
implements UnitAuthorizationService {
    public static final String UNIT_NUMBER = "unitNumber";
    @Autowired
    @Qualifier(value="systemAuthorizationService")
    private SystemAuthorizationService systemAuthorizationService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleManagementService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;

    protected RoleService getRoleService() {
        return this.roleManagementService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        return this.systemAuthorizationService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public boolean hasPermission(String userId, String unitNumber, String namespaceCode, String permissionName) {
        boolean userHasPermission = false;
        if (unitNumber != null) {
            HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
            qualifiedRoleAttributes.put(UNIT_NUMBER, unitNumber);
            userHasPermission = this.permissionService.isAuthorized(userId, namespaceCode, permissionName, qualifiedRoleAttributes);
        }
        return userHasPermission;
    }

    @Override
    public boolean hasPermission(String userId, String namespaceCode, String permissionName) {
        boolean userHasPermission = false;
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(UNIT_NUMBER, "*");
        userHasPermission = this.permissionService.isAuthorized(userId, namespaceCode, permissionName, qualifiedRoleAttributes);
        return userHasPermission;
    }
}

