/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.citi;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.citi.CitiDataLoadingService;
import org.kuali.coeus.common.framework.person.citi.CitiDataProcessingService;
import org.kuali.coeus.common.framework.person.citi.CitiJob;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.krad.UserSession;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component(value="citiJob")
public class CitiJobImpl
extends QuartzJobBean
implements CitiJob {
    private static final Logger LOG = LogManager.getLogger(CitiJobImpl.class);
    private static final String KC_SYSTEM_PRINCIPAL_NM = "kc";
    private CitiDataProcessingService citiDataProcessingService;
    private GlobalVariableService globalVariableService;
    private CitiDataLoadingService citiDataLoadingService;

    @Override
    public void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.info("Starting CITI job");
        this.getGlobalVariableService().doInNewGlobalVariables(new UserSession(KC_SYSTEM_PRINCIPAL_NM), () -> {
            this.getCitiDataLoadingService().loadRecords();
            this.getCitiDataProcessingService().processRecords();
            return null;
        });
        LOG.info("Finished CITI job");
    }

    public CitiDataProcessingService getCitiDataProcessingService() {
        return this.citiDataProcessingService;
    }

    public void setCitiDataProcessingService(CitiDataProcessingService citiDataProcessingService) {
        this.citiDataProcessingService = citiDataProcessingService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public CitiDataLoadingService getCitiDataLoadingService() {
        return this.citiDataLoadingService;
    }

    public void setCitiDataLoadingService(CitiDataLoadingService citiDataLoadingService) {
        this.citiDataLoadingService = citiDataLoadingService;
    }
}

