/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.nih;

import gov.nih.era.external.SubmissionValidationServiceStub;
import gov.nih.era.external.ValidateApplicationError;
import gov.nih.era.svs.types.AttachmentMetaData;
import gov.nih.era.svs.types.ValidateApplicationRequest;
import gov.nih.era.svs.types.ValidateApplicationResponse;
import gov.nih.era.svs.types.ValidateComponentRequest;
import gov.nih.era.svs.types.ValidationMessageList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.nih.NihServiceBase;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionValidationService;
import org.kuali.coeus.propdev.impl.s2s.nih.ValidationMessageDto;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.springframework.stereotype.Component;

@Component(value="nihSubmissionValidationService")
public class NihSubmissionValidationServiceImpl
extends NihServiceBase
implements NihSubmissionValidationService {
    private static final String NIH_GOV_S2S_HOST = "nih.gov.s2s.host";
    private static final String NIH_GOV_S2S_PORT = "nih.gov.s2s.port";
    private static final String APPLICATION_PDF = "application/pdf";
    private static final Logger LOG = LogManager.getLogger(NihSubmissionValidationServiceImpl.class);

    @Override
    public String getServiceHost() {
        return this.getS2SConfigurationService().getValueAsString(NIH_GOV_S2S_HOST);
    }

    @Override
    public String getServicePort() {
        return this.getS2SConfigurationService().getValueAsString(NIH_GOV_S2S_PORT);
    }

    @Override
    public List<ValidationMessageDto> validateApplication(String xmlText, List<AttachmentData> attachments, String dunsNumber) {
        if (StringUtils.isBlank((CharSequence)xmlText) || !this.isNihServiceEnabled()) {
            return Collections.emptyList();
        }
        return (List)this.optionallyCache(Objects.hash(xmlText, attachments, dunsNumber), () -> this.callValidateApplication(xmlText, attachments, dunsNumber));
    }

    protected List<ValidationMessageDto> callValidateApplication(String xmlText, List<AttachmentData> attachments, String dunsNumber) {
        ValidateApplicationRequest parameters = new ValidateApplicationRequest();
        parameters.setGrantApplicationXML(xmlText);
        if (attachments != null) {
            List<AttachmentMetaData> attachmentMetaDatas = parameters.getAttachmentMetaData();
            attachments.stream().map(this::toAttachmentMetaData).forEach(attachmentMetaDatas::add);
        }
        try {
            this.debugLogJaxbObject(ValidateApplicationRequest.class, parameters, LOG);
            SubmissionValidationServiceStub serviceStub = this.createConfiguredService(dunsNumber, SubmissionValidationServiceStub.class);
            ValidateApplicationResponse response = serviceStub.validateApplication(parameters);
            if (response.getValidationMessageList() == null) {
                response.setValidationMessageList(new ValidationMessageList());
            }
            this.debugLogJaxbObject(ValidateApplicationResponse.class, response, LOG);
            return this.toDtos(response);
        }
        catch (ValidateApplicationError | SOAPFaultException validateApplicationError) {
            throw new S2sCommunicationException("error.nih.service.unknown", (Exception)validateApplicationError);
        }
    }

    @Override
    public List<ValidationMessageDto> validateComponent(String xmlText, List<AttachmentData> attachments, String dunsNumber, String opportunityId) {
        if (StringUtils.isBlank((CharSequence)xmlText) || !this.isNihServiceEnabled()) {
            return Collections.emptyList();
        }
        return (List)this.optionallyCache(Objects.hash(xmlText, attachments, dunsNumber, opportunityId), () -> this.callValidateComponent(xmlText, attachments, dunsNumber, opportunityId));
    }

    protected List<ValidationMessageDto> callValidateComponent(String xmlText, List<AttachmentData> attachments, String dunsNumber, String opportunityId) {
        ValidateComponentRequest parameters = new ValidateComponentRequest();
        parameters.setComponentXML(xmlText);
        parameters.setOpportunityID(opportunityId);
        if (attachments != null) {
            List<AttachmentMetaData> attachmentMetaDatas = parameters.getAttachmentMetaData();
            attachments.stream().map(this::toAttachmentMetaData).forEach(attachmentMetaDatas::add);
        }
        try {
            this.debugLogJaxbObject(ValidateApplicationRequest.class, parameters, LOG);
            SubmissionValidationServiceStub serviceStub = this.createConfiguredService(dunsNumber, SubmissionValidationServiceStub.class);
            ValidateApplicationResponse response = serviceStub.validateComponent(parameters);
            if (response.getValidationMessageList() == null) {
                response.setValidationMessageList(new ValidationMessageList());
            }
            this.debugLogJaxbObject(ValidateApplicationResponse.class, response, LOG);
            return this.toDtos(response);
        }
        catch (ValidateApplicationError | SOAPFaultException validateApplicationError) {
            throw new S2sCommunicationException("error.nih.service.unknown", (Exception)validateApplicationError);
        }
    }

    private List<ValidationMessageDto> toDtos(ValidateApplicationResponse response) {
        if (response == null || response.getValidationMessageList() == null) {
            return Collections.emptyList();
        }
        return response.getValidationMessageList().getValidationMessage().stream().map(vm -> {
            ValidationMessageDto dto = new ValidationMessageDto();
            dto.setValidationSubApplicationGroupID(vm.getValidationSubApplicationGroupID());
            dto.setValidationSubApplicationID(vm.getValidationSubApplicationID());
            dto.setValidationRuleNumber(vm.getValidationRuleNumber());
            dto.setValidationSeverityCode(vm.getValidationSeverityCode());
            dto.setValidationMessageText(vm.getValidationMessageText());
            dto.setValidationMessageId(vm.getValidationMessageId());
            dto.setFormName(vm.getFormName());
            return dto;
        }).collect(Collectors.toList());
    }

    private AttachmentMetaData toAttachmentMetaData(AttachmentData attachment) {
        AttachmentMetaData attachmentMetaData = new AttachmentMetaData();
        attachmentMetaData.setFileLocation(attachment.getContentId());
        attachmentMetaData.setFileName(attachment.getFileName());
        attachmentMetaData.setMimeType(attachment.getFileName().toLowerCase().endsWith(".pdf") ? APPLICATION_PDF : attachment.getContentType());
        attachmentMetaData.setSizeInBytes(attachment.getContent().length);
        attachmentMetaData.setPageCount(this.getPageCount(attachment));
        return attachmentMetaData;
    }

    private int getPageCount(AttachmentData attachment) {
        int n;
        block8: {
            PDDocument document = PDDocument.load((byte[])attachment.getContent());
            try {
                n = document.getNumberOfPages();
                if (document == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    LOG.warn((Object)e);
                    return 1;
                }
            }
            document.close();
        }
        return n;
    }
}

