/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.service;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncDescendantValues;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncSelectorService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class AwardSyncSelectorServiceImpl
implements AwardSyncSelectorService {
    private ParameterService parameterService;

    @Override
    public boolean isAwardInvolvedInSync(Award award, List<AwardSyncChange> changes) {
        for (AwardSyncChange change : changes) {
            if (!this.isChangeApplicableToAward(award, change)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChangeApplicableToAward(Award award, AwardSyncChange change) {
        boolean retval = false;
        if (StringUtils.equals((CharSequence)change.getSyncDescendants(), (CharSequence)AwardSyncDescendantValues.SYNC_ACTIVE.getSyncValue()) && this.isAwardActive(award) || StringUtils.equals((CharSequence)change.getSyncDescendants(), (CharSequence)AwardSyncDescendantValues.SYNC_ALL.getSyncValue())) {
            if (this.isFabricatedAccount(award) && change.isSyncFabricated()) {
                retval = true;
            }
            if (this.isCostShareAccount(award) && change.isSyncCostSharing()) {
                retval = true;
            }
            if (!this.isFabricatedAccount(award) && !this.isCostShareAccount(award)) {
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public boolean isAwardActive(Award award) {
        String activeParm = this.getParameterService().getParameterValueAsString(AwardDocument.class, "AWARD_ACTIVE_STATUS_CODES");
        for (String activeCode : activeParm.split(",")) {
            if (!StringUtils.equals((CharSequence)award.getAwardStatus().getStatusCode(), (CharSequence)activeCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCostShareAccount(Award award) {
        String sponsorCode = this.getParameterService().getParameterValueAsString(AwardDocument.class, "AWARD_COST_SHARING");
        return StringUtils.equals((CharSequence)award.getSponsorCode(), (CharSequence)sponsorCode);
    }

    @Override
    public boolean isFabricatedAccount(Award award) {
        String typeCode = this.getParameterService().getParameterValueAsString(AwardDocument.class, "AWARD_FABRICATED_EQUIPMENT");
        return Objects.equals(award.getAccountTypeCode(), Integer.valueOf(typeCode));
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }
}

