/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.notification;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.notification.AwardNotificationRenderer;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;

public class AwardReportTrackingNotificationRenderer
extends AwardNotificationRenderer {
    private static final long serialVersionUID = -2035058699415467934L;
    protected static final String START_REPEAT_SECTION = "{BEGIN_REPEAT_SECTION}";
    protected static final String END_REPEAT_SECTION = "{END_REPEAT_SECTION}";
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private List<ReportTracking> reports;

    public AwardReportTrackingNotificationRenderer() {
    }

    public AwardReportTrackingNotificationRenderer(List<ReportTracking> reports) {
        this.reports = reports;
    }

    protected Map<String, String> getReportReplacementParameters(ReportTracking report) {
        Map<String, String> result = this.getAwardReplacementParameters(report.getAward());
        SimpleDateFormat dateFormatter = new SimpleDateFormat(MM_DD_YYYY);
        if (report.getReportClass() == null) {
            report.refreshReferenceObject("reportClass");
        }
        result.put("{REPORT_CLASS}", report.getReportClass().getDescription());
        if (report.getReport() == null) {
            report.refreshReferenceObject("report");
        }
        result.put("{REPORT_TYPE}", report.getReport().getDescription());
        result.put("{REPORT_DUE_DATE}", dateFormatter.format(report.getDueDate()));
        result.put("{COMMENTS}", report.getComments() != null ? report.getComments() : "");
        result.put(START_REPEAT_SECTION, "");
        result.put(END_REPEAT_SECTION, "");
        return result;
    }

    @Override
    public String render(String text) {
        int startIndex = StringUtils.indexOf((CharSequence)text, (CharSequence)START_REPEAT_SECTION);
        int endIndex = StringUtils.indexOf((CharSequence)text, (CharSequence)END_REPEAT_SECTION) + END_REPEAT_SECTION.length();
        String startStr = text.substring(0, startIndex);
        String repeatedStr = text.substring(startIndex, endIndex);
        String endStr = text.substring(endIndex);
        StringBuilder buffer = new StringBuilder();
        buffer.append(startStr);
        this.reports.forEach(report -> buffer.append(this.render(repeatedStr, this.getReportReplacementParameters((ReportTracking)report))));
        buffer.append(endStr);
        return buffer.toString();
    }

    public List<ReportTracking> getReports() {
        return this.reports;
    }

    public void setReports(List<ReportTracking> reports) {
        this.reports = reports;
    }
}

