/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.service.impl;

import java.util.Map;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.print.AwardBudgetHierarchyPrint;
import org.kuali.kra.award.printing.print.AwardBudgetHistoryTransactionPrint;
import org.kuali.kra.award.printing.print.AwardDeltaPrint;
import org.kuali.kra.award.printing.print.AwardNoticePrint;
import org.kuali.kra.award.printing.print.AwardTemplatePrint;
import org.kuali.kra.award.printing.print.MoneyAndEndDatesHistoryPrint;
import org.kuali.kra.award.printing.service.AwardPrintingService;

public class AwardPrintingServiceImpl
implements AwardPrintingService {
    private AwardDeltaPrint awardDeltaPrint;
    private AwardNoticePrint awardNoticePrint;
    private AwardTemplatePrint awardTemplatePrint;
    private MoneyAndEndDatesHistoryPrint moneyAndEndDatesHistoryPrint;
    private AwardBudgetHierarchyPrint awardBudgetHierarchyPrint;
    private AwardBudgetHistoryTransactionPrint awardBudgetHistoryTransactionPrint;
    private PrintingService printingService;

    @Override
    public AttachmentDataSource printAwardReport(KcPersistableBusinessObjectBase printableBO, AwardPrintType awardReportType, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        AbstractPrint printable = null;
        String repoprtFileNamePrefix = "";
        switch (awardReportType) {
            case AWARD_DELTA_REPORT: {
                printable = this.getAwardDeltaPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case AWARD_NOTICE_REPORT: {
                printable = this.getAwardNoticePrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case MONEY_AND_END_DATES_HISTORY: {
                printable = this.getMoneyAndEndDatesHistoryPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case AWARD_BUDGET_HIERARCHY: {
                printable = this.getAwardBudgetHierarchyPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case AWARD_BUDGET_HISTORY_TRANSACTION: {
                printable = this.getAwardBudgetHistoryTransactionPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case AWARD_TEMPLATE: {
                printable = this.getAwardTemplatePrint();
                repoprtFileNamePrefix = ((AwardTemplate)printableBO).getTemplateCode().toString();
            }
        }
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBO);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print(printable);
            source.setName(this.getReportName(repoprtFileNamePrefix, awardReportType.getAwardPrintType()));
            source.setType("application/pdf");
        }
        return source;
    }

    protected String getReportName(String reportFileNamePrefix, String reportName) {
        StringBuilder reportFullName = new StringBuilder(reportFileNamePrefix).append("_").append(reportName.replace(' ', '_')).append(".pdf");
        return reportFullName.toString();
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public AwardDeltaPrint getAwardDeltaPrint() {
        return this.awardDeltaPrint;
    }

    public void setAwardDeltaPrint(AwardDeltaPrint awardDeltaPrint) {
        this.awardDeltaPrint = awardDeltaPrint;
    }

    public AwardNoticePrint getAwardNoticePrint() {
        return this.awardNoticePrint;
    }

    public void setAwardNoticePrint(AwardNoticePrint awardNoticePrint) {
        this.awardNoticePrint = awardNoticePrint;
    }

    public AwardTemplatePrint getAwardTemplatePrint() {
        return this.awardTemplatePrint;
    }

    public void setAwardTemplatePrint(AwardTemplatePrint awardTemplatePrint) {
        this.awardTemplatePrint = awardTemplatePrint;
    }

    public MoneyAndEndDatesHistoryPrint getMoneyAndEndDatesHistoryPrint() {
        return this.moneyAndEndDatesHistoryPrint;
    }

    public void setMoneyAndEndDatesHistoryPrint(MoneyAndEndDatesHistoryPrint moneyAndEndDatesHistoryPrint) {
        this.moneyAndEndDatesHistoryPrint = moneyAndEndDatesHistoryPrint;
    }

    public AwardBudgetHierarchyPrint getAwardBudgetHierarchyPrint() {
        return this.awardBudgetHierarchyPrint;
    }

    public void setAwardBudgetHierarchyPrint(AwardBudgetHierarchyPrint awardBudgetHierarchyPrint) {
        this.awardBudgetHierarchyPrint = awardBudgetHierarchyPrint;
    }

    public AwardBudgetHistoryTransactionPrint getAwardBudgetHistoryTransactionPrint() {
        return this.awardBudgetHistoryTransactionPrint;
    }

    public void setAwardBudgetHistoryTransactionPrint(AwardBudgetHistoryTransactionPrint awardBudgetHistoryTransactionPrint) {
        this.awardBudgetHistoryTransactionPrint = awardBudgetHistoryTransactionPrint;
    }
}

