/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.budgetNarrativeAttachments12V12.BudgetNarrativeAttachments12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.BudgetBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="BudgetV1_2Generator")
public class BudgetV1_2Generator
extends BudgetBaseGenerator<BudgetNarrativeAttachments12Document> {
    @Value(value="http://apply.grants.gov/forms/BudgetNarrativeAttachments_1_2-V1.2")
    private String namespace;
    @Value(value="Budget-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/Budget-V1.2.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/BudgetNarrativeAttachments_1_2-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    private BudgetNarrativeAttachments12Document getBudgetNarrativeAttachmentsDocument() {
        BudgetNarrativeAttachments12Document budgetNarrativeAttachmentsDocument = (BudgetNarrativeAttachments12Document)BudgetNarrativeAttachments12Document.Factory.newInstance();
        BudgetNarrativeAttachments12Document.BudgetNarrativeAttachments12 budgetNarrativeAttachments = (BudgetNarrativeAttachments12Document.BudgetNarrativeAttachments12)BudgetNarrativeAttachments12Document.BudgetNarrativeAttachments12.Factory.newInstance();
        budgetNarrativeAttachments.setFormVersion(FormVersion.v1_2.getVersion());
        AttachmentGroupMin1Max100DataType attachmentGroupMin1Max100DataType = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroupMin1Max100DataType.setAttachedFileArray(this.getAttachedFileDataTypes());
        budgetNarrativeAttachments.setAttachments(attachmentGroupMin1Max100DataType);
        budgetNarrativeAttachmentsDocument.setBudgetNarrativeAttachments12(budgetNarrativeAttachments);
        return budgetNarrativeAttachmentsDocument;
    }

    @Override
    public BudgetNarrativeAttachments12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getBudgetNarrativeAttachmentsDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(BudgetNarrativeAttachments12Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getBudgetNarrativeAttachments12().getAttachments() != null) {
                List<AttachedFileDataType> attachedFileList = form.getBudgetNarrativeAttachments12().getAttachments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); ++i) {
                    AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (i == 0 && a.getContentId().equals(attachedFile.getFileLocation().getHref())) {
                        return CollectionUtils.entry("BudgetNarrativeAttachments_1_2_P1.mandatoryFile0", a);
                    }
                    if (i <= 0 || !a.getContentId().equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("BudgetNarrativeAttachments_1_2_P1.optionalFile" + (i - 1), a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<BudgetNarrativeAttachments12Document> factory() {
        return BudgetNarrativeAttachments12Document.Factory;
    }
}

