/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.ed524Budget14V14.ApprovingFederalAgencyDataType;
import gov.grants.apply.forms.ed524Budget14V14.ED524Budget14Document;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationIndirectcostContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.BudgetPeriodNum;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.ED524BudgetBaseGenerator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="ED524BudgetV1_4Generator")
public class ED524BudgetV1_4Generator
extends ED524BudgetBaseGenerator<ED524Budget14Document>
implements S2SFormGeneratorPdfFillable<ED524Budget14Document> {
    public static final String DEFAULT = "D";
    public static final String ON_CAMPUS = "N";
    public static final int RESTRICTED_PROGRAM_QUESTION_ID = -10120;
    public static final int TRAINING_PROGRAM_QUESTION_ID = -10146;
    public static final String OVERHEAD = "O";
    @Value(value="http://apply.grants.gov/forms/ED_524_Budget_1_4-V1.4")
    private String namespace;
    @Value(value="ED_524_Budget_1_4-V1.4")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_524_Budget_1_4-V1.4.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ED_524_Budget_1_4-V1.4.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    protected ED524Budget14Document getED524Budget() {
        ED524Budget14Document ed524BudgetDocument = (ED524Budget14Document)ED524Budget14Document.Factory.newInstance();
        ED524Budget14Document.ED524Budget14 ed524Budget = (ED524Budget14Document.ED524Budget14)ED524Budget14Document.ED524Budget14.Factory.newInstance();
        ed524Budget.setFormVersion(FormVersion.v1_4.getVersion());
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            ed524Budget.setLEGALNAME(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
        } else {
            ed524Budget.setLEGALNAME("NONE");
        }
        ScaleTwoDecimal totalPersonnel = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalPersonnelCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalFringe = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalFringeCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTravel = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTravelCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalEquip = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalEquipCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalSupplies = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalSuppliesCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalContractual = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalContractualCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalConstruction = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalConstructionCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalOther = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalOtherCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTraining = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTrainingCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalCostAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalCostSharingAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDirectCostAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDirectCostAllYrsCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCostAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCostAllYrsCS = ScaleTwoDecimal.ZERO;
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget == null) {
            return ed524BudgetDocument;
        }
        for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
            ScaleTwoDecimal totalCategoryCS;
            if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P1.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFirstYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFirstYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFirstYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFirstYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (ScaleTwoDecimal)totalCostAllYrs.add((AbstractDecimal)this.totalCost);
                totalCostSharingAllYrs = (ScaleTwoDecimal)totalCostSharingAllYrs.add((AbstractDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (ScaleTwoDecimal)totalDirectCostAllYrs.add((AbstractDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (ScaleTwoDecimal)totalIndirectCostAllYrs.add((AbstractDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFirstYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (ScaleTwoDecimal)totalIndirectCostAllYrsCS.add((AbstractDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFirstYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFirstYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.supplyCostCS);
                totalSupplies = (ScaleTwoDecimal)totalSupplies.add((AbstractDecimal)this.supplyCost);
                totalSuppliesCS = (ScaleTwoDecimal)totalSuppliesCS.add((AbstractDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionFirstYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFirstYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFirstYearAmount(this.otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFirstYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.otherCostCS);
                totalOther = (ScaleTwoDecimal)totalOther.add((AbstractDecimal)this.otherCost);
                totalOtherCS = (ScaleTwoDecimal)totalOtherCS.add((AbstractDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFirstYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFirstYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.equipmentCostCS);
                totalEquip = (ScaleTwoDecimal)totalEquip.add((AbstractDecimal)this.equipmentCost);
                totalEquipCS = (ScaleTwoDecimal)totalEquipCS.add((AbstractDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFirstYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFirstYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.contractualCostCS);
                totalContractual = (ScaleTwoDecimal)totalContractual.add((AbstractDecimal)this.contractualCost);
                totalContractualCS = (ScaleTwoDecimal)totalContractualCS.add((AbstractDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFirstYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFirstYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.travelCostCS);
                totalTravel = (ScaleTwoDecimal)totalTravel.add((AbstractDecimal)this.travelCost);
                totalTravelCS = (ScaleTwoDecimal)totalTravelCS.add((AbstractDecimal)this.travelCostCS);
                this.getTrainingCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTrainingFirstYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFirstYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (ScaleTwoDecimal)totalTraining.add((AbstractDecimal)this.trainingCost);
                totalTrainingCS = (ScaleTwoDecimal)totalTrainingCS.add((AbstractDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeFirstYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFirstYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.categoryCostCSFringe);
                totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)this.categoryCostFringe);
                totalFringeCS = (ScaleTwoDecimal)totalFringeCS.add((AbstractDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFirstYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFirstYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.personnelCostCS);
                totalPersonnel = (ScaleTwoDecimal)totalPersonnel.add((AbstractDecimal)this.personnelCost);
                totalPersonnelCS = (ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectFirstYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P2.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSecondYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSecondYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectSecondYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectSecondYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (ScaleTwoDecimal)totalCostAllYrs.add((AbstractDecimal)this.totalCost);
                totalCostSharingAllYrs = (ScaleTwoDecimal)totalCostSharingAllYrs.add((AbstractDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (ScaleTwoDecimal)totalDirectCostAllYrs.add((AbstractDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (ScaleTwoDecimal)totalIndirectCostAllYrs.add((AbstractDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectSecondYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (ScaleTwoDecimal)totalIndirectCostAllYrsCS.add((AbstractDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesSecondYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesSecondYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.supplyCostCS);
                totalSupplies = (ScaleTwoDecimal)totalSupplies.add((AbstractDecimal)this.supplyCost);
                totalSuppliesCS = (ScaleTwoDecimal)totalSuppliesCS.add((AbstractDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionSecondYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionSecondYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                if (this.otherCost.longValue() < 0L) {
                    ed524Budget.setBudgetFederalOtherSecondYearAmount(BigDecimal.ZERO);
                } else {
                    ed524Budget.setBudgetFederalOtherSecondYearAmount(this.otherCost.bigDecimalValue());
                }
                ed524Budget.setBudgetNonFederalOtherSecondYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.otherCostCS);
                totalOther = (ScaleTwoDecimal)totalOther.add((AbstractDecimal)this.otherCost);
                totalOtherCS = (ScaleTwoDecimal)totalOtherCS.add((AbstractDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentSecondYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentSecondYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.equipmentCostCS);
                totalEquip = (ScaleTwoDecimal)totalEquip.add((AbstractDecimal)this.equipmentCost);
                totalEquipCS = (ScaleTwoDecimal)totalEquipCS.add((AbstractDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualSecondYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualSecondYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.contractualCostCS);
                totalContractual = (ScaleTwoDecimal)totalContractual.add((AbstractDecimal)this.contractualCost);
                totalContractualCS = (ScaleTwoDecimal)totalContractualCS.add((AbstractDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelSecondYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelSecondYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.travelCostCS);
                totalTravel = (ScaleTwoDecimal)totalTravel.add((AbstractDecimal)this.travelCost);
                totalTravelCS = (ScaleTwoDecimal)totalTravelCS.add((AbstractDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingSecondYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingSecondYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (ScaleTwoDecimal)totalTraining.add((AbstractDecimal)this.trainingCost);
                totalTrainingCS = (ScaleTwoDecimal)totalTrainingCS.add((AbstractDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeSecondYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeSecondYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.categoryCostCSFringe);
                totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)this.categoryCostFringe);
                totalFringeCS = (ScaleTwoDecimal)totalFringeCS.add((AbstractDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelSecondYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelSecondYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.personnelCostCS);
                totalPersonnel = (ScaleTwoDecimal)totalPersonnel.add((AbstractDecimal)this.personnelCost);
                totalPersonnelCS = (ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectSecondYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P3.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalThirdYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalThirdYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectThirdYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectThirdYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (ScaleTwoDecimal)totalCostAllYrs.add((AbstractDecimal)this.totalCost);
                totalCostSharingAllYrs = (ScaleTwoDecimal)totalCostSharingAllYrs.add((AbstractDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (ScaleTwoDecimal)totalDirectCostAllYrs.add((AbstractDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (ScaleTwoDecimal)totalIndirectCostAllYrs.add((AbstractDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectThirdYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (ScaleTwoDecimal)totalIndirectCostAllYrsCS.add((AbstractDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesThirdYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesThirdYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.supplyCostCS);
                totalSupplies = (ScaleTwoDecimal)totalSupplies.add((AbstractDecimal)this.supplyCost);
                totalSuppliesCS = (ScaleTwoDecimal)totalSuppliesCS.add((AbstractDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionThirdYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionThirdYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                if (this.otherCost.longValue() < 0L) {
                    ed524Budget.setBudgetFederalOtherThirdYearAmount(BigDecimal.ZERO);
                } else {
                    ed524Budget.setBudgetFederalOtherThirdYearAmount(this.otherCost.bigDecimalValue());
                }
                ed524Budget.setBudgetNonFederalOtherThirdYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.otherCostCS);
                totalOther = (ScaleTwoDecimal)totalOther.add((AbstractDecimal)this.otherCost);
                totalOtherCS = (ScaleTwoDecimal)totalOtherCS.add((AbstractDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentThirdYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentThirdYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.equipmentCostCS);
                totalEquip = (ScaleTwoDecimal)totalEquip.add((AbstractDecimal)this.equipmentCost);
                totalEquipCS = (ScaleTwoDecimal)totalEquipCS.add((AbstractDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualThirdYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualThirdYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.contractualCostCS);
                totalContractual = (ScaleTwoDecimal)totalContractual.add((AbstractDecimal)this.contractualCost);
                totalContractualCS = (ScaleTwoDecimal)totalContractualCS.add((AbstractDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelThirdYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelThirdYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.travelCostCS);
                totalTravel = (ScaleTwoDecimal)totalTravel.add((AbstractDecimal)this.travelCost);
                totalTravelCS = (ScaleTwoDecimal)totalTravelCS.add((AbstractDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingThirdYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingThirdYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (ScaleTwoDecimal)totalTraining.add((AbstractDecimal)this.trainingCost);
                totalTrainingCS = (ScaleTwoDecimal)totalTrainingCS.add((AbstractDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeThirdYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeThirdYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.categoryCostCSFringe);
                totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)this.categoryCostFringe);
                totalFringeCS = (ScaleTwoDecimal)totalFringeCS.add((AbstractDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelThirdYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelThirdYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.personnelCostCS);
                totalPersonnel = (ScaleTwoDecimal)totalPersonnel.add((AbstractDecimal)this.personnelCost);
                totalPersonnelCS = (ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectThirdYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P4.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFourthYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFourthYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFourthYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFourthYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (ScaleTwoDecimal)totalCostAllYrs.add((AbstractDecimal)this.totalCost);
                totalCostSharingAllYrs = (ScaleTwoDecimal)totalCostSharingAllYrs.add((AbstractDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (ScaleTwoDecimal)totalDirectCostAllYrs.add((AbstractDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (ScaleTwoDecimal)totalIndirectCostAllYrs.add((AbstractDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFourthYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (ScaleTwoDecimal)totalIndirectCostAllYrsCS.add((AbstractDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFourthYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFourthYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.supplyCostCS);
                totalSupplies = (ScaleTwoDecimal)totalSupplies.add((AbstractDecimal)this.supplyCost);
                totalSuppliesCS = (ScaleTwoDecimal)totalSuppliesCS.add((AbstractDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionFourthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFourthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFourthYearAmount(this.otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFourthYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.otherCostCS);
                totalOther = (ScaleTwoDecimal)totalOther.add((AbstractDecimal)this.otherCost);
                totalOtherCS = (ScaleTwoDecimal)totalOtherCS.add((AbstractDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFourthYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFourthYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.equipmentCostCS);
                totalEquip = (ScaleTwoDecimal)totalEquip.add((AbstractDecimal)this.equipmentCost);
                totalEquipCS = (ScaleTwoDecimal)totalEquipCS.add((AbstractDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFourthYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFourthYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.contractualCostCS);
                totalContractual = (ScaleTwoDecimal)totalContractual.add((AbstractDecimal)this.contractualCost);
                totalContractualCS = (ScaleTwoDecimal)totalContractualCS.add((AbstractDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFourthYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFourthYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.travelCostCS);
                totalTravel = (ScaleTwoDecimal)totalTravel.add((AbstractDecimal)this.travelCost);
                totalTravelCS = (ScaleTwoDecimal)totalTravelCS.add((AbstractDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingFourthYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFourthYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (ScaleTwoDecimal)totalTraining.add((AbstractDecimal)this.trainingCost);
                totalTrainingCS = (ScaleTwoDecimal)totalTrainingCS.add((AbstractDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeFourthYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFourthYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.categoryCostCSFringe);
                totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)this.categoryCostFringe);
                totalFringeCS = (ScaleTwoDecimal)totalFringeCS.add((AbstractDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFourthYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFourthYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.personnelCostCS);
                totalPersonnel = (ScaleTwoDecimal)totalPersonnel.add((AbstractDecimal)this.personnelCost);
                totalPersonnelCS = (ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectFourthYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P5.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFifthYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFifthYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFifthYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFifthYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (ScaleTwoDecimal)totalCostAllYrs.add((AbstractDecimal)this.totalCost);
                totalCostSharingAllYrs = (ScaleTwoDecimal)totalCostSharingAllYrs.add((AbstractDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (ScaleTwoDecimal)totalDirectCostAllYrs.add((AbstractDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (ScaleTwoDecimal)totalIndirectCostAllYrs.add((AbstractDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFifthYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (ScaleTwoDecimal)totalIndirectCostAllYrsCS.add((AbstractDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFifthYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFifthYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.supplyCostCS);
                totalSupplies = (ScaleTwoDecimal)totalSupplies.add((AbstractDecimal)this.supplyCost);
                totalSuppliesCS = (ScaleTwoDecimal)totalSuppliesCS.add((AbstractDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionFifthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFifthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFifthYearAmount(this.otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFifthYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.otherCostCS);
                totalOther = (ScaleTwoDecimal)totalOther.add((AbstractDecimal)this.otherCost);
                totalOtherCS = (ScaleTwoDecimal)totalOtherCS.add((AbstractDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFifthYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFifthYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.equipmentCostCS);
                totalEquip = (ScaleTwoDecimal)totalEquip.add((AbstractDecimal)this.equipmentCost);
                totalEquipCS = (ScaleTwoDecimal)totalEquipCS.add((AbstractDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFifthYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFifthYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.contractualCostCS);
                totalContractual = (ScaleTwoDecimal)totalContractual.add((AbstractDecimal)this.contractualCost);
                totalContractualCS = (ScaleTwoDecimal)totalContractualCS.add((AbstractDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFifthYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFifthYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.travelCostCS);
                totalTravel = (ScaleTwoDecimal)totalTravel.add((AbstractDecimal)this.travelCost);
                totalTravelCS = (ScaleTwoDecimal)totalTravelCS.add((AbstractDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingFifthYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFifthYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (ScaleTwoDecimal)totalTraining.add((AbstractDecimal)this.trainingCost);
                totalTrainingCS = (ScaleTwoDecimal)totalTrainingCS.add((AbstractDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeFifthYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFifthYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.categoryCostCSFringe);
                totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)this.categoryCostFringe);
                totalFringeCS = (ScaleTwoDecimal)totalFringeCS.add((AbstractDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFifthYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFifthYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.personnelCostCS);
                totalPersonnel = (ScaleTwoDecimal)totalPersonnel.add((AbstractDecimal)this.personnelCost);
                totalPersonnelCS = (ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectFifthYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P6.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSixthYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSixthYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectSixthYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectSixthYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (ScaleTwoDecimal)totalCostAllYrs.add((AbstractDecimal)this.totalCost);
                totalCostSharingAllYrs = (ScaleTwoDecimal)totalCostSharingAllYrs.add((AbstractDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (ScaleTwoDecimal)totalDirectCostAllYrs.add((AbstractDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (ScaleTwoDecimal)totalIndirectCostAllYrs.add((AbstractDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectSixthYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (ScaleTwoDecimal)totalIndirectCostAllYrsCS.add((AbstractDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesSixthYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesSixthYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.supplyCostCS);
                totalSupplies = (ScaleTwoDecimal)totalSupplies.add((AbstractDecimal)this.supplyCost);
                totalSuppliesCS = (ScaleTwoDecimal)totalSuppliesCS.add((AbstractDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionSixthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionSixthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherSixthYearAmount(this.otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherSixthYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.otherCostCS);
                totalOther = (ScaleTwoDecimal)totalOther.add((AbstractDecimal)this.otherCost);
                totalOtherCS = (ScaleTwoDecimal)totalOtherCS.add((AbstractDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentSixthYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentSixthYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.equipmentCostCS);
                totalEquip = (ScaleTwoDecimal)totalEquip.add((AbstractDecimal)this.equipmentCost);
                totalEquipCS = (ScaleTwoDecimal)totalEquipCS.add((AbstractDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualSixthYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualSixthYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.contractualCostCS);
                totalContractual = (ScaleTwoDecimal)totalContractual.add((AbstractDecimal)this.contractualCost);
                totalContractualCS = (ScaleTwoDecimal)totalContractualCS.add((AbstractDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelSixthYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelSixthYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.travelCostCS);
                totalTravel = (ScaleTwoDecimal)totalTravel.add((AbstractDecimal)this.travelCost);
                totalTravelCS = (ScaleTwoDecimal)totalTravelCS.add((AbstractDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingSixthYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingSixthYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (ScaleTwoDecimal)totalTraining.add((AbstractDecimal)this.trainingCost);
                totalTrainingCS = (ScaleTwoDecimal)totalTrainingCS.add((AbstractDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeSixthYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeSixthYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.categoryCostCSFringe);
                totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)this.categoryCostFringe);
                totalFringeCS = (ScaleTwoDecimal)totalFringeCS.add((AbstractDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelSixthYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelSixthYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.personnelCostCS);
                totalPersonnel = (ScaleTwoDecimal)totalPersonnel.add((AbstractDecimal)this.personnelCost);
                totalPersonnelCS = (ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectSixthYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (!budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P7.getNum())) continue;
            totalCategoryCS = ScaleTwoDecimal.ZERO;
            this.getTotalCosts(budgetPeriod);
            ed524Budget.setBudgetFederalSeventhYearAmount(this.totalCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalSeventhYearAmount(this.totalCostSharing.bigDecimalValue());
            ed524Budget.setBudgetFederalDirectSeventhYearAmount(this.totalDirectCost.bigDecimalValue());
            ed524Budget.setBudgetFederalIndirectSeventhYearAmount(this.totalIndirectCost.bigDecimalValue());
            totalCostAllYrs = (ScaleTwoDecimal)totalCostAllYrs.add((AbstractDecimal)this.totalCost);
            totalCostSharingAllYrs = (ScaleTwoDecimal)totalCostSharingAllYrs.add((AbstractDecimal)this.totalCostSharing);
            totalDirectCostAllYrs = (ScaleTwoDecimal)totalDirectCostAllYrs.add((AbstractDecimal)this.totalDirectCost);
            totalIndirectCostAllYrs = (ScaleTwoDecimal)totalIndirectCostAllYrs.add((AbstractDecimal)this.totalIndirectCost);
            this.getIndirectCosts(budgetPeriod);
            ed524Budget.setBudgetNonFederalIndirectSeventhYearAmount(this.indirectCS.bigDecimalValue());
            totalIndirectCostAllYrsCS = (ScaleTwoDecimal)totalIndirectCostAllYrsCS.add((AbstractDecimal)this.indirectCS);
            this.getSuppliesCosts(budgetPeriod);
            ed524Budget.setBudgetFederalSuppliesSeventhYearAmount(this.supplyCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalSuppliesSeventhYearAmount(this.supplyCostCS.bigDecimalValue());
            totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.supplyCostCS);
            totalSupplies = (ScaleTwoDecimal)totalSupplies.add((AbstractDecimal)this.supplyCost);
            totalSuppliesCS = (ScaleTwoDecimal)totalSuppliesCS.add((AbstractDecimal)this.supplyCostCS);
            ed524Budget.setBudgetFederalConstructionSeventhYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
            ed524Budget.setBudgetNonFederalConstructionSeventhYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
            this.getOtherCosts(budgetPeriod);
            ed524Budget.setBudgetFederalOtherSeventhYearAmount(this.otherCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalOtherSeventhYearAmount(this.otherCostCS.bigDecimalValue());
            totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.otherCostCS);
            totalOther = (ScaleTwoDecimal)totalOther.add((AbstractDecimal)this.otherCost);
            totalOtherCS = (ScaleTwoDecimal)totalOtherCS.add((AbstractDecimal)this.otherCostCS);
            this.getEquipmentCosts(budgetPeriod);
            ed524Budget.setBudgetFederalEquipmentSeventhYearAmount(this.equipmentCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalEquipmentSeventhYearAmount(this.equipmentCostCS.bigDecimalValue());
            totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.equipmentCostCS);
            totalEquip = (ScaleTwoDecimal)totalEquip.add((AbstractDecimal)this.equipmentCost);
            totalEquipCS = (ScaleTwoDecimal)totalEquipCS.add((AbstractDecimal)this.equipmentCostCS);
            this.getContractualCosts(budgetPeriod);
            ed524Budget.setBudgetFederalContractualSeventhYearAmount(this.contractualCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalContractualSeventhYearAmount(this.contractualCostCS.bigDecimalValue());
            totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.contractualCostCS);
            totalContractual = (ScaleTwoDecimal)totalContractual.add((AbstractDecimal)this.contractualCost);
            totalContractualCS = (ScaleTwoDecimal)totalContractualCS.add((AbstractDecimal)this.contractualCostCS);
            this.getTravelCosts(budgetPeriod);
            ed524Budget.setBudgetFederalTravelSeventhYearAmount(this.travelCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalTravelSeventhYearAmount(this.travelCostCS.bigDecimalValue());
            totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.travelCostCS);
            totalTravel = (ScaleTwoDecimal)totalTravel.add((AbstractDecimal)this.travelCost);
            totalTravelCS = (ScaleTwoDecimal)totalTravelCS.add((AbstractDecimal)this.travelCostCS);
            ed524Budget.setBudgetFederalTrainingSeventhYearAmount(this.trainingCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalTrainingSeventhYearAmount(this.trainingCostCS.bigDecimalValue());
            totalTraining = (ScaleTwoDecimal)totalTraining.add((AbstractDecimal)this.trainingCost);
            totalTrainingCS = (ScaleTwoDecimal)totalTrainingCS.add((AbstractDecimal)this.trainingCostCS);
            ed524Budget.setBudgetFederalFringeSeventhYearAmount(this.categoryCostFringe.bigDecimalValue());
            ed524Budget.setBudgetNonFederalFringeSeventhYearAmount(this.categoryCostCSFringe.bigDecimalValue());
            totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.categoryCostCSFringe);
            totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)this.categoryCostFringe);
            totalFringeCS = (ScaleTwoDecimal)totalFringeCS.add((AbstractDecimal)this.categoryCostCSFringe);
            this.getPersonnelCosts(budgetPeriod);
            ed524Budget.setBudgetFederalPersonnelSeventhYearAmount(this.personnelCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalPersonnelSeventhYearAmount(this.personnelCostCS.bigDecimalValue());
            totalCategoryCS = (ScaleTwoDecimal)totalCategoryCS.add((AbstractDecimal)this.personnelCostCS);
            totalPersonnel = (ScaleTwoDecimal)totalPersonnel.add((AbstractDecimal)this.personnelCost);
            totalPersonnelCS = (ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)this.personnelCostCS);
            ed524Budget.setBudgetNonFederalDirectSeventhYearAmount(totalCategoryCS.bigDecimalValue());
        }
        ed524Budget.setBudgetFederalPersonnelTotalAmount(totalPersonnel.bigDecimalValue());
        ed524Budget.setBudgetNonFederalPersonnelTotalAmount(totalPersonnelCS.bigDecimalValue());
        ed524Budget.setBudgetFederalFringeTotalAmount(totalFringe.bigDecimalValue());
        ed524Budget.setBudgetNonFederalFringeTotalAmount(totalFringeCS.bigDecimalValue());
        ed524Budget.setBudgetFederalTravelTotalAmount(totalTravel.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTravelTotalAmount(totalTravelCS.bigDecimalValue());
        ed524Budget.setBudgetFederalEquipmentTotalAmount(totalEquip.bigDecimalValue());
        ed524Budget.setBudgetNonFederalEquipmentTotalAmount(totalEquipCS.bigDecimalValue());
        ed524Budget.setBudgetFederalContractualTotalAmount(totalContractual.bigDecimalValue());
        ed524Budget.setBudgetNonFederalContractualTotalAmount(totalContractualCS.bigDecimalValue());
        ed524Budget.setBudgetFederalSuppliesTotalAmount(totalSupplies.bigDecimalValue());
        ed524Budget.setBudgetNonFederalSuppliesTotalAmount(totalSuppliesCS.bigDecimalValue());
        ed524Budget.setBudgetFederalConstructionTotalAmount(totalConstruction.bigDecimalValue());
        ed524Budget.setBudgetNonFederalConstructionTotalAmount(totalConstructionCS.bigDecimalValue());
        ed524Budget.setBudgetFederalTrainingTotalAmount(totalTraining.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTrainingTotalAmount(totalTrainingCS.bigDecimalValue());
        if (totalOther.longValue() < 0L) {
            ed524Budget.setBudgetFederalOtherTotalAmount(BigDecimal.ZERO);
        } else {
            ed524Budget.setBudgetFederalOtherTotalAmount(totalOther.bigDecimalValue());
        }
        ed524Budget.setBudgetNonFederalOtherTotalAmount(totalOtherCS.bigDecimalValue());
        totalDirectCostAllYrsCS = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)totalPersonnelCS.add((AbstractDecimal)totalFringeCS)).add((AbstractDecimal)totalTravelCS)).add((AbstractDecimal)totalEquipCS)).add((AbstractDecimal)totalContractualCS)).add((AbstractDecimal)totalConstructionCS)).add((AbstractDecimal)totalSuppliesCS)).add((AbstractDecimal)totalOtherCS);
        ed524Budget.setBudgetNonFederalDirectTotalAmount(totalDirectCostAllYrsCS.bigDecimalValue());
        ed524Budget.setBudgetNonFederalIndirectTotalAmount(totalIndirectCostAllYrsCS.bigDecimalValue());
        ed524Budget.setBudgetFederalIndirectTotalAmount(totalIndirectCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetFederalTotalAmount(totalCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetFederalDirectTotalAmount(totalDirectCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTotalAmount(totalCostSharingAllYrs.bigDecimalValue());
        ed524Budget.setIndirectCost(this.populateIndirectCost(budget));
        ed524BudgetDocument.setED524Budget14(ed524Budget);
        return ed524BudgetDocument;
    }

    private ED524Budget14Document.ED524Budget14.IndirectCost populateIndirectCost(ProposalDevelopmentBudgetExtContract budget) {
        ED524Budget14Document.ED524Budget14.IndirectCost indirectCost = (ED524Budget14Document.ED524Budget14.IndirectCost)ED524Budget14Document.ED524Budget14.IndirectCost.Factory.newInstance();
        ED524Budget14Document.ED524Budget14.IndirectCost.IndirectCostRateAgreementApproved indirectCostRateAgreementApproved = (ED524Budget14Document.ED524Budget14.IndirectCost.IndirectCostRateAgreementApproved)ED524Budget14Document.ED524Budget14.IndirectCost.IndirectCostRateAgreementApproved.Factory.newInstance();
        indirectCost.setIsIndirectCostRateAgreementApproved(YesNoDataType.Y_YES);
        indirectCost.setIndirectCostRateAgreementApproved(indirectCostRateAgreementApproved);
        indirectCost.getIndirectCostRateAgreementApproved().setIndirectCostRatePercentage(this.getIndirectCostRate(budget));
        String agencyName = this.getAgencyName();
        if (agencyName.equals("ED")) {
            indirectCost.getIndirectCostRateAgreementApproved().setApprovingFederalAgency(ApprovingFederalAgencyDataType.ED);
        } else {
            indirectCost.getIndirectCostRateAgreementApproved().setApprovingFederalAgency(ApprovingFederalAgencyDataType.OTHER);
            indirectCost.getIndirectCostRateAgreementApproved().setOtherApprovingFederalAgency(agencyName);
        }
        this.populateFromOrganizationIdc(indirectCost);
        return indirectCost;
    }

    protected BigDecimal getIndirectCostRate(ProposalDevelopmentBudgetExtContract budget) {
        return BigDecimal.valueOf(budget.getBudgetRates().stream().filter(rate -> rate.getRateClass().getRateClassType().getCode().equalsIgnoreCase(OVERHEAD) && rate.getRateType().getRateTypeCode().equalsIgnoreCase(budget.getOhRateTypeCode()) && rate.getRateClass().getCode().equalsIgnoreCase(budget.getRateClass().getCode()) && rate.getOnOffCampusFlag().compareTo(this.getOnOfCampusFlag(budget.getOnOffCampusFlag())) == 0).findFirst().get().getInstituteRate().doubleValue());
    }

    protected boolean getOnOfCampusFlag(String onOffCampusFlag) {
        return onOffCampusFlag.equalsIgnoreCase(DEFAULT) || onOffCampusFlag.equalsIgnoreCase(ON_CAMPUS) ? Boolean.TRUE : Boolean.FALSE;
    }

    private void populateFromOrganizationIdc(ED524Budget14Document.ED524Budget14.IndirectCost indirectCost) {
        this.getLastOrganizationIdc().ifPresent(lastOrgIdc -> {
            Date endDate = lastOrgIdc.getEndDate();
            indirectCost.getIndirectCostRateAgreementApproved().setIndirectCostRateAgreementToDate(this.s2SDateTimeService.convertDateToCalendar(endDate));
            Date startDate = lastOrgIdc.getStartDate();
            indirectCost.getIndirectCostRateAgreementApproved().setIndirectCostRateAgreementFromDate(this.s2SDateTimeService.convertDateToCalendar(startDate));
            this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName()).forEach(answer -> {
                if (-10120 == answer.getQuestionSeqId() && YnqConstant.YES.code().equals(answer.getAnswer())) {
                    indirectCost.setRestrictedPercentage(lastOrgIdc.getApplicableIndirectcostRate().bigDecimalValue());
                    if ("I".equalsIgnoreCase(lastOrgIdc.getRestrictedRatePolicy())) {
                        indirectCost.setRestrictedIndirectCostRate(ED524Budget14Document.ED524Budget14.IndirectCost.RestrictedIndirectCostRate.IS_INCLUDED_IN_YOUR_APPROVED_INDIRECT_COST_RATE_AGREEMENT);
                    } else if ("C".equalsIgnoreCase(lastOrgIdc.getRestrictedRatePolicy())) {
                        indirectCost.setRestrictedIndirectCostRate(ED524Budget14Document.ED524Budget14.IndirectCost.RestrictedIndirectCostRate.COMPLIES_WITH_34_CFR_76_564_C_2);
                    }
                }
                if (-10146 == answer.getQuestionSeqId() && YnqConstant.YES.code().equals(answer.getAnswer())) {
                    if ("T".equalsIgnoreCase(lastOrgIdc.getTrainingRatePolicy())) {
                        indirectCost.setTrainingIndirectCostRate(ED524Budget14Document.ED524Budget14.IndirectCost.TrainingIndirectCostRate.IS_BASED_ON_THE_TRAINING_RATE_OF_8_PERCENT_OF_MTDC_SEE_EDGAR_75_562_C_4);
                    } else if ("I".equalsIgnoreCase(lastOrgIdc.getTrainingRatePolicy())) {
                        indirectCost.setTrainingIndirectCostRate(ED524Budget14Document.ED524Budget14.IndirectCost.TrainingIndirectCostRate.IS_INCLUDED_IN_YOUR_APPROVED_INDIRECT_COST_RATE_AGREEMENT_BECAUSE_IT_IS_LOWER_THAN_THE_TRAINING_RATE_OF_8_PERCENT_OF_MTDC_SEE_EDGAR_75_562_C_4);
                    }
                }
            });
        });
    }

    private Optional<OrganizationIndirectcostContract> getLastOrganizationIdc() {
        return Optional.ofNullable(this.pdDoc.getDevelopmentProposal().getApplicantOrganization()).map(ProposalSiteContract::getOrganization).map(OrganizationContract::getOrganizationIdcs).filter(CollectionUtils::isNotEmpty).map(orgIdcs -> (OrganizationIndirectcostContract)orgIdcs.get(orgIdcs.size() - 1));
    }

    @Override
    public ED524Budget14Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getED524Budget();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(ED524Budget14Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<ED524Budget14Document> factory() {
        return ED524Budget14Document.Factory;
    }
}

