/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.edSF424Supplement30V30.EDSF424Supplement30Document;
import gov.grants.apply.forms.edSF424Supplement30V30.EDSF424Supplement30ProjectDirectorDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewExemptionContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.EDSF424SupplementBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="EDSF424SupplementV3_0Generator")
public class EDSF424SupplementV3_0Generator
extends EDSF424SupplementBaseGenerator<EDSF424Supplement30Document>
implements S2SFormGeneratorPdfFillable<EDSF424Supplement30Document> {
    protected static final int IS_NOVICE_APPLICANT_QUESTION = -10147;
    protected static final int NIA_PREFERENCE_POINTS_QUESTION = -10148;
    protected static final int QUALIFIED_OPPORTUNITY_ZONE_QUESTION = -10149;
    @Value(value="http://apply.grants.gov/forms/ED_SF424_Supplement_3_0-V3.0")
    private String namespace;
    @Value(value="ED_SF424_Supplement_3_0-V3.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_SF424_Supplement-V3.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ED_SF424_Supplement_3_0-V3.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    protected static final String MISSING_PERCENTAGE_EFFORT_ERROR = "The Project Director's (Principal Investigator) Percentage Effort is required.";

    private EDSF424Supplement30Document getEDSF424Supplement() {
        EDSF424Supplement30Document edsf424SupplementDocument = (EDSF424Supplement30Document)EDSF424Supplement30Document.Factory.newInstance();
        EDSF424Supplement30Document.EDSF424Supplement30 edsf424Supplement = (EDSF424Supplement30Document.EDSF424Supplement30)EDSF424Supplement30Document.EDSF424Supplement30.Factory.newInstance();
        edsf424Supplement.setFormVersion(FormVersion.v3_0.getVersion());
        ProposalPersonContract pi = this.getS2SProposalPersonService().getPrincipalInvestigator(this.pdDoc);
        edsf424Supplement.setProjectDirector(this.getProjectDirector(pi));
        this.setQuestionnaireAnswers(edsf424Supplement);
        this.setHumanSubjectsInformation(edsf424Supplement);
        this.setNarratives(edsf424Supplement);
        edsf424SupplementDocument.setEDSF424Supplement30(edsf424Supplement);
        return edsf424SupplementDocument;
    }

    private EDSF424Supplement30ProjectDirectorDataType getProjectDirector(ProposalPersonContract proposalPerson) {
        EDSF424Supplement30ProjectDirectorDataType projectDirector = (EDSF424Supplement30ProjectDirectorDataType)EDSF424Supplement30ProjectDirectorDataType.Factory.newInstance();
        if (proposalPerson != null) {
            projectDirector.setName(this.globLibV20Generator.getHumanNameDataType(proposalPerson));
            if (StringUtils.isNotEmpty((CharSequence)proposalPerson.getOfficePhone())) {
                projectDirector.setPhone(proposalPerson.getOfficePhone());
            }
            if (StringUtils.isNotEmpty((CharSequence)proposalPerson.getEmailAddress())) {
                projectDirector.setEmail(proposalPerson.getEmailAddress());
            }
            if (StringUtils.isNotEmpty((CharSequence)proposalPerson.getFaxNumber())) {
                projectDirector.setFax(proposalPerson.getFaxNumber());
            }
            projectDirector.setAddress(this.globLibV20Generator.getAddressDataTypeV3((Addressable)proposalPerson));
            if (proposalPerson.getPercentageEffort() != null) {
                projectDirector.setProjectDirectorLevelOfEffort(proposalPerson.getPercentageEffort().intValue());
            } else {
                this.getAuditErrors().add(new AuditError("noField", MISSING_PERCENTAGE_EFFORT_ERROR, "grantsGov.Opportunity", new String[0]));
            }
        }
        return projectDirector;
    }

    private void setHumanSubjectsInformation(EDSF424Supplement30Document.EDSF424Supplement30 edsf424Supplement) {
        edsf424Supplement.setIsHumanResearch(YesNoDataType.N_NO);
        boolean areSpecialReviewsPresent = Boolean.FALSE;
        for (ProposalSpecialReviewContract specialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (specialReview.getSpecialReviewType() == null || !specialReview.getSpecialReviewType().getCode().equals("1")) continue;
            edsf424Supplement.setIsHumanResearch(YesNoDataType.Y_YES);
            if (specialReview.getApprovalType() == null || !specialReview.getApprovalType().getCode().equals("4")) continue;
            edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.Y_YES);
            areSpecialReviewsPresent = Boolean.TRUE;
            if (specialReview.getSpecialReviewExemptions() == null || specialReview.getSpecialReviewExemptions().size() <= 0) continue;
            for (ProposalSpecialReviewExemptionContract exemption : specialReview.getSpecialReviewExemptions()) {
                switch (exemption.getExemptionType().getCode()) {
                    case "1": {
                        edsf424Supplement.setExemptionNumber1(YesNoDataType.Y_YES);
                        break;
                    }
                    case "2": {
                        edsf424Supplement.setExemptionNumber2(YesNoDataType.Y_YES);
                        break;
                    }
                    case "3": {
                        edsf424Supplement.setExemptionNumber3(YesNoDataType.Y_YES);
                        break;
                    }
                    case "4": {
                        edsf424Supplement.setExemptionNumber4(YesNoDataType.Y_YES);
                        break;
                    }
                    case "5": {
                        edsf424Supplement.setExemptionNumber5(YesNoDataType.Y_YES);
                        break;
                    }
                    case "6": {
                        edsf424Supplement.setExemptionNumber6(YesNoDataType.Y_YES);
                        break;
                    }
                    case "7": {
                        edsf424Supplement.setExemptionNumber7(YesNoDataType.Y_YES);
                        break;
                    }
                    case "8": {
                        edsf424Supplement.setExemptionNumber8(YesNoDataType.Y_YES);
                    }
                }
            }
        }
        if (!areSpecialReviewsPresent) {
            this.populateAssuranceInformation(edsf424Supplement);
        }
    }

    protected void populateAssuranceInformation(EDSF424Supplement30Document.EDSF424Supplement30 edsf424Supplement) {
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.N_NO);
            if (organization.getHumanSubAssurance() != null) {
                edsf424Supplement.setAssuranceNumber(organization.getHumanSubAssurance());
            }
        }
    }

    private void setQuestionnaireAnswers(EDSF424Supplement30Document.EDSF424Supplement30 edsf424Supplement) {
        List answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        edsf424Supplement.setIsNoviceApplicant(null);
        answerHeaders.stream().filter(Objects::nonNull).flatMap(answerHeader -> answerHeader.getAnswers().stream()).filter(answer -> answer.getAnswer() != null).forEach(answer -> {
            switch (answer.getQuestionSeqId()) {
                case -10147: {
                    this.setIsNoviceApplicant(edsf424Supplement, answer.getAnswer());
                    break;
                }
                case -10148: {
                    edsf424Supplement.setNIAPreferencePoints(Integer.valueOf(answer.getAnswer()));
                    break;
                }
                case -10149: {
                    this.setQualifiedOpportunityZone(edsf424Supplement, (AnswerContract)answer);
                }
            }
        });
    }

    private void setIsNoviceApplicant(EDSF424Supplement30Document.EDSF424Supplement30 edsf424Supplement, String answer) {
        if (YnqConstant.YES.code().equals(answer)) {
            edsf424Supplement.setIsNoviceApplicant(YesNoDataType.Y_YES);
        } else if (YnqConstant.NO.code().equals(answer)) {
            edsf424Supplement.setIsNoviceApplicant(YesNoDataType.N_NO);
        }
    }

    private void setQualifiedOpportunityZone(EDSF424Supplement30Document.EDSF424Supplement30 edsf424Supplement, AnswerContract answerContract) {
        String answer = answerContract.getAnswer();
        switch (answerContract.getAnswerNumber()) {
            case 1: {
                edsf424Supplement.setQualifiedOpportunityZone1(answer);
                break;
            }
            case 2: {
                edsf424Supplement.setQualifiedOpportunityZone2(answer);
                break;
            }
            case 3: {
                edsf424Supplement.setQualifiedOpportunityZone3(answer);
                break;
            }
            case 4: {
                edsf424Supplement.setQualifiedOpportunityZone4(answer);
                break;
            }
            case 5: {
                edsf424Supplement.setQualifiedOpportunityZone5(answer);
                break;
            }
            case 6: {
                edsf424Supplement.setQualifiedOpportunityZone6(answer);
                break;
            }
            case 7: {
                edsf424Supplement.setQualifiedOpportunityZone7(answer);
                break;
            }
            case 8: {
                edsf424Supplement.setQualifiedOpportunityZone8(answer);
                break;
            }
            case 9: {
                edsf424Supplement.setQualifiedOpportunityZone9(answer);
                break;
            }
            case 10: {
                edsf424Supplement.setQualifiedOpportunityZone10(answer);
                break;
            }
            case 11: {
                edsf424Supplement.setQualifiedOpportunityZone11(answer);
                break;
            }
            case 12: {
                edsf424Supplement.setQualifiedOpportunityZone12(answer);
            }
        }
    }

    protected void setNarratives(EDSF424Supplement30Document.EDSF424Supplement30 edsf424Supplement) {
        AttachedFileDataType attachment;
        Optional<NarrativeContract> edsf424SupplementNarrativeOptional = this.pdDoc.getDevelopmentProposal().getNarratives().stream().filter(narrative -> narrative.getNarrativeType().getCode() != null && Integer.parseInt(narrative.getNarrativeType().getCode()) == 54).findFirst();
        if (edsf424SupplementNarrativeOptional.isPresent() && (attachment = this.addAttachedFileType(edsf424SupplementNarrativeOptional.get())) != null) {
            edsf424Supplement.setAttachment(attachment);
        }
    }

    @Override
    public EDSF424Supplement30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getEDSF424Supplement();
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(EDSF424Supplement30Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getEDSF424Supplement30().getAttachment() != null && a.getContentId().equals(form.getEDSF424Supplement30().getAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("ED_SF424_Supplement_3_0_P2.optionalFile0", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<EDSF424Supplement30Document> factory() {
        return EDSF424Supplement30Document.Factory;
    }
}

