/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage23V23.NSFCoverPage23Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV2_3Generator")
public class NSFCoverPageV2_3Generator
extends NSFCoverPageBaseGenerator<NSFCoverPage23Document>
implements S2SFormGeneratorPdfFillable<NSFCoverPage23Document> {
    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    private static final int FUNDING_INT_BRANCH_CAMPUS_QUESTION = 12;
    private static final int FUNDING_FOREIGN_ORG_QUESTION = 13;
    private static final int LIFE_SCIENCES_QUESTION = 14;
    private static final int OFF_CAMPUS_SITE_QUESTION = 15;
    private static final int IMPACTS_TRIBAL_QUESTION = 16;
    private static final int GOALI = -1;
    private static final int RAISE = -2;
    private static final int TRIBAL_IMPACTS_1 = -9;
    private static final int TRIBAL_IMPACTS_2 = -10;
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage_2_3-V2.3")
    private String namespace;
    @Value(value="NSF_CoverPage_2_3")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V2.3.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_2_3-V2.3.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;

    private NSFCoverPage23Document getNSFCoverPage23() {
        AttachedFileDataType potentialImpacts1;
        AttachedFileDataType raise;
        AttachedFileDataType goali;
        AttachedFileDataType mentoringPlan;
        AttachedFileDataType dataManagementPlan;
        NSFCoverPage23Document nsfCoverPage23Document = (NSFCoverPage23Document)NSFCoverPage23Document.Factory.newInstance();
        NSFCoverPage23Document.NSFCoverPage23 nsfCoverPage23 = (NSFCoverPage23Document.NSFCoverPage23)NSFCoverPage23Document.NSFCoverPage23.Factory.newInstance();
        nsfCoverPage23.setFormVersion(FormVersion.v2_3.getVersion());
        this.setFundingOpportunityNumber(nsfCoverPage23);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage23.setDueDate(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage23.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage23);
        this.setNsfId(nsfCoverPage23);
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage23.setSingleCopyDocuments(attachmentGroup);
        }
        if ((dataManagementPlan = this.getAttachedNarrativeFile(146)) != null) {
            nsfCoverPage23.setDataManagementPlan(dataManagementPlan);
        }
        if ((mentoringPlan = this.getAttachedNarrativeFile(147)) != null) {
            nsfCoverPage23.setMentoringPlan(mentoringPlan);
        }
        if ((goali = this.getAttachedNarrativeFile(-1)) != null) {
            nsfCoverPage23.setGOALILetter(goali);
        }
        if ((raise = this.getAttachedNarrativeFile(-2)) != null) {
            nsfCoverPage23.setRAISEEmail(raise);
        }
        if ((potentialImpacts1 = this.getAttachedNarrativeFile(-9)) != null) {
            nsfCoverPage23.setPotentialImpacts1(potentialImpacts1);
        } else if (nsfCoverPage23.getOtherInfo() != null && ((Object)((Object)YesNoDataType.Y_YES)).equals((Object)nsfCoverPage23.getOtherInfo().getPotentialImpacts())) {
            this.getAuditErrors().add(new AuditError("noField", "Potential Impacts on Tribal Nations Attachment 1 is required when the Potential Impacts on Tribal Nations question is yes.", "grantsGov.Opportunity", new String[0]));
        }
        AttachedFileDataType potentialImpacts2 = this.getAttachedNarrativeFile(-10);
        if (potentialImpacts2 != null) {
            nsfCoverPage23.setPotentialImpacts2(potentialImpacts2);
        }
        if (potentialImpacts1 == null && potentialImpacts2 != null) {
            this.getAuditErrors().add(new AuditError("noField", "Potential Impacts on Tribal Nations Attachment 1 should be set before Potential Impacts on Tribal Nations Attachment 2.", "grantsGov.Opportunity", new String[0]));
        }
        nsfCoverPage23Document.setNSFCoverPage23(nsfCoverPage23);
        return nsfCoverPage23Document;
    }

    private void setNsfId(NSFCoverPage23Document.NSFCoverPage23 nsfCoverPage23) {
        DepartmentalPersonDto person = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        nsfCoverPage23.setNSFID(person.getNsfId());
    }

    protected void setFundingMechanism(NSFCoverPage23Document.NSFCoverPage23 nsfCoverPage23, String answer) {
        NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.Enum fundingMechanism = StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.CONFERENCE.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.CONFERENCE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RAPID.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RAPID : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.EAGER.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.EAGER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.EQUIPMENT.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.EQUIPMENT : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RAISE.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RAISE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.FELLOWSHIP.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.FELLOWSHIP : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.IDEAS_LAB.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.IDEAS_LAB : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.GOALI.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.GOALI : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.FASED.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.FASED : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.TRAVEL.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.TRAVEL : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.CENTER.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.CENTER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RESEARCH_INFRASTRUCTURE.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RESEARCH_INFRASTRUCTURE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RESEARCH.toString()) ? NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RESEARCH : null))))))))))));
        nsfCoverPage23.setFundingMechanism(fundingMechanism);
    }

    private void setFundingOpportunityNumber(NSFCoverPage23Document.NSFCoverPage23 nsfCoverPage23) {
        nsfCoverPage23.setFundingOpportunityNumber(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), (int)0, (int)40));
    }

    private void setOtherInfo(NSFCoverPage23Document.NSFCoverPage23 nsfCoverPage23) {
        nsfCoverPage23.setFundingMechanism(NSFCoverPage23Document.NSFCoverPage23.FundingMechanism.RESEARCH);
        NSFCoverPage23Document.NSFCoverPage23.OtherInfo otherInfo = (NSFCoverPage23Document.NSFCoverPage23.OtherInfo)NSFCoverPage23Document.NSFCoverPage23.OtherInfo.Factory.newInstance();
        NSFCoverPage23Document.NSFCoverPage23.PIInfo pInfo = (NSFCoverPage23Document.NSFCoverPage23.PIInfo)NSFCoverPage23Document.NSFCoverPage23.PIInfo.Factory.newInstance();
        List questionnaireAnswers = this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        int unansweredQuestions = questionnaireAnswers.size();
        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 10: {
                    this.setFundingMechanism(nsfCoverPage23, answer);
                    --unansweredQuestions;
                    break;
                }
                case 11: {
                    otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 12: {
                    otherInfo.setIsFundingInternationalBranch(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 13: {
                    otherInfo.setIsFundingForeignOrganization(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 14: {
                    otherInfo.setIsPotentialLifeSciences(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 15: {
                    otherInfo.setIsOffSiteResearch(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 16: {
                    otherInfo.setPotentialImpacts(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
            }
        }
        nsfCoverPage23.setOtherInfo(unansweredQuestions == 0 ? otherInfo : null);
        nsfCoverPage23.setPIInfo(pInfo);
    }

    @Override
    public NSFCoverPage23Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage23();
    }

    protected NSFCoverPage23Document.NSFCoverPage23.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage23Document.NSFCoverPage23.NSFUnitConsideration nsfConsideration = (NSFCoverPage23Document.NSFCoverPage23.NSFUnitConsideration)NSFCoverPage23Document.NSFCoverPage23.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NSFCoverPage23Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType dataManagementPlanAttachedFile;
            if (form.getNSFCoverPage23().getSingleCopyDocuments() != null && form.getNSFCoverPage23().getSingleCopyDocuments().getAttachedFileList() != null) {
                List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage23().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); ++i) {
                    AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (!a.getContentId().equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NSF_CoverPage_2_3_P1.optionalFile1_" + i, a);
                }
            }
            if ((dataManagementPlanAttachedFile = form.getNSFCoverPage23().getDataManagementPlan()) != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_3_P1.optionalFile2", a);
            }
            AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage23().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_3_P1.optionalFile3", a);
            }
            AttachedFileDataType goaliLetterAttachedFile = form.getNSFCoverPage23().getGOALILetter();
            if (goaliLetterAttachedFile != null && a.getContentId().equals(goaliLetterAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_3_P1.optionalFile4", a);
            }
            AttachedFileDataType raiseAttachedFile = form.getNSFCoverPage23().getRAISEEmail();
            if (raiseAttachedFile != null && a.getContentId().equals(raiseAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_3_P1.optionalFile5", a);
            }
            AttachedFileDataType potentialImpacts1 = form.getNSFCoverPage23().getPotentialImpacts1();
            if (potentialImpacts1 != null && a.getContentId().equals(potentialImpacts1.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_3_P1.optionalFile6", a);
            }
            AttachedFileDataType potentialImpacts2 = form.getNSFCoverPage23().getPotentialImpacts2();
            if (potentialImpacts2 != null && a.getContentId().equals(potentialImpacts2.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_3_P1.optionalFile7", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage23Document> factory() {
        return NSFCoverPage23Document.Factory;
    }
}

