/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrMPBudget11V11.BudgetTypeDataType;
import gov.grants.apply.forms.rrMPBudget11V11.BudgetYearDataType;
import gov.grants.apply.forms.rrMPBudget11V11.RRMPBudget11Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalV10.HashValueDocument;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetPeriodDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCompensationDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SEquipmentDto;
import org.kuali.coeus.s2sgen.api.budget.S2SIndirectCostDetailsDto;
import org.kuali.coeus.s2sgen.api.budget.S2SKeyPersonDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherDirectCostInfoDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherPersonnelDto;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RRBudgetBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.s2sgen.impl.util.UnsupportedOtherCostsErrorBuilder;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRMPBudgetV1_1Generator")
public class RRMPBudgetV1_1Generator
extends RRBudgetBaseGenerator<RRMPBudget11Document>
implements S2SFormGeneratorPdfFillable<RRMPBudget11Document> {
    private static final Logger LOG = LogManager.getLogger(RRMPBudgetV1_1Generator.class);
    private static final int SUPPORTED_OTHER_COSTS = 3;
    @Value(value="http://apply.grants.gov/forms/RR_MP_Budget_1_1-V1.1")
    private String namespace;
    @Value(value="RR_MP_Budget_1_1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_MP_Budget-V1.1.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_MP_Budget_1_1-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="165")
    private int sortIndex;

    private RRMPBudget11Document getRRMPBudget11() {
        AttachedFileDataType attachedFileDataType;
        NarrativeContract narrative;
        this.deleteAutoGenNarratives();
        RRMPBudget11Document rrBudgetDocument = (RRMPBudget11Document)RRMPBudget11Document.Factory.newInstance();
        RRMPBudget11Document.RRMPBudget11 rrBudget = (RRMPBudget11Document.RRMPBudget11)RRMPBudget11Document.RRMPBudget11.Factory.newInstance();
        rrBudget.setFormVersion(FormVersion.v1_1.getVersion());
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrBudget.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
            rrBudget.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
        }
        rrBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        this.validateBudgetForForm(this.pdDoc);
        S2SBudgetDto budgetSummary = this.s2sBudgetInfoService.getBudgetInfo(this.pdDoc);
        List budgetPeriodList = budgetSummary.getBudgetPeriods();
        rrBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        for (S2SBudgetPeriodDto budgetPeriodData : budgetPeriodList) {
            this.setBudgetYearDataType(rrBudget, budgetPeriodData);
        }
        Iterator iterator = this.pdDoc.getDevelopmentProposal().getNarratives().iterator();
        while (iterator.hasNext() && ((narrative = (NarrativeContract)iterator.next()).getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 132 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null)) {
        }
        rrBudget.setBudgetJustificationAttachment(this.getBudgetJustification());
        rrBudgetDocument.setRRMPBudget11(rrBudget);
        return rrBudgetDocument;
    }

    private void setBudgetYearDataType(RRMPBudget11Document.RRMPBudget11 rrBudget, S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType budgetYear = rrBudget.addNewBudgetYear();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getEndDate()));
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            if (periodInfo.getTotalCompensation() != null) {
                budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            BigDecimal directCosts = periodInfo.getDirectCostsTotal().bigDecimalValue();
            budgetYear.setDirectCosts(directCosts);
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            if (indirectCosts != null) {
                budgetYear.setIndirectCosts(indirectCosts);
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue().add(indirectCosts.getTotalIndirectCosts()));
            } else {
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
            }
            budgetYear.setTotalCostsFee(budgetYear.getFee() != null ? budgetYear.getFee().add(budgetYear.getTotalCosts()) : budgetYear.getTotalCosts());
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
        }
    }

    private RRMPBudget11Document.RRMPBudget11.BudgetSummary getBudgetSummary(S2SBudgetDto budgetSummaryData) {
        RRMPBudget11Document.RRMPBudget11.BudgetSummary budgetSummary = (RRMPBudget11Document.RRMPBudget11.BudgetSummary)RRMPBudget11Document.RRMPBudget11.BudgetSummary.Factory.newInstance();
        S2SOtherDirectCostInfoDto otherDirectCosts = null;
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getOtherDirectCosts() != null && budgetSummaryData.getOtherDirectCosts().size() > 0) {
                otherDirectCosts = (S2SOtherDirectCostInfoDto)budgetSummaryData.getOtherDirectCosts().get(0);
            }
            if (otherDirectCosts != null) {
                budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(BigDecimal.ZERO);
                budgetSummary.setCumulativeTotalFundsRequestedPersonnel(BigDecimal.ZERO);
                if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                    budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
                }
                if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null && budgetSummaryData.getCumTotalFundsForOtherPersonnel().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                    budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
                }
                if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
                    budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
                }
                if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                    budgetSummary.setCumulativeTotalFundsRequestedPersonnel(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
                }
                budgetSummary.setCumulativeTotalFundsRequestedEquipment(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedTravel(budgetSummaryData.getCumTravel().bigDecimalValue());
                budgetSummary.setCumulativeDomesticTravelCosts(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
                budgetSummary.setCumulativeForeignTravelCosts(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedTraineeCosts(((ScaleTwoDecimal)budgetSummaryData.getPartOtherCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartStipendCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartTravelCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartTuition().add((AbstractDecimal)budgetSummaryData.getPartSubsistence())))))))).bigDecimalValue());
                budgetSummary.setCumulativeTraineeStipends(otherDirectCosts.getPartStipends().bigDecimalValue());
                budgetSummary.setCumulativeTraineeSubsistence(otherDirectCosts.getPartSubsistence().bigDecimalValue());
                budgetSummary.setCumulativeTraineeTravel(otherDirectCosts.getPartTravel().bigDecimalValue());
                budgetSummary.setCumulativeTraineeTuitionFeesHealthInsurance(otherDirectCosts.getPartTuition().bigDecimalValue());
                budgetSummary.setCumulativeOtherTraineeCost(budgetSummaryData.getPartOtherCost().bigDecimalValue());
                budgetSummary.setCumulativeNoofTrainees(budgetSummaryData.getParticipantCount());
                budgetSummary.setCumulativeTotalFundsRequestedOtherDirectCosts(otherDirectCosts.getTotalOtherDirect().bigDecimalValue());
                budgetSummary.setCumulativeMaterialAndSupplies(otherDirectCosts.getMaterials().bigDecimalValue());
                budgetSummary.setCumulativePublicationCosts(otherDirectCosts.getPublications().bigDecimalValue());
                budgetSummary.setCumulativeConsultantServices(otherDirectCosts.getConsultants().bigDecimalValue());
                budgetSummary.setCumulativeADPComputerServices(otherDirectCosts.getComputer().bigDecimalValue());
                budgetSummary.setCumulativeSubawardConsortiumContractualCosts(otherDirectCosts.getSubAwards().bigDecimalValue());
                budgetSummary.setCumulativeEquipmentFacilityRentalFees(otherDirectCosts.getEquipRental().bigDecimalValue());
                budgetSummary.setCumulativeAlterationsAndRenovations(otherDirectCosts.getAlterations().bigDecimalValue());
                List cvOthers = otherDirectCosts.getOtherCosts();
                if (cvOthers.size() > 3) {
                    this.getAuditErrors().add(UnsupportedOtherCostsErrorBuilder.build(3));
                } else {
                    for (int j = 0; j < cvOthers.size(); ++j) {
                        S2SOtherCostDto hmCosts = (S2SOtherCostDto)cvOthers.get(j);
                        if (j == 0) {
                            budgetSummary.setCumulativeOther1DirectCost(hmCosts.getCost().bigDecimalValue());
                            continue;
                        }
                        if (j == 1) {
                            budgetSummary.setCumulativeOther2DirectCost(hmCosts.getCost().bigDecimalValue());
                            continue;
                        }
                        budgetSummary.setCumulativeOther3DirectCost(hmCosts.getCost().bigDecimalValue());
                    }
                }
                budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
                if (budgetSummaryData.getCumFee() != null) {
                    budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
                }
                budgetSummary.setCumulativeTotalCostsFee(budgetSummary.getCumulativeFee() != null ? budgetSummary.getCumulativeFee().add(budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts()) : budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts());
            }
        }
        return budgetSummary;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = (BudgetYearDataType.ParticipantTraineeSupportCosts)BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            traineeSupportCosts.setTuitionFeeHealthInsurance(periodInfo.getPartTuition().bigDecimalValue());
            traineeSupportCosts.setStipends(periodInfo.getPartStipendCost().bigDecimalValue());
            traineeSupportCosts.setTravel(periodInfo.getPartTravelCost().bigDecimalValue());
            traineeSupportCosts.setSubsistence(periodInfo.getPartSubsistence().bigDecimalValue());
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getParticipantCount());
            traineeSupportCosts.setTotalCost(traineeSupportCosts.getTuitionFeeHealthInsurance().add(traineeSupportCosts.getStipends().add(traineeSupportCosts.getTravel().add(traineeSupportCosts.getSubsistence().add(traineeSupportCosts.getOther().getCost())))));
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other other = (BudgetYearDataType.ParticipantTraineeSupportCosts.Other)BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        other.setDescription("Other");
        ScaleTwoDecimal otherCost = ScaleTwoDecimal.ZERO;
        if (periodInfo != null && periodInfo.getPartOtherCost() != null) {
            otherCost = periodInfo.getPartOtherCost();
        }
        other.setCost(otherCost.bigDecimalValue());
        return other;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = (BudgetYearDataType.OtherDirectCosts)BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts().size() > 0) {
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications() != null) {
                otherDirectCosts.setPublicationCosts(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials() != null) {
                otherDirectCosts.setMaterialsSupplies(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants() != null) {
                otherDirectCosts.setConsultantServices(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer() != null) {
                otherDirectCosts.setADPComputerServices(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards() != null) {
                otherDirectCosts.setSubawardConsortiumContractualCosts(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations() != null) {
                otherDirectCosts.setAlterationsRenovations(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental() != null) {
                otherDirectCosts.setEquipmentRentalFee(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental().bigDecimalValue());
            }
            this.setOthersForOtherDirectCosts(otherDirectCosts, periodInfo);
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect() != null) {
                otherDirectCosts.setTotalOtherDirectCost(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect().bigDecimalValue());
            }
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null && periodInfo.getIndirectCosts() != null && periodInfo.getIndirectCosts().getIndirectCostDetails() != null) {
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            int IndirectCostCount = 0;
            for (S2SIndirectCostDetailsDto indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = (BudgetYearDataType.IndirectCosts.IndirectCost)BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                if (indirectCostDetails.getBase() != null) {
                    indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                }
                indirectCost.setCostType(indirectCostDetails.getCostType());
                if (indirectCostDetails.getFunds() != null) {
                    indirectCost.setFundRequested(indirectCostDetails.getFunds().bigDecimalValue());
                }
                if (indirectCostDetails.getRate() != null) {
                    indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                }
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn("Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = (BudgetYearDataType.IndirectCosts)BudgetYearDataType.IndirectCosts.Factory.newInstance();
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(new BudgetYearDataType.IndirectCosts.IndirectCost[0]));
                if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                    indirectCosts.setTotalIndirectCosts(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
                }
            }
        }
        return indirectCosts;
    }

    private void setOthersForOtherDirectCosts(BudgetYearDataType.OtherDirectCosts otherDirectCosts, S2SBudgetPeriodDto periodInfo) {
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null) {
            for (S2SOtherDirectCostInfoDto otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)otherDirectCostInfo.getOtherCosts())) continue;
                for (S2SOtherCostDto oc : otherDirectCostInfo.getOtherCosts()) {
                    BudgetYearDataType.OtherDirectCosts.Other other = otherDirectCosts.addNewOther();
                    other.setCost(oc.getCost().bigDecimalValue());
                    other.setDescription(oc.getDescription());
                }
            }
        }
    }

    private BudgetYearDataType.Travel getTravel(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.Travel travel = (BudgetYearDataType.Travel)BudgetYearDataType.Travel.Factory.newInstance();
        if (periodInfo != null) {
            travel.setDomesticTravelCost(periodInfo.getDomesticTravelCost().bigDecimalValue());
            travel.setForeignTravelCost(periodInfo.getForeignTravelCost().bigDecimalValue());
            travel.setTotalTravelCost(periodInfo.getTotalTravelCost().bigDecimalValue());
        }
        return travel;
    }

    private BudgetYearDataType.Equipment getEquipment(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.Equipment equipment = (BudgetYearDataType.Equipment)BudgetYearDataType.Equipment.Factory.newInstance();
        NarrativeContract extraEquipmentNarr = null;
        if (periodInfo != null && periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0) {
            ArrayList<Object> equipmentArrayList = new ArrayList<Object>();
            ScaleTwoDecimal totalFund = ScaleTwoDecimal.ZERO;
            for (S2SCostDto costInfo : ((S2SEquipmentDto)periodInfo.getEquipment().get(0)).getEquipmentList()) {
                BudgetYearDataType.Equipment.EquipmentList equipmentList = (BudgetYearDataType.Equipment.EquipmentList)BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                equipmentList.setEquipmentItem(costInfo.getDescription());
                if (costInfo.getCost() != null) {
                    equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
                }
                totalFund = (ScaleTwoDecimal)totalFund.add((AbstractDecimal)costInfo.getCost());
                equipmentArrayList.add(equipmentList);
            }
            ArrayList<S2SCostDto> extraEquipmentArrayList = new ArrayList<S2SCostDto>();
            ScaleTwoDecimal totalExtraEquipFund = ScaleTwoDecimal.ZERO;
            for (S2SCostDto costInfo : ((S2SEquipmentDto)periodInfo.getEquipment().get(0)).getExtraEquipmentList()) {
                extraEquipmentArrayList.add(costInfo);
                totalExtraEquipFund = (ScaleTwoDecimal)totalExtraEquipFund.add((AbstractDecimal)costInfo.getCost());
            }
            BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = equipmentArrayList.toArray(new BudgetYearDataType.Equipment.EquipmentList[0]);
            equipment.setEquipmentListArray(equipmentArray);
            totalFund = (ScaleTwoDecimal)totalFund.add((AbstractDecimal)totalExtraEquipFund);
            equipment.setTotalFund(totalFund.bigDecimalValue());
            if (equipmentArray.length > 0) {
                equipment.setTotalFundForAttachedEquipment(totalExtraEquipFund.bigDecimalValue());
            }
            extraEquipmentNarr = this.saveAdditionalEquipments(periodInfo, extraEquipmentArrayList);
        }
        if (extraEquipmentNarr != null) {
            AttachedFileDataType equipmentAttachment = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = (AttachedFileDataType.FileLocation)AttachedFileDataType.FileLocation.Factory.newInstance();
            equipmentAttachment.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraEquipmentNarr);
            fileLocation.setHref(contentId);
            equipmentAttachment.setFileLocation(fileLocation);
            equipmentAttachment.setFileName(extraEquipmentNarr.getNarrativeAttachment().getName());
            equipmentAttachment.setMimeType("application/octet-stream");
            if (extraEquipmentNarr.getNarrativeAttachment() != null) {
                HashValueDocument.HashValue hashValue = this.getHashValue(extraEquipmentNarr.getNarrativeAttachment().getData());
                equipmentAttachment.setHashValue(hashValue);
                this.addAttachment(new AttachmentData(extraEquipmentNarr.getNarrativeAttachment().getFileDataId(), extraEquipmentNarr.getNarrativeAttachment().getName(), contentId, extraEquipmentNarr.getNarrativeAttachment().getData(), "application/octet-stream", hashValue.getHashAlgorithm(), hashValue.getStringValue(), extraEquipmentNarr.getNarrativeAttachment().getUploadUser(), extraEquipmentNarr.getNarrativeAttachment().getUploadTimestamp()));
                equipment.setAdditionalEquipmentsAttachment(equipmentAttachment);
            }
        }
        return equipment;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = (BudgetYearDataType.OtherPersonnel)BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int otherPersonnelCount = 0;
        ArrayList<BudgetYearDataType.OtherPersonnel.Other> otherPersonnelList = new ArrayList<BudgetYearDataType.OtherPersonnel.Other>();
        if (periodInfo != null) {
            for (S2SOtherPersonnelDto otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                    continue;
                }
                if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                    continue;
                }
                if (otherPersonnelCount >= 6) continue;
                S2SCompensationDto sectBCompType = otherPersonnelInfo.getCompensation();
                BudgetYearDataType.OtherPersonnel.Other otherPersonnelDataType = otherPersonnel.addNewOther();
                otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                otherPersonnelDataType.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
                otherPersonnelDataType.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
                otherPersonnelDataType.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
                otherPersonnelDataType.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
                otherPersonnelDataType.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
                otherPersonnelDataType.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
                otherPersonnelList.add(otherPersonnelDataType);
                ++otherPersonnelCount;
            }
            BudgetYearDataType.OtherPersonnel.Other[] otherPersonnelDataTypeArray = otherPersonnelList.toArray(new BudgetYearDataType.OtherPersonnel.Other[0]);
            otherPersonnel.setOtherArray(otherPersonnelDataTypeArray);
            if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
            }
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                otherPersonnel.setTotalOtherPersonnelFund(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDocAssociates = (BudgetYearDataType.OtherPersonnel.PostDocAssociates)BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDocAssociates.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDocAssociates.setProjectRole(otherPersonnel.getRole());
            S2SCompensationDto sectBCompType = otherPersonnel.getCompensation();
            postDocAssociates.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            postDocAssociates.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            postDocAssociates.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            postDocAssociates.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            postDocAssociates.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            postDocAssociates.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return postDocAssociates;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = (BudgetYearDataType.OtherPersonnel.GraduateStudents)BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            S2SCompensationDto sectBCompType = otherPersonnel.getCompensation();
            graduate.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            graduate.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            graduate.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            graduate.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            graduate.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            graduate.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = (BudgetYearDataType.OtherPersonnel.UndergraduateStudents)BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            S2SCompensationDto sectBCompType = otherPersonnel.getCompensation();
            undergraduate.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            undergraduate.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            undergraduate.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            undergraduate.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            undergraduate.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            undergraduate.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarialClerical = (BudgetYearDataType.OtherPersonnel.SecretarialClerical)BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarialClerical.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarialClerical.setProjectRole(otherPersonnel.getRole());
            S2SCompensationDto sectBCompType = otherPersonnel.getCompensation();
            secretarialClerical.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            secretarialClerical.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            secretarialClerical.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            secretarialClerical.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            secretarialClerical.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            secretarialClerical.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return secretarialClerical;
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.KeyPersons keyPersons = (BudgetYearDataType.KeyPersons)BudgetYearDataType.KeyPersons.Factory.newInstance();
        ScaleTwoDecimal extraFunds = ScaleTwoDecimal.ZERO;
        if (periodInfo != null) {
            if (periodInfo.getKeyPersons() != null) {
                ArrayList keyPersonList = new ArrayList();
                int keyPersonCount = 0;
                for (S2SKeyPersonDto keyPerson : periodInfo.getKeyPersons()) {
                    if (!keyPerson.getRole().equals("PD/PI") && !this.hasPersonnelBudget(keyPerson, periodInfo.getBudgetPeriod()).booleanValue()) continue;
                    BudgetYearDataType.KeyPersons.KeyPerson keyPersonDataType = (BudgetYearDataType.KeyPersons.KeyPerson)BudgetYearDataType.KeyPersons.KeyPerson.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                    if (this.isSponsorNIH(this.pdDoc) && "CO-PD/PI".equals(keyPerson.getRole())) {
                        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
                        for (ProposalPersonContract proposalPerson : developmentProposal.getInvestigators()) {
                            if (!this.isProposalPersonEqualsKeyPerson(proposalPerson, keyPerson)) continue;
                            if (proposalPerson.isMultiplePi()) {
                                keyPersonDataType.setProjectRole("PD/PI");
                                continue;
                            }
                            keyPersonDataType.setProjectRole("CO-INVESTIGATOR");
                        }
                    } else if (keyPerson.getKeyPersonRole() != null) {
                        keyPersonDataType.setProjectRole(keyPerson.getKeyPersonRole());
                    } else {
                        keyPersonDataType.setProjectRole(keyPerson.getRole());
                    }
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)this.pdDoc.getDevelopmentProposal().getBudgets())) {
                        ScaleTwoDecimal baseSalaryByPeriod = keyPerson.getCompensation().getBaseSalary();
                        if (baseSalaryByPeriod != null && baseSalaryByPeriod.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                            keyPersonDataType.setBaseSalary(baseSalaryByPeriod.bigDecimalValue());
                        }
                    } else if (keyPerson.getCompensation().getBaseSalary() != null) {
                        keyPersonDataType.setBaseSalary(keyPerson.getCompensation().getBaseSalary().bigDecimalValue());
                    }
                    keyPersonDataType.setRequestedSalary(keyPerson.getCompensation().getRequestedSalary().bigDecimalValue());
                    keyPersonDataType.setFringeBenefits(keyPerson.getCompensation().getFringe().bigDecimalValue());
                    keyPersonDataType.setAcademicMonths(keyPerson.getCompensation().getAcademicMonths().bigDecimalValue());
                    keyPersonDataType.setCalendarMonths(keyPerson.getCompensation().getCalendarMonths().bigDecimalValue());
                    keyPersonDataType.setFundsRequested(keyPerson.getCompensation().getFundsRequested().bigDecimalValue());
                    keyPersonDataType.setSummerMonths(keyPerson.getCompensation().getSummerMonths().bigDecimalValue());
                    keyPersonList.add(keyPersonDataType);
                    LOG.info("keyPersonCount:" + ++keyPersonCount);
                }
                keyPersons.setKeyPersonArray(keyPersonList.toArray(new BudgetYearDataType.KeyPersons.KeyPerson[0]));
            }
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                keyPersons.setTotalFundForKeyPersons(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            for (S2SKeyPersonDto keyPerson : periodInfo.getExtraKeyPersons()) {
                extraFunds = (ScaleTwoDecimal)extraFunds.add((AbstractDecimal)keyPerson.getCompensation().getFundsRequested());
            }
        }
        keyPersons.setTotalFundForAttachedKeyPersons(extraFunds.bigDecimalValue());
        NarrativeContract extraKeyPersonNarr = this.saveExtraKeyPersons(periodInfo);
        this.setKeyPersonNarrative(keyPersons, extraKeyPersonNarr);
        return keyPersons;
    }

    private void setKeyPersonNarrative(BudgetYearDataType.KeyPersons keyPersons, NarrativeContract extraKeyPersonNarr) {
        if (extraKeyPersonNarr != null) {
            AttachedFileDataType attachedKeyPersons = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = (AttachedFileDataType.FileLocation)AttachedFileDataType.FileLocation.Factory.newInstance();
            attachedKeyPersons.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraKeyPersonNarr);
            fileLocation.setHref(contentId);
            attachedKeyPersons.setFileLocation(fileLocation);
            attachedKeyPersons.setFileName(extraKeyPersonNarr.getNarrativeAttachment().getName());
            attachedKeyPersons.setMimeType("application/octet-stream");
            byte[] narrativeContent = null;
            if (extraKeyPersonNarr.getNarrativeAttachment() != null) {
                narrativeContent = extraKeyPersonNarr.getNarrativeAttachment().getData();
            }
            if (narrativeContent != null && narrativeContent.length > 0) {
                HashValueDocument.HashValue hashValue = this.getHashValue(narrativeContent);
                attachedKeyPersons.setHashValue(hashValue);
                this.addAttachment(new AttachmentData(extraKeyPersonNarr.getNarrativeAttachment().getFileDataId(), extraKeyPersonNarr.getNarrativeAttachment().getName(), contentId, narrativeContent, "application/octet-stream", hashValue.getHashAlgorithm(), hashValue.getStringValue(), extraKeyPersonNarr.getNarrativeAttachment().getUploadUser(), extraKeyPersonNarr.getNarrativeAttachment().getUploadTimestamp()));
                keyPersons.setAttachedKeyPersons(attachedKeyPersons);
            }
        }
    }

    private AttachedFileDataType getBudgetJustification() {
        NarrativeContract narrative;
        AttachedFileDataType attachedFileDataType = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
        Iterator iterator = this.pdDoc.getDevelopmentProposal().getNarratives().iterator();
        while (iterator.hasNext() && ((narrative = (NarrativeContract)iterator.next()).getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 7 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null)) {
        }
        return attachedFileDataType;
    }

    @Override
    public RRMPBudget11Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRMPBudget11();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRMPBudget11Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType budgetJustificationAttachment = form.getRRMPBudget11().getBudgetJustificationAttachment();
            if (budgetJustificationAttachment != null && a.getContentId().equals(budgetJustificationAttachment.getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_MP_Budget_1_1_P4.optionalFile", a);
            }
            List<BudgetYearDataType> budgets = form.getRRMPBudget11().getBudgetYearList();
            if (budgets != null) {
                for (int i = 0; i < budgets.size(); ++i) {
                    BudgetYearDataType budget = budgets.get(i);
                    if (budget == null) continue;
                    BudgetYearDataType.KeyPersons keyPersons = budget.getKeyPersons();
                    if (keyPersons != null && keyPersons.getAttachedKeyPersons() != null && a.getContentId().equals(keyPersons.getAttachedKeyPersons().getFileLocation().getHref())) {
                        return CollectionUtils.entry("RR_MP_Budget_1_1_P1.BudgetYear[" + i + "].P1.optionalFile", a);
                    }
                    BudgetYearDataType.Equipment equipment = budget.getEquipment();
                    if (equipment == null || equipment.getAdditionalEquipmentsAttachment() == null || !a.getContentId().equals(equipment.getAdditionalEquipmentsAttachment().getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("RR_MP_Budget_1_1_P1.BudgetYear[" + i + "].P2.optionalFile", a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RRMPBudget11Document> factory() {
        return RRMPBudget11Document.Factory;
    }
}

