/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sf424V20.SF424Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationYnqContract;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.propdev.api.abstrct.ProposalAbstractContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.propdev.api.s2s.S2sSubmissionTypeContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.SF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.S2sDivisionService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SF424V2_0Generator")
public class SF424V2_0Generator
extends SF424BaseGenerator<SF424Document> {
    private DepartmentalPersonDto aorInfo = null;
    private String applicantTypeOtherSpecify = null;
    private String federalDebtExp;
    private String stateReviewDate = null;
    private String strReview = null;
    private static final String ORGANIZATION_YNQ_ANSWER_YES = "Y";
    @Value(value="http://apply.grants.gov/forms/SF424-V2.0")
    private String namespace;
    @Value(value="SF424-V2.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SF424-V2.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2sDivisionService")
    protected S2sDivisionService s2sDivisionService;

    private SF424Document getSF424Doc() {
        SF424Document sf424Document = (SF424Document)SF424Document.Factory.newInstance();
        sf424Document.setSF424(this.getSF424());
        return sf424Document;
    }

    private SF424Document.SF424 getSF424() {
        String congressionalDistrict;
        String cfdaNumber;
        ProposalPersonContract personInfo;
        ProposalSiteContract proposalSite;
        OrganizationContract organization;
        SF424Document.SF424 sf424V2 = (SF424Document.SF424)SF424Document.SF424.Factory.newInstance();
        sf424V2.setFormVersion(FormVersion.v2_0.getVersion());
        boolean hasBudgetLineItem = false;
        S2sOpportunityContract s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionType() != null) {
            String revisionType;
            S2sSubmissionTypeContract submissionType = s2sOpportunity.getS2sSubmissionType();
            SF424Document.SF424.SubmissionType.Enum subEnum = SF424Document.SF424.SubmissionType.Enum.forInt(Integer.parseInt(submissionType.getCode()));
            sf424V2.setSubmissionType(subEnum);
            SF424Document.SF424.ApplicationType.Enum applicationTypeEnum = null;
            if (this.pdDoc.getDevelopmentProposal().getProposalType() != null) {
                String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
                if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_NEW", proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.NEW;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_RESUBMISSION", proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.REVISION;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_RENEWAL", proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.CONTINUATION;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_CONTINUATION", proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.CONTINUATION;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_REVISION", proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.REVISION;
                }
            }
            sf424V2.setApplicationType(applicationTypeEnum);
            String string = revisionType = s2sOpportunity.getS2sRevisionType() != null ? s2sOpportunity.getS2sRevisionType().getCode() : null;
            if (revisionType != null) {
                SF424Document.SF424.RevisionType.Enum revType = null;
                if (revisionType.equals("A")) {
                    revType = SF424Document.SF424.RevisionType.A_INCREASE_AWARD;
                } else if (revisionType.equals("B")) {
                    revType = SF424Document.SF424.RevisionType.B_DECREASE_AWARD;
                } else if (revisionType.equals("C")) {
                    revType = SF424Document.SF424.RevisionType.C_INCREASE_DURATION;
                } else if (revisionType.equals("D")) {
                    revType = SF424Document.SF424.RevisionType.D_DECREASE_DURATION;
                } else if (revisionType.equals("AD")) {
                    revType = SF424Document.SF424.RevisionType.AD_INCREASE_AWARD_DECREASE_DURATION;
                } else if (revisionType.equals("AC")) {
                    revType = SF424Document.SF424.RevisionType.AC_INCREASE_AWARD_INCREASE_DURATION;
                } else if (revisionType.equals("BD")) {
                    revType = SF424Document.SF424.RevisionType.BD_DECREASE_AWARD_DECREASE_DURATION;
                } else if (revisionType.equals("BC")) {
                    revType = SF424Document.SF424.RevisionType.BC_DECREASE_AWARD_INCREASE_DURATION;
                } else if (revisionType.equals("E")) {
                    revType = SF424Document.SF424.RevisionType.E_OTHER_SPECIFY;
                }
                if (revType != null) {
                    sf424V2.setRevisionType(revType);
                }
                if (revisionType.startsWith("E")) {
                    sf424V2.setRevisionOtherSpecify(s2sOpportunity.getRevisionOtherDescription());
                }
            }
        }
        sf424V2.setDateReceived(this.aorInfo.getSubmittedDate());
        sf424V2.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        String federalId = this.getSubmissionInfoService().getFederalId(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        if (federalId != null) {
            sf424V2.setFederalAwardIdentifier(federalId);
        }
        if ((organization = (proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization()).getOrganization()) != null) {
            sf424V2.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            sf424V2.setDUNSNumber(organization.getDunsNumber());
            sf424V2.setOrganizationAffiliation(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
        } else {
            sf424V2.setOrganizationName(null);
            sf424V2.setDUNSNumber(null);
        }
        sf424V2.setEmployerTaxpayerIdentificationNumber(this.getEmployerId());
        sf424V2.setApplicant(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
        UnitContract leadUnit = this.pdDoc.getDevelopmentProposal().getOwnedByUnit();
        if (leadUnit != null) {
            String divisionName;
            String departmentName = leadUnit.getUnitName();
            if (departmentName != null) {
                sf424V2.setDepartmentName(StringUtils.substring((String)departmentName, (int)0, (int)30));
            }
            if ((divisionName = this.s2sDivisionService.getDivisionFromUnit(leadUnit.getUnitNumber())) != null) {
                sf424V2.setDivisionName(divisionName);
            }
        }
        if ((personInfo = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc)) != null) {
            sf424V2.setContactPerson(this.globLibV20Generator.getHumanNameDataType(personInfo));
            if (personInfo.getDirectoryTitle() != null) {
                String directoryTitle = personInfo.getDirectoryTitle();
                directoryTitle = directoryTitle.length() > 45 ? directoryTitle.substring(0, 44) : directoryTitle;
                sf424V2.setTitle(directoryTitle);
            }
            sf424V2.setPhoneNumber(personInfo.getOfficePhone());
            if (StringUtils.isNotEmpty((CharSequence)personInfo.getFaxNumber())) {
                sf424V2.setFax(personInfo.getFaxNumber());
            }
            sf424V2.setEmail(personInfo.getEmailAddress());
        } else {
            sf424V2.setPhoneNumber(null);
            sf424V2.setEmail(null);
        }
        this.setApplicatTypeCodes(sf424V2);
        if (this.pdDoc.getDevelopmentProposal().getSponsor() != null) {
            sf424V2.setAgencyName(this.getFederalAgencyName());
        }
        if ((cfdaNumber = this.getFirstCfdaNumber()) != null) {
            sf424V2.setCFDANumber(cfdaNumber);
        }
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            sf424V2.setCFDAProgramTitle(announcementTitle);
        }
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null) {
            sf424V2.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityId());
            if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle() != null) {
                sf424V2.setFundingOpportunityTitle(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
            }
            if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getCompetitionId() != null) {
                sf424V2.setCompetitionIdentificationNumber(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getCompetitionId());
            }
        } else {
            sf424V2.setFundingOpportunityTitle(null);
        }
        for (ProposalAbstractContract proposalAbstract : this.pdDoc.getDevelopmentProposal().getProposalAbstracts()) {
            if (proposalAbstract.getAbstractType().getCode() == null || Integer.parseInt(proposalAbstract.getAbstractType().getCode()) != 16) continue;
            String areasAffected = proposalAbstract.getAbstractDetails();
            if (areasAffected != null && areasAffected.length() > 250) {
                sf424V2.setAffectedAreas(areasAffected.substring(0, 250));
                continue;
            }
            sf424V2.setAffectedAreas(areasAffected);
        }
        sf424V2.setProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        AttachmentGroupMin0Max100DataType attachedFileMin0Max100 = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachedFileMin0Max100.setAttachedFileArray(this.getAttachedFileDataTypes());
        sf424V2.setAdditionalProjectTitle(attachedFileMin0Max100);
        String string = congressionalDistrict = organization.getCongressionalDistrict() == null ? "Unknown" : organization.getCongressionalDistrict();
        if (congressionalDistrict.length() > 6) {
            sf424V2.setCongressionalDistrictApplicant(congressionalDistrict.substring(0, 6));
        } else {
            sf424V2.setCongressionalDistrictApplicant(congressionalDistrict);
        }
        ProposalSiteContract perfOrganization = this.pdDoc.getDevelopmentProposal().getPerformingOrganization();
        if (perfOrganization != null) {
            Object congDistrictProject;
            Object object = congDistrictProject = perfOrganization.getFirstCongressionalDistrictName() == null ? "Unknown" : perfOrganization.getFirstCongressionalDistrictName();
            if (((String)congDistrictProject).length() > 6) {
                sf424V2.setCongressionalDistrictProgramProject(((String)congDistrictProject).substring(0, 6));
            } else {
                sf424V2.setCongressionalDistrictProgramProject((String)congDistrictProject);
            }
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            Object attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 42 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            sf424V2.setAdditionalCongressionalDistricts((AttachedFileDataType)attachedFileDataType);
            break;
        }
        if (this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial() != null) {
            sf424V2.setProjectStartDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        } else {
            sf424V2.setProjectStartDate(null);
        }
        if (this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial() != null) {
            sf424V2.setProjectEndDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        } else {
            sf424V2.setProjectEndDate(null);
        }
        ProposalDevelopmentBudgetExtContract budget = this.getS2SCommonBudgetService().getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            if (budget.getTotalCost() != null) {
                sf424V2.setFederalEstimatedFunding(budget.getTotalCost().bigDecimalValue());
            }
            ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
            for (Object budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetLineItemCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            sf424V2.setApplicantEstimatedFunding(costSharingAmount.bigDecimalValue());
            BigDecimal projectIncome = BigDecimal.ZERO;
            for (BudgetProjectIncomeContract budgetProjectIncome : budget.getBudgetProjectIncomes()) {
                projectIncome = projectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            }
            sf424V2.setProgramIncomeEstimatedFunding(projectIncome);
            ScaleTwoDecimal totalEstimatedAmount = ScaleTwoDecimal.ZERO;
            if (budget.getTotalCost() != null) {
                totalEstimatedAmount = (ScaleTwoDecimal)totalEstimatedAmount.add((AbstractDecimal)budget.getTotalCost());
            }
            totalEstimatedAmount = (ScaleTwoDecimal)totalEstimatedAmount.add((AbstractDecimal)costSharingAmount);
            totalEstimatedAmount = (ScaleTwoDecimal)totalEstimatedAmount.add((AbstractDecimal)new ScaleTwoDecimal(projectIncome));
            sf424V2.setTotalEstimatedFunding(totalEstimatedAmount.bigDecimalValue());
        } else {
            sf424V2.setFederalEstimatedFunding(BigDecimal.ZERO);
            sf424V2.setApplicantEstimatedFunding(BigDecimal.ZERO);
            sf424V2.setProgramIncomeEstimatedFunding(BigDecimal.ZERO);
            sf424V2.setTotalEstimatedFunding(BigDecimal.ZERO);
        }
        sf424V2.setStateEstimatedFunding(BigDecimal.ZERO);
        sf424V2.setLocalEstimatedFunding(BigDecimal.ZERO);
        sf424V2.setOtherEstimatedFunding(BigDecimal.ZERO);
        sf424V2.setStateReview(this.getStateReviewCode());
        if (this.strReview != null && this.strReview.equals(ORGANIZATION_YNQ_ANSWER_YES)) {
            Calendar reviewDate = this.s2SDateTimeService.convertDateStringToCalendar(this.stateReviewDate);
            sf424V2.setStateReviewAvailableDate(reviewDate);
        }
        YesNoDataType.Enum yesNo = YesNoDataType.N_NO;
        OrganizationContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (applicantOrganization != null) {
            for (OrganizationYnqContract orgYnq : applicantOrganization.getOrganizationYnqs()) {
                if (orgYnq.getQuestionId() == null || !orgYnq.getQuestionId().equals("I7")) continue;
                String orgYnqanswer = orgYnq.getAnswer();
                if (orgYnqanswer != null) {
                    yesNo = orgYnqanswer.equalsIgnoreCase(ORGANIZATION_YNQ_ANSWER_YES) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                }
                this.federalDebtExp = orgYnq.getExplanation();
            }
        }
        sf424V2.setDelinquentFederalDebt(yesNo);
        if (sf424V2.getDelinquentFederalDebt() != null && ((Object)((Object)sf424V2.getDelinquentFederalDebt())).equals((Object)YesNoDataType.Y_YES)) {
            sf424V2.setDelinquentFederalDebtExplanation(this.federalDebtExp);
        }
        sf424V2.setCertificationAgree(YesNoDataType.Y_YES);
        sf424V2.setAuthorizedRepresentative(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            sf424V2.setAuthorizedRepresentativeTitle(StringUtils.substring((String)this.aorInfo.getPrimaryTitle(), (int)0, (int)45));
        } else {
            sf424V2.setAuthorizedRepresentativeTitle(null);
        }
        sf424V2.setAuthorizedRepresentativePhoneNumber(this.aorInfo.getOfficePhone());
        sf424V2.setAuthorizedRepresentativeEmail(this.aorInfo.getEmailAddress());
        if (StringUtils.isNotEmpty((CharSequence)this.aorInfo.getFaxNumber())) {
            sf424V2.setAuthorizedRepresentativeFax(this.aorInfo.getFaxNumber());
        }
        sf424V2.setAORSignature(this.aorInfo.getFullName());
        sf424V2.setDateSigned(this.aorInfo.getSubmittedDate());
        return sf424V2;
    }

    private void setApplicatTypeCodes(SF424Document.SF424 sf424V2) {
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        List organizationTypes = organization.getOrganizationTypes();
        if (organizationTypes.isEmpty()) {
            sf424V2.setApplicantTypeCode1(null);
            return;
        }
        for (int i = 0; i < organizationTypes.size() && i < 3; ++i) {
            OrganizationTypeContract orgType = (OrganizationTypeContract)organizationTypes.get(i);
            ApplicantTypeCodeDataType.Enum applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            switch (orgType.getOrganizationTypeList().getCode()) {
                case 1: {
                    applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                    break;
                }
                case 2: {
                    applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                    break;
                }
                case 3: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Federal Government";
                    break;
                }
                case 4: {
                    applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 5: {
                    applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 6: {
                    applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                    break;
                }
                case 7: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    break;
                }
                case 8: {
                    applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                    break;
                }
                case 9: {
                    applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                    break;
                }
                case 10: {
                    applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 11: {
                    applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                    break;
                }
                case 14: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Socially and Economically Disadvantaged";
                    break;
                }
                case 15: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Women owned";
                    break;
                }
                case 21: {
                    applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 22: {
                    applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                    break;
                }
                case 23: {
                    applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                    break;
                }
                case 24: {
                    applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                    break;
                }
                case 25: {
                    applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                    break;
                }
                case 26: {
                    applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                    break;
                }
                case 100: {
                    applicantTypeCode = ApplicantTypeCodeDataType.E_REGIONAL_ORGANIZATION;
                    break;
                }
                case 101: {
                    applicantTypeCode = ApplicantTypeCodeDataType.F_U_S_TERRITORY_OR_POSSESSION;
                    break;
                }
                case 102: {
                    applicantTypeCode = ApplicantTypeCodeDataType.K_INDIAN_NATIVE_AMERICAN_TRIBALLY_DESIGNATED_ORGANIZATION;
                    break;
                }
                case 103: {
                    applicantTypeCode = ApplicantTypeCodeDataType.S_HISPANIC_SERVING_INSTITUTION;
                    break;
                }
                case 104: {
                    applicantTypeCode = ApplicantTypeCodeDataType.T_HISTORICALLY_BLACK_COLLEGES_AND_UNIVERSITIES_HBC_US;
                    break;
                }
                case 105: {
                    applicantTypeCode = ApplicantTypeCodeDataType.U_TRIBALLY_CONTROLLED_COLLEGES_AND_UNIVERSITIES_TCC_US;
                    break;
                }
                case 106: {
                    applicantTypeCode = ApplicantTypeCodeDataType.V_ALASKA_NATIVE_AND_NATIVE_HAWAIIAN_SERVING_INSTITUTIONS;
                    break;
                }
                case 107: {
                    applicantTypeCode = ApplicantTypeCodeDataType.W_NON_DOMESTIC_NON_US_ENTITY;
                }
            }
            switch (i) {
                case 0: {
                    sf424V2.setApplicantTypeCode1(applicantTypeCode);
                    break;
                }
                case 1: {
                    sf424V2.setApplicantTypeCode2(applicantTypeCode);
                    break;
                }
                case 2: {
                    sf424V2.setApplicantTypeCode3(applicantTypeCode);
                }
            }
            if (this.applicantTypeOtherSpecify == null) continue;
            sf424V2.setApplicantTypeOtherSpecify(this.applicantTypeOtherSpecify);
        }
    }

    private SF424Document.SF424.StateReview.Enum getStateReviewCode() {
        Map<String, String> eoStateReview = this.getEOStateReview(this.pdDoc);
        SF424Document.SF424.StateReview.Enum stateType = null;
        this.strReview = eoStateReview.get("answer");
        if (this.strReview != null) {
            if (this.strReview.equals(ORGANIZATION_YNQ_ANSWER_YES)) {
                stateType = SF424Document.SF424.StateReview.A_THIS_APPLICATION_WAS_MADE_AVAILABLE_TO_THE_STATE_UNDER_THE_EXECUTIVE_ORDER_12372_PROCESS_FOR_REVIEW_ON;
            } else if (this.strReview.equals("N")) {
                String stateReviewData = eoStateReview.get("stateReviewData");
                if ("Not Covered".equals(stateReviewData)) {
                    stateType = SF424Document.SF424.StateReview.C_PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
                } else if ("Not Selected".equals(stateReviewData)) {
                    stateType = SF424Document.SF424.StateReview.B_PROGRAM_IS_SUBJECT_TO_E_O_12372_BUT_HAS_NOT_BEEN_SELECTED_BY_THE_STATE_FOR_REVIEW;
                }
            }
        }
        if (eoStateReview.get("reviewDate") != null) {
            this.stateReviewDate = eoStateReview.get("reviewDate");
        }
        return stateType;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 41 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public SF424Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        return this.getSF424Doc();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public S2sDivisionService getS2sDivisionService() {
        return this.s2sDivisionService;
    }

    public void setS2sDivisionService(S2sDivisionService s2sDivisionService) {
        this.s2sDivisionService = s2sDivisionService;
    }

    @Override
    public DocumentFactory<SF424Document> factory() {
        return SF424Document.Factory;
    }
}

