/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sf42421V21.SF42421Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationYnqContract;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.propdev.api.s2s.S2sSubmissionTypeContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.SF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.S2sDivisionService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SF424V2_1Generator")
public class SF424V2_1Generator
extends SF424BaseGenerator<SF42421Document>
implements S2SFormGeneratorPdfFillable<SF42421Document> {
    private DepartmentalPersonDto aorInfo = null;
    private String applicantTypeOtherSpecify = null;
    private String stateReviewDate = null;
    private String strReview = null;
    private static final String ORGANIZATION_YNQ_ANSWER_YES = "Y";
    private static final int AREAS_AFFECTED_ATTACHMENT = 135;
    private static final int DEBT_EXPLANATION_ATTACHMENT = 136;
    private static final int ADDITIONAL_PROJECT_TITLE_ATTACHMENT = 137;
    private static final int ADDITIONAL_CONGRESSIONAL_DISTRICTS_ATTACHMENT = 138;
    @Value(value="http://apply.grants.gov/forms/SF424_2_1-V2.1")
    private String namespace;
    @Value(value="SF424-V2.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SF424-V2.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/SF424_2_1-V2.1.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2sDivisionService")
    protected S2sDivisionService s2sDivisionService;

    private SF42421Document getSF42421Doc() {
        SF42421Document sf42421Document = (SF42421Document)SF42421Document.Factory.newInstance();
        sf42421Document.setSF42421(this.getSF42421());
        return sf42421Document;
    }

    private SF42421Document.SF42421 getSF42421() {
        String congressionalDistrict;
        String cfdaNumber;
        ProposalPersonContract personInfo;
        ProposalSiteContract proposalSite;
        OrganizationContract organization;
        SF42421Document.SF42421 sf424V21 = (SF42421Document.SF42421)SF42421Document.SF42421.Factory.newInstance();
        sf424V21.setFormVersion(FormVersion.v2_1.getVersion());
        boolean hasBudgetLineItem = false;
        S2sOpportunityContract s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionType() != null) {
            String revisionType;
            S2sSubmissionTypeContract submissionType = s2sOpportunity.getS2sSubmissionType();
            SF42421Document.SF42421.SubmissionType.Enum subEnum = SF42421Document.SF42421.SubmissionType.Enum.forInt(Integer.parseInt(submissionType.getCode()));
            sf424V21.setSubmissionType(subEnum);
            SF42421Document.SF42421.ApplicationType.Enum applicationTypeEnum = null;
            if (this.pdDoc.getDevelopmentProposal().getProposalType() != null) {
                String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
                if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_NEW", proposalTypeCode)) {
                    applicationTypeEnum = SF42421Document.SF42421.ApplicationType.NEW;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_RESUBMISSION", proposalTypeCode)) {
                    applicationTypeEnum = SF42421Document.SF42421.ApplicationType.REVISION;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_RENEWAL", proposalTypeCode)) {
                    applicationTypeEnum = SF42421Document.SF42421.ApplicationType.CONTINUATION;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_CONTINUATION", proposalTypeCode)) {
                    applicationTypeEnum = SF42421Document.SF42421.ApplicationType.CONTINUATION;
                } else if (this.doesParameterContainCode("PROPOSAL_TYPE_CODE_REVISION", proposalTypeCode)) {
                    applicationTypeEnum = SF42421Document.SF42421.ApplicationType.REVISION;
                }
            }
            sf424V21.setApplicationType(applicationTypeEnum);
            String string = revisionType = s2sOpportunity.getS2sRevisionType() != null ? s2sOpportunity.getS2sRevisionType().getCode() : null;
            if (revisionType != null) {
                SF42421Document.SF42421.RevisionType.Enum revType = null;
                if (revisionType.equals("A")) {
                    revType = SF42421Document.SF42421.RevisionType.A_INCREASE_AWARD;
                } else if (revisionType.equals("B")) {
                    revType = SF42421Document.SF42421.RevisionType.B_DECREASE_AWARD;
                } else if (revisionType.equals("C")) {
                    revType = SF42421Document.SF42421.RevisionType.C_INCREASE_DURATION;
                } else if (revisionType.equals("D")) {
                    revType = SF42421Document.SF42421.RevisionType.D_DECREASE_DURATION;
                } else if (revisionType.equals("AD")) {
                    revType = SF42421Document.SF42421.RevisionType.AD_INCREASE_AWARD_DECREASE_DURATION;
                } else if (revisionType.equals("AC")) {
                    revType = SF42421Document.SF42421.RevisionType.AC_INCREASE_AWARD_INCREASE_DURATION;
                } else if (revisionType.equals("BD")) {
                    revType = SF42421Document.SF42421.RevisionType.BD_DECREASE_AWARD_DECREASE_DURATION;
                } else if (revisionType.equals("BC")) {
                    revType = SF42421Document.SF42421.RevisionType.BC_DECREASE_AWARD_INCREASE_DURATION;
                } else if (revisionType.equals("E")) {
                    revType = SF42421Document.SF42421.RevisionType.E_OTHER_SPECIFY;
                }
                if (revType != null) {
                    sf424V21.setRevisionType(revType);
                }
                if (revisionType.startsWith("E")) {
                    sf424V21.setRevisionOtherSpecify(s2sOpportunity.getRevisionOtherDescription());
                }
            }
        }
        sf424V21.setDateReceived(this.aorInfo.getSubmittedDate());
        sf424V21.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        String federalId = this.getSubmissionInfoService().getFederalId(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        if (federalId != null) {
            sf424V21.setFederalAwardIdentifier(federalId);
        }
        if ((organization = (proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization()).getOrganization()) != null) {
            sf424V21.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            sf424V21.setDUNSNumber(organization.getDunsNumber());
            sf424V21.setOrganizationAffiliation(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
        } else {
            sf424V21.setOrganizationName(null);
            sf424V21.setDUNSNumber(null);
        }
        sf424V21.setEmployerTaxpayerIdentificationNumber(this.getEmployerId());
        sf424V21.setApplicant(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
        UnitContract leadUnit = this.pdDoc.getDevelopmentProposal().getOwnedByUnit();
        if (leadUnit != null) {
            String divisionName;
            String departmentName = leadUnit.getUnitName();
            if (departmentName != null) {
                sf424V21.setDepartmentName(StringUtils.substring((String)departmentName, (int)0, (int)30));
            }
            if ((divisionName = this.s2sDivisionService.getDivisionFromUnit(leadUnit.getUnitNumber())) != null) {
                sf424V21.setDivisionName(divisionName);
            }
        }
        if ((personInfo = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc)) != null) {
            sf424V21.setContactPerson(this.globLibV20Generator.getHumanNameDataType(personInfo));
            if (personInfo.getDirectoryTitle() != null) {
                String directoryTitle = personInfo.getDirectoryTitle();
                directoryTitle = directoryTitle.length() > 45 ? directoryTitle.substring(0, 44) : directoryTitle;
                sf424V21.setTitle(directoryTitle);
            }
            sf424V21.setPhoneNumber(personInfo.getOfficePhone());
            if (StringUtils.isNotEmpty((CharSequence)personInfo.getFaxNumber())) {
                sf424V21.setFax(personInfo.getFaxNumber());
            }
            sf424V21.setEmail(personInfo.getEmailAddress());
        } else {
            sf424V21.setPhoneNumber(null);
            sf424V21.setEmail(null);
        }
        this.setApplicatTypeCodes(sf424V21);
        if (this.pdDoc.getDevelopmentProposal().getSponsor() != null) {
            sf424V21.setAgencyName(this.getFederalAgencyName());
        }
        if ((cfdaNumber = this.getFirstCfdaNumber()) != null) {
            sf424V21.setCFDANumber(cfdaNumber);
        }
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            sf424V21.setCFDAProgramTitle(announcementTitle);
        }
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null) {
            sf424V21.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityId());
            if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle() != null) {
                sf424V21.setFundingOpportunityTitle(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
            }
            if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getCompetitionId() != null) {
                sf424V21.setCompetitionIdentificationNumber(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getCompetitionId());
            }
        } else {
            sf424V21.setFundingOpportunityTitle(null);
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 135 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            sf424V21.setAreasAffected(attachedFileDataType);
            break;
        }
        sf424V21.setProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        AttachmentGroupMin0Max100DataType attachedFileMin0Max100 = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachedFileMin0Max100.setAttachedFileArray(this.getAttachedFileDataTypes());
        sf424V21.setAdditionalProjectTitle(attachedFileMin0Max100);
        String string = congressionalDistrict = organization.getCongressionalDistrict() == null ? "Unknown" : organization.getCongressionalDistrict();
        if (congressionalDistrict.length() > 6) {
            sf424V21.setCongressionalDistrictApplicant(congressionalDistrict.substring(0, 6));
        } else {
            sf424V21.setCongressionalDistrictApplicant(congressionalDistrict);
        }
        ProposalSiteContract perfOrganization = this.pdDoc.getDevelopmentProposal().getPerformingOrganization();
        if (perfOrganization != null) {
            Object congDistrictProject;
            Object object = congDistrictProject = perfOrganization.getFirstCongressionalDistrictName() == null ? "Unknown" : perfOrganization.getFirstCongressionalDistrictName();
            if (((String)congDistrictProject).length() > 6) {
                sf424V21.setCongressionalDistrictProgramProject(((String)congDistrictProject).substring(0, 6));
            } else {
                sf424V21.setCongressionalDistrictProgramProject((String)congDistrictProject);
            }
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            Object attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 138 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            sf424V21.setAdditionalCongressionalDistricts((AttachedFileDataType)attachedFileDataType);
            break;
        }
        if (this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial() != null) {
            sf424V21.setProjectStartDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        } else {
            sf424V21.setProjectStartDate(null);
        }
        if (this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial() != null) {
            sf424V21.setProjectEndDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        } else {
            sf424V21.setProjectEndDate(null);
        }
        ProposalDevelopmentBudgetExtContract budget = this.getS2SCommonBudgetService().getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            if (budget.getTotalCost() != null) {
                sf424V21.setFederalEstimatedFunding(budget.getTotalCost().bigDecimalValue());
            }
            ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
            for (Object budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetLineItemCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            sf424V21.setApplicantEstimatedFunding(costSharingAmount.bigDecimalValue());
            BigDecimal projectIncome = BigDecimal.ZERO;
            for (BudgetProjectIncomeContract budgetProjectIncome : budget.getBudgetProjectIncomes()) {
                projectIncome = projectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            }
            sf424V21.setProgramIncomeEstimatedFunding(projectIncome);
            ScaleTwoDecimal totalEstimatedAmount = ScaleTwoDecimal.ZERO;
            if (budget.getTotalCost() != null) {
                totalEstimatedAmount = (ScaleTwoDecimal)totalEstimatedAmount.add((AbstractDecimal)budget.getTotalCost());
            }
            totalEstimatedAmount = (ScaleTwoDecimal)totalEstimatedAmount.add((AbstractDecimal)costSharingAmount);
            totalEstimatedAmount = (ScaleTwoDecimal)totalEstimatedAmount.add((AbstractDecimal)new ScaleTwoDecimal(projectIncome));
            sf424V21.setTotalEstimatedFunding(totalEstimatedAmount.bigDecimalValue());
        } else {
            sf424V21.setFederalEstimatedFunding(BigDecimal.ZERO);
            sf424V21.setApplicantEstimatedFunding(BigDecimal.ZERO);
            sf424V21.setProgramIncomeEstimatedFunding(BigDecimal.ZERO);
            sf424V21.setTotalEstimatedFunding(BigDecimal.ZERO);
        }
        sf424V21.setStateEstimatedFunding(BigDecimal.ZERO);
        sf424V21.setLocalEstimatedFunding(BigDecimal.ZERO);
        sf424V21.setOtherEstimatedFunding(BigDecimal.ZERO);
        sf424V21.setStateReview(this.getStateReviewCode());
        if (this.strReview != null && this.strReview.equals(ORGANIZATION_YNQ_ANSWER_YES)) {
            Calendar reviewDate = this.s2SDateTimeService.convertDateStringToCalendar(this.stateReviewDate);
            sf424V21.setStateReviewAvailableDate(reviewDate);
        }
        YesNoDataType.Enum yesNo = YesNoDataType.N_NO;
        OrganizationContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (applicantOrganization != null) {
            for (OrganizationYnqContract orgYnq : applicantOrganization.getOrganizationYnqs()) {
                String orgYnqanswer;
                if (orgYnq.getQuestionId() == null || !orgYnq.getQuestionId().equals("I7") || (orgYnqanswer = orgYnq.getAnswer()) == null) continue;
                if (orgYnqanswer.equalsIgnoreCase(ORGANIZATION_YNQ_ANSWER_YES)) {
                    yesNo = YesNoDataType.Y_YES;
                    continue;
                }
                yesNo = YesNoDataType.N_NO;
            }
        }
        sf424V21.setDelinquentFederalDebt(yesNo);
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 136 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            sf424V21.setDebtExplanation(attachedFileDataType);
            break;
        }
        sf424V21.setCertificationAgree(YesNoDataType.Y_YES);
        sf424V21.setAuthorizedRepresentative(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            sf424V21.setAuthorizedRepresentativeTitle(StringUtils.substring((String)this.aorInfo.getPrimaryTitle(), (int)0, (int)45));
        } else {
            sf424V21.setAuthorizedRepresentativeTitle(null);
        }
        sf424V21.setAuthorizedRepresentativePhoneNumber(this.aorInfo.getOfficePhone());
        sf424V21.setAuthorizedRepresentativeEmail(this.aorInfo.getEmailAddress());
        if (StringUtils.isNotEmpty((CharSequence)this.aorInfo.getFaxNumber())) {
            sf424V21.setAuthorizedRepresentativeFax(this.aorInfo.getFaxNumber());
        }
        sf424V21.setAORSignature(this.aorInfo.getFullName());
        sf424V21.setDateSigned(this.aorInfo.getSubmittedDate());
        return sf424V21;
    }

    private void setApplicatTypeCodes(SF42421Document.SF42421 sf424V21) {
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        List organizationTypes = organization.getOrganizationTypes();
        if (organizationTypes.isEmpty()) {
            sf424V21.setApplicantTypeCode1(null);
            return;
        }
        for (int i = 0; i < organizationTypes.size() && i < 3; ++i) {
            OrganizationTypeContract orgType = (OrganizationTypeContract)organizationTypes.get(i);
            ApplicantTypeCodeDataType.Enum applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            switch (orgType.getOrganizationTypeList().getCode()) {
                case 1: {
                    applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                    break;
                }
                case 2: {
                    applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                    break;
                }
                case 3: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Federal Government";
                    break;
                }
                case 4: {
                    applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 5: {
                    applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 6: {
                    applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                    break;
                }
                case 7: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    break;
                }
                case 8: {
                    applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                    break;
                }
                case 9: {
                    applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                    break;
                }
                case 10: {
                    applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 11: {
                    applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                    break;
                }
                case 14: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Socially and Economically Disadvantaged";
                    break;
                }
                case 15: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Women owned";
                    break;
                }
                case 21: {
                    applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 22: {
                    applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                    break;
                }
                case 23: {
                    applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                    break;
                }
                case 24: {
                    applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                    break;
                }
                case 25: {
                    applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                    break;
                }
                case 26: {
                    applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                    break;
                }
                case 100: {
                    applicantTypeCode = ApplicantTypeCodeDataType.E_REGIONAL_ORGANIZATION;
                    break;
                }
                case 101: {
                    applicantTypeCode = ApplicantTypeCodeDataType.F_U_S_TERRITORY_OR_POSSESSION;
                    break;
                }
                case 102: {
                    applicantTypeCode = ApplicantTypeCodeDataType.K_INDIAN_NATIVE_AMERICAN_TRIBALLY_DESIGNATED_ORGANIZATION;
                    break;
                }
                case 103: {
                    applicantTypeCode = ApplicantTypeCodeDataType.S_HISPANIC_SERVING_INSTITUTION;
                    break;
                }
                case 104: {
                    applicantTypeCode = ApplicantTypeCodeDataType.T_HISTORICALLY_BLACK_COLLEGES_AND_UNIVERSITIES_HBC_US;
                    break;
                }
                case 105: {
                    applicantTypeCode = ApplicantTypeCodeDataType.U_TRIBALLY_CONTROLLED_COLLEGES_AND_UNIVERSITIES_TCC_US;
                    break;
                }
                case 106: {
                    applicantTypeCode = ApplicantTypeCodeDataType.V_ALASKA_NATIVE_AND_NATIVE_HAWAIIAN_SERVING_INSTITUTIONS;
                    break;
                }
                case 107: {
                    applicantTypeCode = ApplicantTypeCodeDataType.W_NON_DOMESTIC_NON_US_ENTITY;
                }
            }
            switch (i) {
                case 0: {
                    sf424V21.setApplicantTypeCode1(applicantTypeCode);
                    break;
                }
                case 1: {
                    sf424V21.setApplicantTypeCode2(applicantTypeCode);
                    break;
                }
                case 2: {
                    sf424V21.setApplicantTypeCode3(applicantTypeCode);
                }
            }
            if (this.applicantTypeOtherSpecify == null) continue;
            sf424V21.setApplicantTypeOtherSpecify(this.applicantTypeOtherSpecify);
        }
    }

    private SF42421Document.SF42421.StateReview.Enum getStateReviewCode() {
        Map<String, String> eoStateReview = this.getEOStateReview(this.pdDoc);
        SF42421Document.SF42421.StateReview.Enum stateType = null;
        this.strReview = eoStateReview.get("answer");
        if (this.strReview != null) {
            if (this.strReview.equals(ORGANIZATION_YNQ_ANSWER_YES)) {
                stateType = SF42421Document.SF42421.StateReview.A_THIS_APPLICATION_WAS_MADE_AVAILABLE_TO_THE_STATE_UNDER_THE_EXECUTIVE_ORDER_12372_PROCESS_FOR_REVIEW_ON;
            } else if (this.strReview.equals("N")) {
                String stateReviewData = eoStateReview.get("stateReviewData");
                if ("Not Covered".equals(stateReviewData)) {
                    stateType = SF42421Document.SF42421.StateReview.C_PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
                } else if ("Not Selected".equals(stateReviewData)) {
                    stateType = SF42421Document.SF42421.StateReview.B_PROGRAM_IS_SUBJECT_TO_E_O_12372_BUT_HAS_NOT_BEEN_SELECTED_BY_THE_STATE_FOR_REVIEW;
                }
            }
        }
        if (eoStateReview.get("reviewDate") != null) {
            this.stateReviewDate = eoStateReview.get("reviewDate");
        }
        return stateType;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 137 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public SF42421Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        return this.getSF42421Doc();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public S2sDivisionService getS2sDivisionService() {
        return this.s2sDivisionService;
    }

    public void setS2sDivisionService(S2sDivisionService s2sDivisionService) {
        this.s2sDivisionService = s2sDivisionService;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(SF42421Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType areasAffected = form.getSF42421().getAreasAffected();
            if (areasAffected != null && a.getContentId().equals(areasAffected.getFileLocation().getHref())) {
                return CollectionUtils.entry("SF424_2_1_P2.optionalFile1", a);
            }
            AttachedFileDataType congressionalDistricts = form.getSF42421().getAdditionalCongressionalDistricts();
            if (congressionalDistricts != null && a.getContentId().equals(congressionalDistricts.getFileLocation().getHref())) {
                return CollectionUtils.entry("SF424_2_1_P3.optionalFile0", a);
            }
            AttachedFileDataType debtExplanation = form.getSF42421().getDebtExplanation();
            if (debtExplanation != null && a.getContentId().equals(debtExplanation.getFileLocation().getHref())) {
                return CollectionUtils.entry("SF424_2_1_P3.optionalFile1", a);
            }
            AttachmentGroupMin0Max100DataType additionalProjectTitle = form.getSF42421().getAdditionalProjectTitle();
            if (additionalProjectTitle != null && additionalProjectTitle.getAttachedFileList() != null) {
                List<AttachedFileDataType> atts = additionalProjectTitle.getAttachedFileList();
                for (int i = 0; i < atts.size(); ++i) {
                    AttachedFileDataType att = atts.get(i);
                    if (att == null || !a.getContentId().equals(att.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("SF424_2_1_P2.optionalFile0" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<SF42421Document> factory() {
        return SF42421Document.Factory;
    }
}

