/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support.pdf.attachment;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;

public class AttachmentTool {
    public static void main(String[] args) throws IOException {
        PdfDictionary embFiles;
        PdfDictionary catalog;
        PdfDictionary names;
        if (args.length < 1) {
            System.out.println("Usage: AttachmentTool /path/to/pdf/file.pdf");
            System.exit(1);
        }
        if ((names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)(catalog = new PdfReader(args[0]).getCatalog()).get(PdfName.NAMES))) != null && (embFiles = (PdfDictionary)PdfReader.getPdfObject((PdfObject)names.get(PdfName.EMBEDDEDFILES))) != null) {
            Map<String, PdfObject> embMap = AttachmentTool.readTree(embFiles);
            embMap.entrySet().stream().map(o -> CollectionUtils.entry((String)o.getKey(), (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)o.getValue())))).filter(e -> Objects.nonNull(e.getValue())).map(e -> CollectionUtils.entry((String)e.getKey(), AttachmentTool.getFilename((PdfDictionary)e.getValue()))).filter(e -> Objects.nonNull(e.getKey())).sorted(Map.Entry.comparingByKey()).forEach(e -> System.out.println((String)e.getKey() + " -> " + (String)e.getValue()));
        }
    }

    private static String getFilename(PdfDictionary filespec) {
        PdfString fn = (PdfString)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.F));
        if (fn == null) {
            return null;
        }
        return fn.toUnicodeString();
    }

    private static void iterateItems(PdfDictionary dic, Map<String, PdfObject> items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease((PdfObject)dic.get(PdfName.NAMES));
                if (nn == null) break block2;
                for (int k = 0; k < nn.size(); ++k) {
                    PdfString s = (PdfString)PdfReader.getPdfObjectRelease((PdfObject)nn.getPdfObject(k++));
                    items.put(s.toUnicodeString(), nn.getPdfObject(k));
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease((PdfObject)dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            for (int k = 0; k < nn.size(); ++k) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)nn.getPdfObject(k));
                AttachmentTool.iterateItems(kid, items);
            }
        }
    }

    private static Map<String, PdfObject> readTree(PdfDictionary dic) {
        HashMap<String, PdfObject> items = new HashMap<String, PdfObject>();
        if (dic != null) {
            AttachmentTool.iterateItems(dic, items);
        }
        return items;
    }
}

