/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.person;

import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.common.api.person.KcPersonRepositoryService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.unit.UnitRepositoryService;
import org.kuali.coeus.common.api.unit.admin.UnitAdministratorContract;
import org.kuali.coeus.instprop.api.admin.ProposalAdminDetailsContract;
import org.kuali.coeus.instprop.api.admin.ProposalAdminDetailsService;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.s2s.override.S2sOverrideContract;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="departmentalPersonService")
public class DepartmentalPersonServiceImpl
implements DepartmentalPersonService {
    private static final String CONTACT_TYPE_O = "O";
    private static final String DUMMY_NSF_ID = "000000000";
    @Autowired
    @Qualifier(value="proposalAdminDetailsService")
    private ProposalAdminDetailsService proposalAdminDetailsService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="kcPersonRepositoryService")
    private KcPersonRepositoryService kcPersonRepositoryService;
    @Autowired
    @Qualifier(value="unitRepositoryService")
    private UnitRepositoryService unitRepositoryService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

    @Override
    public DepartmentalPersonDto getDepartmentalPerson(ProposalDevelopmentDocumentContract pdDoc) {
        ProposalAdminDetailsContract proposalAdminDetails;
        DepartmentalPersonDto depPerson = this.isOverrideWithSignedBy(pdDoc.getDevelopmentProposal()) ? this.overridePerson(pdDoc.getDevelopmentProposal().getS2sOverride()) : (this.isProposalAdminWithSignedBy(proposalAdminDetails = (ProposalAdminDetailsContract)this.proposalAdminDetailsService.findProposalAdminDetailsByPropDevNumber(pdDoc.getDevelopmentProposal().getProposalNumber()).stream().findFirst().orElse(null)) ? this.submittedPerson(proposalAdminDetails) : this.notSubmittedPerson(pdDoc.getDevelopmentProposal().getApplicantOrganization()));
        if (this.isOverrideWithSubmittedDate(pdDoc.getDevelopmentProposal())) {
            Calendar submittedDate = Calendar.getInstance();
            submittedDate.setTime(pdDoc.getDevelopmentProposal().getS2sOverride().getSubmittedDate());
            depPerson.setSubmittedDate(submittedDate);
        }
        return depPerson;
    }

    private boolean isOverrideWithSignedBy(DevelopmentProposalContract proposal) {
        return proposal.getS2sOverride() != null && proposal.getS2sOverride().isActive() && StringUtils.isNotBlank((CharSequence)proposal.getS2sOverride().getSignedBy()) && proposal.getS2sOverride().getSignedByPerson() != null;
    }

    private boolean isOverrideWithSubmittedDate(DevelopmentProposalContract proposal) {
        return proposal.getS2sOverride() != null && proposal.getS2sOverride().isActive() && proposal.getS2sOverride().getSubmittedDate() != null;
    }

    private boolean isProposalAdminWithSignedBy(ProposalAdminDetailsContract proposalAdminDetails) {
        return proposalAdminDetails != null && StringUtils.isNotBlank((CharSequence)proposalAdminDetails.getSignedBy());
    }

    private DepartmentalPersonDto overridePerson(S2sOverrideContract s2sOverride) {
        return this.fromKcPerson(s2sOverride.getSignedByPerson());
    }

    private DepartmentalPersonDto notSubmittedPerson(ProposalSiteContract proposalSite) {
        DepartmentalPersonDto depPerson = new DepartmentalPersonDto();
        RolodexContract rolodex = proposalSite.getRolodex();
        if (rolodex != null) {
            depPerson.setFirstName(rolodex.getFirstName());
            depPerson.setMiddleName(rolodex.getMiddleName());
            depPerson.setLastName(rolodex.getLastName());
            StringBuilder fullName = new StringBuilder();
            if (rolodex.getFirstName() != null) {
                fullName.append(rolodex.getFirstName());
                fullName.append(" ");
            }
            if (rolodex.getMiddleName() != null) {
                fullName.append(rolodex.getMiddleName());
                fullName.append(" ");
            }
            if (rolodex.getLastName() != null) {
                fullName.append(rolodex.getLastName());
            }
            depPerson.setFullName(fullName.toString());
            depPerson.setEmailAddress(rolodex.getEmailAddress());
            depPerson.setOfficePhone(rolodex.getPhoneNumber());
            depPerson.setPrimaryTitle(rolodex.getTitle());
            depPerson.setAddress1(proposalSite.getAddressLine1());
            depPerson.setAddress2(proposalSite.getAddressLine2());
            depPerson.setAddress3(proposalSite.getAddressLine3());
            depPerson.setCity(proposalSite.getCity());
            depPerson.setCounty(proposalSite.getCounty());
            depPerson.setCountryCode(proposalSite.getCountryCode());
            depPerson.setFaxNumber(rolodex.getFaxNumber());
            depPerson.setPostalCode(proposalSite.getPostalCode());
            depPerson.setState(proposalSite.getState());
            depPerson.setPersonId(Integer.toString(rolodex.getRolodexId()));
            depPerson.setDirDept(proposalSite.getLocationName());
        }
        depPerson.setSubmittedDate(Calendar.getInstance());
        depPerson.setNsfId(DUMMY_NSF_ID);
        return depPerson;
    }

    private DepartmentalPersonDto submittedPerson(ProposalAdminDetailsContract proposalAdminDetails) {
        return this.fromKcPerson(this.kcPersonRepositoryService.findKcPersonByUserName(proposalAdminDetails.getSignedBy()));
    }

    private DepartmentalPersonDto fromKcPerson(KcPersonContract person) {
        DepartmentalPersonDto depPerson = new DepartmentalPersonDto();
        if (person != null) {
            depPerson.setFirstName(person.getFirstName());
            depPerson.setMiddleName(person.getMiddleName());
            depPerson.setLastName(person.getLastName());
            depPerson.setFullName(person.getFullName());
            depPerson.setEmailAddress(person.getEmailAddress());
            depPerson.setOfficePhone(person.getPhoneNumber());
            depPerson.setPrimaryTitle(person.getPrimaryTitle());
            depPerson.setAddress1(person.getAddressLine1());
            depPerson.setAddress2(person.getAddressLine2());
            depPerson.setAddress3(person.getAddressLine3());
            depPerson.setCity(person.getCity());
            depPerson.setCounty(person.getCounty());
            depPerson.setCountryCode(person.getCountryCode());
            depPerson.setFaxNumber(person.getFaxNumber());
            depPerson.setPostalCode(person.getPostalCode());
            depPerson.setState(person.getState());
            depPerson.setPersonId(person.getPersonId());
            depPerson.setDirDept(person.getContactOrganizationName());
            depPerson.setNsfId(person.getNsfId());
        }
        depPerson.setSubmittedDate(Calendar.getInstance());
        return depPerson;
    }

    @Override
    public DepartmentalPersonDto getContactPerson(ProposalDevelopmentDocumentContract pdDoc) {
        UnitContract leadUnit;
        String contactType = this.getContactType();
        boolean isNumber = true;
        try {
            Integer.parseInt(contactType);
        }
        catch (NumberFormatException e) {
            isNumber = false;
        }
        DepartmentalPersonDto depPerson = new DepartmentalPersonDto();
        if (isNumber && (leadUnit = pdDoc.getDevelopmentProposal().getOwnedByUnit()) != null) {
            KcPersonContract unitAdmin = null;
            for (UnitAdministratorContract admin : leadUnit.getUnitAdministrators()) {
                if (!contactType.equals(admin.getUnitAdministratorType().getCode())) continue;
                unitAdmin = this.kcPersonRepositoryService.findKcPersonByPersonId(admin.getPersonId());
                depPerson.setLastName(unitAdmin.getLastName());
                depPerson.setFirstName(unitAdmin.getFirstName());
                if (unitAdmin.getMiddleName() != null) {
                    depPerson.setMiddleName(unitAdmin.getMiddleName());
                }
                depPerson.setEmailAddress(unitAdmin.getEmailAddress());
                depPerson.setOfficePhone(unitAdmin.getOfficePhone());
                depPerson.setFaxNumber(unitAdmin.getFaxNumber());
                depPerson.setPrimaryTitle(unitAdmin.getPrimaryTitle());
                depPerson.setAddress1(unitAdmin.getAddressLine1());
                depPerson.setAddress2(unitAdmin.getAddressLine2());
                depPerson.setAddress3(unitAdmin.getAddressLine3());
                depPerson.setCity(unitAdmin.getCity());
                depPerson.setCounty(unitAdmin.getCounty());
                depPerson.setCountryCode(unitAdmin.getCountryCode());
                depPerson.setPostalCode(unitAdmin.getPostalCode());
                depPerson.setState(unitAdmin.getState());
                break;
            }
            if (unitAdmin == null) {
                UnitContract parentUnit = this.unitRepositoryService.findTopUnit();
                for (UnitAdministratorContract parentAdmin : parentUnit.getUnitAdministrators()) {
                    if (!contactType.equals(parentAdmin.getUnitAdministratorType().getCode())) continue;
                    KcPersonContract parentUnitAdmin = this.kcPersonRepositoryService.findKcPersonByPersonId(parentAdmin.getPersonId());
                    depPerson.setLastName(parentUnitAdmin.getLastName());
                    depPerson.setFirstName(parentUnitAdmin.getFirstName());
                    if (parentUnitAdmin.getMiddleName() != null) {
                        depPerson.setMiddleName(parentUnitAdmin.getMiddleName());
                    }
                    depPerson.setEmailAddress(parentUnitAdmin.getEmailAddress());
                    depPerson.setOfficePhone(parentUnitAdmin.getOfficePhone());
                    depPerson.setFaxNumber(parentUnitAdmin.getFaxNumber());
                    depPerson.setPrimaryTitle(parentUnitAdmin.getPrimaryTitle());
                    depPerson.setAddress1(parentUnitAdmin.getAddressLine1());
                    depPerson.setAddress2(parentUnitAdmin.getAddressLine2());
                    depPerson.setAddress3(parentUnitAdmin.getAddressLine3());
                    depPerson.setCity(parentUnitAdmin.getCity());
                    depPerson.setCounty(parentUnitAdmin.getCounty());
                    depPerson.setCountryCode(parentUnitAdmin.getCountryCode());
                    depPerson.setPostalCode(parentUnitAdmin.getPostalCode());
                    depPerson.setState(parentUnitAdmin.getState());
                    break;
                }
            }
        }
        return depPerson;
    }

    protected String getContactType() {
        String contactType = this.s2SConfigurationService.getValueAsString("PROPOSAL_CONTACT_TYPE");
        if (contactType == null || contactType.length() == 0) {
            contactType = CONTACT_TYPE_O;
        }
        return contactType;
    }

    public ProposalAdminDetailsService getProposalAdminDetailsService() {
        return this.proposalAdminDetailsService;
    }

    public void setProposalAdminDetailsService(ProposalAdminDetailsService proposalAdminDetailsService) {
        this.proposalAdminDetailsService = proposalAdminDetailsService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public KcPersonRepositoryService getKcPersonRepositoryService() {
        return this.kcPersonRepositoryService;
    }

    public void setKcPersonRepositoryService(KcPersonRepositoryService kcPersonRepositoryService) {
        this.kcPersonRepositoryService = kcPersonRepositoryService;
    }

    public UnitRepositoryService getUnitRepositoryService() {
        return this.unitRepositoryService;
    }

    public void setUnitRepositoryService(UnitRepositoryService unitRepositoryService) {
        this.unitRepositoryService = unitRepositoryService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }
}

