/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.print;

import gov.grants.apply.system.metaGrantApplication.GrantApplicationDocument;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeService;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2sAppSubmissionContract;
import org.kuali.coeus.propdev.api.s2s.override.S2sOverrideContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.print.FormElements;
import org.kuali.coeus.s2sgen.api.print.FormPackage;
import org.kuali.coeus.s2sgen.api.print.FormPackageService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.FormApplicationService;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorRetrievalService;
import org.kuali.coeus.s2sgen.impl.print.S2SFile;
import org.kuali.coeus.s2sgen.impl.util.XPathExecutor;
import org.kuali.coeus.s2sgen.impl.validate.S2SValidatorService;
import org.kuali.coeus.s2sgen.impl.validate.ValidationResult;
import org.kuali.coeus.sys.api.model.KcFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Node;

@Component(value="formPackageService")
public class FormPackageServiceImpl
implements FormPackageService {
    private static final Logger LOG = LogManager.getLogger(FormPackageServiceImpl.class);
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    private S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="narrativeService")
    private NarrativeService narrativeService;
    @Autowired
    @Qualifier(value="s2SFormGeneratorRetrievalService")
    private S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService;
    @Autowired
    @Qualifier(value="s2SValidatorService")
    private S2SValidatorService s2SValidatorService;
    @Autowired
    @Qualifier(value="formApplicationService")
    private FormApplicationService formApplicationService;
    @Autowired
    private ResourceLoader resourceLoader;

    public FormPackage retrieveFormPackage(Set<String> namespaces, ProposalDevelopmentDocumentContract pdDoc) {
        if (namespaces == null) {
            throw new IllegalArgumentException("namespaces is null");
        }
        if (pdDoc == null) {
            throw new IllegalArgumentException("pdDoc is null");
        }
        if (namespaces.isEmpty()) {
            FormPackage formPackage = new FormPackage();
            GrantApplicationDocument.GrantApplication.Forms forms = (GrantApplicationDocument.GrantApplication.Forms)GrantApplicationDocument.GrantApplication.Forms.Factory.newInstance();
            String grantApplication = this.getFormApplicationService().getGrantApplicationDocument(pdDoc, forms);
            formPackage.setXmlFile((KcFile)new S2SFile("Grant Application.xml", "text/xml", grantApplication.getBytes(StandardCharsets.UTF_8)));
            return formPackage;
        }
        DevelopmentProposalContract developmentProposal = pdDoc.getDevelopmentProposal();
        S2sAppSubmissionContract s2sAppSubmission = this.getLatestS2SAppSubmission(developmentProposal.getS2sAppSubmission());
        boolean submitted = s2sAppSubmission != null && s2sAppSubmission.getGgTrackingId() != null;
        S2sOverrideContract s2sOverride = developmentProposal.getS2sOverride();
        boolean overridden = s2sOverride != null && s2sOverride.isActive();
        boolean requiresValidation = !submitted;
        List<FormElements> forms = this.retrieveFormElements(namespaces, pdDoc);
        FormPackage formPackage = new FormPackage();
        String grantApplication = this.createGrantApplication(pdDoc, s2sAppSubmission, submitted, s2sOverride, overridden, forms.stream().map(FormElements::getXmlFile).collect(Collectors.toList()));
        formPackage.setXmlFile((KcFile)new S2SFile("Grant Application.xml", "text/xml", grantApplication.getBytes(StandardCharsets.UTF_8)));
        if (requiresValidation) {
            ValidationResult result = this.s2SValidatorService.validateApplication(grantApplication, this.resourceLoader.getResource(developmentProposal.getS2sOpportunity().getSchemaUrl()));
            formPackage.setErrors(result.getErrors());
        }
        formPackage.setFormElements(forms);
        return formPackage;
    }

    public List<FormElements> retrieveFormElements(Set<String> namespaces, ProposalDevelopmentDocumentContract pdDoc) {
        boolean requiresXmlModification;
        if (namespaces == null) {
            throw new IllegalArgumentException("namespaces is null");
        }
        if (pdDoc == null) {
            throw new IllegalArgumentException("pdDoc is null");
        }
        if (namespaces.isEmpty()) {
            return Collections.emptyList();
        }
        DevelopmentProposalContract developmentProposal = pdDoc.getDevelopmentProposal();
        String proposalNumber = developmentProposal.getProposalNumber();
        S2sAppSubmissionContract s2sAppSubmission = this.getLatestS2SAppSubmission(developmentProposal.getS2sAppSubmission());
        boolean submitted = s2sAppSubmission != null && s2sAppSubmission.getGgTrackingId() != null;
        S2sOverrideContract s2sOverride = developmentProposal.getS2sOverride();
        boolean overridden = s2sOverride != null && s2sOverride.isActive();
        boolean requiresValidation = !submitted;
        boolean requiresNarrativeCleanup = !submitted && !overridden;
        boolean bl = requiresXmlModification = !submitted && !overridden;
        if (!requiresNarrativeCleanup) {
            this.getNarrativeService().deleteSystemGeneratedNarratives(pdDoc.getDevelopmentProposal().getNarratives());
        }
        return this.s2SFormGeneratorRetrievalService.getS2SGenerators(namespaces, proposalNumber).stream().map(generator -> this.determineGenerator(s2sAppSubmission, submitted, s2sOverride, overridden, (S2SFormGenerator<XmlObject>)generator)).map(generator -> {
            FormElements formElements = new FormElements();
            formElements.setNamespace(generator.getNamespace());
            ArrayList<AuditError> errors = new ArrayList<AuditError>(generator.getAuditErrors());
            Object formObject = generator.getFormObject(pdDoc);
            if (formObject != null) {
                if (requiresValidation) {
                    ValidationResult result = this.s2SValidatorService.validateForm((XmlObject)formObject, this.getFormNameFromNamespace(generator.getNamespace()));
                    errors.addAll(result.getErrors());
                }
                String applicationXml = formObject.xmlText(this.s2SFormGeneratorRetrievalService.getXmlOptionsPrefixes());
                String filteredApplicationXml = requiresXmlModification ? this.s2SDateTimeService.removeTimezoneFactor(applicationXml) : applicationXml;
                formElements.setXmlFile((KcFile)this.getXmlFile(generator.getNamespace(), filteredApplicationXml));
                List<AttachmentData> attachments = generator.getAttachments();
                if (generator.supportsPdfFilling()) {
                    formElements.setPdfElements(this.getPdfElements(generator.getNamespace(), (S2SFormGeneratorPdfFillable)((Object)generator), formObject, attachments));
                }
                if (generator.supportsXslTransform()) {
                    formElements.setStylesheetElements(this.getStylesheetElements((S2SFormGenerator)generator, attachments));
                }
            }
            formElements.setErrors(errors);
            return formElements;
        }).collect(Collectors.toList());
    }

    private String createGrantApplication(ProposalDevelopmentDocumentContract pdDoc, S2sAppSubmissionContract s2sAppSubmission, boolean submitted, S2sOverrideContract s2sOverride, boolean overridden, List<KcFile> formFiles) {
        if (submitted) {
            return s2sAppSubmission.getS2sApplication().getApplication();
        }
        if (overridden) {
            return s2sOverride.getApplicationOverride().getApplication();
        }
        GrantApplicationDocument.GrantApplication.Forms forms = (GrantApplicationDocument.GrantApplication.Forms)GrantApplicationDocument.GrantApplication.Forms.Factory.newInstance();
        formFiles.stream().map(file -> {
            try {
                return (XmlObject)XmlObject.Factory.parse(new String(file.getData(), StandardCharsets.UTF_8));
            }
            catch (XmlException e) {
                throw new RuntimeException(e);
            }
        }).forEach(formObject -> this.setFormObject(forms, (XmlObject)formObject));
        return this.getFormApplicationService().getGrantApplicationDocument(pdDoc, forms);
    }

    private void setFormObject(GrantApplicationDocument.GrantApplication.Forms forms, XmlObject formObject) {
        XmlCursor formCursor = formObject.newCursor();
        formCursor.toStartDoc();
        formCursor.toNextToken();
        XmlCursor metaGrantCursor = forms.newCursor();
        metaGrantCursor.toNextToken();
        formCursor.moveXml(metaGrantCursor);
    }

    private S2SFormGenerator<XmlObject> determineGenerator(S2sAppSubmissionContract s2sAppSubmission, boolean submitted, S2sOverrideContract s2sOverride, boolean overridden, S2SFormGenerator<XmlObject> generator) {
        if (submitted) {
            if (generator instanceof S2SFormGeneratorPdfFillable) {
                return new SubmittedPdfFillableFormGeneratorAdapter<XmlObject>(generator, s2sAppSubmission);
            }
            return new SubmittedFormGeneratorAdapter<XmlObject>(generator, s2sAppSubmission);
        }
        if (overridden) {
            if (generator instanceof S2SFormGeneratorPdfFillable) {
                return new OverriddenPdfFillableFormGeneratorAdapter<XmlObject>(generator, s2sOverride);
            }
            return new OverriddenFormGeneratorAdapter<XmlObject>(generator, s2sOverride);
        }
        return generator;
    }

    private <T extends XmlObject> FormElements.PdfElements getPdfElements(String namespace, S2SFormGeneratorPdfFillable<T> generator, T xmlObject, List<AttachmentData> attachments) {
        FormElements.PdfElements pdfElements = new FormElements.PdfElements();
        S2SFormGeneratorPdfFillable.Attachments mappedAttachments = generator.getMappedAttachments(xmlObject, attachments);
        if (!CollectionUtils.isEmpty(mappedAttachments.getUnmapped())) {
            LOG.warn("Unmapped attachments found " + mappedAttachments.getUnmapped().stream().map(AttachmentData::getFileName).toList());
        }
        pdfElements.setPdfFile((KcFile)this.getPdfFile(namespace, generator.getPdfForm()));
        pdfElements.setAttachments(mappedAttachments.getMapped());
        return pdfElements;
    }

    private <T extends XmlObject> FormElements.StylesheetElements getStylesheetElements(S2SFormGenerator<T> generator, List<AttachmentData> attachments) {
        FormElements.StylesheetElements stylesheetElements = new FormElements.StylesheetElements();
        stylesheetElements.setStylesheets(generator.getStylesheets().stream().map(this::getStylesheetFile).collect(Collectors.toList()));
        stylesheetElements.setAttachments(attachments);
        return stylesheetElements;
    }

    private String getFormNameFromNamespace(String namespace) {
        return namespace.substring(namespace.lastIndexOf(47) + 1);
    }

    private S2SFile getXmlFile(String namespace, String xml) {
        S2SFile xmlFile = new S2SFile();
        xmlFile.setData(xml.getBytes());
        xmlFile.setName(this.getFormNameFromNamespace(namespace) + ".xml");
        xmlFile.setType("text/xml");
        return xmlFile;
    }

    private S2SFile getPdfFile(String namespace, Resource pdfResource) {
        try {
            S2SFile pdfFile = new S2SFile();
            pdfFile.setData(pdfResource.getInputStream().readAllBytes());
            pdfFile.setName(this.getFormNameFromNamespace(namespace) + ".pdf");
            pdfFile.setType("application/pdf");
            return pdfFile;
        }
        catch (IOException e) {
            throw new S2SException((Exception)e);
        }
    }

    private S2SFile getStylesheetFile(Resource stylesheetResource) {
        try {
            S2SFile pdfFile = new S2SFile();
            pdfFile.setData(stylesheetResource.getInputStream().readAllBytes());
            pdfFile.setName(stylesheetResource.getFilename());
            pdfFile.setType("text/xsl");
            return pdfFile;
        }
        catch (IOException e) {
            throw new S2SException((Exception)e);
        }
    }

    protected S2sAppSubmissionContract getLatestS2SAppSubmission(List<? extends S2sAppSubmissionContract> submissions) {
        return submissions.stream().max(Comparator.comparing(S2sAppSubmissionContract::getSubmissionNumber)).orElse(null);
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public NarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public S2SFormGeneratorRetrievalService getS2SFormGeneratorRetrievalService() {
        return this.s2SFormGeneratorRetrievalService;
    }

    public void setS2SFormGeneratorRetrievalService(S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService) {
        this.s2SFormGeneratorRetrievalService = s2SFormGeneratorRetrievalService;
    }

    public S2SValidatorService getS2SValidatorService() {
        return this.s2SValidatorService;
    }

    public void setS2SValidatorService(S2SValidatorService s2SValidatorService) {
        this.s2SValidatorService = s2SValidatorService;
    }

    public FormApplicationService getFormApplicationService() {
        return this.formApplicationService;
    }

    public void setFormApplicationService(FormApplicationService formApplicationService) {
        this.formApplicationService = formApplicationService;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private static class SubmittedPdfFillableFormGeneratorAdapter<T extends XmlObject>
    extends SubmittedFormGeneratorAdapter<T>
    implements S2SFormGeneratorPdfFillable<T> {
        private SubmittedPdfFillableFormGeneratorAdapter(S2SFormGenerator<T> generator, S2sAppSubmissionContract s2sAppSubmission) {
            super(generator, s2sAppSubmission);
        }

        @Override
        public String getBeanName() {
            return SubmittedPdfFillableFormGeneratorAdapter.class.getName();
        }

        @Override
        public Resource getPdfForm() {
            return ((S2SFormGeneratorPdfFillable)((Object)this.getGenerator())).getPdfForm();
        }

        @Override
        public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(T form, List<AttachmentData> attachments) {
            return ((S2SFormGeneratorPdfFillable)((Object)this.getGenerator())).getMappedAttachments(form, attachments);
        }
    }

    private static class SubmittedFormGeneratorAdapter<T extends XmlObject>
    implements S2SFormGenerator<T> {
        private final S2SFormGenerator<T> generator;
        private T xmlObject;
        private final List<AttachmentData> attachments;
        private final List<AuditError> auditErrors = new ArrayList<AuditError>();

        private SubmittedFormGeneratorAdapter(S2SFormGenerator<T> generator, S2sAppSubmissionContract s2sAppSubmission) {
            this.generator = generator;
            this.attachments = s2sAppSubmission.getS2sApplication().getS2sAppAttachmentList().stream().map(a -> new AttachmentData(a.getFileDataId(), a.getName(), a.getContentId(), a.getData(), a.getContentType(), "SHA-1", a.getSha1Hash(), a.getUploadUser(), a.getUploadTimestamp())).toList();
            try {
                XmlObject formsObject = this.getForms(this.getApplication(s2sAppSubmission));
                String formsXml = formsObject.toString();
                String formsXpath = formsXml.startsWith("<xml-fragment") ? "/xml-fragment/*[namespace-uri(.) = '" + generator.getNamespace() + "']" : "/*[namespace-uri(.) = '" + generator.getNamespace() + "']";
                XPathExecutor executer = new XPathExecutor(formsXml);
                Node d = executer.getNode(formsXpath);
                this.xmlObject = (XmlObject)this.factory().parse(d);
            }
            catch (XmlException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.auditErrors.add(new AuditError("noField", "error.proposalDevelopment.grants.gov.form.not.found", "grantsGov.Opportunity", new String[]{this.getFormName()}));
            }
        }

        @Override
        public DocumentFactory<T> factory() {
            return this.generator.factory();
        }

        @Override
        public String getBeanName() {
            return SubmittedFormGeneratorAdapter.class.getName();
        }

        @Override
        public String getNamespace() {
            return this.generator.getNamespace();
        }

        @Override
        public String getFormName() {
            return this.generator.getFormName();
        }

        @Override
        public int getSortIndex() {
            return this.generator.getSortIndex();
        }

        @Override
        public List<Resource> getStylesheets() {
            return this.generator.getStylesheets();
        }

        @Override
        public boolean supportsPdfFilling() {
            return this.generator.supportsPdfFilling();
        }

        @Override
        public boolean supportsXslTransform() {
            return this.generator.supportsXslTransform();
        }

        @Override
        public T getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
            return this.xmlObject;
        }

        @Override
        public List<AttachmentData> getAttachments() {
            return this.attachments;
        }

        @Override
        public List<AuditError> getAuditErrors() {
            return this.auditErrors;
        }

        private GrantApplicationDocument getApplication(S2sAppSubmissionContract s2sAppSubmission) {
            String submittedApplicationXml = s2sAppSubmission.getS2sApplication().getApplication();
            try {
                return (GrantApplicationDocument)GrantApplicationDocument.Factory.parse(submittedApplicationXml);
            }
            catch (XmlException e) {
                throw new S2SException((Exception)((Object)e));
            }
        }

        private XmlObject getForms(GrantApplicationDocument grantApplicationDocument) {
            return grantApplicationDocument.getGrantApplication().getForms().newCursor().getObject();
        }

        public S2SFormGenerator<T> getGenerator() {
            return this.generator;
        }
    }

    private static class OverriddenPdfFillableFormGeneratorAdapter<T extends XmlObject>
    extends OverriddenFormGeneratorAdapter<T>
    implements S2SFormGeneratorPdfFillable<T> {
        private OverriddenPdfFillableFormGeneratorAdapter(S2SFormGenerator<T> generator, S2sOverrideContract s2sOverride) {
            super(generator, s2sOverride);
            if (!s2sOverride.isActive()) {
                throw new IllegalStateException("S2sOverride is not active");
            }
        }

        @Override
        public String getBeanName() {
            return OverriddenPdfFillableFormGeneratorAdapter.class.getName();
        }

        @Override
        public Resource getPdfForm() {
            return ((S2SFormGeneratorPdfFillable)((Object)this.getGenerator())).getPdfForm();
        }

        @Override
        public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(T form, List<AttachmentData> attachments) {
            return ((S2SFormGeneratorPdfFillable)((Object)this.getGenerator())).getMappedAttachments(form, attachments);
        }
    }

    private static class OverriddenFormGeneratorAdapter<T extends XmlObject>
    implements S2SFormGenerator<T> {
        private final S2SFormGenerator<T> generator;
        private T xmlObject;
        private final List<AttachmentData> attachments;
        private final List<AuditError> auditErrors = new ArrayList<AuditError>();

        private OverriddenFormGeneratorAdapter(S2SFormGenerator<T> generator, S2sOverrideContract s2sOverride) {
            if (!s2sOverride.isActive()) {
                throw new IllegalStateException("S2sOverride is not active");
            }
            this.generator = generator;
            this.attachments = s2sOverride.getApplicationOverride().getAttachments().stream().map(a -> new AttachmentData(a.getFileDataId(), a.getName(), a.getContentId(), a.getData(), a.getType(), "SHA-1", a.getSha1Hash(), a.getUploadUser(), a.getUploadTimestamp())).toList();
            try {
                XmlObject formsObject = this.getForms(this.getApplication(s2sOverride));
                String formsXml = formsObject.toString();
                String formsXpath = formsXml.startsWith("<xml-fragment") ? "/xml-fragment/*[namespace-uri(.) = '" + generator.getNamespace() + "']" : "/*[namespace-uri(.) = '" + generator.getNamespace() + "']";
                XPathExecutor executer = new XPathExecutor(formsXml);
                Node d = executer.getNode(formsXpath);
                this.xmlObject = (XmlObject)this.factory().parse(d);
            }
            catch (XmlException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.auditErrors.add(new AuditError("noField", "error.proposalDevelopment.grants.gov.form.not.found", "grantsGov.Opportunity", new String[]{this.getFormName()}));
            }
        }

        @Override
        public DocumentFactory<T> factory() {
            return this.generator.factory();
        }

        @Override
        public String getBeanName() {
            return OverriddenFormGeneratorAdapter.class.getName();
        }

        @Override
        public String getNamespace() {
            return this.generator.getNamespace();
        }

        @Override
        public String getFormName() {
            return this.generator.getFormName();
        }

        @Override
        public int getSortIndex() {
            return this.generator.getSortIndex();
        }

        @Override
        public List<Resource> getStylesheets() {
            return this.generator.getStylesheets();
        }

        @Override
        public boolean supportsPdfFilling() {
            return this.generator.supportsPdfFilling();
        }

        @Override
        public boolean supportsXslTransform() {
            return this.generator.supportsXslTransform();
        }

        @Override
        public T getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
            return this.xmlObject;
        }

        @Override
        public List<AttachmentData> getAttachments() {
            return this.attachments;
        }

        @Override
        public List<AuditError> getAuditErrors() {
            return this.auditErrors;
        }

        private GrantApplicationDocument getApplication(S2sOverrideContract s2sOverride) {
            String submittedApplicationXml = s2sOverride.getApplicationOverride().getApplication();
            try {
                return (GrantApplicationDocument)GrantApplicationDocument.Factory.parse(submittedApplicationXml);
            }
            catch (XmlException e) {
                throw new S2SException((Exception)((Object)e));
            }
        }

        private XmlObject getForms(GrantApplicationDocument grantApplicationDocument) {
            return grantApplicationDocument.getGrantApplication().getForms().newCursor().getObject();
        }

        public S2SFormGenerator<T> getGenerator() {
            return this.generator;
        }
    }
}

