/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.print;

import gov.grants.apply.system.metaGrantApplication.GrantApplicationDocument;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeService;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardAttachmentContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.attachment.ProposalPersonBiographyContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.s2s.S2sAppAttachmentsContract;
import org.kuali.coeus.propdev.api.s2s.S2sAppSubmissionContract;
import org.kuali.coeus.propdev.api.s2s.S2sApplicationContract;
import org.kuali.coeus.propdev.api.s2s.S2sApplicationService;
import org.kuali.coeus.propdev.api.s2s.S2sOppFormsContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormAttContract;
import org.kuali.coeus.propdev.api.s2s.UserAttachedFormService;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.print.FormPrintResult;
import org.kuali.coeus.s2sgen.api.print.FormPrintService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorRetrievalService;
import org.kuali.coeus.s2sgen.impl.print.GenericPrintable;
import org.kuali.coeus.s2sgen.impl.print.S2SFile;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintable;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintingService;
import org.kuali.coeus.s2sgen.impl.util.SafeXmlUtils;
import org.kuali.coeus.s2sgen.impl.util.XPathExecutor;
import org.kuali.coeus.s2sgen.impl.validate.S2SValidatorService;
import org.kuali.coeus.s2sgen.impl.validate.ValidationResult;
import org.kuali.coeus.sys.api.model.KcFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(value="formPrintService")
public class FormPrintServiceImpl
implements FormPrintService {
    private static final Logger LOG = LogManager.getLogger(FormPrintServiceImpl.class);
    private static final String NARRATIVE_CONTENT_ID_PREFIX = "N";
    private static final String BIOGRAPHY_CONTENT_ID_PREFIX = "B";
    private static final String NARRATIVE_LEGACY_DATA_CONTENT_ID_PREFIX = "M";
    private static final String BIOGRAPHY_LEGACY_DATA_CONTENT_ID_PREFIX = "ID";
    private static final String BIOGRAPHY_LEGACY_DATA_CONTENT_ID_ELEMENT = "BN";
    private static final List<String> ATT_PREFIXES = Stream.of("N-", "B-", "M-", "ID-", "BN-").toList();
    @Autowired
    @Qualifier(value="s2sApplicationService")
    private S2sApplicationService s2sApplicationService;
    @Autowired
    @Qualifier(value="s2SFormGeneratorRetrievalService")
    private S2SFormGeneratorRetrievalService s2SFormGeneratorService;
    @Autowired
    @Qualifier(value="s2SValidatorService")
    private S2SValidatorService s2SValidatorService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    private S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="narrativeService")
    private NarrativeService narrativeService;
    @Autowired
    @Qualifier(value="s2SPrintingService")
    private S2SPrintingService s2SPrintingService;
    @Autowired
    @Qualifier(value="userAttachedFormService")
    private UserAttachedFormService userAttachedFormService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    protected S2SCommonBudgetService s2SCommonBudgetService;

    public FormPrintResult printForm(ProposalDevelopmentDocumentContract pdDoc) throws S2SException {
        if (pdDoc == null) {
            throw new IllegalArgumentException("pdDoc is null");
        }
        S2sAppSubmissionContract s2sAppSubmission = this.getLatestS2SAppSubmission(pdDoc);
        PrintableResult pResult = s2sAppSubmission != null && s2sAppSubmission.getGgTrackingId() != null ? this.getSubmittedPDFStream(pdDoc) : this.getPDFStream(pdDoc);
        if (pdDoc.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
            FormPrintResult result = new FormPrintResult();
            result.setErrors(pResult.errors);
            return result;
        }
        S2SFile attachmentDataSource = this.s2SPrintingService.print(pResult.printables);
        attachmentDataSource.setName(this.getFileNameForFormPrinting(pdDoc));
        FormPrintResult result = new FormPrintResult();
        result.setFile((KcFile)attachmentDataSource);
        result.setErrors(pResult.errors);
        return result;
    }

    protected void saveGrantsGovXml(ProposalDevelopmentDocumentContract pdDoc, boolean formEntryFlag, XmlObject formObject, List<AttachmentData> attachmentList, List<? extends S2sAppAttachmentsContract> attachmentLists) throws Exception {
        File attachmentFile;
        String loggingDirectory = this.s2SConfigurationService.getValueAsString("print.xml.directory");
        String opportunityId = pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityId();
        String proposalnumber = pdDoc.getDevelopmentProposal().getProposalNumber();
        String exportDate = StringUtils.replaceChars((String)pdDoc.getDevelopmentProposal().getUpdateTimestamp().toString(), (String)":", (String)"_");
        File grantsGovXmlDirectoryFile = new File(loggingDirectory + opportunityId + "." + proposalnumber + "." + (exportDate = StringUtils.replaceChars((String)exportDate, (String)" ", (String)".")));
        if (!grantsGovXmlDirectoryFile.exists() || formEntryFlag) {
            grantsGovXmlDirectoryFile.mkdir();
        }
        for (AttachmentData attachmentData : attachmentList) {
            attachmentFile = new File(grantsGovXmlDirectoryFile, "Attachments");
            attachmentFile.mkdir();
            File attachedFile = new File(attachmentFile, attachmentData.getFileName());
            try (FileOutputStream output = new FileOutputStream(attachedFile);){
                output.write(attachmentData.getContent());
            }
        }
        for (S2sAppAttachmentsContract s2sAppAttachmentsContract : attachmentLists) {
            attachmentFile = new File(grantsGovXmlDirectoryFile, "Attachments");
            attachmentFile.mkdir();
            KcFile ads = this.getAttributeContent(pdDoc, s2sAppAttachmentsContract.getContentId());
            if (ads == null) continue;
            File attachedFile = new File(attachmentFile, ads.getName());
            try (FileOutputStream output = new FileOutputStream(attachedFile);){
                output.write(ads.getData());
            }
        }
        File xmlFile = new File(grantsGovXmlDirectoryFile, opportunityId + "." + proposalnumber + "." + exportDate + ".xml");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(xmlFile));){
            bufferedWriter.write(formObject.xmlText());
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(grantsGovXmlDirectoryFile + ".zip");
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            this.addFolderToZip("", grantsGovXmlDirectoryFile.getPath(), zipOutputStream);
            zipOutputStream.flush();
        }
    }

    protected void addFolderToZip(String path, String sourceFolder, ZipOutputStream zipOutputStream) throws Exception {
        File proposalNumberfolder = new File(sourceFolder);
        for (String fileName : proposalNumberfolder.list()) {
            if (path.isEmpty()) {
                this.addFileToZip(proposalNumberfolder.getName(), sourceFolder + "/" + fileName, zipOutputStream);
                continue;
            }
            this.addFileToZip(path + "/" + proposalNumberfolder.getName(), sourceFolder + "/" + fileName, zipOutputStream);
        }
    }

    protected void addFileToZip(String path, String sourceFile, ZipOutputStream zipOutputStream) throws Exception {
        File attachmentFile = new File(sourceFile);
        if (attachmentFile.isDirectory()) {
            this.addFolderToZip(path, sourceFile, zipOutputStream);
        } else {
            byte[] buffer = new byte[1024];
            try (FileInputStream fileInputStream = new FileInputStream(attachmentFile);){
                int length;
                zipOutputStream.putNextEntry(new ZipEntry(path + "/" + attachmentFile.getName()));
                while ((length = fileInputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, length);
                }
            }
        }
    }

    protected String getFileNameForFormPrinting(ProposalDevelopmentDocumentContract pdDoc) {
        String fileName = pdDoc.getDocumentNumber() + pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber() + ".pdf";
        return fileName;
    }

    protected PrintableResult getSubmittedPDFStream(ProposalDevelopmentDocumentContract pdDoc) throws S2SException {
        GrantApplicationDocument submittedDocument;
        try {
            S2sAppSubmissionContract s2sAppSubmission = this.getLatestS2SAppSubmission(pdDoc);
            String submittedApplicationXml = this.findSubmittedXml(s2sAppSubmission);
            String submittedApplication = this.s2SDateTimeService.removeTimezoneFactor(submittedApplicationXml);
            submittedDocument = (GrantApplicationDocument)GrantApplicationDocument.Factory.parse(submittedApplication);
        }
        catch (XmlException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new S2SException((Exception)((Object)e));
        }
        DevelopmentProposalContract developmentProposal = pdDoc.getDevelopmentProposal();
        List generators = this.s2SFormGeneratorService.getS2SGenerators(this.getSelectedNamespaces(developmentProposal.getS2sOppForms()), developmentProposal.getProposalNumber());
        boolean formEntryFlag = true;
        ArrayList<S2SPrintable> formPrintables = new ArrayList<S2SPrintable>();
        for (S2SFormGenerator generator : generators) {
            if (!CollectionUtils.isNotEmpty(generator.getStylesheets())) continue;
            XmlObject formFragment = this.getFormObject(submittedDocument);
            String frmXpath = formFragment.toString().startsWith("<xml-fragment") ? "/xml-fragment/*[namespace-uri(.) = '" + generator.getNamespace() + "']" : "/*[namespace-uri(.) = '" + generator.getNamespace() + "']";
            GenericPrintable formPrintable = new GenericPrintable();
            if (CollectionUtils.isNotEmpty(generator.getStylesheets())) {
                formPrintable.setXslTemplates(generator.getStylesheets());
            }
            S2sApplicationContract s2sApplciation = this.s2sApplicationService.findS2sApplicationByProposalNumber(pdDoc.getDevelopmentProposal().getProposalNumber());
            List attachmentList = s2sApplciation.getS2sAppAttachmentList();
            LinkedHashMap<String, byte[]> formAttachments = new LinkedHashMap<String, byte[]>();
            try {
                XPathExecutor executer = new XPathExecutor(formFragment.toString());
                Node d = executer.getNode(frmXpath);
                Element el = (Element)d;
                String formNodeString = this.convertNodeToString(d);
                formPrintable.setName(generator.getFormName());
                formPrintable.setXml(formNodeString);
                NodeList attList = el.getElementsByTagNameNS("http://apply.grants.gov/system/Attachments-V1.0", "FileLocation");
                int attLen = attList.getLength();
                for (int i = 0; i < attLen; ++i) {
                    Node attNode = attList.item(i);
                    String contentId = ((Element)attNode).getAttributeNS("http://apply.grants.gov/system/Attachments-V1.0", "href");
                    if (attachmentList == null || attachmentList.isEmpty()) continue;
                    for (S2sAppAttachmentsContract attAppAttachments : attachmentList) {
                        KcFile file;
                        if (!attAppAttachments.getContentId().equals(contentId) || (file = this.getAttributeContent(pdDoc, contentId)) == null) continue;
                        try (ByteArrayOutputStream attStream = new ByteArrayOutputStream();){
                            attStream.write(file.getData());
                        }
                        catch (IOException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                            throw new S2SException((Exception)e);
                        }
                        String attachment = "   ATT : " + attAppAttachments.getContentId();
                        formAttachments.put(attachment, file.getData());
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (developmentProposal.getGrantsGovSelectFlag().booleanValue()) {
                    ArrayList<AttachmentData> attachmentLists = new ArrayList<AttachmentData>();
                    this.saveGrantsGovXml(pdDoc, formEntryFlag, formFragment, attachmentLists, attachmentList);
                    formEntryFlag = false;
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            formPrintable.setAttachments(formAttachments);
            formPrintables.add(formPrintable);
        }
        PrintableResult result = new PrintableResult();
        result.printables = formPrintables;
        return result;
    }

    private String convertNodeToString(Node node) {
        try {
            DOMSource domSource = new DOMSource(node);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = SafeXmlUtils.safeTransformerFactory();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception ex) {
            LOG.warn("Not able convert form node to byte array " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected String findSubmittedXml(S2sAppSubmissionContract appSubmission) {
        S2sApplicationContract s2sApplication = this.s2sApplicationService.findS2sApplicationByProposalNumber(appSubmission.getProposalNumber());
        return s2sApplication.getApplication();
    }

    protected PrintableResult getPDFStream(ProposalDevelopmentDocumentContract pdDoc) throws S2SException {
        ArrayList<AuditError> errors = new ArrayList<AuditError>();
        DevelopmentProposalContract developmentProposal = pdDoc.getDevelopmentProposal();
        String proposalNumber = developmentProposal.getProposalNumber();
        List generators = this.s2SFormGeneratorService.getS2SGenerators(this.getSelectedNamespaces(developmentProposal.getS2sOppForms()), proposalNumber);
        ArrayList<S2SPrintable> formPrintables = new ArrayList<S2SPrintable>();
        boolean formEntryFlag = true;
        this.getNarrativeService().deleteSystemGeneratedNarratives(pdDoc.getDevelopmentProposal().getNarratives());
        GrantApplicationDocument.GrantApplication.Forms forms = (GrantApplicationDocument.GrantApplication.Forms)GrantApplicationDocument.GrantApplication.Forms.Factory.newInstance();
        for (S2SFormGenerator s2sFormGenerator : generators) {
            Object formObject = s2sFormGenerator.getFormObject(pdDoc);
            errors.addAll(s2sFormGenerator.getAuditErrors());
            ValidationResult result = this.s2SValidatorService.validateForm((XmlObject)formObject, s2sFormGenerator.getFormName());
            errors.addAll(result.getErrors());
            if (!result.isValid() || !errors.stream().noneMatch(error -> error.getLevel() != AuditError.Level.WARNING) || !CollectionUtils.isNotEmpty(s2sFormGenerator.getStylesheets())) continue;
            String applicationXml = formObject.xmlText(this.s2SFormGeneratorService.getXmlOptionsPrefixes());
            String filteredApplicationXml = this.s2SDateTimeService.removeTimezoneFactor(applicationXml);
            GenericPrintable formPrintable = new GenericPrintable();
            formPrintable.setName(s2sFormGenerator.getFormName());
            formPrintable.setXml(filteredApplicationXml);
            if (CollectionUtils.isNotEmpty(s2sFormGenerator.getStylesheets())) {
                formPrintable.setXslTemplates(s2sFormGenerator.getStylesheets());
            }
            List<AttachmentData> attachmentList = s2sFormGenerator.getAttachments();
            try {
                if (developmentProposal.getGrantsGovSelectFlag().booleanValue()) {
                    ArrayList attachmentLists = new ArrayList();
                    this.setFormObject(forms, (XmlObject)formObject);
                    this.saveGrantsGovXml(pdDoc, formEntryFlag, forms, attachmentList, attachmentLists);
                    formEntryFlag = false;
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            LinkedHashMap<String, byte[]> formAttachments = new LinkedHashMap<String, byte[]>();
            if (attachmentList != null && !attachmentList.isEmpty()) {
                for (AttachmentData attachmentData : attachmentList) {
                    if (!this.isPdfType(attachmentData.getContent())) continue;
                    String attachment = "   ATT : " + attachmentData.getContentId();
                    formAttachments.put(attachment, attachmentData.getContent());
                }
            }
            if (!formAttachments.isEmpty()) {
                formPrintable.setAttachments(formAttachments);
            }
            formPrintables.add(formPrintable);
        }
        PrintableResult result = new PrintableResult();
        result.errors = errors;
        result.printables = formPrintables;
        return result;
    }

    protected XmlObject getFormObject(GrantApplicationDocument submittedXml) {
        GrantApplicationDocument.GrantApplication.Forms forms = submittedXml.getGrantApplication().getForms();
        return forms.newCursor().getObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KcFile getAttributeContent(ProposalDevelopmentDocumentContract pdDoc, String contentId) {
        KcFile bsAtt = this.getBudgetSubawardAttachment(pdDoc, contentId);
        if (bsAtt != null) {
            return bsAtt;
        }
        KcFile uafAtt = this.getUserAttachedFormAttachment(pdDoc, contentId);
        if (uafAtt != null) {
            return uafAtt;
        }
        String proposalNumber = pdDoc.getDevelopmentProposal().getProposalNumber();
        String contentSubId = StringUtils.replace((String)contentId, (String)(proposalNumber + "-"), (String)"");
        if (ATT_PREFIXES.stream().anyMatch(contentSubId::startsWith)) {
            String[] contentIds = contentSubId.split("-");
            String[] contentDesc = contentIds[1].split("_");
            if (StringUtils.equals((CharSequence)contentIds[0], (CharSequence)NARRATIVE_CONTENT_ID_PREFIX)) {
                for (NarrativeContract narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
                    if (!narrative.getModuleNumber().equals(Integer.valueOf(contentDesc[0]))) continue;
                    return narrative.getNarrativeAttachment();
                }
                return null;
            } else {
                if (!StringUtils.equals((CharSequence)contentIds[0], (CharSequence)BIOGRAPHY_CONTENT_ID_PREFIX)) return this.getLegacyCoeusAttachmentContent(pdDoc, contentIds, contentDesc);
                for (ProposalPersonBiographyContract biography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
                    if (!biography.getProposalPersonNumber().equals(Integer.valueOf(contentDesc[0])) || !biography.getBiographyNumber().equals(Integer.valueOf(contentDesc[1]))) continue;
                    return biography.getPersonnelAttachment();
                }
            }
            return null;
        } else {
            LOG.warn("contentId: " + contentId + " has an invalid format");
        }
        return null;
    }

    protected KcFile getLegacyCoeusAttachmentContent(ProposalDevelopmentDocumentContract pdDoc, String[] contentIds, String[] contentDesc) {
        if (StringUtils.equals((CharSequence)contentIds[0], (CharSequence)NARRATIVE_LEGACY_DATA_CONTENT_ID_PREFIX)) {
            return pdDoc.getDevelopmentProposal().getNarratives().stream().filter(narrative -> narrative.getModuleNumber().equals(Integer.valueOf(contentDesc[0]))).findAny().get().getNarrativeAttachment();
        }
        if (StringUtils.equals((CharSequence)contentIds[0], (CharSequence)BIOGRAPHY_LEGACY_DATA_CONTENT_ID_PREFIX) && StringUtils.equals((CharSequence)contentDesc[1], (CharSequence)BIOGRAPHY_LEGACY_DATA_CONTENT_ID_ELEMENT)) {
            String[] biographyDescrption = contentIds[2].split("_");
            return pdDoc.getDevelopmentProposal().getPropPersonBios().stream().filter(biography -> biography.getPersonId().equals(contentDesc[0]) && biography.getBiographyNumber().equals(Integer.valueOf(biographyDescrption[0]))).findAny().get().getPersonnelAttachment();
        }
        return null;
    }

    private KcFile getUserAttachedFormAttachment(ProposalDevelopmentDocumentContract pdDoc, String contentId) {
        Optional<S2sUserAttachedFormAttContract> uafAtt = pdDoc.getDevelopmentProposal().getS2sUserAttachedForms().stream().flatMap(uaf -> uaf.getS2sUserAttachedFormAtts().stream()).filter(att -> contentId.equals(att.getContentId())).findAny();
        return uafAtt.orElse(null);
    }

    private KcFile getBudgetSubawardAttachment(ProposalDevelopmentDocumentContract pdDoc, String contentId) {
        Optional<BudgetSubAwardAttachmentContract> att;
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(pdDoc.getDevelopmentProposal());
        if (budget != null && (att = budget.getBudgetSubAwards().stream().flatMap(sa -> sa.getBudgetSubAwardAttachments().stream()).filter(attachment -> contentId.equals(attachment.getName())).findAny()).isPresent()) {
            return (KcFile)att.get();
        }
        return null;
    }

    protected S2sAppSubmissionContract getLatestS2SAppSubmission(ProposalDevelopmentDocumentContract pdDoc) {
        S2sAppSubmissionContract s2sSubmission = null;
        int submissionNo = 0;
        for (S2sAppSubmissionContract s2sAppSubmission : pdDoc.getDevelopmentProposal().getS2sAppSubmission()) {
            if (s2sAppSubmission.getSubmissionNumber() == null || s2sAppSubmission.getSubmissionNumber() <= submissionNo) continue;
            s2sSubmission = s2sAppSubmission;
            submissionNo = s2sAppSubmission.getSubmissionNumber();
        }
        return s2sSubmission;
    }

    protected Set<String> getSelectedNamespaces(List<? extends S2sOppFormsContract> s2sOppForms) {
        return s2sOppForms.stream().filter(S2sOppFormsContract::getSelectToPrint).map(S2sOppFormsContract::getOppNameSpace).collect(Collectors.toSet());
    }

    protected boolean isPdfType(byte[] data) {
        int ATTRIBUTE_CHUNK_SIZE = 1200;
        String PRE_HEXA = "0x";
        boolean retValue = false;
        String[] str = new String[]{"25", "50", "44", "46"};
        byte[] byteCheckArr = new byte[4];
        byte[] byteDataArr = new byte[4];
        for (int byteIndex = 0; byteIndex < byteCheckArr.length; ++byteIndex) {
            byteCheckArr[byteIndex] = Integer.decode("0x" + str[byteIndex]).byteValue();
        }
        int startPoint = 0;
        int endPoint = 1200 > data.length / 2 ? data.length / 2 : 1200;
        for (int forwardIndex = startPoint; forwardIndex < endPoint - str.length; ++forwardIndex) {
            if (forwardIndex == 0) {
                for (int fillIndex = 0; fillIndex < str.length; ++fillIndex) {
                    byteDataArr[fillIndex] = FormPrintServiceImpl.toUnsignedByte(data[fillIndex]);
                }
            } else {
                System.arraycopy(byteDataArr, 1, byteDataArr, 0, str.length - 1);
                byteDataArr[str.length - 1] = FormPrintServiceImpl.toUnsignedByte(data[str.length - 1 + forwardIndex]);
            }
            if (!new String(byteCheckArr).equals(new String(byteDataArr))) continue;
            retValue = true;
        }
        return retValue;
    }

    protected static byte toUnsignedByte(int intVal) {
        byte byteVal;
        if (intVal > 127) {
            int temp = intVal - 256;
            byteVal = (byte)temp;
        } else {
            byteVal = (byte)intVal;
        }
        return byteVal;
    }

    protected void setFormObject(GrantApplicationDocument.GrantApplication.Forms forms, XmlObject formObject) {
        XmlCursor formCursor = formObject.newCursor();
        formCursor.toStartDoc();
        formCursor.toNextToken();
        XmlCursor metaGrantCursor = forms.newCursor();
        metaGrantCursor.toNextToken();
        formCursor.moveXml(metaGrantCursor);
    }

    public NarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public S2SPrintingService getS2SPrintingService() {
        return this.s2SPrintingService;
    }

    public void setS2SPrintingService(S2SPrintingService s2SPrintingService) {
        this.s2SPrintingService = s2SPrintingService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    public S2sApplicationService getS2sApplicationService() {
        return this.s2sApplicationService;
    }

    public void setS2sApplicationService(S2sApplicationService s2sApplicationService) {
        this.s2sApplicationService = s2sApplicationService;
    }

    public S2SFormGeneratorRetrievalService getS2SFormGeneratorService() {
        return this.s2SFormGeneratorService;
    }

    public S2SValidatorService getS2SValidatorService() {
        return this.s2SValidatorService;
    }

    public UserAttachedFormService getUserAttachedFormService() {
        return this.userAttachedFormService;
    }

    public void setUserAttachedFormService(UserAttachedFormService userAttachedFormService) {
        this.userAttachedFormService = userAttachedFormService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }

    public void setS2SFormGeneratorService(S2SFormGeneratorRetrievalService s2SFormGeneratorService) {
        this.s2SFormGeneratorService = s2SFormGeneratorService;
    }

    public void setS2SValidatorService(S2SValidatorService s2SValidatorService) {
        this.s2SValidatorService = s2SValidatorService;
    }

    protected static class PrintableResult {
        private List<S2SPrintable> printables;
        private List<AuditError> errors;

        protected PrintableResult() {
        }
    }
}

