/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.print;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.print.S2SFile;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintable;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintingService;
import org.kuali.coeus.s2sgen.impl.util.SafeXmlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component(value="s2SPrintingService")
public class S2SPrintingServiceImpl
implements S2SPrintingService {
    private static final Logger LOG = LogManager.getLogger(S2SPrintingServiceImpl.class);
    private static final char SPACE_SEPARATOR = ' ';
    private static final int WHITESPACE_LENGTH_76 = 76;
    private static final int WHITESPACE_LENGTH_60 = 60;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

    protected Map<String, byte[]> getPrintBytes(S2SPrintable printableArtifact) {
        FopFactoryBuilder builder;
        String xml = printableArtifact.getXml();
        String name = printableArtifact.getName();
        try {
            String loggingEnable = this.s2SConfigurationService.getValueAsString("print.logging.enable");
            if (Boolean.parseBoolean(loggingEnable)) {
                this.logPrintDetails(xml, name);
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        LinkedHashMap<String, byte[]> pdfByteMap = new LinkedHashMap<String, byte[]>();
        try {
            builder = new FopFactoryBuilder(new URI(this.s2SConfigurationService.getValueAsString("application.url")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        FopFactory fopFactory = builder.build();
        if (CollectionUtils.isNotEmpty(printableArtifact.getXslTemplates())) {
            IntStream.range(0, printableArtifact.getXslTemplates().size()).forEach(i -> {
                Resource xslt = printableArtifact.getXslTemplates().get(i);
                try {
                    if (xslt.getInputStream().available() <= 0) {
                        LOG.error("Stylesheet is not available");
                    } else {
                        this.createPdfWithFOP(xml, i + "_" + name, pdfByteMap, fopFactory, xslt);
                    }
                }
                catch (IOException | TransformerException | FOPException e) {
                    throw new S2SException(e.getMessage(), (Exception)e);
                }
            });
        }
        if (printableArtifact.getAttachments() != null) {
            pdfByteMap.putAll(printableArtifact.getAttachments());
        }
        return pdfByteMap;
    }

    protected void createPdfWithFOP(String xml, String name, Map<String, byte[]> pdfByteMap, FopFactory fopFactory, Resource xslt) throws FOPException, TransformerException, IOException {
        TransformerFactory factory = SafeXmlUtils.safeTransformerFactory();
        Transformer transformer = factory.newTransformer(new StreamSource(xslt.getInputStream()));
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8.name()));
        StreamSource src = new StreamSource(inputStream);
        Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)outputStream);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
        byte[] pdfBytes = outputStream.toByteArray();
        if (pdfBytes.length > 0) {
            pdfByteMap.put(name, pdfBytes);
        }
    }

    @Override
    public S2SFile print(S2SPrintable printableArtifacts) throws S2SException {
        ArrayList<S2SPrintable> printables = new ArrayList<S2SPrintable>();
        printables.add(printableArtifacts);
        return this.print(printables);
    }

    @Override
    public S2SFile print(List<S2SPrintable> printableArtifactList) throws S2SException {
        ArrayList<String> bookmarksList = new ArrayList<String>();
        ArrayList<byte[]> pdfBaosList = new ArrayList<byte[]>();
        for (S2SPrintable printableArtifact : printableArtifactList) {
            Map<String, byte[]> printBytes = this.getPrintBytes(printableArtifact);
            for (String bookmark : printBytes.keySet()) {
                byte[] pdfBytes = printBytes.get(bookmark);
                if (!this.isPdfGoodToMerge(pdfBytes)) continue;
                bookmarksList.add(bookmark);
                pdfBaosList.add(pdfBytes);
            }
        }
        S2SFile printablePdf = new S2SFile();
        byte[] mergedPdfBytes = this.mergePdfBytes(pdfBaosList, bookmarksList, false);
        if (mergedPdfBytes == null) {
            mergedPdfBytes = new byte[]{};
        }
        printablePdf.setData(mergedPdfBytes);
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getReportName());
        fileName.append(".pdf");
        printablePdf.setName(fileName.toString());
        printablePdf.setType("application/pdf");
        boolean loggingEnable = this.s2SConfigurationService.getValueAsBoolean("print.pdf.logging.enable");
        if (loggingEnable) {
            this.logPdfPrintDetails(printablePdf);
        }
        return printablePdf;
    }

    protected boolean isPdfGoodToMerge(byte[] pdfBytes) throws S2SException {
        try {
            new PdfReader(pdfBytes);
            return true;
        }
        catch (IOException e) {
            throw new S2SException((Exception)e);
        }
    }

    protected String getReportName() {
        String dateString = new Date().toString();
        return StringUtils.deleteWhitespace((String)dateString);
    }

    @Override
    public byte[] mergePdfBytes(List<byte[]> pdfBytesList, List<String> bookmarksList, boolean headerFooterRequired) throws S2SException {
        PdfReader reader;
        Document document = null;
        PdfWriter writer = null;
        ByteArrayOutputStream mergedPdfReport = new ByteArrayOutputStream();
        int totalNumOfPages = 0;
        PdfReader[] pdfReaderArr = new PdfReader[pdfBytesList.size()];
        int pdfReaderCount = 0;
        for (byte[] fileBytes : pdfBytesList) {
            LOG.debug("File Size " + fileBytes.length + " For " + bookmarksList.get(pdfReaderCount));
            try {
                pdfReaderArr[pdfReaderCount] = reader = new PdfReader(fileBytes);
                ++pdfReaderCount;
                totalNumOfPages += reader.getNumberOfPages();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        HeaderFooter footer = null;
        if (headerFooterRequired) {
            Calendar calendar = Calendar.getInstance();
            String dateString = this.formateCalendar(calendar);
            StringBuilder footerPhStr = new StringBuilder();
            footerPhStr.append(" of ");
            footerPhStr.append(totalNumOfPages);
            footerPhStr.append(this.getWhitespaceString(76));
            footerPhStr.append(this.getWhitespaceString(76));
            footerPhStr.append(this.getWhitespaceString(60));
            footerPhStr.append(dateString);
            Font font = FontFactory.getFont((String)"Times", (float)8.0f, (int)0, (Color)Color.BLACK);
            Phrase beforePhrase = new Phrase("Page ", font);
            Phrase afterPhrase = new Phrase(footerPhStr.toString(), font);
            footer = new HeaderFooter(beforePhrase, afterPhrase);
            footer.setAlignment(7);
            footer.setBorderWidth(0.0f);
        }
        for (int count = 0; count < pdfReaderArr.length; ++count) {
            reader = pdfReaderArr[count];
            if (reader == null) {
                LOG.debug("Empty PDF byetes found for " + bookmarksList.get(count));
                continue;
            }
            int nop = reader.getNumberOfPages();
            if (count == 0) {
                document = nop > 0 ? new Document(reader.getPageSizeWithRotation(1)) : new Document();
                try {
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)mergedPdfReport);
                }
                catch (DocumentException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new S2SException(e.getMessage(), (Exception)((Object)e));
                }
                if (footer != null) {
                    document.setFooter(footer);
                }
                document.open();
            }
            PdfContentByte cb = writer.getDirectContent();
            int pageCount = 0;
            while (pageCount < nop) {
                document.setPageSize(reader.getPageSize(++pageCount));
                document.newPage();
                if (footer != null) {
                    document.setFooter(footer);
                }
                PdfImportedPage page = writer.getImportedPage(reader, pageCount);
                cb.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                PdfOutline root = cb.getRootOutline();
                if (pageCount != 1) continue;
                String pageName = bookmarksList.get(count);
                cb.addOutline(new PdfOutline(root, new PdfDestination(2), pageName), pageName);
            }
        }
        if (document != null) {
            try {
                document.close();
                return mergedPdfReport.toByteArray();
            }
            catch (Exception e) {
                LOG.error("Exception occured because the generated PDF document has no pages", (Throwable)e);
            }
        }
        return null;
    }

    protected String formateCalendar(Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("M/d/yy h:mm a");
        return dateFormat.format(calendar.getTime());
    }

    protected String getWhitespaceString(int length) {
        StringBuilder sb = new StringBuilder();
        char[] whiteSpace = new char[length];
        Arrays.fill(whiteSpace, ' ');
        sb.append(whiteSpace);
        return sb.toString();
    }

    protected void logPrintDetails(String xmlString, String key) {
        String loggingDirectory = this.s2SConfigurationService.getValueAsString("print.logging.directory");
        if (loggingDirectory != null) {
            String dateString = new Timestamp(new Date().getTime()).toString();
            String reportName = StringUtils.deleteWhitespace((String)key);
            String createdTime = StringUtils.replaceChars((String)StringUtils.deleteWhitespace((String)dateString), (String)":", (String)"_");
            File dir = this.getLoggingDir(loggingDirectory);
            File file = new File(dir, reportName + "_" + createdTime + ".xml");
            try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
                out.write(xmlString);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void logPdfPrintDetails(S2SFile pdf) {
        String loggingDirectory = this.s2SConfigurationService.getValueAsString("print.logging.directory");
        if (loggingDirectory != null && pdf != null && pdf.getData() != null) {
            String dateString = new Timestamp(new Date().getTime()).toString();
            String createdTime = StringUtils.replaceChars((String)StringUtils.deleteWhitespace((String)dateString), (String)":", (String)"_");
            String fileName = StringUtils.replaceChars((String)StringUtils.deleteWhitespace((String)pdf.getName().replace(".pdf", "")), (String)":", (String)"_") + "_" + createdTime + ".pdf";
            try (FileOutputStream fos = new FileOutputStream(new File(this.getLoggingDir(loggingDirectory), fileName));){
                fos.write(pdf.getData());
                fos.flush();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected File getLoggingDir(String loggingDirectory) {
        File dir = new File(loggingDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        return dir;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }
}

