/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.util.SafeXmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XPathExecutor {
    private Document doc;

    public XPathExecutor(String xml) {
        try {
            this.init(xml);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new S2SException(e);
        }
    }

    public String execute(String xPath) {
        if (xPath == null) {
            return null;
        }
        try {
            return XPathFactory.newInstance().newXPath().evaluate(xPath, this.getDoc());
        }
        catch (XPathExpressionException e) {
            throw new S2SException((Exception)e);
        }
    }

    public Node getNode(String xpath) {
        try {
            return (Node)XPathFactory.newInstance().newXPath().evaluate(xpath, this.getDoc(), XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new S2SException((Exception)e);
        }
    }

    private void init(String xml) throws IOException, ParserConfigurationException, SAXException {
        if (xml == null) {
            return;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8.name()));){
            DocumentBuilderFactory dfactory = SafeXmlUtils.safeDocumentBuilderFactory();
            dfactory.setNamespaceAware(true);
            this.setDoc(dfactory.newDocumentBuilder().parse(stream));
        }
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }
}

