/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.validate;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.impl.util.SafeXmlUtils;
import org.kuali.coeus.s2sgen.impl.util.XmlBeansUtils;
import org.kuali.coeus.s2sgen.impl.validate.S2SErrorHandlerService;
import org.kuali.coeus.s2sgen.impl.validate.S2SValidatorService;
import org.kuali.coeus.s2sgen.impl.validate.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Component(value="s2SValidatorService")
public class S2SValidatorServiceImpl
implements S2SValidatorService {
    private static final Logger LOG = LogManager.getLogger(S2SValidatorServiceImpl.class);
    private static final Cache<String, Schema> SCHEMA_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
    @Autowired
    @Qualifier(value="s2SErrorHandlerService")
    private S2SErrorHandlerService s2SErrorHandlerService;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/schema/catalog.xml")
    private Resource catalog;
    @Value(value="#{{'http', 'https'}}")
    private Set<String> approvedSchemaProtocols;
    @Value(value="#{{'https://apply07.grants.gov/', 'https://trainingapply.grants.gov/', 'http://at07apply.grants.gov/', ''}}")
    private Set<String> approvedSchemaPrefixes;

    @Override
    public ValidationResult validateForm(XmlObject formObject, String formName) {
        ArrayList<String> formErrors = new ArrayList<String>();
        boolean valid = this.validateXml(formObject, formErrors);
        ValidationResult result = new ValidationResult();
        result.setValid(valid);
        result.setErrors(formErrors.stream().filter(error -> this.notTopFormNodeWhenChildrenExist((String)error, (List<String>)formErrors)).map(validationError -> this.s2SErrorHandlerService.getError("/GrantApplication/Forms" + validationError, formName)).collect(Collectors.toList()));
        return result;
    }

    private boolean notTopFormNodeWhenChildrenExist(String error, List<String> formErrors) {
        return formErrors.stream().noneMatch(other -> other.startsWith(error + "/"));
    }

    @Override
    public ValidationResult validateApplication(String applicationXml, Resource oppSchemaResource) {
        final ValidationResult result = new ValidationResult();
        result.setValid(true);
        result.setErrors(Collections.emptyList());
        if (oppSchemaResource == null) {
            result.setValid(false);
            this.addAuditError(result, new AuditError("noField", "Opportunity Schema URL is blank or does not exist", "grantsGov.Opportunity", new String[0]));
        }
        if (StringUtils.isBlank((CharSequence)applicationXml)) {
            result.setValid(false);
            this.addAuditError(result, new AuditError("noField", "Application XML is blank", "grantsGov.Opportunity", new String[0]));
        }
        if (!result.isValid()) {
            return result;
        }
        Schema schema = null;
        try {
            schema = (Schema)SCHEMA_CACHE.get((Object)oppSchemaResource.getURL().toString(), () -> {
                Schema fetchedSchema = this.fetchSchema(oppSchemaResource);
                if (fetchedSchema == null) {
                    throw new IllegalStateException("Schema is null");
                }
                return fetchedSchema;
            });
        }
        catch (IOException | RuntimeException | ExecutionException e) {
            LOG.warn("Unable to fetch a valid schema " + oppSchemaResource.getFilename(), (Throwable)e);
            this.addAuditError(result, new AuditError("noField", "Unable to retrieve opportunity schema from grants.gov.  Application validation did not occur.", "grantsGov.Opportunity", AuditError.Level.WARNING, new String[0]));
        }
        if (schema != null) {
            try {
                StreamSource xmlFile = new StreamSource(new ByteArrayInputStream(applicationXml.getBytes(StandardCharsets.UTF_8.name())));
                Validator validator = SafeXmlUtils.safeValidator(schema);
                validator.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException e) {
                        S2SValidatorServiceImpl.this.addAuditError(result, new AuditError("noField", e.getMessage(), "grantsGov.Opportunity", AuditError.Level.WARNING, new String[0]));
                    }

                    @Override
                    public void error(SAXParseException e) {
                        S2SValidatorServiceImpl.this.addError(result, e);
                    }

                    @Override
                    public void fatalError(SAXParseException e) {
                        S2SValidatorServiceImpl.this.addError(result, e);
                    }
                });
                validator.validate(xmlFile);
            }
            catch (IOException | SAXException e) {
                this.addError(result, e);
            }
        }
        return result;
    }

    private void addError(ValidationResult result, Exception e) {
        result.setValid(false);
        this.addAuditError(result, new AuditError("noField", e.getMessage(), "grantsGov.Opportunity", new String[0]));
    }

    private void addAuditError(ValidationResult result, AuditError error) {
        result.setErrors(Stream.concat(Stream.of(error), result.getErrors().stream()).collect(Collectors.toList()));
    }

    private Schema fetchSchema(Resource oppSchemaResource) throws IOException, SAXException {
        String schemaUrl = oppSchemaResource.getURL().toString();
        if (this.approvedSchemaPrefixes.stream().noneMatch(schemaUrl::startsWith)) {
            throw new IllegalArgumentException("Unsafe schema location " + schemaUrl);
        }
        Schema schema = null;
        if (StringUtils.isNotBlank((CharSequence)schemaUrl)) {
            SchemaFactory schemaFactory = SafeXmlUtils.safeSchemaFactory();
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", String.join((CharSequence)",", this.approvedSchemaProtocols));
            schema = schemaFactory.newSchema(new URL(schemaUrl + "?" + UUID.randomUUID()));
        }
        return schema;
    }

    protected boolean validateXml(XmlObject formObject, List<String> errors) {
        boolean isValid;
        XmlOptions validationOptions = XmlBeansUtils.getXmlOptionsPrefixes();
        ArrayList validationErrors = new ArrayList();
        validationOptions.setErrorListener(validationErrors);
        boolean bl = isValid = StringUtils.isEmpty((CharSequence)formObject.schemaType().getFullJavaName()) || formObject.validate(validationOptions);
        if (!isValid) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Errors occurred during validation of XML from form generator");
            }
            for (XmlError error : validationErrors) {
                Node node = error.getCursorLocation().getDomNode();
                String xpath = this.getXPath(node);
                errors.add(xpath);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Error: " + error + (String)(xpath != null ? " " + xpath : ""));
            }
        }
        return isValid;
    }

    protected String getXPath(Node node) {
        if (node == null || node.getNodeType() == 9) {
            return "";
        }
        return this.getXPath(node.getParentNode()) + "/" + node.getNodeName();
    }

    public S2SErrorHandlerService getS2SErrorHandlerService() {
        return this.s2SErrorHandlerService;
    }

    public void setS2SErrorHandlerService(S2SErrorHandlerService s2SErrorHandlerService) {
        this.s2SErrorHandlerService = s2SErrorHandlerService;
    }

    public Resource getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Resource catalog) {
        this.catalog = catalog;
    }

    public Set<String> getApprovedSchemaProtocols() {
        return this.approvedSchemaProtocols;
    }

    public void setApprovedSchemaProtocols(Set<String> approvedSchemaProtocols) {
        this.approvedSchemaProtocols = approvedSchemaProtocols;
    }

    public Set<String> getApprovedSchemaPrefixes() {
        return this.approvedSchemaPrefixes;
    }

    public void setApprovedSchemaPrefixes(Set<String> approvedSchemaPrefixes) {
        this.approvedSchemaPrefixes = approvedSchemaPrefixes;
    }
}

