<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!-- $Revision:   1.4  $ -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0"
                xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
                xmlns:NSF_KeyPersonExpanded_3_3="http://apply.grants.gov/forms/NSF_KeyPersonExpanded_3_3-V3.3"
                xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
                xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://devapply.row.com/system/Header-V1.0">
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.5in" margin-right="0.5in">
                <fo:region-body margin-top="0.5in" margin-bottom="0.7in" font-family="Helvetica,Times,Courier" font-size="14pt"/>
                <fo:region-before extent=".5in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="NSF_KeyPersonExpanded_3_3:NSF_KeyPersonExpanded_3_3">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <fo:static-content flow-name="xsl-region-before">
                    <!--title-->
                    <fo:block>&#160;</fo:block>
                    <fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt" table-layout="fixed">
                        <fo:table-column column-width="proportional-column-width(20)"/>
                        <fo:table-column column-width="proportional-column-width(60)"/>
                        <fo:table-column column-width="proportional-column-width(20)"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell>
                                    <fo:block>&#160;</fo:block>
                                </fo:table-cell>
                                <fo:table-cell>
                                    <fo:block text-align="center" font-size="14pt" font-weight="200">
                                        NSF Senior/Key Person Profile (Expanded)
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell hyphenate="true" language="en" line-height="9pt" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="right" border-style="solid" border-width="0pt" border-color="white">
                                    <fo:block>
                                        <fo:inline font-size="8px" font-weight="100">OMB Number: 3145-0058</fo:inline>
                                    </fo:block>
                                    <fo:block>
                                        <fo:inline font-size="8px" font-weight="100">Expiration Date: 10/31/2025</fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:static-content>
                <fo:flow flow-name="xsl-region-body" font-family="Helvetica,Times,Courier">
                    <fo:block>&#160;</fo:block>
                    <!--==========PDPI============================================================================-->
                    <xsl:for-each select="NSF_KeyPersonExpanded_3_3:PDPI">
                        <xsl:call-template name="PersonTemplate">
                            <xsl:with-param name="title" select="'PROFILE - Project Director/Principal Investigator'"/>
                            <xsl:with-param name="organizationName" select="true()"/>
                            <xsl:with-param name="biosketchRequired" select="true()"/>
                        </xsl:call-template>
                    </xsl:for-each>
                    <!--========== End of PDPI========================================================================-->
                    <xsl:for-each select="NSF_KeyPersonExpanded_3_3:KeyPerson">
                        <xsl:call-template name="PersonTemplate">
                            <xsl:with-param name="title" select="concat('PROFILE - Senior/Key Person ', position())"/>
                            <xsl:with-param name="organizationName" select="false()"/>
                            <xsl:with-param name="biosketchRequired" select="false()"/>
                        </xsl:call-template>
                    </xsl:for-each>

                    <fo:block font-size="8pt">
                        <fo:table width="100%" table-layout="fixed">
                            <fo:table-column column-width="proportional-column-width(45)"/>
                            <fo:table-column column-width="proportional-column-width(35)"/>
                            <fo:table-column column-width="proportional-column-width(20)"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell padding-after="4pt">
                                        <fo:block>&#160;</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>File Name</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>Mime Type</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell font-weight="bold" padding-after="6pt">
                                        <fo:block>ADDITIONAL SENIOR/KEY PERSON PROFILE(S)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell hyphenate="true" language="en">
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:AdditionalProfilesAttached/NSF_KeyPersonExpanded_3_3:AdditionalProfileAttached/att:FileName"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:AdditionalProfilesAttached/NSF_KeyPersonExpanded_3_3:AdditionalProfileAttached/att:MimeType"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell font-weight="bold" padding-after="6pt">
                                        <fo:block>Additional Biographical Sketch(es) (Senior/Key Person)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell hyphenate="true" language="en">
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:BioSketchsAttached/NSF_KeyPersonExpanded_3_3:BioSketchAttached/att:FileName"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:BioSketchsAttached/NSF_KeyPersonExpanded_3_3:BioSketchAttached/att:MimeType"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell font-weight="bold" padding-after="6pt">
                                        <fo:block>Additional Current and Pending (Other) Support(s)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell hyphenate="true" language="en">
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SupportsAttached/NSF_KeyPersonExpanded_3_3:SupportAttached/att:FileName"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SupportsAttached/NSF_KeyPersonExpanded_3_3:SupportAttached/att:MimeType"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell font-weight="bold" padding-after="6pt">
                                        <fo:block>Additional Collaborators &amp; Other Affiliations</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell hyphenate="true" language="en">
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:CollaboratorsAttached/NSF_KeyPersonExpanded_3_3:CollaboratorAttached/att:FileName"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:CollaboratorsAttached/NSF_KeyPersonExpanded_3_3:CollaboratorAttached/att:MimeType"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell font-weight="bold" padding-after="6pt">
                                        <fo:block>Additional Synergistic Activities</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell hyphenate="true" language="en">
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SynergisticActivitiesAttached/NSF_KeyPersonExpanded_3_3:SynergisticAttached/att:FileName"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SynergisticActivitiesAttached/NSF_KeyPersonExpanded_3_3:SynergisticAttached/att:MimeType"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <!--========================================= KP Template ====================================-->
    <xsl:template name="PersonTemplate">
        <xsl:param name="title"/>
        <xsl:param name="organizationName"/>
        <xsl:param name="biosketchRequired"/>
        <fo:block font-size="8pt" break-after="page">
            <!--table for Person information-->
            <fo:table width="100%" border-style="solid" border-width="1pt" border-top-width="1.5pt" border-color="black" border-bottom-width="1.0pt" table-layout="fixed" font-weight="bold" >
                <fo:table-column column-width="proportional-column-width(1)"/>
                <fo:table-body>
                    <!--row1, header-->
                    <fo:table-row>
                        <fo:table-cell padding-before="4pt" padding-after="3pt">
                            <fo:block text-align="center">
                                <fo:inline font-weight="bold"><xsl:value-of select="$title"/></fo:inline>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <xsl:for-each select="NSF_KeyPersonExpanded_3_3:Profile">
                        <!--row2 & 3, first, middle, last and suffix -->
                        <xsl:for-each select="NSF_KeyPersonExpanded_3_3:Name">
                            <fo:table-row>
                                <fo:table-cell line-height="10pt" border-top-style="solid" border-width="1.5pt" border-top-color="black" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                    <fo:block>
                                        <fo:table width="100%" table-layout="fixed">
                                            <fo:table-column column-width="proportional-column-width(19)"/>
                                            <fo:table-column column-width="proportional-column-width(40)"/>
                                            <fo:table-column column-width="proportional-column-width(41)"/>
                                            <fo:table-body>
                                                <fo:table-row>
                                                    <fo:table-cell>
                                                        <fo:block>Prefix:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="./globLib:PrefixName"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell>
                                                        <fo:block>* First Name:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="./globLib:FirstName"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell>
                                                        <fo:block>Middle Name:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="./globLib:MiddleName"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- last name, suffix -->
                            <fo:table-row>
                                <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                    <fo:block>
                                        <fo:table width="100%" table-layout="fixed">
                                            <fo:table-column column-width="proportional-column-width(64)"/>
                                            <fo:table-column column-width="proportional-column-width(36)"/>
                                            <fo:table-body>
                                                <fo:table-row>
                                                    <fo:table-cell>
                                                        <fo:block>* Last Name:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="./globLib:LastName"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell>
                                                        <fo:block>Suffix:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="./globLib:SuffixName"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </xsl:for-each>
                        <!--row4-->
                        <fo:table-row>
                            <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                <fo:block>
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(100)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell hyphenate="true" language="en">
                                                    <fo:block>Position/Title:&#160;<fo:inline font-weight="100">
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:Title"/></fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                <fo:block>
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(100)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell hyphenate="true" language="en">
                                                    <fo:block>Department:&#160;<fo:inline font-weight="100">
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:Department"/></fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <!--row5-->
                        <fo:table-row>
                            <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                <fo:block>
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(100)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <xsl:choose>
                                                    <xsl:when test="$organizationName">
                                                        <fo:table-cell hyphenate="true" language="en">
                                                            <fo:block>Organization Name:&#160;<fo:inline font-weight="100">
                                                                <xsl:value-of select="NSF_KeyPersonExpanded_3_3:OrganizationName"/></fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <fo:table-cell hyphenate="true" language="en">
                                                            <fo:block>* Organization UEI ID:&#160;<fo:inline font-weight="100">
                                                                <xsl:value-of select="NSF_KeyPersonExpanded_3_3:OrganizationUEIID"/></fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                <fo:block>
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(100)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell hyphenate="true" language="en">
                                                    <fo:block>Division:&#160;<fo:inline font-weight="100">
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:Division"/></fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <!--address for-each loop-->
                        <xsl:for-each select="NSF_KeyPersonExpanded_3_3:Address">
                            <!--row6-->
                            <fo:table-row>
                                <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                    <fo:block>* Street1:&#160;<fo:inline font-weight="100"><xsl:value-of select="globLib:Street1"/></fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                    <fo:block>Street2:&#160;<fo:inline font-weight="100"><xsl:value-of select="globLib:Street2"/></fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <!--row7 (5 columns)-->
                            <fo:table-row>
                                <fo:table-cell line-height="10pt">
                                    <fo:block>
                                        <fo:table width="100%" table-layout="fixed">
                                            <fo:table-column column-width="proportional-column-width(40)"/>
                                            <fo:table-column column-width="proportional-column-width(60)"/>
                                            <fo:table-body>
                                                <fo:table-row>
                                                    <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                        <fo:block>* City:&#160;<fo:inline font-weight="100"><xsl:value-of select="globLib:City"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                        <fo:block>County/ Parish:&#160;<fo:inline font-weight="100"><xsl:value-of select="globLib:County"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell line-height="10pt">
                                    <fo:block>
                                        <fo:table width="100%" table-layout="fixed">
                                            <fo:table-column column-width="proportional-column-width(60)"/>
                                            <fo:table-column column-width="proportional-column-width(40)"/>
                                            <fo:table-body>
                                                <fo:table-row>
                                                    <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                        <fo:block>* State:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="globLib:State"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                        <fo:block>Province:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="globLib:Province"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                        <fo:block>* Country:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="globLib:Country"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                        <fo:block>* Zip / Postal Code:&#160;<fo:inline font-weight="100">
                                                            <xsl:value-of select="globLib:ZipPostalCode"/></fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <!--end Address loop-->
                        </xsl:for-each>
                        <!--row phone, fax-->
                        <fo:table-row>
                            <fo:table-cell line-height="10pt">
                                <fo:block>
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(34)"/>
                                        <fo:table-column column-width="proportional-column-width(66)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                    <fo:block>* Phone Number:&#160;<fo:inline font-weight="100">
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:Phone"/></fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                    <fo:block>Fax Number:&#160;<fo:inline font-weight="100">
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:Fax"/></fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <!--row email -->
                        <fo:table-row>
                            <fo:table-cell line-height="10pt" padding-start="3pt" padding-end="3pt" padding-before="4pt" padding-after="4pt">
                                <fo:block>* E-Mail:&#160;<fo:inline font-weight="100">
                                    <xsl:value-of select="NSF_KeyPersonExpanded_3_3:Email"/></fo:inline>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <!--row, project role, project category-->
                        <fo:table-row>
                            <fo:table-cell padding-start="3pt" padding-before="4pt" padding-after="3pt" line-height="10pt" border-top-style="solid" border-top-color="black" border-top-width="1.0pt">
                                <fo:block font-weight="bold">
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(40)"/>
                                        <fo:table-column column-width="proportional-column-width(60)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                    <fo:block>* Project Role:&#160;<fo:inline font-weight="100">
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:ProjectRole"/>
                                                    </fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>

                                            <fo:table-row>
                                                <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt" font-weight="100">
                                                    <fo:block>Enter the NSF ID associated with the PI/Co-PI
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                    <fo:block>NSF ID:&#160;<fo:inline font-weight="100">
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:NSFID"/>
                                                    </fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <!-- Degree type -->
                        <fo:table-row>
                            <fo:table-cell padding-start="3pt" padding-before="4pt" padding-after="3pt" line-height="10pt" border-top-style="solid" border-top-color="black" border-top-width="1.0pt">
                                <fo:block font-weight="bold">
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(15)"/>
                                        <fo:table-column column-width="proportional-column-width(85)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell hyphenate="true" language="en" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                    <fo:block>Degree Type:&#160;</fo:block>
                                                    <fo:block>Degree Year:&#160;</fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell hyphenate="true" language="en" font-weight="100" padding-start="3pt" padding-end="3pt" padding-before="4pt">
                                                    <fo:block>To update the Degree Type and Degree Year information please</fo:block>
                                                    <fo:block>login as a PI at <fo:basic-link external-destination="url('http://www.research.gov')" color="blue" text-decoration="underline">www.Research.gov</fo:basic-link>; and update it in the ‘View My</fo:block>
                                                    <fo:block>Roles’ page.</fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>

                        <fo:table-row>
                            <fo:table-cell padding-start="3pt" padding-before="4pt" padding-after="3pt" line-height="10pt" border-top-style="solid" border-top-color="black" border-top-width="1.0pt">
                                <fo:block>
                                    <fo:table width="100%" table-layout="fixed">
                                        <fo:table-column column-width="proportional-column-width(35)"/>
                                        <fo:table-column column-width="proportional-column-width(35)"/>
                                        <fo:table-column column-width="proportional-column-width(30)"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell padding-after="4pt">
                                                    <fo:block>&#160;</fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell>
                                                    <fo:block>File Name</fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell>
                                                    <fo:block>Mime Type</fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <xsl:choose>
                                                    <xsl:when test="$biosketchRequired">
                                                        <fo:table-cell font-weight="bold" padding-after="6pt">
                                                            <fo:block>* Attach Biographical Sketch</fo:block>
                                                        </fo:table-cell>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <fo:table-cell font-weight="bold" padding-after="6pt">
                                                            <fo:block>Attach Biographical Sketch</fo:block>
                                                        </fo:table-cell>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                <fo:table-cell hyphenate="true" language="en">
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:BioSketchsAttached/NSF_KeyPersonExpanded_3_3:BioSketchAttached/att:FileName"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell>
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:BioSketchsAttached/NSF_KeyPersonExpanded_3_3:BioSketchAttached/att:MimeType"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell padding-after="4pt" font-weight="100" number-columns-spanned="3">
                                                    <fo:block>Note: Biographical Sketches must be submitted using SciENcv format. Failure to submit this document using SciENcv format will prevent your proposal
                                                        from being processed.</fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell font-weight="bold" padding-after="6pt">
                                                    <fo:block>Attach Current &#38; Pending Support</fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell hyphenate="true" language="en">
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SupportsAttached/NSF_KeyPersonExpanded_3_3:SupportAttached/att:FileName"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell>
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SupportsAttached/NSF_KeyPersonExpanded_3_3:SupportAttached/att:MimeType"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell padding-after="4pt" font-weight="100" number-columns-spanned="3">
                                                    <fo:block>Note: Current &amp; Pending (Other) Support must be submitted using SciENcv format. Failure to submit this document using SciENcv format will prevent
                                                        your proposal from being processed.</fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell font-weight="bold" padding-after="6pt">
                                                    <fo:block>* Attach Collaborators &#38; Other Affiliations</fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell hyphenate="true" language="en">
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:CollaboratorsAttached/NSF_KeyPersonExpanded_3_3:CollaboratorAttached/att:FileName"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell>
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:CollaboratorsAttached/NSF_KeyPersonExpanded_3_3:CollaboratorAttached/att:MimeType"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell font-weight="bold" padding-after="6pt">
                                                    <fo:block>* Attach Synergistic Activities</fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell hyphenate="true" language="en">
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SynergisticActivitiesAttached/NSF_KeyPersonExpanded_3_3:SynergisticAttached/att:FileName"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell>
                                                    <fo:block>
                                                        <xsl:value-of select="NSF_KeyPersonExpanded_3_3:SynergisticActivitiesAttached/NSF_KeyPersonExpanded_3_3:SynergisticAttached/att:MimeType"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell padding-after="4pt" font-weight="100" number-columns-spanned="3">
                                                    <fo:block>Note: Per the NSF Proposal &amp; Award Policies &amp; Procedures Guide (PAPPG) Chapter II.D.2.h.iv each individual identified as a senior/key person must
                                                        provide a document of up to one-page.</fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <!-- end Person loop-->
                    </xsl:for-each>
                </fo:table-body>
            </fo:table>
            <!--space after tables-->
            <fo:block>&#160;</fo:block>
            <fo:block>&#160;</fo:block>
        </fo:block>

    </xsl:template>
    <!--========= End Person Template =============================================================-->

</xsl:stylesheet>
