/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nasaPIandAORSupplementalDataSheetV10.FederalAgencyDataType;
import gov.grants.apply.forms.nasaPIandAORSupplementalDataSheetV10.NasaPIandAORSupplementalDataSheetDocument;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NasaPIandAORSupplementalDataSheetV1_0Generator")
public class NasaPIandAORSupplementalDataSheetV1_0Generator
extends S2SBaseFormGenerator<NasaPIandAORSupplementalDataSheetDocument>
implements S2SFormGeneratorPdfFillable<NasaPIandAORSupplementalDataSheetDocument> {
    private static final Logger LOG = LogManager.getLogger(NasaPIandAORSupplementalDataSheetV1_0Generator.class);
    @Value(value="http://apply.grants.gov/forms/Nasa_PIandAORSupplementalDataSheet-V1.0")
    private String namespace;
    @Value(value="Nasa_PIandAORSupplementalDataSheet-V1.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/Nasa_PIandAORSupplementalDataSheet-V1.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/Nasa_PIandAORSupplementalDataSheet-V1.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    private DepartmentalPersonService departmentalPersonService;
    @Autowired
    @Qualifier(value="s2SProposalPersonService")
    private S2SProposalPersonService s2SProposalPersonService;
    private static final Integer PI_PROPOSAL_YNQ_INTERNATIONAL_PARTICIPATION = 112;
    private static final Integer PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT = 113;
    private static final Integer PI_SUB_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT = 111;
    private static final Integer PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION = 110;
    private static final String NOT_ANSWERED = "No";
    List<? extends AnswerHeaderContract> answerHeaders;

    private NasaPIandAORSupplementalDataSheetDocument getnasapIandAORSupplementalDataSheetDocument() {
        NasaPIandAORSupplementalDataSheetDocument nasaPIandAORSupplementalDataSheetDocument = (NasaPIandAORSupplementalDataSheetDocument)NasaPIandAORSupplementalDataSheetDocument.Factory.newInstance();
        NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet nasapIandAORSupplementalDataSheet = (NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet)NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.Factory.newInstance();
        nasapIandAORSupplementalDataSheet.setFormVersion(FormVersion.v1_0.getVersion());
        nasapIandAORSupplementalDataSheet.setAuthorizedRepresentativeName(this.getAuthorizedRep());
        nasapIandAORSupplementalDataSheet.setPrincipalInvestigatorName(this.getPrincipalInvestigator());
        nasaPIandAORSupplementalDataSheetDocument.setNasaPIandAORSupplementalDataSheet(nasapIandAORSupplementalDataSheet);
        return nasaPIandAORSupplementalDataSheetDocument;
    }

    private NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.AuthorizedRepresentativeName getAuthorizedRep() {
        NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.AuthorizedRepresentativeName authorizedRepresentativeName = (NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.AuthorizedRepresentativeName)NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.AuthorizedRepresentativeName.Factory.newInstance();
        DepartmentalPersonDto aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        authorizedRepresentativeName.setAORName(this.globLibV20Generator.getHumanNameDataType(aorInfo));
        return authorizedRepresentativeName;
    }

    private NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.PrincipalInvestigatorName getPrincipalInvestigator() {
        NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.PrincipalInvestigatorName principalInvestigatorName = (NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.PrincipalInvestigatorName)NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.PrincipalInvestigatorName.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            principalInvestigatorName.setPDPIName(this.globLibV20Generator.getHumanNameDataType(PI));
        } else {
            principalInvestigatorName.setPDPIName((HumanNameDataType)HumanNameDataType.Factory.newInstance());
        }
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        for (AnswerHeaderContract answerHeaderContract : this.answerHeaders) {
            for (AnswerContract answers : answerHeaderContract.getAnswers()) {
                if (answers.getQuestionId() == null || !this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId().equals(PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION)) continue;
                String explanation = null;
                if (answers.getAnswer() == null || answers.getAnswer().equals(NOT_ANSWERED)) continue;
                String answer = answers.getAnswer();
                if (this.getAnswer(PI_SUB_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT, this.answerHeaders) != null) {
                    explanation = this.getAnswer(PI_SUB_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT, this.answerHeaders);
                }
                if (answer == null) continue;
                if (answer.equals(YnqConstant.YES.code())) {
                    principalInvestigatorName.setUSGovernmentParticipation(YesNoDataType.Y_YES);
                    FederalAgencyDataType.Enum FederalAgencyEnum = this.getFederalAgency(explanation);
                    principalInvestigatorName.setFederalAgency(FederalAgencyEnum);
                    String amnt = this.getAnswer(PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT, this.answerHeaders);
                    principalInvestigatorName.setFederalAgencyDollar(amnt != null ? new BigDecimal(Integer.valueOf(amnt)) : null);
                    continue;
                }
                if (!answer.equals(YnqConstant.NO.code())) continue;
                principalInvestigatorName.setUSGovernmentParticipation(YesNoDataType.N_NO);
            }
        }
        block2: for (AnswerHeaderContract answerHeaderContract : this.answerHeaders) {
            for (AnswerContract answers : answerHeaderContract.getAnswers()) {
                if (answers.getQuestionId() == null || !this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId().equals(PI_PROPOSAL_YNQ_INTERNATIONAL_PARTICIPATION) || answers.getAnswer() == null || answers.getAnswer().equals(NOT_ANSWERED)) continue;
                String answer = answers.getAnswer();
                if (answer == null) continue block2;
                if (answer.equals(YnqConstant.YES.code())) {
                    principalInvestigatorName.setInternationalParticipation(YesNoDataType.Y_YES);
                    continue block2;
                }
                if (!answer.equals(YnqConstant.NO.code())) continue block2;
                principalInvestigatorName.setInternationalParticipation(YesNoDataType.N_NO);
                continue block2;
            }
        }
        return principalInvestigatorName;
    }

    private FederalAgencyDataType.Enum getFederalAgency(String explanation) {
        FederalAgencyDataType.Enum FederalAgencyEnum = null;
        if (explanation != null) {
            try {
                int federalAgencyCode = Integer.parseInt(explanation);
                if (federalAgencyCode > 99 && federalAgencyCode < 151) {
                    FederalAgencyEnum = FederalAgencyDataType.Enum.forInt(federalAgencyCode - 100);
                }
            }
            catch (NumberFormatException e) {
                LOG.warn("Comments entered should be number between 101 to 150", (Throwable)e);
            }
        }
        return FederalAgencyEnum;
    }

    @Override
    public NasaPIandAORSupplementalDataSheetDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getnasapIandAORSupplementalDataSheetDocument();
    }

    public DepartmentalPersonService getDepartmentalPersonService() {
        return this.departmentalPersonService;
    }

    public void setDepartmentalPersonService(DepartmentalPersonService departmentalPersonService) {
        this.departmentalPersonService = departmentalPersonService;
    }

    public S2SProposalPersonService getS2SProposalPersonService() {
        return this.s2SProposalPersonService;
    }

    public void setS2SProposalPersonService(S2SProposalPersonService s2SProposalPersonService) {
        this.s2SProposalPersonService = s2SProposalPersonService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NasaPIandAORSupplementalDataSheetDocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<NasaPIandAORSupplementalDataSheetDocument> factory() {
        return NasaPIandAORSupplementalDataSheetDocument.Factory;
    }
}

