/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CareerDevelopmentAwardSupV10.CitizenshipDataType;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSupV10.PHS398CareerDevelopmentAwardSupDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398CareerDevelopmentAwardSupBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398CareerDevelopmentAwardSupV1_0Generator")
public class PHS398CareerDevelopmentAwardSupV1_0Generator
extends PHS398CareerDevelopmentAwardSupBaseGenerator<PHS398CareerDevelopmentAwardSupDocument> {
    private static final String PROPOSAL_TYPE_TASK_ORDER = "6";
    @Value(value="http://apply.grants.gov/forms/PHS398_CareerDevelopmentAwardSup-V1.0")
    private String namespace;
    @Value(value="PHS398_CareerDevelopmentAwardSup-V1.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CareerDevelopmentAwardSup-V1.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="192")
    private int sortIndex;

    private PHS398CareerDevelopmentAwardSupDocument getPHS398CareerDevelopmentAwardSup() {
        PHS398CareerDevelopmentAwardSupDocument phs398CareerDevelopmentAwardSupDocument = (PHS398CareerDevelopmentAwardSupDocument)PHS398CareerDevelopmentAwardSupDocument.Factory.newInstance();
        PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup phs398CareerDevelopmentAwardSup = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.Factory.newInstance();
        phs398CareerDevelopmentAwardSup.setFormVersion(FormVersion.v1_0.getVersion());
        phs398CareerDevelopmentAwardSup.setApplicationType(this.getApplicationType());
        phs398CareerDevelopmentAwardSup.setCitizenship(this.getCitizenshipDataType());
        phs398CareerDevelopmentAwardSup.setCareerDevelopmentAwardAttachments(this.getCareerDevelopmentAwardAttachments());
        phs398CareerDevelopmentAwardSupDocument.setPHS398CareerDevelopmentAwardSup(phs398CareerDevelopmentAwardSup);
        return phs398CareerDevelopmentAwardSupDocument;
    }

    private CitizenshipDataType.Enum getCitizenshipDataType() {
        return this.pdDoc.getDevelopmentProposal().getProposalPersons().stream().filter(ProposalPersonContract::isInvestigator).map(proposalPerson -> this.s2SProposalPersonService.getCitizenship((ProposalPersonContract)proposalPerson)).map(citizenShip -> {
            if (CitizenshipType.NON_US_CITIZEN_WITH_TEMPORARY_VISA.equals(citizenShip)) {
                return CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA;
            }
            if (CitizenshipType.PERMANENT_RESIDENT_OF_US.equals(citizenShip)) {
                return CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S;
            }
            if (CitizenshipType.US_CITIZEN_OR_NONCITIZEN_NATIONAL.equals(citizenShip)) {
                return CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL;
            }
            return null;
        }).findFirst().orElse(null);
    }

    private PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType getApplicationType() {
        PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType applicationType = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProposalType().getCode() != null && !this.pdDoc.getDevelopmentProposal().getProposalType().getCode().equals(PROPOSAL_TYPE_TASK_ORDER)) {
            applicationType.setTypeOfApplication(PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType.TypeOfApplication.Enum.forInt(Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalType().getCode())));
        } else {
            applicationType.setTypeOfApplication(PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType.TypeOfApplication.NEW);
        }
        return applicationType;
    }

    private PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments getCareerDevelopmentAwardAttachments() {
        PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.Factory.newInstance();
        AttachmentGroupMin0Max100DataType attachmentGroupMin0Max100DataType = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
        ArrayList<AttachedFileDataType> attachedFileList = new ArrayList<AttachedFileDataType>();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            int narrativeType = Integer.parseInt(narrative.getNarrativeType().getCode());
            switch (narrativeType) {
                case 70: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.IntroductionToApplication introductionToApplication = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.IntroductionToApplication)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.IntroductionToApplication.Factory.newInstance();
                    introductionToApplication.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setIntroductionToApplication(introductionToApplication);
                    break;
                }
                case 71: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SpecificAims specificAims = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SpecificAims)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SpecificAims.Factory.newInstance();
                    specificAims.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setSpecificAims(specificAims);
                    break;
                }
                case 72: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.BackgroundAndSignificance backgroundAndSignificance = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.BackgroundAndSignificance)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.BackgroundAndSignificance.Factory.newInstance();
                    backgroundAndSignificance.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setBackgroundAndSignificance(backgroundAndSignificance);
                    break;
                }
                case 73: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResearchDesignAndMethods researchDesignAndMethods = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResearchDesignAndMethods)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResearchDesignAndMethods.Factory.newInstance();
                    researchDesignAndMethods.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResearchDesignAndMethods(researchDesignAndMethods);
                    break;
                }
                case 79: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport inclusionEnrollmentReport = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport.Factory.newInstance();
                    inclusionEnrollmentReport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionEnrollmentReport(inclusionEnrollmentReport);
                    break;
                }
                case 80: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProgressReportPublicationList progressReportPublicationList = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProgressReportPublicationList)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProgressReportPublicationList.Factory.newInstance();
                    progressReportPublicationList.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setProgressReportPublicationList(progressReportPublicationList);
                    break;
                }
                case 74: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects protectionOfHumanSubjects = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects.Factory.newInstance();
                    protectionOfHumanSubjects.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
                    break;
                }
                case 75: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities.Factory.newInstance();
                    inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
                    break;
                }
                case 76: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment targetedPlannedEnrollment = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment.Factory.newInstance();
                    targetedPlannedEnrollment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setTargetedPlannedEnrollment(targetedPlannedEnrollment);
                    break;
                }
                case 77: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfChildren inclusionOfChildren = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfChildren)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfChildren.Factory.newInstance();
                    inclusionOfChildren.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionOfChildren(inclusionOfChildren);
                    break;
                }
                case 78: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.VertebrateAnimals vertebrateAnimals = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.VertebrateAnimals)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.VertebrateAnimals.Factory.newInstance();
                    vertebrateAnimals.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setVertebrateAnimals(vertebrateAnimals);
                    break;
                }
                case 81: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SelectAgentResearch selectAgentResearch = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SelectAgentResearch)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SelectAgentResearch.Factory.newInstance();
                    selectAgentResearch.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setSelectAgentResearch(selectAgentResearch);
                    break;
                }
                case 82: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.PreliminaryStudiesProgressReport preliminaryStudiesProgressReport = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.PreliminaryStudiesProgressReport)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.PreliminaryStudiesProgressReport.Factory.newInstance();
                    preliminaryStudiesProgressReport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setPreliminaryStudiesProgressReport(preliminaryStudiesProgressReport);
                    break;
                }
                case 83: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements consortiumContractualArrangements = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements.Factory.newInstance();
                    consortiumContractualArrangements.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setConsortiumContractualArrangements(consortiumContractualArrangements);
                    break;
                }
                case 84: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResourceSharingPlans resourceSharingPlans = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResourceSharingPlans)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResourceSharingPlans.Factory.newInstance();
                    resourceSharingPlans.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResourceSharingPlans(resourceSharingPlans);
                    break;
                }
                case 62: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CandidateBackground candidateBackground = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CandidateBackground)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CandidateBackground.Factory.newInstance();
                    candidateBackground.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCandidateBackground(candidateBackground);
                    break;
                }
                case 63: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives careerGoalsAndObjectives = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives.Factory.newInstance();
                    careerGoalsAndObjectives.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCareerGoalsAndObjectives(careerGoalsAndObjectives);
                    break;
                }
                case 64: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities careerDevelopmentAndTrainingActivities = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities.Factory.newInstance();
                    careerDevelopmentAndTrainingActivities.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCareerDevelopmentAndTrainingActivities(careerDevelopmentAndTrainingActivities);
                    break;
                }
                case 65: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch responsibleConductOfResearch = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch.Factory.newInstance();
                    responsibleConductOfResearch.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResponsibleConductOfResearch(responsibleConductOfResearch);
                    break;
                }
                case 66: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.MentoringPlan mentoringPlan = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.MentoringPlan)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.MentoringPlan.Factory.newInstance();
                    mentoringPlan.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setMentoringPlan(mentoringPlan);
                    break;
                }
                case 67: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.StatementsOfSupport statementsOfSupport = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.StatementsOfSupport)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.StatementsOfSupport.Factory.newInstance();
                    statementsOfSupport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setStatementsOfSupport(statementsOfSupport);
                    break;
                }
                case 68: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InsitutionalEnvironment insitutionalEnvironment = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InsitutionalEnvironment)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InsitutionalEnvironment.Factory.newInstance();
                    insitutionalEnvironment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInsitutionalEnvironment(insitutionalEnvironment);
                    break;
                }
                case 69: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InstitutionalCommitment institutionalCommitment = (PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InstitutionalCommitment)PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InstitutionalCommitment.Factory.newInstance();
                    institutionalCommitment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInstitutionalCommitment(institutionalCommitment);
                    break;
                }
                case 85: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    attachedFileList.add(attachedFileDataType);
                }
            }
        }
        attachmentGroupMin0Max100DataType.setAttachedFileArray(attachedFileList.toArray(new AttachedFileDataType[0]));
        careerDevelopmentAwardAttachments.setAppendix(attachmentGroupMin0Max100DataType);
        return careerDevelopmentAwardAttachments;
    }

    @Override
    public PHS398CareerDevelopmentAwardSupDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398CareerDevelopmentAwardSup();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHS398CareerDevelopmentAwardSupDocument> factory() {
        return PHS398CareerDevelopmentAwardSupDocument.Factory;
    }
}

