/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CoverPageSupplement50V50.PHS398CoverPageSupplement50Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398CoverPageSupplementBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398CoverPageSupplement_5_0V5_0Generator")
public class PHS398CoverPageSupplement_5_0V5_0Generator
extends PHS398CoverPageSupplementBaseGenerator<PHS398CoverPageSupplement50Document>
implements S2SFormGeneratorPdfFillable<PHS398CoverPageSupplement50Document> {
    protected static final Integer PROPOSAL_YNQ_QUESTION_114 = 114;
    protected static final Integer PROPOSAL_YNQ_QUESTION_115 = 115;
    protected static final Integer PROPOSAL_YNQ_QUESTION_116 = 116;
    protected static final Integer PROPOSAL_YNQ_QUESTION_117 = 117;
    protected static final Integer PROPOSAL_YNQ_QUESTION_118 = 118;
    protected static final Integer PROPOSAL_YNQ_QUESTION_119 = 119;
    protected static final Integer PROPOSAL_YNQ_QUESTION_120 = 120;
    protected static final Integer PROPOSAL_YNQ_QUESTION_145 = 145;
    protected static final Integer PROPOSAL_YNQ_QUESTION_146 = 146;
    protected static final Integer PROPOSAL_YNQ_QUESTION_147 = 147;
    protected static final Integer PROPOSAL_YNQ_QUESTION_148 = 148;
    protected static final int HUMAN_FETAL_TISSUE_INVOLVED = -10145;
    public static final Integer INCREASED_REGISTRATION_NUMBER = 149;
    protected static final int PROJECT_INCOME_DESCRIPTION_MAX_LENGTH = 150;
    private static final int MAX_EUTHANASIA_METHOD_DESC = 1000;
    protected static final int HFT_COMPLIANCE_ASSURANCE = -5;
    protected static final int HFT_IRB_CONSENT_FORM = -6;
    private List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/PHS398_CoverPageSupplement_5_0-V5.0")
    private String namespace;
    @Value(value="PHS398_CoverPageSupplement_5_0-V5.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CoverPageSupplement-V5.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_CoverPageSupplement_5_0-V5.0.pdf")
    private Resource pdfForm;
    @Value(value="158")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    private S2SCommonBudgetService s2SCommonBudgetService;

    private PHS398CoverPageSupplement50Document getCoverPageSupplement() {
        PHS398CoverPageSupplement50Document coverPageSupplementDocument = (PHS398CoverPageSupplement50Document)PHS398CoverPageSupplement50Document.Factory.newInstance();
        PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement = (PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50)PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.Factory.newInstance();
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        coverPageSupplement.setFormVersion(FormVersion.v5_0.getVersion());
        this.setIsInventionsAndPatentsAndIsPreviouslyReported(coverPageSupplement);
        this.setFormerPDNameAndIsChangeOfPDPI(coverPageSupplement);
        this.setFormerInstitutionNameAndChangeOfInstitution(coverPageSupplement);
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            PHS398CoverPageSupplement_5_0V5_0Generator.setIncomeBudgetPeriods(coverPageSupplement, budget.getBudgetProjectIncomes());
        } else {
            coverPageSupplement.setProgramIncome(YesNoDataType.N_NO);
        }
        PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.StemCells stemCells = this.getStemCells();
        coverPageSupplement.setStemCells(stemCells);
        PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.VertebrateAnimals vertebrateAnimals = this.getVertebrateAnimals();
        if (vertebrateAnimals != null) {
            coverPageSupplement.setVertebrateAnimals(vertebrateAnimals);
        }
        this.setHFTInvolved(coverPageSupplement);
        coverPageSupplementDocument.setPHS398CoverPageSupplement50(coverPageSupplement);
        return coverPageSupplementDocument;
    }

    private PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.VertebrateAnimals getVertebrateAnimals() {
        PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.VertebrateAnimals vertebrateAnimals = (PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.VertebrateAnimals)PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.VertebrateAnimals.Factory.newInstance();
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_145, this.answerHeaders);
        if (answer == null || answer.equals("No") || YnqConstant.NO.code().equals(answer)) {
            return null;
        }
        this.setVertebrateAnimalsSubQuestions(vertebrateAnimals);
        return vertebrateAnimals;
    }

    private void setVertebrateAnimalsSubQuestions(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.VertebrateAnimals vertebrateAnimals) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_146, this.answerHeaders);
        if (answer != null && YnqConstant.YES.code().equals(answer)) {
            vertebrateAnimals.setAnimalEuthanasiaIndicator(YesNoDataType.Y_YES);
        } else if (answer != null && YnqConstant.NO.code().equals(answer)) {
            vertebrateAnimals.setAnimalEuthanasiaIndicator(YesNoDataType.N_NO);
        }
        answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_147, this.answerHeaders);
        if (answer != null && YnqConstant.YES.code().equals(answer)) {
            vertebrateAnimals.setAVMAConsistentIndicator(YesNoDataType.Y_YES);
        } else if (answer != null && YnqConstant.NO.code().equals(answer)) {
            vertebrateAnimals.setAVMAConsistentIndicator(YesNoDataType.N_NO);
            answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_148, this.answerHeaders);
            if (answer != null) {
                vertebrateAnimals.setEuthanasiaMethodDescription(StringUtils.substring((String)answer.trim(), (int)0, (int)1000));
            }
        }
    }

    private void setIsInventionsAndPatentsAndIsPreviouslyReported(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_118, this.answerHeaders);
        if (answer != null && !answer.equals("No") && YnqConstant.YES.code().equals(answer)) {
            this.setInventionsAndPatentsAndIsPreviouslyReportedSubQuestions(coverPageSupplement);
        }
    }

    private void setInventionsAndPatentsAndIsPreviouslyReportedSubQuestions(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement) {
        String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_119, this.answerHeaders);
        if (explanation != null && !explanation.equals("No")) {
            if (YnqConstant.YES.code().equals(explanation)) {
                coverPageSupplement.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                String subQuestionExplanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_120, this.answerHeaders);
                if (subQuestionExplanation != null && !subQuestionExplanation.equals("No")) {
                    if (YnqConstant.YES.code().equals(subQuestionExplanation)) {
                        coverPageSupplement.setIsPreviouslyReported(YesNoDataType.Y_YES);
                    } else if (YnqConstant.NO.code().equals(subQuestionExplanation)) {
                        coverPageSupplement.setIsPreviouslyReported(YesNoDataType.N_NO);
                    }
                } else {
                    coverPageSupplement.setIsPreviouslyReported(null);
                }
            } else if (YnqConstant.NO.code().equals(explanation)) {
                coverPageSupplement.setIsInventionsAndPatents(YesNoDataType.N_NO);
            }
        } else {
            coverPageSupplement.setIsInventionsAndPatents(null);
        }
    }

    private void setFormerPDNameAndIsChangeOfPDPI(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_114, this.answerHeaders);
        String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_115, this.answerHeaders);
        if (YnqConstant.YES.code().equals(answer)) {
            coverPageSupplement.setIsChangeOfPDPI(YesNoDataType.Y_YES);
            if (explanation != null) {
                RolodexContract rolodex = this.rolodexService.getRolodex(Integer.valueOf(explanation));
                HumanNameDataType formerPDName = this.globLibV20Generator.getHumanNameDataType(rolodex);
                if (formerPDName != null && formerPDName.getFirstName() != null && formerPDName.getLastName() != null) {
                    coverPageSupplement.setFormerPDName(formerPDName);
                }
            } else {
                coverPageSupplement.setFormerPDName(null);
            }
        } else {
            coverPageSupplement.setIsChangeOfPDPI(YesNoDataType.N_NO);
        }
    }

    private void setFormerInstitutionNameAndChangeOfInstitution(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_116, this.answerHeaders);
        String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_117, this.answerHeaders);
        if (YnqConstant.YES.code().equals(answer)) {
            coverPageSupplement.setIsChangeOfInstitution(YesNoDataType.Y_YES);
            if (explanation != null) {
                coverPageSupplement.setFormerInstitutionName(explanation);
            } else {
                coverPageSupplement.setFormerInstitutionName(null);
            }
        } else {
            coverPageSupplement.setIsChangeOfInstitution(YesNoDataType.N_NO);
        }
    }

    private static void setIncomeBudgetPeriods(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement, List<? extends BudgetProjectIncomeContract> projectIncomes) {
        if (projectIncomes.isEmpty()) {
            coverPageSupplement.setProgramIncome(YesNoDataType.N_NO);
        } else {
            coverPageSupplement.setProgramIncome(YesNoDataType.Y_YES);
        }
        coverPageSupplement.setIncomeBudgetPeriodArray(PHS398CoverPageSupplement_5_0V5_0Generator.getIncomeBudgetPeriod(projectIncomes));
    }

    private static PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod[] getIncomeBudgetPeriod(List<? extends BudgetProjectIncomeContract> projectIncomes) {
        TreeMap<Integer, PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod> incomeBudgetPeriodMap = new TreeMap<Integer, PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod>();
        for (BudgetProjectIncomeContract budgetProjectIncomeContract : projectIncomes) {
            BigDecimal anticipatedAmount;
            Integer budgetPeriodNumber = budgetProjectIncomeContract.getBudgetPeriodNumber();
            PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod incomeBudgPeriod = (PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod)incomeBudgetPeriodMap.get(budgetPeriodNumber);
            if (incomeBudgPeriod == null) {
                incomeBudgPeriod = (PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod)PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod.Factory.newInstance();
                incomeBudgPeriod.setBudgetPeriod(budgetPeriodNumber);
                anticipatedAmount = BigDecimal.ZERO;
            } else {
                anticipatedAmount = incomeBudgPeriod.getAnticipatedAmount();
            }
            anticipatedAmount = anticipatedAmount.add(budgetProjectIncomeContract.getProjectIncome().bigDecimalValue());
            incomeBudgPeriod.setAnticipatedAmount(anticipatedAmount);
            String description = PHS398CoverPageSupplement_5_0V5_0Generator.getProjectIncomeDescription(budgetProjectIncomeContract);
            if (description != null) {
                if (incomeBudgPeriod.getSource() != null) {
                    incomeBudgPeriod.setSource(incomeBudgPeriod.getSource() + ";" + description);
                } else {
                    incomeBudgPeriod.setSource(description);
                }
            }
            incomeBudgetPeriodMap.put(budgetPeriodNumber, incomeBudgPeriod);
        }
        return incomeBudgetPeriodMap.values().toArray(new PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.IncomeBudgetPeriod[0]);
    }

    protected static String getProjectIncomeDescription(BudgetProjectIncomeContract projectIncome) {
        return projectIncome.getDescription() != null ? StringUtils.substring((String)projectIncome.getDescription(), (int)0, (int)150) : null;
    }

    private PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.StemCells getStemCells() {
        PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.StemCells stemCells = (PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.StemCells)PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.StemCells.Factory.newInstance();
        String answer = this.getAnswer(IS_HUMAN_STEM_CELLS_INVOLVED, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            if (YnqConstant.YES.code().equals(answer)) {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.Y_YES);
                this.setStemCellsSubQuestions(stemCells);
            } else {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.N_NO);
            }
        }
        return stemCells;
    }

    private void setStemCellsSubQuestions(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.StemCells stemCells) {
        String subAnswer = this.getAnswer(SPECIFIC_STEM_CELL_LINE, this.answerHeaders);
        String childAnswer = null;
        if (subAnswer != null && !subAnswer.equals("No")) {
            if (YnqConstant.YES.code().equals(subAnswer)) {
                stemCells.setStemCellsIndicator(YesNoDataType.N_NO);
                childAnswer = this.getAnswers(INCREASED_REGISTRATION_NUMBER, this.answerHeaders);
            } else {
                stemCells.setStemCellsIndicator(YesNoDataType.Y_YES);
            }
        }
        if (childAnswer != null) {
            if ("Unknown".equalsIgnoreCase(childAnswer)) {
                stemCells.setStemCellsIndicator(YesNoDataType.Y_YES);
            } else {
                List<String> cellLines = this.getCellLines(childAnswer);
                if (cellLines.size() > 0) {
                    stemCells.setCellLinesArray(cellLines.toArray(new String[0]));
                }
            }
        }
    }

    private void setHFTInvolved(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement) {
        String answer = this.getAnswer(-10145, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            if (YnqConstant.YES.code().equals(answer)) {
                coverPageSupplement.setIsHumanFetalTissueInvolved(YesNoDataType.Y_YES);
                this.addAttachmentsForHFT(coverPageSupplement);
            } else {
                coverPageSupplement.setIsHumanFetalTissueInvolved(YesNoDataType.N_NO);
            }
        }
    }

    private void addAttachmentsForHFT(PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50 coverPageSupplement) {
        this.pdDoc.getDevelopmentProposal().getNarratives().forEach(narrative -> {
            switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                case -6: {
                    this.doWithAttachedFileType((NarrativeContract)narrative, attachedFileDataType -> {
                        PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.HFTIRBConsentForm consentForm = (PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.HFTIRBConsentForm)PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.HFTIRBConsentForm.Factory.newInstance();
                        consentForm.setAttFile((AttachedFileDataType)attachedFileDataType);
                        coverPageSupplement.setHFTIRBConsentForm(consentForm);
                    });
                    break;
                }
                case -5: {
                    this.doWithAttachedFileType((NarrativeContract)narrative, attachedFileDataType -> {
                        PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.ComplianceAssurance complianceAssurance = (PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.ComplianceAssurance)PHS398CoverPageSupplement50Document.PHS398CoverPageSupplement50.ComplianceAssurance.Factory.newInstance();
                        complianceAssurance.setAttFile((AttachedFileDataType)attachedFileDataType);
                        coverPageSupplement.setComplianceAssurance(complianceAssurance);
                    });
                }
            }
        });
    }

    private void doWithAttachedFileType(NarrativeContract narrative, Consumer<AttachedFileDataType> fn) {
        Optional.ofNullable(this.addAttachedFileType(narrative)).ifPresent(fn);
    }

    @Override
    public PHS398CoverPageSupplement50Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getCoverPageSupplement();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHS398CoverPageSupplement50Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<PHS398CoverPageSupplement50Document> factory() {
        return PHS398CoverPageSupplement50Document.Factory;
    }
}

