/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phsFellowshipSupplemental12V12.CitizenshipDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental12V12.DegreeTypeDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental12V12.FieldOfTrainingDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental12V12.PHSFellowshipSupplemental12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398FellowshipSupplementalBaseGenerator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398FellowshipSupplementalV1_2Generator")
public class PHS398FellowshipSupplementalV1_2Generator
extends PHS398FellowshipSupplementalBaseGenerator<PHSFellowshipSupplemental12Document> {
    private static final Logger LOG = LogManager.getLogger(PHS398FellowshipSupplementalV1_2Generator.class);
    private static final int DEGREE_TYPE_SOUGHT = 99;
    private static final int OTHER_DBOTH = 100;
    private static final int SPONSOR_COSPONSOR = 134;
    private static final String ANSWER_YES = "Yes";
    private static final String ANSWER_NO = "No";
    private static final ScaleTwoDecimal POINT_ZERO_ONE = new ScaleTwoDecimal(0.01);
    @Value(value="http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_1_2-V1.2")
    private String namespace;
    @Value(value="PHS_Fellowship_Supplemental_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS_fellowship_supplemental-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="210")
    private int sortIndex;

    private PHSFellowshipSupplemental12Document getPHSFellowshipSupplemental12() {
        PHSFellowshipSupplemental12Document phsFellowshipSupplementalDocument = (PHSFellowshipSupplemental12Document)PHSFellowshipSupplemental12Document.Factory.newInstance();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12 phsFellowshipSupplemental = phsFellowshipSupplementalDocument.addNewPHSFellowshipSupplemental12();
        phsFellowshipSupplemental.setFormVersion(FormVersion.v1_2.getVersion());
        phsFellowshipSupplemental.setApplicationType(this.getApplicationType());
        phsFellowshipSupplemental.setAppendix(this.getAppendix());
        this.setQuestionnaireData(phsFellowshipSupplemental);
        return phsFellowshipSupplementalDocument;
    }

    private void setQuestionnaireData(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12 phsFellowshipSupplemental) {
        Object questionId;
        HashMap<Integer, String> hmBudgetQuestions = new HashMap<Integer, String>();
        List<AnswerHeaderContract> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan researchTrainingPlan = phsFellowshipSupplemental.addNewResearchTrainingPlan();
        this.setHumanSubjectInvolvedAndVertebrateAnimalUsed(researchTrainingPlan);
        this.setNarrativeDataForResearchTrainingPlan(phsFellowshipSupplemental, researchTrainingPlan);
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation additionalInfoType = phsFellowshipSupplemental.addNewAdditionalInformation();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.GraduateDegreeSought graduateDegreeSought = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.GraduateDegreeSought)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.GraduateDegreeSought.Factory.newInstance();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.StemCells stemCellstype = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.StemCells)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.StemCells.Factory.newInstance();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvKirsch = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        for (AnswerHeaderContract answerHeader : answers) {
            QuestionnaireContract questionnaire = this.questionAnswerService.findQuestionnaireById(answerHeader.getQuestionnaireId());
            List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            block57: for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                Integer questionNumber = questionnaireQuestion.getQuestionNumber();
                Integer parentQuestionNumber = questionnaireQuestion.getParentQuestionNumber();
                questionId = question.getQuestionSeqId();
                if (answer != null) {
                    if (!answer.equalsIgnoreCase(ANSWER_YES) || !answer.equalsIgnoreCase(ANSWER_NO)) {
                        switch ((Integer)questionId) {
                            case 1: {
                                researchTrainingPlan.setHumanSubjectsIndefinite(this.getYesNoEnum(answer));
                                break;
                            }
                            case 4: {
                                researchTrainingPlan.setVertebrateAnimalsIndefinite(this.getYesNoEnum(answer));
                                break;
                            }
                            case 2: {
                                researchTrainingPlan.setClinicalTrial(this.getYesNoEnum(answer));
                                break;
                            }
                            case 3: {
                                researchTrainingPlan.setPhase3ClinicalTrial(this.getYesNoEnum(answer));
                                break;
                            }
                            case 5: {
                                stemCellstype.setIsHumanStemCellsInvolved(this.getYesNoEnum(answer));
                                break;
                            }
                            case 6: {
                                stemCellstype.setStemCellsIndicator(this.getYesNoEnum(answer));
                                break;
                            }
                            case 7: {
                                List<AnswerContract> answerList = this.getAnswers(questionnaireQuestion, answerHeader);
                                for (AnswerContract questionnaireAnswerBO : answerList) {
                                    String questionnaireSubAnswer = questionnaireAnswerBO.getAnswer();
                                    if (questionnaireSubAnswer == null) continue;
                                    stemCellstype.addCellLines(questionnaireAnswerBO.getAnswer());
                                }
                                break;
                            }
                            case 99: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.Enum.forString(answer));
                                break;
                            }
                            case 35: {
                                graduateDegreeSought.setDegreeDate(answer.substring(6, 10) + "-" + answer.substring(0, 2));
                                break;
                            }
                            case 16: {
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 18: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.DDOT_OTHER_DOCTOR_OF_MEDICAL_DENTISTRY);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 19: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.VDOT_OTHER_DOCTOR_OF_VETERINARY_MEDICINE);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 21: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.MDOT_OTHER_DOCTOR_OF_MEDICINE);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 100: {
                                if (!((Object)((Object)graduateDegreeSought.getDegreeType())).equals((Object)DegreeTypeDataType.OTH_OTHER)) break;
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 17: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.DOTH_OTHER_DOCTORATE);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 22: 
                            case 23: {
                                if (answer.toUpperCase().equals("SUB CATEGORY NOT FOUND")) break;
                                additionalInfoType.setFieldOfTraining(FieldOfTrainingDataType.Enum.forString(answer));
                                break;
                            }
                            case 24: {
                                additionalInfoType.setCurrentPriorNRSASupportIndicator(this.getYesNoEnum(answer));
                                break;
                            }
                            case 27: 
                            case 32: 
                            case 33: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 49: {
                                if ((Integer)questionId == 43) {
                                    if (!answer.equals("N")) break;
                                    answer = "Unknown";
                                    questionId = 44;
                                }
                                if ((Integer)questionId == 49) {
                                    if (!answer.equals("N")) break;
                                    answer = "Unknown";
                                    questionId = 45;
                                }
                                if ((Integer)questionId == 46) {
                                    if (!answer.equals("N")) break;
                                    answer = "Unknown";
                                    questionId = 27;
                                }
                                PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean cbKirschstein = new PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean();
                                cbKirschstein.setAnswer(answer);
                                cbKirschstein.setQuestionId((Integer)questionId);
                                cbKirschstein.setQuestionNumber(questionNumber);
                                cbKirschstein.setParentQuestionNumber(parentQuestionNumber);
                                cvKirsch.add(cbKirschstein);
                                break;
                            }
                            case 28: {
                                additionalInfoType.setChangeOfInstitution(this.getYesNoEnum(answer));
                                break;
                            }
                            case 29: {
                                additionalInfoType.setFormerInstitution(answer);
                                break;
                            }
                            case 36: {
                                hmBudgetQuestions.put(36, answer);
                                break;
                            }
                            case 37: {
                                hmBudgetQuestions.put(37, answer);
                                break;
                            }
                            case 41: {
                                hmBudgetQuestions.put(41, answer);
                                break;
                            }
                            case 38: {
                                hmBudgetQuestions.put(38, answer);
                                break;
                            }
                            case 51: {
                                hmBudgetQuestions.put(51, answer);
                                break;
                            }
                            case 40: {
                                hmBudgetQuestions.put(40, answer);
                                break;
                            }
                            case 50: {
                                hmBudgetQuestions.put(50, answer);
                                break;
                            }
                            case 48: {
                                hmBudgetQuestions.put(48, answer);
                                break;
                            }
                            case 47: {
                                hmBudgetQuestions.put(47, answer);
                                break;
                            }
                        }
                    }
                    if (!answer.equalsIgnoreCase(ANSWER_YES) && !answer.equalsIgnoreCase(ANSWER_NO)) continue;
                    switch ((Integer)questionId) {
                        case 1: {
                            researchTrainingPlan.setHumanSubjectsIndefinite(null);
                            researchTrainingPlan.setHumanSubjectsInvolved(null);
                            continue block57;
                        }
                        case 4: {
                            researchTrainingPlan.setVertebrateAnimalsIndefinite(null);
                            researchTrainingPlan.setVertebrateAnimalsUsed(null);
                            continue block57;
                        }
                        case 2: {
                            researchTrainingPlan.setClinicalTrial(null);
                            continue block57;
                        }
                        case 3: {
                            if (researchTrainingPlan.getClinicalTrial() == null) continue block57;
                            if (((Object)((Object)researchTrainingPlan.getClinicalTrial())).equals((Object)this.getYesNoEnum("N"))) {
                                researchTrainingPlan.setPhase3ClinicalTrial(this.getYesNoEnum(answer));
                                continue block57;
                            }
                            researchTrainingPlan.setPhase3ClinicalTrial(null);
                            continue block57;
                        }
                        case 22: {
                            additionalInfoType.setFieldOfTraining(null);
                            continue block57;
                        }
                        case 5: {
                            stemCellstype.setIsHumanStemCellsInvolved(null);
                            continue block57;
                        }
                        case 24: {
                            additionalInfoType.setCurrentPriorNRSASupportIndicator(null);
                            continue block57;
                        }
                    }
                    continue;
                }
                if (answer != null) continue;
                switch ((Integer)questionId) {
                    case 1: {
                        researchTrainingPlan.setHumanSubjectsIndefinite(null);
                        researchTrainingPlan.setHumanSubjectsInvolved(null);
                        break;
                    }
                    case 4: {
                        researchTrainingPlan.setVertebrateAnimalsIndefinite(null);
                        researchTrainingPlan.setVertebrateAnimalsUsed(null);
                        break;
                    }
                    case 2: {
                        researchTrainingPlan.setClinicalTrial(null);
                        break;
                    }
                    case 3: {
                        if (researchTrainingPlan.getClinicalTrial() != YesNoDataType.Y_YES) break;
                        researchTrainingPlan.setPhase3ClinicalTrial(null);
                        break;
                    }
                    case 22: {
                        additionalInfoType.setFieldOfTraining(null);
                        break;
                    }
                    case 5: {
                        stemCellstype.setIsHumanStemCellsInvolved(null);
                        break;
                    }
                    case 24: {
                        additionalInfoType.setCurrentPriorNRSASupportIndicator(null);
                        break;
                    }
                }
            }
        }
        if (stemCellstype != null) {
            additionalInfoType.setStemCells(stemCellstype);
        }
        if (graduateDegreeSought.getDegreeType() != null) {
            additionalInfoType.setGraduateDegreeSought(graduateDegreeSought);
        }
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvType = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvStart = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvEnd = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvLevel = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvGrant = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        if (additionalInfoType.getCurrentPriorNRSASupportIndicator() != null) {
            if (((Object)((Object)additionalInfoType.getCurrentPriorNRSASupportIndicator())).equals((Object)YesNoDataType.Y_YES)) {
                cvKirsch.sort(BY_QUESTION_NUMBER);
                questionId = cvKirsch.iterator();
                while (questionId.hasNext()) {
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean aCvKirsch;
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean = aCvKirsch = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)questionId.next();
                    switch (kbBean.getQuestionId()) {
                        case 32: {
                            cvLevel.add(kbBean);
                            break;
                        }
                        case 33: {
                            cvType.add(kbBean);
                            break;
                        }
                        case 44: {
                            cvStart.add(kbBean);
                            break;
                        }
                        case 45: {
                            cvEnd.add(kbBean);
                            break;
                        }
                        case 27: {
                            cvGrant.add(kbBean);
                        }
                    }
                }
            }
            ArrayList<PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport> currentPriorNRSASupportList = new ArrayList<PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport>();
            int numberRepeats = cvLevel.size();
            if (numberRepeats > 0) {
                for (int j = 0; j < numberRepeats; ++j) {
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean1 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvLevel.get(j);
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean2 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvType.get(j);
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean3 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvStart.get(j);
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean4 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvEnd.get(j);
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean5 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvGrant.get(j);
                    PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport nrsaSupportType = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport.Factory.newInstance();
                    nrsaSupportType.setLevel(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum.forString(kbBean1.getAnswer()));
                    nrsaSupportType.setType(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum.forString(kbBean2.getAnswer()));
                    if (!kbBean3.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setStartDate(this.s2SDateTimeService.convertDateStringToCalendar(kbBean3.getAnswer()));
                    }
                    if (!kbBean4.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setEndDate(this.s2SDateTimeService.convertDateStringToCalendar(kbBean4.getAnswer()));
                    }
                    nrsaSupportType.setGrantNumber(kbBean5.getAnswer());
                    currentPriorNRSASupportList.add(nrsaSupportType);
                }
            }
            additionalInfoType.setCurrentPriorNRSASupportArray(currentPriorNRSASupportList.toArray(new PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport[0]));
        }
        phsFellowshipSupplemental.setBudget(this.getBudget(hmBudgetQuestions));
        this.setAdditionalInformation(additionalInfoType);
    }

    private PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget getBudget(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.Factory.newInstance();
        budget.setTuitionAndFeesRequested(YesNoDataType.N_NO);
        this.getInstitutionalBaseSalary(budget, budgetMap);
        this.getFederalStipendRequested(budget);
        this.getSupplementationFromOtherSources(budget, budgetMap);
        this.setTuitionRequestedYears(budget);
        return budget;
    }

    private void setTuitionRequestedYears(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget) {
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget == null) {
            return;
        }
        ScaleTwoDecimal tuitionTotal = ScaleTwoDecimal.ZERO;
        for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
            ScaleTwoDecimal tuition = ScaleTwoDecimal.ZERO;
            for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("TUITION_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                tuition = (ScaleTwoDecimal)tuition.add((AbstractDecimal)budgetLineItem.getLineItemCost());
            }
            tuitionTotal = (ScaleTwoDecimal)tuitionTotal.add((AbstractDecimal)tuition);
            switch (budgetPeriod.getBudgetPeriod()) {
                case 1: {
                    budget.setTuitionRequestedYear1(tuition.bigDecimalValue());
                    break;
                }
                case 2: {
                    budget.setTuitionRequestedYear2(tuition.bigDecimalValue());
                    break;
                }
                case 3: {
                    budget.setTuitionRequestedYear3(tuition.bigDecimalValue());
                    break;
                }
                case 4: {
                    budget.setTuitionRequestedYear4(tuition.bigDecimalValue());
                    break;
                }
                case 5: {
                    budget.setTuitionRequestedYear5(tuition.bigDecimalValue());
                    break;
                }
                case 6: {
                    budget.setTuitionRequestedYear6(tuition.bigDecimalValue());
                    break;
                }
            }
        }
        budget.setTuitionRequestedTotal(tuitionTotal.bigDecimalValue());
        if (!tuitionTotal.equals((Object)ScaleTwoDecimal.ZERO)) {
            budget.setTuitionAndFeesRequested(YesNoDataType.Y_YES);
        }
    }

    private void getSupplementationFromOtherSources(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget, Map<Integer, String> hmBudgetQuestions) {
        if (!hmBudgetQuestions.isEmpty() && hmBudgetQuestions.get(37) != null && hmBudgetQuestions.get(37).toUpperCase().equals("Y")) {
            PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.SupplementationFromOtherSources supplementationFromOtherSources = budget.addNewSupplementationFromOtherSources();
            if (hmBudgetQuestions.get(41) != null) {
                supplementationFromOtherSources.setSource(hmBudgetQuestions.get(41));
                supplementationFromOtherSources.setAmount(new BigDecimal(hmBudgetQuestions.get(38)));
                try {
                    supplementationFromOtherSources.setNumberOfMonths(new BigDecimal(hmBudgetQuestions.get(51)));
                }
                catch (NumberFormatException ex) {
                    LOG.error((Object)ex);
                }
                supplementationFromOtherSources.setType(hmBudgetQuestions.get(40));
            }
        }
    }

    protected void getFederalStipendRequested(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget) {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.FederalStipendRequested federalStipendRequested = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.FederalStipendRequested)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.FederalStipendRequested.Factory.newInstance();
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget != null) {
            ScaleTwoDecimal sumOfLineItemCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal numberOfMonths = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!this.getCostElementsByParam("STIPEND_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                    sumOfLineItemCost = (ScaleTwoDecimal)sumOfLineItemCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                    if (CollectionUtils.isNotEmpty((Collection)budgetLineItem.getBudgetPersonnelDetailsList())) {
                        for (BudgetPersonnelDetailsContract details : budgetLineItem.getBudgetPersonnelDetailsList()) {
                            ScaleTwoDecimal detailsNumberOfMonths = details.getPercentEffort() != null ? (ScaleTwoDecimal)this.getNumberOfMonths(details.getStartDate(), details.getEndDate()).multiply((AbstractDecimal)((ScaleTwoDecimal)details.getPercentEffort().multiply((AbstractDecimal)POINT_ZERO_ONE))) : this.getNumberOfMonths(details.getStartDate(), details.getEndDate());
                            numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)detailsNumberOfMonths);
                        }
                        continue;
                    }
                    numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)this.getNumberOfMonths(budgetLineItem.getStartDate(), budgetLineItem.getEndDate()));
                }
            }
            federalStipendRequested.setAmount(sumOfLineItemCost.bigDecimalValue());
            federalStipendRequested.setNumberOfMonths(numberOfMonths.bigDecimalValue());
            budget.setFederalStipendRequested(federalStipendRequested);
        }
    }

    private void getInstitutionalBaseSalary(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget, Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.InstitutionalBaseSalary institutionalBaseSalary = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.InstitutionalBaseSalary)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.InstitutionalBaseSalary.Factory.newInstance();
        if (budgetMap.get(36) != null && budgetMap.get(36).equals(YnqConstant.YES.code())) {
            if (budgetMap.get(47) != null) {
                institutionalBaseSalary.setAmount(new BigDecimal(budgetMap.get(47)));
            }
            if (budgetMap.get(48) != null) {
                institutionalBaseSalary.setAcademicPeriod(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.InstitutionalBaseSalary.AcademicPeriod.Enum.forString(budgetMap.get(48)));
            }
            if (budgetMap.get(50) != null) {
                institutionalBaseSalary.setNumberOfMonths(new BigDecimal(budgetMap.get(50)));
            }
            budget.setInstitutionalBaseSalary(institutionalBaseSalary);
        }
    }

    private void setNarrativeDataForResearchTrainingPlan(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12 phsFellowshipSupplemental, PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.addNewSpecificAims();
        researchTrainingPlan.addNewResearchStrategy();
        researchTrainingPlan.addNewRespectiveContributions();
        researchTrainingPlan.addNewSelectionOfSponsorAndInstitution();
        researchTrainingPlan.addNewResponsibleConductOfResearch();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors sponsors = phsFellowshipSupplemental.addNewSponsors();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors.SponsorCosponsorInformation sponsorCosponsorInfo = sponsors.addNewSponsorCosponsorInformation();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                    case 97: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.IntroductionToApplication introductionToApplication = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.IntroductionToApplication)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.IntroductionToApplication.Factory.newInstance();
                        introductionToApplication.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setIntroductionToApplication(introductionToApplication);
                        break;
                    }
                    case 98: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SpecificAims specificAims = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SpecificAims)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SpecificAims.Factory.newInstance();
                        specificAims.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSpecificAims(specificAims);
                        break;
                    }
                    case 127: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResearchStrategy researchStrategy = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResearchStrategy)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResearchStrategy.Factory.newInstance();
                        researchStrategy.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResearchStrategy(researchStrategy);
                        break;
                    }
                    case 102: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionEnrollmentReport inclusionEnrollmentReport = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionEnrollmentReport)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionEnrollmentReport.Factory.newInstance();
                        inclusionEnrollmentReport.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionEnrollmentReport(inclusionEnrollmentReport);
                        break;
                    }
                    case 103: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProgressReportPublicationList)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProgressReportPublicationList.Factory.newInstance();
                        progressReportPublicationList.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProgressReportPublicationList(progressReportPublicationList);
                        break;
                    }
                    case 104: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProtectionOfHumanSubjects protectionOfHumanSubjects = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProtectionOfHumanSubjects)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProtectionOfHumanSubjects.Factory.newInstance();
                        protectionOfHumanSubjects.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
                        break;
                    }
                    case 105: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfWomenAndMinorities)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfWomenAndMinorities.Factory.newInstance();
                        inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
                        break;
                    }
                    case 106: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.TargetedPlannedEnrollment tarPlannedEnrollmentTable = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.TargetedPlannedEnrollment)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.TargetedPlannedEnrollment.Factory.newInstance();
                        tarPlannedEnrollmentTable.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setTargetedPlannedEnrollment(tarPlannedEnrollmentTable);
                        break;
                    }
                    case 107: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfChildren inclusionOfChildren = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfChildren)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfChildren.Factory.newInstance();
                        inclusionOfChildren.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfChildren(inclusionOfChildren);
                        break;
                    }
                    case 108: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.VertebrateAnimals)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.VertebrateAnimals.Factory.newInstance();
                        vertebrateAnimals.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setVertebrateAnimals(vertebrateAnimals);
                        break;
                    }
                    case 109: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectAgentResearch selectAgentResearch = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectAgentResearch)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectAgentResearch.Factory.newInstance();
                        selectAgentResearch.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSelectAgentResearch(selectAgentResearch);
                        break;
                    }
                    case 110: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResourceSharingPlan)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResourceSharingPlan.Factory.newInstance();
                        resourceSharingPlan.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResourceSharingPlan(resourceSharingPlan);
                        break;
                    }
                    case 88: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.RespectiveContributions respectiveContributions = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.RespectiveContributions)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.RespectiveContributions.Factory.newInstance();
                        respectiveContributions.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setRespectiveContributions(respectiveContributions);
                        break;
                    }
                    case 89: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectionOfSponsorAndInstitution selectionOfSponsorAndInstitution = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectionOfSponsorAndInstitution)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectionOfSponsorAndInstitution.Factory.newInstance();
                        selectionOfSponsorAndInstitution.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSelectionOfSponsorAndInstitution(selectionOfSponsorAndInstitution);
                        break;
                    }
                    case 90: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResponsibleConductOfResearch responsibleConductOfResearch = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResponsibleConductOfResearch)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResponsibleConductOfResearch.Factory.newInstance();
                        responsibleConductOfResearch.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResponsibleConductOfResearch(responsibleConductOfResearch);
                        break;
                    }
                    case 134: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        sponsorCosponsorInfo.setAttFile(attachedFileDataType);
                        break;
                    }
                }
            }
        }
    }

    private void setHumanSubjectInvolvedAndVertebrateAnimalUsed(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.N_NO);
        researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.N_NO);
        for (ProposalSpecialReviewContract propSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if ("1".equals(propSpecialReview.getSpecialReviewType().getCode())) {
                researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.Y_YES);
                continue;
            }
            if (!"2".equals(propSpecialReview.getSpecialReviewType().getCode())) continue;
            researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.Y_YES);
        }
    }

    private void setAdditionalInformation(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation additionalInformation) {
        Boolean hasInvestigator = false;
        additionalInformation.addNewFellowshipTrainingAndCareerGoals();
        additionalInformation.addNewActivitiesPlannedUnderThisAward();
        ProposalPersonContract principalInvestigator = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!proposalPerson.isPrincipalInvestigator()) continue;
            hasInvestigator = true;
            CitizenshipType citizenShip = this.s2SProposalPersonService.getCitizenship(proposalPerson);
            if (citizenShip != null && StringUtils.isNotBlank((CharSequence)citizenShip.getCitizenShip())) {
                if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA.toString())) {
                    additionalInformation.setCitizenship(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA);
                    continue;
                }
                if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S.toString())) {
                    additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S);
                    continue;
                }
                if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL.toString())) {
                    additionalInformation.setCitizenship(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL);
                    continue;
                }
                if (!citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING.toString())) continue;
                additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING);
                continue;
            }
            additionalInformation.setCitizenship(null);
        }
        if (principalInvestigator != null && principalInvestigator.getMobilePhoneNumber() != null) {
            additionalInformation.setAlernatePhoneNumber(principalInvestigator.getMobilePhoneNumber());
        }
        if (!hasInvestigator.booleanValue()) {
            additionalInformation.setCitizenship(null);
        }
        additionalInformation.setConcurrentSupport(YesNoDataType.N_NO);
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                    case 91: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ConcurrentSupportDescription)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ConcurrentSupportDescription.Factory.newInstance();
                        concurrentSupportDescription.setAttFile(attachedFileDataType);
                        additionalInformation.setConcurrentSupport(YesNoDataType.Y_YES);
                        additionalInformation.setConcurrentSupportDescription(concurrentSupportDescription);
                        break;
                    }
                    case 92: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.FellowshipTrainingAndCareerGoals fellowshipTrainingAndCareerGoals = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.FellowshipTrainingAndCareerGoals)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.FellowshipTrainingAndCareerGoals.Factory.newInstance();
                        fellowshipTrainingAndCareerGoals.setAttFile(attachedFileDataType);
                        additionalInformation.setFellowshipTrainingAndCareerGoals(fellowshipTrainingAndCareerGoals);
                        break;
                    }
                    case 93: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.DissertationAndResearchExperience dissertationAndResearchExperience = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.DissertationAndResearchExperience)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.DissertationAndResearchExperience.Factory.newInstance();
                        dissertationAndResearchExperience.setAttFile(attachedFileDataType);
                        additionalInformation.setDissertationAndResearchExperience(dissertationAndResearchExperience);
                        break;
                    }
                    case 94: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ActivitiesPlannedUnderThisAward activitiesPlannedUnderThisAward = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ActivitiesPlannedUnderThisAward)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ActivitiesPlannedUnderThisAward.Factory.newInstance();
                        activitiesPlannedUnderThisAward.setAttFile(attachedFileDataType);
                        additionalInformation.setActivitiesPlannedUnderThisAward(activitiesPlannedUnderThisAward);
                        break;
                    }
                }
            }
        }
    }

    private PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType getApplicationType() {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType applicationType = (PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType)PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.Factory.newInstance();
        applicationType.setTypeOfApplication(this.getTypeOfApplication());
        return applicationType;
    }

    private PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.Enum getTypeOfApplication() {
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.Enum typeOfApplication = null;
        if (proposalTypeCode != null) {
            if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.NEW;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_CONTINUATION").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.CONTINUATION;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.REVISION;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.RENEWAL;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.RESUBMISSION;
            }
        }
        return typeOfApplication;
    }

    @Override
    public PHSFellowshipSupplemental12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHSFellowshipSupplemental12();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHSFellowshipSupplemental12Document> factory() {
        return PHSFellowshipSupplemental12Document.Factory;
    }
}

