/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398TrainingBudget20V20.PHS398TrainingBudget20Document;
import gov.grants.apply.forms.phs398TrainingBudget20V20.PHS398TrainingBudget20YearDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.rate.TrainingStipendRateContract;
import org.kuali.coeus.common.budget.api.rate.TrainingStipendRateService;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.api.budget.S2SIndirectCostDetailsDto;
import org.kuali.coeus.s2sgen.api.budget.S2SIndirectCostDto;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetIndirectCostsService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398TrainingBudgetV2_0Generator")
public class PHS398TrainingBudgetV2_0Generator
extends S2SBaseFormGenerator<PHS398TrainingBudget20Document>
implements S2SFormGeneratorPdfFillable<PHS398TrainingBudget20Document> {
    private static final String GRANTS_GOV_STIPEND_ERROR_MESSAGE = "A stipend budget line item is required equal to or greater than the trainee numbers and associated stipend levels indicated in the questionnaire.Currently the stipend value in the budget is in deficit by (amount) for Year period of the budget.";
    private static final String UNDERGRADS = "Undergraduates";
    private static final String PREDOC = "Predoctoral";
    private static final String POSTDOC = "Postdoctoral";
    private static final String STIPEND_AMOUNT = "amount";
    private static final String BUDGET_PERIOD = "period";
    private static final int PHS_TRAINING_BUDGET_BUDGETJUSTIFICATION_130 = 130;
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD1 = new Integer[]{2, 5, 8, 11, 53, 54, 56};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD2 = new Integer[]{59, 60, 63, 66, 108, 109, 111};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD3 = new Integer[]{114, 115, 118, 121, 164, 165, 167};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD4 = new Integer[]{170, 171, 174, 177, 219, 220, 222};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD5 = new Integer[]{225, 226, 229, 232, 274, 275, 277};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD1 = new Integer[]{17, 26, 35, 44};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD2 = new Integer[]{72, 81, 90, 99};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD3 = new Integer[]{127, 136, 146, 155};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD4 = new Integer[]{183, 192, 201, 210};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD5 = new Integer[]{238, 247, 256, 265};
    private static final int FN_INDEX = 0;
    private static final int SN_INDEX = 1;
    private static final int FD_INDEX = 2;
    private static final int SD_INDEX = 3;
    private static final int ZERO = 0;
    private static final int CV_INDIRECT_COST_LIMIT = 2;
    @Value(value="http://apply.grants.gov/forms/PHS398_TrainingBudget_2_0-V2.0")
    private String namespace;
    @Value(value="PHS398_TrainingBudget_2_0-V2.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_TrainingBudget_2_0-V2.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_TrainingBudget_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="160")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SBudgetInfoService")
    private S2SBudgetIndirectCostsService s2sBudgetIndirectCostsService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="trainingStipendRateService")
    private TrainingStipendRateService trainingStipendRateService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    private S2SCommonBudgetService s2SCommonBudgetService;
    @Autowired
    @Qualifier(value="modularBudgetService")
    protected ModularBudgetService modularBudgetService;

    @Override
    public PHS398TrainingBudget20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        PHS398TrainingBudget20Document trainingBudgetTypeDocument = (PHS398TrainingBudget20Document)PHS398TrainingBudget20Document.Factory.newInstance();
        trainingBudgetTypeDocument.setPHS398TrainingBudget20(this.getPHS398TrainingBudget(proposalDevelopmentDocument));
        return trainingBudgetTypeDocument;
    }

    private PHS398TrainingBudget20Document.PHS398TrainingBudget20 getPHS398TrainingBudget(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        NarrativeContract narrative;
        DevelopmentProposalContract developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(developmentProposal);
        PHS398TrainingBudget20Document.PHS398TrainingBudget20 trainingBudgetType = (PHS398TrainingBudget20Document.PHS398TrainingBudget20)PHS398TrainingBudget20Document.PHS398TrainingBudget20.Factory.newInstance();
        if (budget == null) {
            return trainingBudgetType;
        }
        trainingBudgetType.setFormVersion(FormVersion.v2_0.getVersion());
        trainingBudgetType.setBudgetType(PHS398TrainingBudget20Document.PHS398TrainingBudget20.BudgetType.PROJECT);
        this.setOrganizationData(trainingBudgetType, developmentProposal);
        List modularAmounts = this.modularBudgetService.getModularBudgetAmounts((BudgetContract)budget);
        int numPeople = 0;
        BigDecimal stipendAmountOtherFull = new BigDecimal("0");
        BigDecimal stipendAmountOtherShort = new BigDecimal("0");
        BigDecimal stipendAmountF = new BigDecimal("0");
        BigDecimal stipendAmountJ = new BigDecimal("0");
        BigDecimal stipendAmountPreSingFull = new BigDecimal("0");
        BigDecimal stipendAmountPreDualFull = new BigDecimal("0");
        BigDecimal stipendAmountPreSingShort = new BigDecimal("0");
        BigDecimal stipendAmountPreDualShort = new BigDecimal("0");
        BigDecimal stipendAmount0 = new BigDecimal("0");
        BigDecimal stipendAmount1 = new BigDecimal("0");
        BigDecimal stipendAmount2 = new BigDecimal("0");
        BigDecimal stipendAmount3 = new BigDecimal("0");
        BigDecimal stipendAmount4 = new BigDecimal("0");
        BigDecimal stipendAmount5 = new BigDecimal("0");
        BigDecimal stipendAmount6 = new BigDecimal("0");
        BigDecimal stipendAmount7 = new BigDecimal("0");
        BigDecimal stipendAmountDeg0 = new BigDecimal("0");
        BigDecimal stipendAmountDeg1 = new BigDecimal("0");
        BigDecimal stipendAmountDeg2 = new BigDecimal("0");
        BigDecimal stipendAmountDeg3 = new BigDecimal("0");
        BigDecimal stipendAmountDeg4 = new BigDecimal("0");
        BigDecimal stipendAmountDeg5 = new BigDecimal("0");
        BigDecimal stipendAmountDeg6 = new BigDecimal("0");
        BigDecimal stipendAmountDeg7 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg0 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg1 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg2 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg3 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg4 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg5 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg6 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg7 = new BigDecimal("0");
        BigDecimal cumUndergradStipends = new BigDecimal("0");
        BigDecimal cumPreDocSingleStipends = new BigDecimal("0");
        BigDecimal cumPreDocDualStipends = new BigDecimal("0");
        BigDecimal cumPreDocTotalStipends = new BigDecimal("0");
        BigDecimal cumPostDocNonDegStipends = new BigDecimal("0");
        BigDecimal cumPostDocDegStipends = new BigDecimal("0");
        BigDecimal cumPostDocTotalStipends = new BigDecimal("0");
        BigDecimal cumOtherStipends = new BigDecimal("0");
        BigDecimal cumUndergradTuition = new BigDecimal("0");
        BigDecimal cumPreDocSingleTuition = new BigDecimal("0");
        BigDecimal cumPreDocDualTuition = new BigDecimal("0");
        BigDecimal cumPreDocTotalTuition = new BigDecimal("0");
        BigDecimal cumPostDocNonDegTuition = new BigDecimal("0");
        BigDecimal cumPostDocDegTuition = new BigDecimal("0");
        BigDecimal cumPostDocTotalTuition = new BigDecimal("0");
        BigDecimal cumOtherTuition = new BigDecimal("0");
        BigDecimal cumTrainingCosts = new BigDecimal("0");
        BigDecimal cumTravelCosts = new BigDecimal("0");
        BigDecimal cumConsCosts = new BigDecimal("0");
        BigDecimal cumResearchTotalDirectCosts = new BigDecimal("0");
        BigDecimal cumTotalOtherDirectCosts = new BigDecimal("0");
        BigDecimal cumTotalDirectCosts = new BigDecimal("0");
        BigDecimal cumTotalIndCosts1 = new BigDecimal("0");
        BigDecimal cumTotalIndCosts2 = new BigDecimal("0");
        BigDecimal cumTotalIndCosts = new BigDecimal("0");
        BigDecimal cumTotalDirectAndIndCosts = new BigDecimal("0");
        BigDecimal researchDirectCosts = new BigDecimal("0");
        BigDecimal totalOtherDirectCostsRequested = new BigDecimal("0");
        List budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriodContract budgetPeriod : budgetPeriods) {
            Double researchDirectCostValue;
            PHS398TrainingBudget20YearDataType phs398TrainingBudgetYearDataType = trainingBudgetType.addNewBudgetYear();
            ScaleTwoDecimal trainingTraveCost = this.getBudgetPeriodCost(budgetPeriod, "TRAINEE_TRAVEL_COST_ELEMENTS");
            phs398TrainingBudgetYearDataType.setTraineeTravelRequested(trainingTraveCost.bigDecimalValue());
            ScaleTwoDecimal trainingCost = this.getBudgetPeriodCost(budgetPeriod, "TRAINING_REL_COST_ELEMENTS");
            phs398TrainingBudgetYearDataType.setTrainingRelatedExpensesRequested(trainingCost.bigDecimalValue());
            ScaleTwoDecimal consTrainingCost = this.getBudgetPeriodCost(budgetPeriod, "SUBCONTRACT_COST_ELEMENTS");
            phs398TrainingBudgetYearDataType.setConsortiumTrainingCostsRequested(consTrainingCost.bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPostdocNonDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, "TUITION_POSTDOC_NONDEG_COST_ELEMENTS").bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPostdocDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, "TUITION_POSTDOC_DEG_COST_ELEMENTS").bigDecimalValue());
            phs398TrainingBudgetYearDataType.setUndergraduateTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, "TUITION_UNDERGRAD_COST_ELEMENTS").bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPredocDualDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, "TUITION_PREDOC_DUAL_DEG_COST_ELEMENTS").bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPredocSingleDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, "TUITION_PREDOC_SINGLE_DEG_COST_ELEMENTS").bigDecimalValue());
            phs398TrainingBudgetYearDataType.setOtherTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, "TUITION_OTHER_COST_ELEMENTS").bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPeriodEndDate(DateUtils.toCalendar((Date)budgetPeriod.getEndDate()));
            phs398TrainingBudgetYearDataType.setPeriodStartDate(DateUtils.toCalendar((Date)budgetPeriod.getStartDate()));
            cumUndergradTuition = cumUndergradTuition.add(phs398TrainingBudgetYearDataType.getUndergraduateTuitionAndFeesRequested());
            cumPreDocSingleTuition = cumPreDocSingleTuition.add(phs398TrainingBudgetYearDataType.getPredocSingleDegreeTuitionAndFeesRequested());
            cumPreDocDualTuition = cumPreDocDualTuition.add(phs398TrainingBudgetYearDataType.getPredocDualDegreeTuitionAndFeesRequested());
            cumPostDocNonDegTuition = cumPostDocNonDegTuition.add(phs398TrainingBudgetYearDataType.getPostdocNonDegreeTuitionAndFeesRequested());
            cumPostDocDegTuition = cumPostDocDegTuition.add(phs398TrainingBudgetYearDataType.getPostdocDegreeTuitionAndFeesRequested());
            cumPostDocTotalTuition = cumPostDocNonDegTuition.add(cumPostDocDegTuition);
            cumOtherTuition = cumOtherTuition.add(phs398TrainingBudgetYearDataType.getOtherTuitionAndFeesRequested());
            cumTrainingCosts = cumTrainingCosts.add(phs398TrainingBudgetYearDataType.getTrainingRelatedExpensesRequested());
            cumTravelCosts = cumTravelCosts.add(phs398TrainingBudgetYearDataType.getTraineeTravelRequested());
            cumConsCosts = cumConsCosts.add(phs398TrainingBudgetYearDataType.getConsortiumTrainingCostsRequested());
            S2SIndirectCostDto indirectCostInfo = this.s2sBudgetIndirectCostsService.getIndirectCosts((BudgetContract)budget, budgetPeriod, modularAmounts);
            List cvIndirectCost = indirectCostInfo.getIndirectCostDetails();
            BigDecimal totIndCosts = new BigDecimal("0");
            int i = 0;
            while (i < cvIndirectCost.size() & i < 2) {
                S2SIndirectCostDetailsDto indireCost = (S2SIndirectCostDetailsDto)cvIndirectCost.get(i);
                totIndCosts = totIndCosts.add(indireCost.getFunds().bigDecimalValue());
                switch (i) {
                    case 0: {
                        phs398TrainingBudgetYearDataType.setIndirectCostType1(indireCost.getCostType());
                        phs398TrainingBudgetYearDataType.setIndirectCostBase1(indireCost.getBase().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostFundsRequested1(indireCost.getFunds().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostRate1(indireCost.getRate().bigDecimalValue());
                        cumTotalIndCosts1 = cumTotalIndCosts1.add(phs398TrainingBudgetYearDataType.getIndirectCostFundsRequested1());
                        break;
                    }
                    case 1: {
                        phs398TrainingBudgetYearDataType.setIndirectCostType1(indireCost.getCostType());
                        phs398TrainingBudgetYearDataType.setIndirectCostBase2(indireCost.getBase().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostFundsRequested2(indireCost.getFunds().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostRate2(indireCost.getRate().bigDecimalValue());
                        cumTotalIndCosts2 = cumTotalIndCosts2.add(phs398TrainingBudgetYearDataType.getIndirectCostFundsRequested2());
                        break;
                    }
                }
                ++i;
            }
            phs398TrainingBudgetYearDataType.setTotalIndirectCostsRequested(totIndCosts);
            int numPostDocLevel4 = 0;
            int numPostDocLevel7 = 0;
            HashMap<String, String> hmNonDegree = new HashMap<String, String>();
            HashMap<String, String> hmDegree = new HashMap<String, String>();
            hmNonDegree.put("fulllevel0", "0");
            hmNonDegree.put("fulllevel1", "0");
            hmNonDegree.put("fulllevel2", "0");
            hmNonDegree.put("fulllevel3", "0");
            hmNonDegree.put("fulllevel4", "0");
            hmNonDegree.put("fulllevel5", "0");
            hmNonDegree.put("fulllevel6", "0");
            hmNonDegree.put("fulllevel7", "0");
            hmNonDegree.put("shortlevel0", "0");
            hmNonDegree.put("shortlevel1", "0");
            hmNonDegree.put("shortlevel2", "0");
            hmNonDegree.put("shortlevel3", "0");
            hmNonDegree.put("shortlevel4", "0");
            hmNonDegree.put("shortlevel5", "0");
            hmNonDegree.put("shortlevel6", "0");
            hmNonDegree.put("shortlevel7", "0");
            String answer = null;
            int preDocCountFull = 0;
            int preDocCountShort = 0;
            int undergradFirstYearNum = 0;
            int undergradJrNum = 0;
            BigDecimal otherShortStipends = new BigDecimal("0");
            BigDecimal otherFullStipends = new BigDecimal("0");
            List<? extends AnswerHeaderContract> answerHeaders = this.findQuestionnaireWithAnswers(developmentProposal);
            if (answerHeaders != null) {
                for (AnswerHeaderContract answerHeaderContract : answerHeaders) {
                    QuestionnaireContract questionnaire = this.getQuestionAnswerService().findQuestionnaireById(answerHeaderContract.getQuestionnaireId());
                    List list = questionnaire.getQuestionnaireQuestions();
                    for (QuestionnaireQuestionContract questionnaireQuestion : list) {
                        AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeaderContract);
                        answer = answerBO.getAnswer();
                        QuestionContract question = questionnaireQuestion.getQuestion();
                        if (answer == null) continue;
                        int answerIntVal = 0;
                        try {
                            answerIntVal = Integer.parseInt(answer);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (this.isPreDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod)) {
                            switch (question.getQuestionSeqId()) {
                                case 72: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setUndergraduateNumFullTime(answerIntVal);
                                    break;
                                }
                                case 73: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setUndergraduateNumShortTerm(answerIntVal);
                                    break;
                                }
                                case 74: {
                                    if (answer == null) break;
                                    undergradFirstYearNum += answerIntVal;
                                    break;
                                }
                                case 75: {
                                    if (answer == null) break;
                                    undergradJrNum += answerIntVal;
                                    break;
                                }
                                case 77: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocSingleDegreeNumFullTime(answerIntVal);
                                    preDocCountFull += phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumFullTime();
                                    break;
                                }
                                case 78: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocSingleDegreeNumShortTerm(answerIntVal);
                                    preDocCountShort += phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumShortTerm();
                                    break;
                                }
                                case 79: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocDualDegreeNumFullTime(answerIntVal);
                                    preDocCountFull += phs398TrainingBudgetYearDataType.getPredocDualDegreeNumFullTime();
                                    break;
                                }
                                case 80: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocDualDegreeNumShortTerm(answerIntVal);
                                    preDocCountShort += phs398TrainingBudgetYearDataType.getPredocDualDegreeNumShortTerm();
                                    break;
                                }
                                case 95: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setOtherNumFullTime(answerIntVal);
                                    break;
                                }
                                case 97: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setOtherNumShortTerm(answerIntVal);
                                    break;
                                }
                                case 96: {
                                    if (answer == null) break;
                                    otherFullStipends = new BigDecimal(answer);
                                    break;
                                }
                                case 98: {
                                    if (answer == null) break;
                                    otherShortStipends = new BigDecimal(answer);
                                }
                            }
                        }
                        if (this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 0)) {
                            switch (question.getQuestionSeqId()) {
                                case 86: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel0", answer);
                                    break;
                                }
                                case 87: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel1", answer);
                                    break;
                                }
                                case 88: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel2", answer);
                                    break;
                                }
                                case 89: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel3", answer);
                                    break;
                                }
                                case 90: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel4", answer);
                                    break;
                                }
                                case 91: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel5", answer);
                                    break;
                                }
                                case 92: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel6", answer);
                                    break;
                                }
                                case 93: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel7", answer);
                                    break;
                                }
                            }
                        }
                        if (!this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 1)) continue;
                        switch (question.getQuestionSeqId()) {
                            case 86: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel0", answer);
                                break;
                            }
                            case 87: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel1", answer);
                                break;
                            }
                            case 88: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel2", answer);
                                break;
                            }
                            case 89: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel3", answer);
                                break;
                            }
                            case 90: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel4", answer);
                                break;
                            }
                            case 91: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel5", answer);
                                break;
                            }
                            case 92: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel6", answer);
                                break;
                            }
                            case 93: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel7", answer);
                                break;
                            }
                        }
                    }
                }
            }
            phs398TrainingBudgetYearDataType.setUndergraduateNumFirstYearSophomoreStipends(undergradFirstYearNum);
            phs398TrainingBudgetYearDataType.setUndergraduateNumJuniorSeniorStipends(undergradJrNum);
            phs398TrainingBudgetYearDataType.setOtherStipendsRequested(otherShortStipends.add(otherFullStipends));
            phs398TrainingBudgetYearDataType.setPredocTotalNumShortTerm(preDocCountShort);
            phs398TrainingBudgetYearDataType.setPredocTotalNumFullTime(preDocCountFull);
            cumOtherStipends = cumOtherStipends.add(phs398TrainingBudgetYearDataType.getOtherStipendsRequested());
            int postDocNumNonDegreeFullTime = Integer.parseInt((String)hmNonDegree.get("fulllevel0")) + Integer.parseInt((String)hmNonDegree.get("fulllevel1")) + Integer.parseInt((String)hmNonDegree.get("fulllevel2")) + Integer.parseInt((String)hmNonDegree.get("fulllevel3")) + Integer.parseInt((String)hmNonDegree.get("fulllevel4")) + Integer.parseInt((String)hmNonDegree.get("fulllevel5")) + Integer.parseInt((String)hmNonDegree.get("fulllevel6")) + Integer.parseInt((String)hmNonDegree.get("fulllevel7"));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeFullTime(postDocNumNonDegreeFullTime);
            int n = Integer.parseInt((String)hmNonDegree.get("shortlevel0")) + Integer.parseInt((String)hmNonDegree.get("shortlevel1")) + Integer.parseInt((String)hmNonDegree.get("shortlevel2")) + Integer.parseInt((String)hmNonDegree.get("shortlevel3")) + Integer.parseInt((String)hmNonDegree.get("shortlevel4")) + Integer.parseInt((String)hmNonDegree.get("shortlevel5")) + Integer.parseInt((String)hmNonDegree.get("shortlevel6")) + Integer.parseInt((String)hmNonDegree.get("shortlevel7"));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeShortTerm(n);
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel0(Integer.parseInt((String)hmNonDegree.get("fulllevel0")) + Integer.parseInt((String)hmNonDegree.get("shortlevel0")));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel1(Integer.parseInt((String)hmNonDegree.get("fulllevel1")) + Integer.parseInt((String)hmNonDegree.get("shortlevel1")));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel2(Integer.parseInt((String)hmNonDegree.get("fulllevel2")) + Integer.parseInt((String)hmNonDegree.get("shortlevel2")));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel3(Integer.parseInt((String)hmNonDegree.get("fulllevel3")) + Integer.parseInt((String)hmNonDegree.get("shortlevel3")));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel4(Integer.parseInt((String)hmNonDegree.get("fulllevel4")) + Integer.parseInt((String)hmNonDegree.get("shortlevel4")));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel5(Integer.parseInt((String)hmNonDegree.get("fulllevel5")) + Integer.parseInt((String)hmNonDegree.get("shortlevel5")));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel6(Integer.parseInt((String)hmNonDegree.get("fulllevel6")) + Integer.parseInt((String)hmNonDegree.get("shortlevel6")));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel7(Integer.parseInt((String)hmNonDegree.get("fulllevel7")) + Integer.parseInt((String)hmNonDegree.get("shortlevel7")));
            answer = null;
            hmDegree.put("fulllevel0", "0");
            hmDegree.put("fulllevel1", "0");
            hmDegree.put("fulllevel2", "0");
            hmDegree.put("fulllevel3", "0");
            hmDegree.put("fulllevel4", "0");
            hmDegree.put("fulllevel5", "0");
            hmDegree.put("fulllevel6", "0");
            hmDegree.put("fulllevel7", "0");
            hmDegree.put("shortlevel0", "0");
            hmDegree.put("shortlevel1", "0");
            hmDegree.put("shortlevel2", "0");
            hmDegree.put("shortlevel3", "0");
            hmDegree.put("shortlevel4", "0");
            hmDegree.put("shortlevel5", "0");
            hmDegree.put("shortlevel6", "0");
            hmDegree.put("shortlevel7", "0");
            if (answerHeaders != null) {
                for (AnswerHeaderContract answerHeaderContract : answerHeaders) {
                    QuestionnaireContract questionnaire = this.getQuestionAnswerService().findQuestionnaireById(answerHeaderContract.getQuestionnaireId());
                    List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
                    for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                        AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeaderContract);
                        answer = answerBO.getAnswer();
                        QuestionContract question = questionnaireQuestion.getQuestion();
                        if (answer == null) continue;
                        int answerIntVal = 0;
                        try {
                            answerIntVal = Integer.parseInt(answer);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 2)) {
                            switch (question.getQuestionSeqId()) {
                                case 86: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel0", answer);
                                    break;
                                }
                                case 87: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel1", answer);
                                    break;
                                }
                                case 88: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel2", answer);
                                    break;
                                }
                                case 89: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel3", answer);
                                    break;
                                }
                                case 90: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel4", answer);
                                    break;
                                }
                                case 91: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel5", answer);
                                    break;
                                }
                                case 92: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel6", answer);
                                    break;
                                }
                                case 93: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel7", answer);
                                    break;
                                }
                            }
                        }
                        if (!this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 3)) continue;
                        switch (question.getQuestionSeqId()) {
                            case 86: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel0", answer);
                                break;
                            }
                            case 87: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel1", answer);
                                break;
                            }
                            case 88: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel2", answer);
                                break;
                            }
                            case 89: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel3", answer);
                                break;
                            }
                            case 90: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel4", answer);
                                break;
                            }
                            case 91: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel5", answer);
                                break;
                            }
                            case 92: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel6", answer);
                                break;
                            }
                            case 93: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel7", answer);
                                break;
                            }
                        }
                    }
                }
            }
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel0(Integer.parseInt((String)hmDegree.get("fulllevel0")) + Integer.parseInt((String)hmDegree.get("shortlevel0")));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel1(Integer.parseInt((String)hmDegree.get("fulllevel1")) + Integer.parseInt((String)hmDegree.get("shortlevel1")));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel2(Integer.parseInt((String)hmDegree.get("fulllevel2")) + Integer.parseInt((String)hmDegree.get("shortlevel2")));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel3(Integer.parseInt((String)hmDegree.get("fulllevel3")) + Integer.parseInt((String)hmDegree.get("shortlevel3")));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel4(Integer.parseInt((String)hmDegree.get("fulllevel4")) + Integer.parseInt((String)hmDegree.get("shortlevel4")));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel5(Integer.parseInt((String)hmDegree.get("fulllevel5")) + Integer.parseInt((String)hmDegree.get("shortlevel5")));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel6(Integer.parseInt((String)hmDegree.get("fulllevel6")) + Integer.parseInt((String)hmDegree.get("shortlevel6")));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel7(Integer.parseInt((String)hmDegree.get("fulllevel7")) + Integer.parseInt((String)hmDegree.get("shortlevel7")));
            int postDocNumDegreeFulltime = Integer.parseInt((String)hmDegree.get("fulllevel0")) + Integer.parseInt((String)hmDegree.get("fulllevel1")) + Integer.parseInt((String)hmDegree.get("fulllevel2")) + Integer.parseInt((String)hmDegree.get("fulllevel3")) + Integer.parseInt((String)hmDegree.get("fulllevel4")) + Integer.parseInt((String)hmDegree.get("fulllevel5")) + Integer.parseInt((String)hmDegree.get("fulllevel6")) + Integer.parseInt((String)hmDegree.get("fulllevel7"));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeFullTime(postDocNumDegreeFulltime);
            int n2 = Integer.parseInt((String)hmDegree.get("shortlevel0")) + Integer.parseInt((String)hmDegree.get("shortlevel1")) + Integer.parseInt((String)hmDegree.get("shortlevel2")) + Integer.parseInt((String)hmDegree.get("shortlevel3")) + Integer.parseInt((String)hmDegree.get("shortlevel4")) + Integer.parseInt((String)hmDegree.get("shortlevel5")) + Integer.parseInt((String)hmDegree.get("shortlevel6")) + Integer.parseInt((String)hmDegree.get("shortlevel7"));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeShortTerm(n2);
            phs398TrainingBudgetYearDataType.setPostdocTotalShortTerm(phs398TrainingBudgetYearDataType.getPostdocNumDegreeShortTerm() + phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeShortTerm());
            phs398TrainingBudgetYearDataType.setPostdocTotalFullTime(phs398TrainingBudgetYearDataType.getPostdocNumDegreeFullTime() + phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeFullTime());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel0(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel0() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel0());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel1(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel1() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel1());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel2(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel2() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel2());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel3(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel3() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel3());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel4(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel4() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel4());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel5(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel5() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel5());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel6(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel6() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel6());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel7(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel7() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel7());
            numPeople = phs398TrainingBudgetYearDataType.getUndergraduateNumFirstYearSophomoreStipends();
            stipendAmountF = this.getStipendAmount(budgetPeriod, UNDERGRADS, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getUndergraduateNumJuniorSeniorStipends();
            stipendAmountJ = this.getStipendAmount(budgetPeriod, UNDERGRADS, 1, numPeople);
            phs398TrainingBudgetYearDataType.setUndergraduateStipendsRequested(stipendAmountF.add(stipendAmountJ));
            cumUndergradStipends = cumUndergradStipends.add(phs398TrainingBudgetYearDataType.getUndergraduateStipendsRequested());
            numPeople = phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumFullTime();
            stipendAmountPreSingFull = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getPredocDualDegreeNumFullTime();
            stipendAmountPreDualFull = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumShortTerm();
            stipendAmountPreSingShort = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getPredocDualDegreeNumShortTerm();
            stipendAmountPreDualShort = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            phs398TrainingBudgetYearDataType.setPredocSingleDegreeStipendsRequested(stipendAmountPreSingFull.add(stipendAmountPreSingShort));
            phs398TrainingBudgetYearDataType.setPredocDualDegreeStipendsRequested(stipendAmountPreDualFull.add(stipendAmountPreDualShort));
            phs398TrainingBudgetYearDataType.setPredocTotalStipendsRequested(stipendAmountPreSingFull.add(stipendAmountPreDualFull.add(stipendAmountPreSingShort).add(stipendAmountPreDualShort)));
            cumPreDocSingleStipends = cumPreDocSingleStipends.add(stipendAmountPreSingFull).add(stipendAmountPreSingShort);
            cumPreDocDualStipends = cumPreDocDualStipends.add(stipendAmountPreDualFull).add(stipendAmountPreDualShort);
            cumPreDocTotalStipends = cumPreDocSingleStipends.add(cumPreDocDualStipends);
            cumPreDocTotalTuition = cumPreDocDualTuition.add(cumPreDocSingleTuition);
            int numPostDocLevel0 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel0();
            stipendAmountNonDeg0 = this.getStipendAmount(budgetPeriod, POSTDOC, 0, numPostDocLevel0);
            numPostDocLevel0 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel0();
            stipendAmountDeg0 = this.getStipendAmount(budgetPeriod, POSTDOC, 0, numPostDocLevel0);
            int numPostDocLevel1 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel1();
            stipendAmountNonDeg1 = this.getStipendAmount(budgetPeriod, POSTDOC, 1, numPostDocLevel1);
            numPostDocLevel1 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel1();
            stipendAmountDeg1 = this.getStipendAmount(budgetPeriod, POSTDOC, 1, numPostDocLevel1);
            int numPostDocLevel2 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel2();
            stipendAmountNonDeg2 = this.getStipendAmount(budgetPeriod, POSTDOC, 2, numPostDocLevel2);
            numPostDocLevel2 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel2();
            stipendAmountDeg2 = this.getStipendAmount(budgetPeriod, POSTDOC, 2, numPostDocLevel2);
            int numPostDocLevel3 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel3();
            stipendAmountNonDeg3 = this.getStipendAmount(budgetPeriod, POSTDOC, 3, numPostDocLevel3);
            numPostDocLevel3 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel3();
            stipendAmountDeg3 = this.getStipendAmount(budgetPeriod, POSTDOC, 3, numPostDocLevel3);
            numPostDocLevel4 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel4();
            stipendAmountNonDeg4 = this.getStipendAmount(budgetPeriod, POSTDOC, 4, numPostDocLevel4);
            numPostDocLevel4 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel4();
            stipendAmountDeg4 = this.getStipendAmount(budgetPeriod, POSTDOC, 4, numPostDocLevel4);
            int numPostDocLevel5 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel5();
            stipendAmountNonDeg5 = this.getStipendAmount(budgetPeriod, POSTDOC, 5, numPostDocLevel5);
            numPostDocLevel5 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel5();
            stipendAmountDeg5 = this.getStipendAmount(budgetPeriod, POSTDOC, 5, numPostDocLevel5);
            int numPostDocLevel6 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel6();
            stipendAmountNonDeg6 = this.getStipendAmount(budgetPeriod, POSTDOC, 6, numPostDocLevel6);
            numPostDocLevel6 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel6();
            stipendAmountDeg6 = this.getStipendAmount(budgetPeriod, POSTDOC, 6, numPostDocLevel6);
            numPostDocLevel7 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel7();
            stipendAmountNonDeg7 = this.getStipendAmount(budgetPeriod, POSTDOC, 7, numPostDocLevel7);
            numPostDocLevel7 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel7();
            stipendAmountDeg7 = this.getStipendAmount(budgetPeriod, POSTDOC, 7, numPostDocLevel7);
            phs398TrainingBudgetYearDataType.setPostdocDegreeStipendsRequested(stipendAmountDeg0.add(stipendAmountDeg1).add(stipendAmountDeg2).add(stipendAmountDeg3).add(stipendAmountDeg4).add(stipendAmountDeg5).add(stipendAmountDeg6).add(stipendAmountDeg7));
            phs398TrainingBudgetYearDataType.setPostdocNonDegreeStipendsRequested(stipendAmountNonDeg0.add(stipendAmountNonDeg1).add(stipendAmountNonDeg2).add(stipendAmountNonDeg3).add(stipendAmountNonDeg4).add(stipendAmountNonDeg5).add(stipendAmountNonDeg6).add(stipendAmountNonDeg7));
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendsRequested(phs398TrainingBudgetYearDataType.getPostdocNonDegreeStipendsRequested().add(phs398TrainingBudgetYearDataType.getPostdocDegreeStipendsRequested()));
            phs398TrainingBudgetYearDataType.setPostdocTotalTuitionAndFeesRequested(phs398TrainingBudgetYearDataType.getPostdocDegreeTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPostdocNonDegreeTuitionAndFeesRequested()));
            phs398TrainingBudgetYearDataType.setPredocTotalTuitionAndFeesRequested(phs398TrainingBudgetYearDataType.getPredocDualDegreeTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPredocSingleDegreeTuitionAndFeesRequested()));
            phs398TrainingBudgetYearDataType.setTotalTuitionAndFeesRequested(phs398TrainingBudgetYearDataType.getPredocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPostdocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getUndergraduateTuitionAndFeesRequested())).add(phs398TrainingBudgetYearDataType.getOtherTuitionAndFeesRequested()));
            phs398TrainingBudgetYearDataType.setTotalStipendsRequested(phs398TrainingBudgetYearDataType.getPostdocTotalStipendsRequested().add(phs398TrainingBudgetYearDataType.getPredocTotalStipendsRequested().add(phs398TrainingBudgetYearDataType.getUndergraduateStipendsRequested())).add(phs398TrainingBudgetYearDataType.getOtherStipendsRequested()));
            phs398TrainingBudgetYearDataType.setTotalStipendsAndTuitionFeesRequested(phs398TrainingBudgetYearDataType.getTotalStipendsRequested().add(phs398TrainingBudgetYearDataType.getPostdocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPredocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getUndergraduateTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getOtherTuitionAndFeesRequested())))));
            researchDirectCosts = ((ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().subtract((AbstractDecimal)trainingCost)).subtract((AbstractDecimal)trainingTraveCost)).subtract((AbstractDecimal)consTrainingCost)).bigDecimalValue();
            researchDirectCosts = researchDirectCosts.subtract(phs398TrainingBudgetYearDataType.getTotalStipendsAndTuitionFeesRequested());
            phs398TrainingBudgetYearDataType.setResearchDirectCostsRequested(researchDirectCosts);
            if (phs398TrainingBudgetYearDataType.getResearchDirectCostsRequested() != null && (researchDirectCostValue = Double.valueOf(phs398TrainingBudgetYearDataType.getResearchDirectCostsRequested().doubleValue())) < 0.0) {
                String researchDirectCostValueStipend = researchDirectCostValue.toString();
                String budgetYear = budgetPeriod.getBudgetPeriod().toString();
                AuditError stipendError = new AuditError("noField", GRANTS_GOV_STIPEND_ERROR_MESSAGE, "grantsGov.Opportunity", new String[0]);
                String errorMessage = stipendError.getMessageKey();
                errorMessage = errorMessage.replace(STIPEND_AMOUNT, researchDirectCostValueStipend);
                errorMessage = errorMessage.replace(BUDGET_PERIOD, budgetYear);
                stipendError.setMessageKey(errorMessage);
                this.getAuditErrors().add(stipendError);
            }
            totalOtherDirectCostsRequested = budgetPeriod.getTotalDirectCost().bigDecimalValue();
            totalOtherDirectCostsRequested = totalOtherDirectCostsRequested.subtract(phs398TrainingBudgetYearDataType.getTotalStipendsAndTuitionFeesRequested());
            phs398TrainingBudgetYearDataType.setTotalOtherDirectCostsRequested(totalOtherDirectCostsRequested);
            phs398TrainingBudgetYearDataType.setTotalDirectCostsRequested(phs398TrainingBudgetYearDataType.getTotalOtherDirectCostsRequested().add(phs398TrainingBudgetYearDataType.getTotalStipendsAndTuitionFeesRequested()));
            phs398TrainingBudgetYearDataType.setTotalDirectAndIndirectCostsRequested(phs398TrainingBudgetYearDataType.getTotalDirectCostsRequested().add(phs398TrainingBudgetYearDataType.getTotalIndirectCostsRequested()));
            cumPostDocNonDegStipends = cumPostDocNonDegStipends.add(phs398TrainingBudgetYearDataType.getPostdocNonDegreeStipendsRequested());
            cumPostDocDegStipends = cumPostDocDegStipends.add(phs398TrainingBudgetYearDataType.getPostdocDegreeStipendsRequested());
            cumPostDocTotalStipends = cumPostDocNonDegStipends.add(cumPostDocDegStipends);
            cumResearchTotalDirectCosts = cumResearchTotalDirectCosts.add(phs398TrainingBudgetYearDataType.getResearchDirectCostsRequested());
            cumTotalOtherDirectCosts = cumTotalOtherDirectCosts.add(phs398TrainingBudgetYearDataType.getTotalOtherDirectCostsRequested());
        }
        trainingBudgetType.setCumulativeUndergraduateStipendsRequested(cumUndergradStipends);
        trainingBudgetType.setCumulativeUndergraduateTuitionAndFeesRequested(cumUndergradTuition);
        trainingBudgetType.setCumulativeOtherStipendsRequested(cumOtherStipends);
        trainingBudgetType.setCumulativeOtherTuitionAndFeesRequested(cumOtherTuition);
        trainingBudgetType.setCumulativePostdocDegreeStipendsRequested(cumPostDocDegStipends);
        trainingBudgetType.setCumulativePostdocDegreeTuitionAndFeesRequested(cumPostDocDegTuition);
        trainingBudgetType.setCumulativePostdocNonDegreeStipendsRequested(cumPostDocNonDegStipends);
        trainingBudgetType.setCumulativePostdocNonDegreeTuitionAndFeesRequested(cumPostDocNonDegTuition);
        trainingBudgetType.setCumulativePostdocTotalStipendsRequested(cumPostDocTotalStipends);
        trainingBudgetType.setCumulativePostdocTotalTuitionAndFeesRequested(cumPostDocTotalTuition);
        trainingBudgetType.setCumulativePredocDualDegreeStipendsRequested(cumPreDocDualStipends);
        trainingBudgetType.setCumulativePredocDualDegreeTuitionAndFeesRequested(cumPreDocDualTuition);
        trainingBudgetType.setCumulativePredocSingleDegreeStipendsRequested(cumPreDocSingleStipends);
        trainingBudgetType.setCumulativePredocSingleDegreeTuitionAndFeesRequested(cumPreDocSingleTuition);
        trainingBudgetType.setCumulativePredocTotalStipendsRequested(cumPreDocTotalStipends);
        trainingBudgetType.setCumulativePredocTotalTuitionAndFeesRequested(cumPreDocTotalTuition);
        trainingBudgetType.setCumulativeTotalStipendsRequested(cumPostDocTotalStipends.add(cumPreDocTotalStipends).add(cumOtherStipends).add(cumUndergradStipends));
        trainingBudgetType.setCumulativeTuitionAndFeesRequested(cumPostDocTotalTuition.add(cumPreDocTotalTuition).add(cumOtherTuition).add(cumUndergradTuition));
        trainingBudgetType.setCumulativeTotalStipendsAndTuitionFeesRequested(trainingBudgetType.getCumulativeTotalStipendsRequested().add(trainingBudgetType.getCumulativeTuitionAndFeesRequested()));
        trainingBudgetType.setCumulativeConsortiumTrainingCostsRequested(cumConsCosts);
        trainingBudgetType.setCumulativeResearchDirectCostsRequested(cumResearchTotalDirectCosts);
        trainingBudgetType.setCumulativeTotalDirectCostsRequested(trainingBudgetType.getCumulativeTotalStipendsAndTuitionFeesRequested().add(cumTotalOtherDirectCosts));
        trainingBudgetType.setCumulativeTotalIndirectCostsRequested(cumTotalIndCosts1.add(cumTotalIndCosts2));
        trainingBudgetType.setCumulativeTotalOtherDirectCostsRequested(cumTotalOtherDirectCosts);
        trainingBudgetType.setCumulativeTotalDirectAndIndirectCostsRequested(trainingBudgetType.getCumulativeTotalDirectCostsRequested().add(cumTotalIndCosts1.add(cumTotalIndCosts2)));
        trainingBudgetType.setCumulativeTraineeTravelRequested(cumTravelCosts);
        trainingBudgetType.setCumulativeTrainingRelatedExpensesRequested(cumTrainingCosts);
        AttachedFileDataType attachedFileDataType = null;
        Iterator iterator = developmentProposal.getNarratives().iterator();
        while (iterator.hasNext() && ((narrative = (NarrativeContract)iterator.next()).getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 130 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null)) {
        }
        if (attachedFileDataType == null) {
            attachedFileDataType = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
        }
        trainingBudgetType.setBudgetJustification(attachedFileDataType);
        return trainingBudgetType;
    }

    private void setOrganizationData(PHS398TrainingBudget20Document.PHS398TrainingBudget20 trainingBudgetType, DevelopmentProposalContract developmentProposal) {
        OrganizationContract organization;
        ProposalSiteContract applicantOrgSite = developmentProposal.getApplicantOrganization();
        if (applicantOrgSite != null && (organization = applicantOrgSite.getOrganization()) != null) {
            String uei = organization.getUei();
            if (uei != null) {
                trainingBudgetType.setSAMUEI(uei);
            }
            trainingBudgetType.setOrganizationName(StringUtils.substring((String)applicantOrgSite.getLocationName(), (int)0, (int)60));
        }
    }

    private ScaleTwoDecimal getBudgetPeriodCost(BudgetPeriodContract budgetPeriod, String costType) {
        String[] costElements;
        ScaleTwoDecimal totalLineItemCost = ScaleTwoDecimal.ZERO;
        String costElementsStrValue = this.s2SConfigurationService.getValueAsString(costType);
        for (String costElement : costElements = costElementsStrValue.split(",")) {
            List budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItemContract budgetLineItem : budgetLineItems) {
                if (!budgetLineItem.getCostElementBO().getCostElement().equals(costElement)) continue;
                totalLineItemCost = (ScaleTwoDecimal)totalLineItemCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
            }
        }
        return totalLineItemCost;
    }

    private List<? extends AnswerHeaderContract> findQuestionnaireWithAnswers(DevelopmentProposalContract developmentProposal) {
        return this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(developmentProposal.getProposalNumber(), "http://apply.grants.gov/forms/PHS398_TrainingBudget_2_0-V2.0", "PHS398_TrainingBudget_2_0-V2.0");
    }

    private AnswerContract getAnswer(QuestionnaireQuestionContract questionnaireQuestion, AnswerHeaderContract answerHeader) {
        List answers = answerHeader.getAnswers();
        for (AnswerContract answer : answers) {
            if (!answer.getQuestionnaireQuestionsId().equals(questionnaireQuestion.getId())) continue;
            return answer;
        }
        return null;
    }

    private boolean isPostDocParentQuestionFromPeriodExists(QuestionnaireQuestionContract questionnaireQuestion, BudgetPeriodContract budgetPeriod, int termIndex) {
        return this.getPostDocParentQuestionsForPeriod(budgetPeriod, termIndex).equals(questionnaireQuestion.getParentQuestionNumber());
    }

    private Integer getPostDocParentQuestionsForPeriod(BudgetPeriodContract budgetPeriod, int termIndex) {
        Integer parentId = 0;
        switch (budgetPeriod.getBudgetPeriod()) {
            case 1: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD1[termIndex];
                break;
            }
            case 2: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD2[termIndex];
                break;
            }
            case 3: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD3[termIndex];
                break;
            }
            case 4: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD4[termIndex];
                break;
            }
            case 5: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD5[termIndex];
            }
        }
        return parentId;
    }

    private Integer[] getPreDocParentQuestionsForPeriod(BudgetPeriodContract budgetPeriod) {
        Integer[] parentIds = new Integer[]{};
        switch (budgetPeriod.getBudgetPeriod()) {
            case 1: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD1;
                break;
            }
            case 2: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD2;
                break;
            }
            case 3: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD3;
                break;
            }
            case 4: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD4;
                break;
            }
            case 5: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD5;
            }
        }
        return parentIds;
    }

    private boolean isPreDocParentQuestionFromPeriodExists(QuestionnaireQuestionContract questionnaireQuestion, BudgetPeriodContract budgetPeriod) {
        return Arrays.asList(this.getPreDocParentQuestionsForPeriod(budgetPeriod)).contains(questionnaireQuestion.getParentQuestionNumber());
    }

    private BigDecimal getStipendAmount(BudgetPeriodContract budgetPeriod, String careerLevel, int experienceLevel, int numPeople) {
        BigDecimal stipendCost = ScaleTwoDecimal.ZERO.bigDecimalValue();
        TrainingStipendRateContract trainingStipendRate = this.trainingStipendRateService.findClosestMatchTrainingStipendRate(budgetPeriod.getStartDate(), careerLevel, experienceLevel);
        if (trainingStipendRate != null) {
            stipendCost = trainingStipendRate.getStipendRate().bigDecimalValue().multiply(new ScaleTwoDecimal(numPeople).bigDecimalValue());
        }
        return stipendCost;
    }

    public S2SBudgetIndirectCostsService getS2sBudgetIndirectCostsService() {
        return this.s2sBudgetIndirectCostsService;
    }

    public void setS2sBudgetIndirectCostsService(S2SBudgetIndirectCostsService s2sBudgetIndirectCostsService) {
        this.s2sBudgetIndirectCostsService = s2sBudgetIndirectCostsService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    public TrainingStipendRateService getTrainingStipendRateService() {
        return this.trainingStipendRateService;
    }

    public void setTrainingStipendRateService(TrainingStipendRateService trainingStipendRateService) {
        this.trainingStipendRateService = trainingStipendRateService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHS398TrainingBudget20Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType budgetJustification = form.getPHS398TrainingBudget20().getBudgetJustification();
            if (budgetJustification != null && a.getContentId().equals(budgetJustification.getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS398_TrainingBudget_2_0_P1.mandatoryFile", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHS398TrainingBudget20Document> factory() {
        return PHS398TrainingBudget20Document.Factory;
    }
}

