/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398TrainingBudgetV10.PHS398TrainingBudgetDocument;
import gov.grants.apply.forms.phs398TrainingSubawardBudget20V20.PHS398TrainingSubawardBudget20Document;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="PHS398TrainingSubAwardBudgetV2_0Generator")
public class PHS398TrainingSubAwardBudgetV2_0Generator
extends S2SAdobeFormAttachmentBaseGenerator<PHS398TrainingSubawardBudget20Document>
implements S2SFormGeneratorPdfFillable<PHS398TrainingSubawardBudget20Document> {
    private static final String PHS398_TRAINING_BUDGET_20_NAMESPACE_URI = "http://apply.grants.gov/forms/PHS398_TrainingBudget-V1.0";
    @Value(value="http://apply.grants.gov/forms/PHS398_TrainingSubawardBudget_2_0-V2.0")
    private String namespace;
    @Value(value="PHS398_TrainingSubawardBudget_2_0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_TrainingSubawardBudget-V2.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_TrainingSubawardBudget_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="162")
    private int sortIndex;

    private PHS398TrainingSubawardBudget20Document getPHS398TrainingSubawardBudget() throws S2SException {
        PHS398TrainingSubawardBudget20Document phs398TrainingSubawardBudget20Document = (PHS398TrainingSubawardBudget20Document)PHS398TrainingSubawardBudget20Document.Factory.newInstance();
        PHS398TrainingSubawardBudget20Document.PHS398TrainingSubawardBudget20 phs398TrainingSubawardBudget20 = (PHS398TrainingSubawardBudget20Document.PHS398TrainingSubawardBudget20)PHS398TrainingSubawardBudget20Document.PHS398TrainingSubawardBudget20.Factory.newInstance();
        PHS398TrainingSubawardBudget20Document.PHS398TrainingSubawardBudget20.BudgetAttachments budgetAttachments = (PHS398TrainingSubawardBudget20Document.PHS398TrainingSubawardBudget20.BudgetAttachments)PHS398TrainingSubawardBudget20Document.PHS398TrainingSubawardBudget20.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, PHS398_TRAINING_BUDGET_20_NAMESPACE_URI, true);
        PHS398TrainingBudgetDocument.PHS398TrainingBudget[] budgetList = new PHS398TrainingBudgetDocument.PHS398TrainingBudget[budgetSubAwardsList.size()];
        phs398TrainingSubawardBudget20.setFormVersion(FormVersion.v2_0.getVersion());
        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            switch (attCount) {
                case 1: {
                    phs398TrainingSubawardBudget20.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList[0] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 2: {
                    phs398TrainingSubawardBudget20.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList[1] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 3: {
                    phs398TrainingSubawardBudget20.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList[2] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 4: {
                    phs398TrainingSubawardBudget20.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList[3] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 5: {
                    phs398TrainingSubawardBudget20.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList[4] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 6: {
                    phs398TrainingSubawardBudget20.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList[5] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 7: {
                    phs398TrainingSubawardBudget20.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList[6] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 8: {
                    phs398TrainingSubawardBudget20.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList[7] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 9: {
                    phs398TrainingSubawardBudget20.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList[8] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 10: {
                    phs398TrainingSubawardBudget20.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList[9] = this.getPHS398TrainingBudget(budgetSubAwards);
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attCount;
        }
        budgetAttachments.setPHS398TrainingBudgetArray(budgetList);
        phs398TrainingSubawardBudget20.setBudgetAttachments(budgetAttachments);
        phs398TrainingSubawardBudget20Document.setPHS398TrainingSubawardBudget20(phs398TrainingSubawardBudget20);
        return phs398TrainingSubawardBudget20Document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PHS398TrainingBudgetDocument.PHS398TrainingBudget getPHS398TrainingBudget(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        Document subAwdFormsDoc;
        PHS398TrainingBudgetDocument.PHS398TrainingBudget rrBudget = (PHS398TrainingBudgetDocument.PHS398TrainingBudget)PHS398TrainingBudgetDocument.PHS398TrainingBudget.Factory.newInstance();
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        try {
            subAwdFormsDoc = this.stringToDom(subAwdXML);
        }
        catch (S2SException e1) {
            return rrBudget;
        }
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(PHS398_TRAINING_BUDGET_20_NAMESPACE_URI, "PHS398_TrainingBudget");
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        byte[] subAwdNodeBytes = null;
        InputStream bgtIS = null;
        try {
            subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
            bgtIS = new ByteArrayInputStream(subAwdNodeBytes);
            PHS398TrainingBudgetDocument rrBudgetDocument = (PHS398TrainingBudgetDocument)PHS398TrainingBudgetDocument.Factory.parse(bgtIS);
            rrBudget = rrBudgetDocument.getPHS398TrainingBudget();
        }
        catch (IOException | XmlException | S2SException e) {
            PHS398TrainingBudgetDocument.PHS398TrainingBudget pHS398TrainingBudget = rrBudget;
            return pHS398TrainingBudget;
        }
        finally {
            if (bgtIS != null) {
                try {
                    bgtIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rrBudget;
    }

    @Override
    public PHS398TrainingSubawardBudget20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398TrainingSubawardBudget();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHS398TrainingSubawardBudget20Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<PHS398TrainingSubawardBudget20Document> factory() {
        return PHS398TrainingSubawardBudget20Document.Factory;
    }
}

