/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.support.CommonSF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.person.S2sDivisionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class RRSF424BaseGenerator<T extends XmlObject>
extends CommonSF424BaseGenerator<T> {
    private static final Logger LOG = LogManager.getLogger(RRSF424BaseGenerator.class);
    protected static final String PRINCIPAL_INVESTIGATOR = "PI";
    protected static final int PRE_APPLICATION = 6;
    protected static final int ADDITIONAL_CONGRESSIONAL_DESTRICT = 59;
    private static final String CONTACT_TYPE_O = "O";
    protected static final String CONTACT_TYPE_I = "I";
    protected static final String STATE_REVIEW_YES = "Y";
    protected static final String STATE_REVIEW_NO = "N";
    protected static final String VALUE_YES = "Yes";
    protected static final int PRIMARY_TITLE_MAX_LENGTH = 45;
    protected static final int DIRECTORY_TITLE_MAX_LENGTH = 45;
    protected static final int DEPARTMENT_NAME_MAX_LENGTH = 30;
    protected static final int ANSWER_EXPLANATION_MAX_LENGTH = 20;
    protected static final int SFLLL_OTHEREXPLANATORY = 86;
    protected static final Integer ANSWER_128 = 128;
    protected static final Integer ANSWER_111 = 111;
    protected static final String NOT_ANSWERED = "No";
    private static final String SUBMISSION_TYPE_CODE = "submissionTypeCode";
    private static final String SUBMISSION_TYPE_DESCRIPTION = "submissionTypeDescription";
    protected static final String KEY_REVISION_CODE = "revisionCode";
    protected static final String KEY_REVISION_OTHER_DESCRIPTION = "revisionOtherDescription";
    private static final int FEDERAL_ID_MAX_LENGTH = 30;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    protected S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;
    @Autowired
    @Qualifier(value="s2sDivisionService")
    protected S2sDivisionService s2sDivisionService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    protected S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="modularBudgetService")
    protected ModularBudgetService modularBudgetService;

    protected String getOtherAgencySubmissionExplanation() {
        Long answerId = this.getAnswerId(ANSWER_111, this.getAnswerHeaders());
        String submissionExplanation = null;
        if (this.getQuestionAnswerService().isAnswerDescriptionRetrievalSupported(answerId)) {
            submissionExplanation = this.getQuestionAnswerService().getAnswerDescription(answerId);
            submissionExplanation = submissionExplanation != null ? submissionExplanation.substring(5) : null;
        } else {
            LOG.warn("answer description retrieval not supported for answer id: " + answerId);
        }
        if (submissionExplanation == null) {
            submissionExplanation = "Unknown";
        }
        if (submissionExplanation.length() > 20) {
            return submissionExplanation.substring(0, 20);
        }
        return submissionExplanation;
    }

    protected String getContactType() {
        String contactType = this.s2SConfigurationService.getValueAsString("PROPOSAL_CONTACT_TYPE");
        if (contactType == null || contactType.length() == 0) {
            contactType = CONTACT_TYPE_O;
        }
        return contactType;
    }

    protected String getFederalId() {
        String federalId = this.pdDoc.getDevelopmentProposal().getSponsorProposalNumber();
        return federalId != null ? StringUtils.left((String)federalId.trim(), (int)30) : null;
    }

    protected DepartmentalPersonDto getContactPerson(ProposalDevelopmentDocumentContract pdDoc) {
        return this.departmentalPersonService.getContactPerson(pdDoc);
    }

    protected Map<String, String> getSubmissionType(ProposalDevelopmentDocumentContract pdDoc) {
        HashMap<String, String> submissionInfo = new HashMap<String, String>();
        S2sOpportunityContract opportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (opportunity != null) {
            if (opportunity.getS2sSubmissionType() != null) {
                String submissionTypeCode = opportunity.getS2sSubmissionType().getCode();
                String submissionTypeDescription = opportunity.getS2sSubmissionType().getDescription();
                submissionInfo.put(SUBMISSION_TYPE_CODE, submissionTypeCode);
                submissionInfo.put(SUBMISSION_TYPE_DESCRIPTION, submissionTypeDescription);
            }
            if (opportunity.getS2sRevisionType() != null) {
                String revisionCode = opportunity.getS2sRevisionType().getCode();
                submissionInfo.put(KEY_REVISION_CODE, revisionCode);
            }
            if (opportunity.getRevisionOtherDescription() != null) {
                submissionInfo.put(KEY_REVISION_OTHER_DESCRIPTION, opportunity.getRevisionOtherDescription());
            }
        }
        return submissionInfo;
    }

    protected String getDepartmentName(KcPersonContract kcPerson) {
        return this.getDepartmentName(kcPerson.getUnit());
    }

    protected String getDepartmentName(UnitContract unit) {
        return unit != null ? StringUtils.substring((String)unit.getUnitName(), (int)0, (int)30) : "";
    }

    protected String getDepartmentName(DepartmentalPersonDto departmentalPerson) {
        return departmentalPerson != null ? StringUtils.substring((String)departmentalPerson.getDirDept(), (int)0, (int)30) : "";
    }

    protected abstract List<? extends AnswerHeaderContract> getAnswerHeaders();

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public DepartmentalPersonService getDepartmentalPersonService() {
        return this.departmentalPersonService;
    }

    public void setDepartmentalPersonService(DepartmentalPersonService departmentalPersonService) {
        this.departmentalPersonService = departmentalPersonService;
    }

    public S2sDivisionService getS2sDivisionService() {
        return this.s2sDivisionService;
    }

    public void setS2sDivisionService(S2sDivisionService s2sDivisionService) {
        this.s2sDivisionService = s2sDivisionService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }
}

