/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.XfaForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormAttContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormFileContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.s2sgen.impl.generate.DynamicForm;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.Named;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.KcFile;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="UserAttachedFormGenerator")
public class UserAttachedFormGenerator
implements S2SFormGenerator<XmlObject>,
S2SFormGeneratorPdfFillable<XmlObject>,
DynamicForm,
BeanNameAware,
Named {
    public static final String META_GRANT_APPLICATION_NS = "http://apply.grants.gov/system/MetaGrantApplication";
    public static final String FORMS = "Forms";
    private String beanName;
    private List<AuditError> auditErrors = new ArrayList<AuditError>();
    private List<AttachmentData> attachments = new ArrayList<AttachmentData>();
    private S2sUserAttachedFormContract s2sUserAttachedForm;
    private Optional<S2SFormGenerator<?>> supportedS2SFormGenerator;
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService grantApplicationHashService;

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        XmlObject xmlObject;
        S2sUserAttachedFormFileContract userAttachedFormFile = (S2sUserAttachedFormFileContract)this.getS2sUserAttachedForm().getS2sUserAttachedFormFileList().get(0);
        if (userAttachedFormFile == null) {
            throw new RuntimeException("Cannot find XML Data");
        }
        String formXml = userAttachedFormFile.getXmlFile();
        try {
            xmlObject = (XmlObject)XmlObject.Factory.parse(formXml);
        }
        catch (XmlException e) {
            throw new RuntimeException("XmlObject not ready");
        }
        this.s2sUserAttachedForm.getS2sUserAttachedFormAtts().forEach(this::addAttachment);
        return xmlObject;
    }

    protected void addAttachment(AttachmentData attachment) {
        this.attachments.add(attachment);
    }

    private void addAttachment(S2sUserAttachedFormAttContract s2sUserAttachedFormAtt) {
        String hash = this.getGrantApplicationHashService().computeAttachmentHash(s2sUserAttachedFormAtt.getData());
        this.addAttachment(new AttachmentData(s2sUserAttachedFormAtt.getFileDataId(), s2sUserAttachedFormAtt.getContentId(), s2sUserAttachedFormAtt.getContentId(), s2sUserAttachedFormAtt.getData(), s2sUserAttachedFormAtt.getType(), "SHA-1", hash, s2sUserAttachedFormAtt.getUploadUser(), s2sUserAttachedFormAtt.getUploadTimestamp()));
    }

    @Override
    public List<AuditError> getAuditErrors() {
        return this.auditErrors;
    }

    public void setAuditErrors(List<AuditError> auditErrors) {
        this.auditErrors = auditErrors;
    }

    @Override
    public List<AttachmentData> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<AttachmentData> attachments) {
        this.attachments = attachments;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }

    @Override
    public String getNamespace() {
        return this.getS2sUserAttachedForm().getNamespace();
    }

    @Override
    public String getFormName() {
        return this.getS2sUserAttachedForm().getFormName();
    }

    @Override
    public int getSortIndex() {
        return this.supportedS2SFormGenerator.map(S2SFormGenerator::getSortIndex).orElse(Integer.MAX_VALUE);
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.supportedS2SFormGenerator.map(S2SFormGenerator::getStylesheets).orElse(Collections.emptyList());
    }

    @Override
    public boolean supportsPdfFilling() {
        return true;
    }

    @Override
    public boolean supportsXslTransform() {
        return this.supportedS2SFormGenerator.map(S2SFormGenerator::supportsXslTransform).orElse(false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Resource getPdfForm() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearXfaFormData(PdfReader reader) {
        Node firstForm;
        NodeList formsNode;
        Document xfaDocument;
        XfaForm xfaForm = reader.getAcroFields().getXfa();
        if (xfaForm.isXfaPresent() && (xfaDocument = xfaForm.getDomDocument()) != null && (formsNode = xfaDocument.getElementsByTagNameNS(META_GRANT_APPLICATION_NS, FORMS)) != null && (firstForm = formsNode.item(0)) != null) {
            xfaForm.setNodeText(firstForm, "");
        }
    }

    private void clearAttachments(PdfReader reader) {
        PdfDictionary embFiles;
        List atts;
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)catalog.get(PdfName.NAMES));
        if (names != null && (atts = this.getS2sUserAttachedForm().getS2sUserAttachedFormAtts()) != null && !atts.isEmpty() && (embFiles = (PdfDictionary)PdfReader.getPdfObject((PdfObject)names.get(PdfName.EMBEDDEDFILES))) != null) {
            this.removeMatchingAttachments(atts, embFiles);
        }
    }

    private void removeMatchingAttachments(List<? extends S2sUserAttachedFormAttContract> atts, PdfDictionary embFiles) {
        PdfArray efNames = embFiles.getAsArray(PdfName.NAMES);
        ListIterator iterator = efNames.listIterator();
        while (iterator.hasNext()) {
            PdfObject key = (PdfObject)iterator.next();
            if (!iterator.hasNext()) continue;
            PdfDictionary file = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)iterator.next()));
            String fileName = this.getFilename(file);
            if (!atts.stream().map(KcFile::getName).anyMatch(name -> name.equals(fileName))) continue;
            iterator.remove();
            iterator.previous();
            iterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(XmlObject form, List<AttachmentData> attachments) {
        try (PdfReader reader = new PdfReader(this.getS2sUserAttachedFormFile().getFormFile());){
            PdfDictionary catalog = reader.getCatalog();
            PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)catalog.get(PdfName.NAMES));
            if (names == null) return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
            PdfDictionary embFiles = (PdfDictionary)PdfReader.getPdfObject((PdfObject)names.get(PdfName.EMBEDDEDFILES));
            if (embFiles != null) {
                Map<String, PdfObject> embMap = UserAttachedFormGenerator.readTree(embFiles);
                Map embeddedFiles = embMap.entrySet().stream().map(o -> CollectionUtils.entry((String)o.getKey(), (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)o.getValue())))).filter(e -> Objects.nonNull(e.getValue())).map(e -> CollectionUtils.entry(this.getFilename((PdfDictionary)e.getValue()), (String)e.getKey())).filter(e -> Objects.nonNull(e.getValue())).collect(CollectionUtils.nullSafeEntriesToMap());
                Map<Boolean, List<Map.Entry>> attachmentPartition = this.getS2sUserAttachedForm().getS2sUserAttachedFormAtts().stream().map(a -> {
                    String hash = this.getGrantApplicationHashService().computeAttachmentHash(a.getData());
                    return new AttachmentData(a.getFileDataId(), a.getName(), a.getContentId(), a.getData(), a.getType(), "SHA-1", hash, a.getUploadUser(), a.getUploadTimestamp());
                }).map(a -> CollectionUtils.entry((String)embeddedFiles.get(a.getFileName()), a)).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
                S2SFormGeneratorPdfFillable.Attachments attachments2 = new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
                return attachments2;
            }
            S2SFormGeneratorPdfFillable.Attachments attachments3 = new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
            return attachments3;
        }
        catch (IOException e2) {
            throw new RuntimeException("Cannot read PDF");
        }
    }

    private String getFilename(PdfDictionary filespec) {
        PdfString fn = (PdfString)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.F));
        if (fn == null) {
            return null;
        }
        return fn.toUnicodeString();
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public DocumentFactory<XmlObject> factory() {
        return XmlObject.Factory;
    }

    @Override
    public S2sUserAttachedFormContract getS2sUserAttachedForm() {
        return this.s2sUserAttachedForm;
    }

    @Override
    public void setS2sUserAttachedForm(S2sUserAttachedFormContract s2sUserAttachedForm) {
        this.s2sUserAttachedForm = s2sUserAttachedForm;
    }

    public S2sUserAttachedFormFileContract getS2sUserAttachedFormFile() {
        return (S2sUserAttachedFormFileContract)this.getS2sUserAttachedForm().getS2sUserAttachedFormFileList().get(0);
    }

    @Override
    public Optional<S2SFormGenerator<?>> getSupportedS2SFormGenerator() {
        return this.supportedS2SFormGenerator;
    }

    @Override
    public void setSupportedS2SFormGenerator(Optional<S2SFormGenerator<?>> supportedS2SFormGenerator) {
        this.supportedS2SFormGenerator = supportedS2SFormGenerator;
    }

    private static void iterateItems(PdfDictionary dic, Map<String, PdfObject> items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease((PdfObject)dic.get(PdfName.NAMES));
                if (nn == null) break block2;
                for (int k = 0; k < nn.size(); ++k) {
                    PdfString s = (PdfString)PdfReader.getPdfObjectRelease((PdfObject)nn.getPdfObject(k++));
                    items.put(s.toUnicodeString(), nn.getPdfObject(k));
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease((PdfObject)dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            for (int k = 0; k < nn.size(); ++k) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)nn.getPdfObject(k));
                UserAttachedFormGenerator.iterateItems(kid, items);
            }
        }
    }

    private static Map<String, PdfObject> readTree(PdfDictionary dic) {
        HashMap<String, PdfObject> items = new HashMap<String, PdfObject>();
        if (dic != null) {
            UserAttachedFormGenerator.iterateItems(dic, items);
        }
        return items;
    }
}

