/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, U, M extends Map<K, U>> Collector<Map.Entry<K, U>, ?, M> entriesToMap(Supplier<M> mapSupplier) {
        if (mapSupplier == null) {
            throw new IllegalArgumentException("mapSupplier cannot be null");
        }
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, mapSupplier);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> entriesToMapWithReplacing() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, HashMap::new);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> nullSafeEntriesToMap() {
        return CollectionUtils.nullSafeToMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> nullSafeToMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            HashMap result = new HashMap();
            for (Object item : list) {
                Object key = keyMapper.apply((Object)item);
                if (result.putIfAbsent(key, valueMapper.apply((Object)item)) == null) continue;
                throw new IllegalStateException(String.format("Duplicate key %s", key));
            }
            return result;
        });
    }
}

