/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.category.CategoryDefinition;
import org.kuali.rice.krms.api.repository.category.CategoryDefinitionContract;
import org.kuali.rice.krms.api.repository.function.FunctionDefinitionContract;
import org.kuali.rice.krms.api.repository.function.FunctionParameterDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionParameterDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="function")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="FunctionType", propOrder={"id", "namespace", "name", "description", "returnType", "typeId", "active", "versionNumber", "parameters", "categories", "_futureElements"})
public class FunctionDefinition
extends AbstractDataTransferObject
implements FunctionDefinitionContract {
    private static final long serialVersionUID = 1391030685309770560L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="namespace", required=true)
    private final String namespace;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="returnType", required=true)
    private final String returnType;
    @XmlElement(name="typeId", required=true)
    private final String typeId;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElementWrapper(name="parameters", required=false)
    @XmlElement(name="parameter", required=false)
    private final List<FunctionParameterDefinition> parameters;
    @XmlElementWrapper(name="categories", required=false)
    @XmlElement(name="category", required=false)
    private final List<CategoryDefinition> categories;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private FunctionDefinition() {
        this.id = null;
        this.namespace = null;
        this.name = null;
        this.description = null;
        this.returnType = null;
        this.typeId = null;
        this.active = true;
        this.versionNumber = null;
        this.parameters = null;
        this.categories = null;
    }

    private FunctionDefinition(Builder builder) {
        this.id = builder.getId();
        this.namespace = builder.getNamespace();
        this.name = builder.getName();
        this.description = builder.getDescription();
        this.returnType = builder.getReturnType();
        this.typeId = builder.getTypeId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.parameters = new ArrayList<FunctionParameterDefinition>();
        for (FunctionParameterDefinition.Builder parameter : builder.getParameters()) {
            this.parameters.add(parameter.build());
        }
        this.categories = new ArrayList<CategoryDefinition>();
        for (CategoryDefinition.Builder category : builder.getCategories()) {
            this.categories.add(category.build());
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public List<FunctionParameterDefinition> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public List<CategoryDefinition> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public static final class Builder
    implements FunctionDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -4470376239998290245L;
        private String id;
        private String namespace;
        private String name;
        private String description;
        private String returnType;
        private String typeId;
        private boolean active;
        private Long versionNumber;
        private List<FunctionParameterDefinition.Builder> parameters;
        private List<CategoryDefinition.Builder> categories;

        private Builder(String namespace, String name, String returnType, String typeId) {
            this.setNamespace(namespace);
            this.setName(name);
            this.setReturnType(returnType);
            this.setTypeId(typeId);
            this.setActive(true);
            this.setParameters(new ArrayList<FunctionParameterDefinition.Builder>());
            this.setCategories(new ArrayList<CategoryDefinition.Builder>());
        }

        public static Builder create(String namespace, String name, String returnType, String typeId) {
            return new Builder(namespace, name, returnType, typeId);
        }

        public static Builder create(FunctionDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getNamespace(), contract.getName(), contract.getReturnType(), contract.getTypeId());
            builder.setId(contract.getId());
            builder.setDescription(contract.getDescription());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            for (FunctionParameterDefinitionContract functionParameterDefinitionContract : contract.getParameters()) {
                builder.getParameters().add(FunctionParameterDefinition.Builder.create(functionParameterDefinitionContract));
            }
            for (CategoryDefinitionContract categoryDefinitionContract : contract.getCategories()) {
                builder.getCategories().add(CategoryDefinition.Builder.create(categoryDefinitionContract));
            }
            return builder;
        }

        public FunctionDefinition build() {
            return new FunctionDefinition(this);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace was blank");
            }
            this.namespace = namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was blank");
            }
            this.name = name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String returnType) {
            if (StringUtils.isBlank((String)returnType)) {
                throw new IllegalArgumentException("returnType was blank");
            }
            this.returnType = returnType;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        public void setTypeId(String typeId) {
            if (StringUtils.isBlank((String)typeId)) {
                throw new IllegalArgumentException("typeId was blank");
            }
            this.typeId = typeId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public List<FunctionParameterDefinition.Builder> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<FunctionParameterDefinition.Builder> parameters) {
            if (parameters == null) {
                throw new IllegalArgumentException("parameters was null");
            }
            this.parameters = parameters;
        }

        public List<CategoryDefinition.Builder> getCategories() {
            return this.categories;
        }

        public void setCategories(List<CategoryDefinition.Builder> categories) {
            if (categories == null) {
                throw new IllegalArgumentException("categories was null");
            }
            this.categories = categories;
        }
    }

    static class Elements {
        static final String ID = "id";
        static final String NAMESPACE = "namespace";
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String RETURN_TYPE = "returnType";
        static final String TYPE_ID = "typeId";
        static final String ACTIVE = "active";
        static final String PARAMETERS = "parameters";
        static final String PARAMETER = "parameter";
        static final String CATEGORIES = "categories";
        static final String CATEGORY = "category";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "function";
        static final String TYPE_NAME = "FunctionType";

        Constants() {
        }
    }
}

