/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.suggest.phrase.SmoothingModel;
import org.elasticsearch.search.suggest.phrase.StupidBackoffScorer;
import org.elasticsearch.search.suggest.phrase.WordScorer;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class StupidBackoff
extends SmoothingModel {
    public static final double DEFAULT_BACKOFF_DISCOUNT = 0.4;
    public static final String NAME = "stupid_backoff";
    private static final ParseField DISCOUNT_FIELD = new ParseField("discount", new String[0]);
    static final ParseField PARSE_FIELD = new ParseField("stupid_backoff", new String[0]);
    private double discount = 0.4;

    public StupidBackoff(double discount) {
        this.discount = discount;
    }

    public StupidBackoff(StreamInput in) throws IOException {
        this.discount = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.discount);
    }

    public double getDiscount() {
        return this.discount;
    }

    @Override
    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(DISCOUNT_FIELD.getPreferredName(), this.discount);
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(SmoothingModel other) {
        StupidBackoff otherModel = (StupidBackoff)other;
        return Objects.equals(this.discount, otherModel.discount);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.discount);
    }

    public static SmoothingModel fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        double discount = 0.4;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            }
            if (!token.isValue() || !DISCOUNT_FIELD.match(fieldName, parser.getDeprecationHandler())) continue;
            discount = parser.doubleValue();
        }
        return new StupidBackoff(discount);
    }

    @Override
    public WordScorer.WordScorerFactory buildWordScorerFactory() {
        return (reader, terms, field, realWordLikelihood, separator) -> new StupidBackoffScorer(reader, terms, field, realWordLikelihood, separator, this.discount);
    }
}

