/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.questionnaire;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireQuestion;
import org.kuali.coeus.propdev.api.questionnaire.PropDevQuestionAnswerService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="propDevQuestionAnswerService")
public class PropDevQuestionAnswerServiceImpl
implements PropDevQuestionAnswerService {
    @Autowired
    @Qualifier(value="proposalDevelopmentS2sQuestionnaireService")
    private ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;

    public List<? extends AnswerContract> getQuestionnaireAnswers(String proposalNumber, String namespace, String formName) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        if (StringUtils.isBlank((CharSequence)formName)) {
            throw new IllegalArgumentException("formName is blank");
        }
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.dataObjectService.find(DevelopmentProposal.class, (Object)proposalNumber);
        if (developmentProposal != null) {
            List<AnswerHeader> answerHeaders = this.getProposalDevelopmentS2sQuestionnaireService().getProposalAnswerHeaderForForm(developmentProposal, namespace, formName);
            ArrayList<Answer> questionnaireAnswers = new ArrayList<Answer>();
            for (AnswerHeader answerHeader : answerHeaders) {
                Questionnaire questionnaire = answerHeader.getQuestionnaire();
                List<QuestionnaireQuestion> questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
                for (QuestionnaireQuestion questionnaireQuestion : questionnaireQuestions) {
                    Answer questionAnswer = this.getAnswer(questionnaireQuestion, answerHeader);
                    if (questionAnswer == null) continue;
                    questionnaireAnswers.add(questionAnswer);
                }
            }
            return ListUtils.emptyIfNull(questionnaireAnswers);
        }
        return Collections.emptyList();
    }

    public List<? extends AnswerHeaderContract> getQuestionnaireAnswerHeaders(String proposalNumber, String namespace, String formName) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        if (StringUtils.isBlank((CharSequence)formName)) {
            throw new IllegalArgumentException("formName is blank");
        }
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.dataObjectService.find(DevelopmentProposal.class, (Object)proposalNumber);
        return ListUtils.emptyIfNull(this.proposalDevelopmentS2sQuestionnaireService.getProposalAnswerHeaderForForm(developmentProposal, namespace, formName));
    }

    public List<? extends AnswerHeaderContract> getQuestionnaireAnswerHeaders(String proposalNumber) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.dataObjectService.find(DevelopmentProposal.class, (Object)proposalNumber);
        ProposalDevelopmentModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(developmentProposal);
        return ListUtils.emptyIfNull(this.questionnaireAnswerService.getQuestionnaireAnswer(moduleQuestionnaireBean));
    }

    protected Answer getAnswer(QuestionnaireQuestion questionnaireQuestion, AnswerHeader answerHeader) {
        List<Answer> answers = answerHeader.getAnswers();
        for (Answer answer : answers) {
            if (!answer.getQuestionnaireQuestionsId().equals(questionnaireQuestion.getId())) continue;
            return answer;
        }
        return null;
    }

    public ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        return this.proposalDevelopmentS2sQuestionnaireService;
    }

    public void setProposalDevelopmentS2sQuestionnaireService(ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService) {
        this.proposalDevelopmentS2sQuestionnaireService = proposalDevelopmentS2sQuestionnaireService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }
}

