/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.framework.util.ReflectionUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.component.Ordered;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.RecycleUtils;
import org.springframework.core.OrderComparator;

public class ComponentUtils {
    private static final Logger LOG = LogManager.getLogger(ComponentUtils.class);

    private ComponentUtils() {
    }

    public static <T extends Component> T copy(T component) {
        return ComponentUtils.copy(component, null);
    }

    public static <T extends Component> T copy(T component, String idSuffix) {
        if (component == null) {
            return null;
        }
        Component copy = (Component)CopyUtils.copy(component);
        if (StringUtils.isNotBlank((String)idSuffix)) {
            ComponentUtils.updateIdsWithSuffixNested(copy, idSuffix);
        }
        return (T)copy;
    }

    public static <T extends Component> List<T> copy(List<T> components) {
        if (components != null) {
            ArrayList<Component> componentsCopy = new ArrayList<Component>();
            for (Component component : components) {
                Component copiedComponent = ComponentUtils.copy(component);
                componentsCopy.add(copiedComponent);
            }
            return componentsCopy;
        }
        return new ArrayList();
    }

    public static <T extends org.kuali.rice.krad.uif.field.Field> void bindAndIdFieldList(List<T> fields, String addBindingPrefix, String idSuffix) {
        ComponentUtils.updateIdsWithSuffixNested(fields, idSuffix);
        ComponentUtils.prefixBindingPath(fields, addBindingPrefix);
    }

    public static <T extends Component> T copyComponent(T component, String addBindingPrefix, String idSuffix) {
        T copy = ComponentUtils.copy(component, idSuffix);
        ComponentUtils.prefixBindingPathNested(copy, addBindingPrefix);
        return copy;
    }

    public static <T extends Component> List<T> copyComponentList(List<T> components, String idSuffix) {
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> copiedComponentList = new ArrayList<Component>(components.size());
        for (Component field : components) {
            Component copiedComponent = ComponentUtils.copy(field, idSuffix);
            copiedComponentList.add(copiedComponent);
        }
        return copiedComponentList;
    }

    public static <T> List<T> getComponentsOfType(List<? extends Component> items, Class<T> componentType) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        List typeComponents = Collections.emptyList();
        for (Component component : items) {
            if (!componentType.isInstance(component)) continue;
            if (typeComponents.isEmpty()) {
                typeComponents = new ArrayList(items.size());
            }
            typeComponents.add(componentType.cast(component));
        }
        return typeComponents;
    }

    public static <T extends Component> List<T> getNestedContainerComponents(Container container, Class<T> componentType) {
        ArrayList<Object> typeComponents = new ArrayList<Object>();
        if (container == null) {
            return typeComponents;
        }
        for (Component component : container.getItems()) {
            if (component == null) continue;
            if (component instanceof Container) {
                typeComponents.addAll(ComponentUtils.getNestedContainerComponents((Container)component, componentType));
                continue;
            }
            if (component instanceof FieldGroup) {
                typeComponents.addAll(ComponentUtils.getNestedContainerComponents(((FieldGroup)component).getGroup(), componentType));
                continue;
            }
            if (!componentType.isAssignableFrom(component.getClass())) continue;
            typeComponents.add((Component)componentType.cast(component));
        }
        return typeComponents;
    }

    public static <T extends Component> List<T> getNestedNonCollectionComponents(List<Component> items, Class<T> componentType) {
        ArrayList<Object> typeComponents = new ArrayList<Object>();
        if (items == null) {
            return typeComponents;
        }
        for (Component item : items) {
            if (item == null) continue;
            if (item instanceof Container && !(item instanceof CollectionGroup)) {
                typeComponents.addAll(ComponentUtils.getNestedNonCollectionComponents((Container)item, componentType));
                continue;
            }
            if (item instanceof FieldGroup) {
                typeComponents.addAll(ComponentUtils.getNestedNonCollectionComponents(((FieldGroup)item).getGroup(), componentType));
                continue;
            }
            if (!componentType.isAssignableFrom(item.getClass())) continue;
            typeComponents.add((Component)componentType.cast(item));
        }
        return typeComponents;
    }

    public static <T extends Component> List<T> getNestedNonCollectionComponents(Container container, Class<T> componentType) {
        ArrayList<Object> typeComponents = new ArrayList<Object>();
        if (container == null) {
            return typeComponents;
        }
        for (Component component : container.getItems()) {
            if (component == null) continue;
            if (component instanceof Container && !(component instanceof CollectionGroup)) {
                typeComponents.addAll(ComponentUtils.getNestedNonCollectionComponents((Container)component, componentType));
                continue;
            }
            if (component instanceof FieldGroup) {
                typeComponents.addAll(ComponentUtils.getNestedNonCollectionComponents(((FieldGroup)component).getGroup(), componentType));
                continue;
            }
            if (!componentType.isAssignableFrom(component.getClass())) continue;
            typeComponents.add((Component)componentType.cast(component));
        }
        return typeComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Component> getAllNestedComponents(Component component) {
        if (component == null) {
            return Collections.emptyList();
        }
        List<Component> components = Collections.emptyList();
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        elementQueue.offer(component);
        try {
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (currentElement instanceof Component && currentElement != component) {
                    if (components.isEmpty()) {
                        components = new ArrayList<Component>();
                    }
                    components.add((Component)currentElement);
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
        return components;
    }

    public static Component findComponentInList(List<Component> components, String componentId) {
        for (Component component : components) {
            if (component == null || !StringUtils.equals((String)component.getId(), (String)componentId)) continue;
            return component;
        }
        return null;
    }

    public static void prefixBindingPath(List<? extends Component> components, String addBindingPrefix) {
        for (Component component : components) {
            ComponentUtils.prefixBindingPath(component, addBindingPrefix);
        }
    }

    public static void prefixBindingPath(Component component, String addBindingPrefix) {
        if (component instanceof DataBinding) {
            ComponentUtils.prefixBindingPath((DataBinding)component, addBindingPrefix);
        } else if (component instanceof FieldGroup && ((FieldGroup)component).getItems() != null) {
            List<? extends Component> fieldGroupItems = ((FieldGroup)component).getItems();
            ComponentUtils.prefixBindingPath(fieldGroupItems, addBindingPrefix);
        } else if (component instanceof Group && ((Group)component).getItems() != null && !(component instanceof CollectionGroup)) {
            List<? extends Component> groupItems = ((Group)component).getItems();
            ComponentUtils.prefixBindingPath(groupItems, addBindingPrefix);
        }
    }

    public static void prefixBindingPath(DataBinding field, String addBindingPrefix) {
        Object bindingPrefix = addBindingPrefix;
        if (StringUtils.isNotBlank((String)field.getBindingInfo().getBindByNamePrefix())) {
            bindingPrefix = (String)bindingPrefix + "." + field.getBindingInfo().getBindByNamePrefix();
        }
        field.getBindingInfo().setBindByNamePrefix((String)bindingPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prefixBindingPathNested(Component component, String addBindingPrefix) {
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        elementQueue.offer(component);
        try {
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (currentElement instanceof DataBinding) {
                    if (LOG.isDebugEnabled()) {
                        LOG.info("setting nested binding prefix '" + addBindingPrefix + "' on " + String.valueOf(currentElement));
                    }
                    ComponentUtils.prefixBindingPath((DataBinding)currentElement, addBindingPrefix);
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    public static void updateIdsWithSuffixNested(List<? extends Component> components, String idSuffix) {
        for (Component component : components) {
            ComponentUtils.updateIdsWithSuffixNested(component, idSuffix);
        }
    }

    public static void updateIdsWithSuffixNested(Component component, String idSuffix) {
        ComponentUtils.updateIdWithSuffix(component, idSuffix);
        ComponentUtils.updateChildIdsWithSuffixNested(component, idSuffix);
    }

    public static void updateIdWithSuffix(LifecycleElement element, String idSuffix) {
        LayoutManager manager;
        if (StringUtils.isBlank((String)idSuffix)) {
            return;
        }
        if (element != null) {
            element.setId(element.getId() + idSuffix);
        }
        if (element instanceof Container && (manager = ((Container)element).getLayoutManager()) != null) {
            manager.setId(manager.getId() + idSuffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChildIdsWithSuffixNested(Component component, String idSuffix) {
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        try {
            elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(component).values());
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (currentElement instanceof Component) {
                    ComponentUtils.updateIdWithSuffix((Component)currentElement, idSuffix);
                    elementQueue.addAll(((Component)currentElement).getPropertyReplacerComponents());
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    public static int generateId(LifecycleElement element, int seed) {
        if (element == null) {
            return seed;
        }
        int prime = 6971;
        int hash = 6971 * seed + element.getClass().getName().hashCode();
        String id = element.getId();
        hash *= 6971;
        if (id != null) {
            hash += id.hashCode();
        }
        do {
            id = Long.toString((long)(hash *= 4507) - Integer.MIN_VALUE, 36);
        } while (!ViewLifecycle.getView().getViewIndex().observeAssignedId(id));
        element.setId("u" + id);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAndAssignIds(List<? extends Component> components) {
        if (components == null || components.isEmpty()) {
            return;
        }
        int hash = 1;
        Queue toClear = RecycleUtils.getInstance(LinkedList.class);
        toClear.addAll(components);
        try {
            while (!toClear.isEmpty()) {
                List<Component> propertyReplacerComponents;
                LifecycleElement element = (LifecycleElement)toClear.poll();
                hash = ComponentUtils.generateId(element, hash);
                for (LifecycleElement nested : ViewLifecycleUtils.getElementsForLifecycle(element).values()) {
                    if (nested == null) continue;
                    toClear.add(nested);
                }
                if (!(element instanceof Component) || (propertyReplacerComponents = ((Component)element).getPropertyReplacerComponents()) == null) continue;
                for (Component nested : propertyReplacerComponents) {
                    if (nested == null) continue;
                    toClear.add(nested);
                }
            }
        }
        finally {
            toClear.clear();
            RecycleUtils.recycle(toClear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Component> void setComponentsPropertyDeep(List<T> components, String propertyPath, Object propertyValue) {
        if (components == null || components.isEmpty()) {
            return;
        }
        HashSet skipTypes = null;
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        elementQueue.addAll(components);
        try {
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
                Class<?> componentClass = currentElement.getClass();
                if (skipTypes != null && skipTypes.contains(componentClass)) continue;
                if (!ObjectPropertyUtils.isWritableProperty(currentElement, propertyPath)) {
                    if (skipTypes == null) {
                        skipTypes = new HashSet();
                    }
                    skipTypes.add(componentClass);
                    continue;
                }
                ObjectPropertyUtils.setPropertyValue(currentElement, propertyPath, propertyValue, true);
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    public static void setComponentPropertyDeep(Component component, String propertyPath, Object propertyValue) {
        ComponentUtils.setComponentsPropertyDeep(Collections.singletonList(component), propertyPath, propertyValue);
    }

    public static void setComponentPropertyFinal(Component component, String propertyName, Object propertyValue) {
        if (component == null) {
            return;
        }
        ObjectPropertyUtils.setPropertyValue(component, propertyName, propertyValue);
        if (component.getPropertyExpressions() != null && component.getPropertyExpressions().containsKey(propertyName)) {
            component.getPropertyExpressions().remove(propertyName);
        }
    }

    public static boolean canBeRefreshed(Component component) {
        boolean hasRefreshCondition = StringUtils.isNotBlank((String)component.getProgressiveRender()) || StringUtils.isNotBlank((String)component.getConditionalRefresh()) || component.getRefreshTimer() > 0 || component.getRefreshWhenChangedPropertyNames() != null && !component.getRefreshWhenChangedPropertyNames().isEmpty();
        boolean isInlineEditField = component instanceof InputField && (((InputField)component).isInlineEdit() || ((InputField)component).isAjaxInlineEdit());
        return hasRefreshCondition || component.isRefreshedByAction() || component.isDisclosedByAction() || component.isRetrieveViaAjax() || isInlineEditField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushObjectToContext(Collection<? extends LifecycleElement> elements, String contextName, Object contextValue) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        LinkedList<? extends LifecycleElement> elementQueue = new LinkedList<LifecycleElement>();
        try {
            elementQueue.addAll(elements);
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (currentElement instanceof Component) {
                    ((Component)currentElement).pushObjectToContext(contextName, contextValue);
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    public static void pushObjectToContext(Component component, String contextName, Object contextValue) {
        if (component == null) {
            return;
        }
        ComponentUtils.pushObjectToContext(Collections.singletonList(component), contextName, contextValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushAllToContext(List<? extends Component> components, Map<String, Object> sourceContext) {
        if (components == null || components.isEmpty()) {
            return;
        }
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        try {
            elementQueue.addAll(components);
            while (!elementQueue.isEmpty()) {
                LifecycleElement currentElement = (LifecycleElement)elementQueue.poll();
                if (currentElement == null) continue;
                if (currentElement instanceof Component) {
                    ((Component)currentElement).pushAllToContext(sourceContext);
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(currentElement).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    public static void pushAllToContext(Component component, Map<String, Object> sourceContext) {
        if (component == null) {
            return;
        }
        ComponentUtils.pushAllToContext(Collections.singletonList(component), sourceContext);
    }

    public static void updateContextsForLine(List<? extends Component> components, CollectionGroup collectionGroup, Object collectionLine, int lineIndex, String lineSuffix) {
        for (Component component : components) {
            ComponentUtils.updateContextForLine(component, collectionGroup, collectionLine, lineIndex, lineSuffix);
        }
    }

    public static void updateContextForLine(Component component, CollectionGroup collectionGroup, Object collectionLine, int lineIndex, String lineSuffix) {
        if (StringUtils.isNotBlank((String)collectionGroup.getContainerIdSuffix())) {
            lineSuffix = (String)lineSuffix + collectionGroup.getContainerIdSuffix();
        }
        HashMap<String, Object> toUpdate = new HashMap<String, Object>(5);
        toUpdate.put("collectionGroup", collectionGroup);
        toUpdate.put("line", collectionLine);
        toUpdate.put("index", lineIndex);
        toUpdate.put("lineSuffix", lineSuffix);
        boolean isAddLine = lineIndex == -1;
        toUpdate.put("isAddLine", isAddLine);
        ComponentUtils.pushAllToContext(component, toUpdate);
    }

    public static void cleanContextDeap(LifecycleElement lifecycleElement) {
        if (lifecycleElement == null) {
            return;
        }
        lifecycleElement.setContext(null);
        Class<?> elementClass = lifecycleElement.getClass();
        List fields = ReflectionUtils.getAllFields(elementClass);
        for (Field field : fields) {
            Object elements;
            if (Collection.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.makeAccessible((Field)field);
                elements = (Collection)ReflectionUtils.getField((Field)field, (Object)lifecycleElement);
                if (elements == null) continue;
                Iterator<Object> iterator = elements.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e == null || !LifecycleElement.class.isAssignableFrom(e.getClass())) continue;
                    ComponentUtils.cleanContextDeap((LifecycleElement)e);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.makeAccessible((Field)field);
                elements = (Map)ReflectionUtils.getField((Field)field, (Object)lifecycleElement);
                if (elements == null) continue;
                for (Object object : elements.entrySet()) {
                    if (object == null || !LifecycleElement.class.isAssignableFrom(object.getClass())) continue;
                    ComponentUtils.cleanContextDeap((LifecycleElement)object);
                }
                continue;
            }
            if (!LifecycleElement.class.isAssignableFrom(field.getType())) continue;
            ReflectionUtils.makeAccessible((Field)field);
            LifecycleElement nestedElement = (LifecycleElement)ReflectionUtils.getField((Field)field, (Object)lifecycleElement);
            ComponentUtils.cleanContextDeap(nestedElement);
        }
    }

    public static <T extends Ordered> List<T> sort(List<T> items, int defaultOrderSequence) {
        int order;
        Ordered component;
        int i;
        if (items == null) {
            return null;
        }
        ArrayList<Ordered> orderedItems = new ArrayList<Ordered>(items.size());
        HashSet<Integer> foundOrders = new HashSet<Integer>();
        for (i = items.size() - 1; i >= 0; --i) {
            component = (Ordered)items.get(i);
            order = component.getOrder();
            if (order == 0) {
                orderedItems.add(component);
                continue;
            }
            if (foundOrders.contains(order)) continue;
            orderedItems.add(component);
            foundOrders.add(order);
        }
        for (i = 0; i < items.size(); ++i) {
            component = (Ordered)items.get(i);
            order = component.getOrder();
            if (order != 0) continue;
            ++defaultOrderSequence;
            while (foundOrders.contains(defaultOrderSequence)) {
                ++defaultOrderSequence;
            }
            component.setOrder(defaultOrderSequence);
        }
        Collections.sort(orderedItems, new OrderComparator());
        return orderedItems;
    }

    public static List<InputField> getAllInputFieldsWithinContainer(Container container) {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (LifecycleElement c : ViewLifecycleUtils.getElementsForLifecycle(container).values()) {
            if (c instanceof InputField) {
                inputFields.add((InputField)c);
                continue;
            }
            if (c instanceof Container) {
                inputFields.addAll(ComponentUtils.getAllInputFieldsWithinContainer((Container)c));
                continue;
            }
            if (!(c instanceof FieldGroup)) continue;
            Group cb = ((FieldGroup)c).getGroup();
            inputFields.addAll(ComponentUtils.getAllInputFieldsWithinContainer(cb));
        }
        return inputFields;
    }

    public static boolean containsPropertyExpression(Component component, String propertyName, boolean collectionMatch) {
        boolean hasExpression = false;
        Map<String, String> propertyExpressions = component.getPropertyExpressions();
        if (collectionMatch) {
            for (String expressionPropertyName : propertyExpressions.keySet()) {
                if (!expressionPropertyName.startsWith(propertyName)) continue;
                hasExpression = true;
            }
        } else if (propertyExpressions.containsKey(propertyName)) {
            hasExpression = true;
        }
        return hasExpression;
    }

    public static void adjustNestedLevelsForTableCollections(Container container, int currentLevel) {
        if (container != null && container instanceof CollectionGroup && container.getLayoutManager() != null && container.getLayoutManager() instanceof TableLayoutManager && ((TableLayoutManager)container.getLayoutManager()).getRichTable() != null && ((TableLayoutManager)container.getLayoutManager()).getRichTable().isRender() && ((TableLayoutManager)container.getLayoutManager()).getRichTable().isForceLocalJsonData()) {
            ((TableLayoutManager)container.getLayoutManager()).getRichTable().setNestedLevel(currentLevel);
            ++currentLevel;
        }
        if (container != null) {
            List<Container> subContainers = ViewLifecycleUtils.getNestedElementsOfTypeShallow(container, Container.class);
            for (Container subContainer : subContainers) {
                ComponentUtils.adjustNestedLevelsForTableCollections(subContainer, currentLevel);
            }
            List<FieldGroup> subFieldGroups = ViewLifecycleUtils.getNestedElementsOfTypeShallow(container, FieldGroup.class);
            for (FieldGroup fieldGroup : subFieldGroups) {
                if (fieldGroup == null) continue;
                ComponentUtils.adjustNestedLevelsForTableCollections(fieldGroup.getGroup(), currentLevel);
            }
        }
    }
}

