/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.doctype.ProcessDefinition;
import org.kuali.rice.kew.api.doctype.RoutePath;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DataObjectAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class DocumentAuthorizerBase
extends DataObjectAuthorizerBase
implements DocumentAuthorizer {
    private static final long serialVersionUID = -5354518767379472681L;
    private DocumentRequestAuthorizationCache documentRequestAuthorizationCache;
    public static final String PRE_ROUTING_ROUTE_NAME = "PreRoute";

    @Override
    public final boolean canInitiate(String documentTypeName, Person user) {
        String nameSpaceCode = "KR-SYS";
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", documentTypeName);
        return DocumentAuthorizerBase.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), nameSpaceCode, "Initiate Document", permissionDetails, Collections.emptyMap());
    }

    @Override
    public boolean canOpen(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-NS", "Open Document", user.getPrincipalId());
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-NS", "Edit Document", user.getPrincipalId());
    }

    @Override
    public boolean canAnnotate(Document document, Person user) {
        return this.canAddNoteAttachment(document, null, user);
    }

    @Override
    public boolean canReload(Document document, Person user) {
        return true;
    }

    @Override
    public boolean canClose(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Save Document", user.getPrincipalId());
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Route Document", user.getPrincipalId());
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        boolean isCompletionRequested = document.getDocumentHeader().getWorkflowDocument().isCompletionRequested();
        return isCompletionRequested || this.isAuthorizedByTemplate(document, "KR-WKFLW", "Cancel Document", user.getPrincipalId());
    }

    @Override
    public boolean canRecall(Document document, Person user) {
        return this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo().isValidAction(ActionType.RECALL);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-NS", "Copy Document", user.getPrincipalId());
    }

    @Override
    public boolean canPerformRouteReport(Document document, Person user) {
        return true;
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Blanket Approve Document", user.getPrincipalId());
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return this.canTakeRequestedAction(document, "A", user);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return this.canApprove(document, user);
    }

    @Override
    public boolean canSendNoteFyi(Document document, Person user) {
        return this.canSendAdHocRequests(document, "F", user);
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return this.canTakeRequestedAction(document, "F", user);
    }

    @Override
    public boolean canAcknowledge(Document document, Person user) {
        return this.canTakeRequestedAction(document, "K", user);
    }

    @Override
    public boolean canReceiveAdHoc(Document document, Person user, String actionRequestCode) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("actionRequestCd", actionRequestCode);
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Ad Hoc Review Document", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    @Override
    public boolean canAddNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "Add Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    @Override
    public boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        boolean canDeleteNoteAttachment = false;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        additionalPermissionDetails.put("createdBySelf", "false");
        canDeleteNoteAttachment = this.isAuthorizedByTemplate(document, "KR-NS", "Delete Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, null);
        if (!canDeleteNoteAttachment) {
            additionalPermissionDetails.put("createdBySelf", "true");
            canDeleteNoteAttachment = this.isAuthorizedByTemplate(document, "KR-NS", "Delete Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, null);
            if (canDeleteNoteAttachment && !authorUniversalIdentifier.equals(user.getPrincipalId())) {
                canDeleteNoteAttachment = false;
            }
        }
        return canDeleteNoteAttachment;
    }

    @Override
    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "View Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    @Override
    @Deprecated
    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        return this.canViewNoteAttachment(document, attachmentTypeCode, user);
    }

    @Override
    public boolean canSendAdHocRequests(Document document, String actionRequestCd, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (actionRequestCd != null) {
            additionalPermissionDetails.put("actionRequestCd", actionRequestCd);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "Send Ad Hoc Request", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    @Override
    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-NS", "Edit Document", user.getPrincipalId()) && this.isDocumentInitiator(document, user);
    }

    @Override
    public boolean canSendAnyTypeAdHocRequests(Document document, Person user) {
        if (this.canSendAdHocRequests(document, "F", user)) {
            RoutePath routePath = KewApiServiceLocator.getDocumentTypeService().getRoutePathForDocumentTypeName(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            ProcessDefinition processDefinition = routePath.getPrimaryProcess();
            if (processDefinition != null) {
                return processDefinition.getInitialRouteNode() != null;
            }
            return false;
        }
        if (this.canSendAdHocRequests(document, "K", user)) {
            return true;
        }
        return this.canSendAdHocRequests(document, "A", user);
    }

    @Override
    public boolean canTakeRequestedAction(Document document, String actionRequestCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("actionRequestCd", actionRequestCode);
        return this.isAuthorizedByTemplate(document, "KR-NS", "Take Requested Action", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    @Override
    public boolean canSuperUserTakeAction(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveSingleActionRequest(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    @Override
    public boolean canSuperUserApprove(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveDocument(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    @Override
    public boolean canSuperUserDisapprove(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserDisapproveDocument(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    @Override
    protected void addPermissionDetails(Object dataObject, Map<String, String> attributes) {
        super.addPermissionDetails(dataObject, attributes);
        if (dataObject instanceof Document) {
            this.addStandardAttributes((Document)dataObject, attributes);
        }
    }

    @Override
    protected void addRoleQualification(Object dataObject, Map<String, String> attributes) {
        super.addRoleQualification(dataObject, attributes);
        if (dataObject instanceof Document) {
            this.addStandardAttributes((Document)dataObject, attributes);
        }
    }

    protected void addStandardAttributes(Document document, Map<String, String> attributes) {
        WorkflowDocument wd = document.getDocumentHeader().getWorkflowDocument();
        attributes.put("documentNumber", document.getDocumentNumber());
        attributes.put("documentTypeName", wd.getDocumentTypeName());
        if (wd.isInitiated() || wd.isSaved()) {
            attributes.put("routeNodeName", PRE_ROUTING_ROUTE_NAME);
        } else {
            attributes.put("routeNodeName", KRADServiceLocatorWeb.getWorkflowDocumentService().getCurrentRouteNodeNames(wd));
        }
        attributes.put("routeStatusCode", wd.getStatus().getCode());
    }

    protected boolean isDocumentInitiator(Document document, Person user) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return workflowDocument.getInitiatorPrincipalId().equalsIgnoreCase(user.getPrincipalId());
    }

    protected DocumentRequestAuthorizationCache getDocumentRequestAuthorizationCache(Document document) {
        if (this.documentRequestAuthorizationCache == null) {
            this.documentRequestAuthorizationCache = new DocumentRequestAuthorizationCache();
        }
        if (this.documentRequestAuthorizationCache.getWorkflowDocumentInfo() == null) {
            this.documentRequestAuthorizationCache.createWorkflowDocumentInfo(document.getDocumentHeader().getWorkflowDocument());
        }
        return this.documentRequestAuthorizationCache;
    }

    @Override
    public void setDocumentRequestAuthorizationCache(DocumentRequestAuthorizationCache documentRequestAuthorizationCache) {
        this.documentRequestAuthorizationCache = documentRequestAuthorizationCache;
    }
}

