/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.container.ActiveCollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.CollectionGroupBuilder;
import org.kuali.rice.krad.uif.container.CollectionGroupSecurity;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.QuickFinder;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTags(value={@BeanTag(name="collectionGroup", parent="Uif-CollectionGroupBase"), @BeanTag(name="stacked", parent="Uif-StackedCollectionGroup"), @BeanTag(name="stackedSection", parent="Uif-StackedCollectionSection"), @BeanTag(name="stackedSubSection", parent="Uif-StackedCollectionSubSection"), @BeanTag(name="stackedSubCollection-withinSection", parent="Uif-StackedSubCollection-WithinSection"), @BeanTag(name="stackedSubCollection-withinSubSection", parent="Uif-StackedSubCollection-WithinSubSection"), @BeanTag(name="disclosureStackedSection", parent="Uif-Disclosure-StackedCollectionSection"), @BeanTag(name="disclosureStackedSubSection", parent="Uif-Disclosure-StackedCollectionSubSection"), @BeanTag(name="disclosureStackedSubCollection-withinSection", parent="Uif-Disclosure-StackedSubCollection-WithinSection"), @BeanTag(name="disclosureStackedSubCollection-withinSubSection", parent="Uif-Disclosure-StackedSubCollection-WithinSubSection"), @BeanTag(name="table", parent="Uif-TableCollectionGroup"), @BeanTag(name="tableSection", parent="Uif-TableCollectionSection"), @BeanTag(name="tableSubSection", parent="Uif-TableCollectionSubSection"), @BeanTag(name="tableSubCollection-withinSection", parent="Uif-TableSubCollection-WithinSection"), @BeanTag(name="tableSubCollection-withinSubSection", parent="Uif-TableSubCollection-WithinSubSection"), @BeanTag(name="disclosureTableSection", parent="Uif-Disclosure-TableCollectionSection"), @BeanTag(name="disclosureTableSubSection", parent="Uif-Disclosure-TableCollectionSubSection"), @BeanTag(name="disclosureTableSubCollection-withinSection", parent="Uif-Disclosure-TableSubCollection-WithinSection"), @BeanTag(name="disclosureTableSubCollection-withinSubSection", parent="Uif-Disclosure-TableSubCollection-WithinSubSection"), @BeanTag(name="listCollection", parent="Uif-ListCollectionGroup"), @BeanTag(name="listCollectionSection", parent="Uif-ListCollectionSection"), @BeanTag(name="listCollectionSubSection", parent="Uif-ListCollectionSubSection"), @BeanTag(name="maintenanceStackedSection", parent="Uif-MaintenanceStackedCollectionSection"), @BeanTag(name="maintenanceStackedSubCollection-withinSection", parent="Uif-MaintenanceStackedSubCollection-WithinSection"), @BeanTag(name="maintenanceTableSection", parent="Uif-MaintenanceTableCollectionSection"), @BeanTag(name="maintenanceTableSubCollection-withinSection", parent="Uif-MaintenanceTableSubCollection-WithinSection")})
public class CollectionGroupBase
extends GroupBase
implements CollectionGroup {
    private static final long serialVersionUID = -6496712566071542452L;
    private Class<?> collectionObjectClass;
    private String propertyName;
    private BindingInfo bindingInfo;
    private boolean renderAddLine = true;
    private String addLinePropertyName;
    private BindingInfo addLineBindingInfo;
    private Message addLineLabel;
    private List<? extends Component> addLineItems;
    private List<? extends Component> addLineActions;
    @KeepExpression
    private String addLineEnterKeyAction;
    @KeepExpression
    private String lineEnterKeyAction;
    private boolean renderLineActions = true;
    private List<? extends Component> lineActions;
    private boolean includeLineSelectionField;
    private String lineSelectPropertyName;
    private QuickFinder collectionLookup;
    private boolean renderInactiveToggleButton = true;
    @ClientSideState(variableName="inactive")
    private boolean showInactiveLines;
    private CollectionFilter activeCollectionFilter;
    private List<CollectionFilter> filters = Collections.emptyList();
    private List<String> duplicateLinePropertyNames = Collections.emptyList();
    private List<BindingInfo> unauthorizedLineBindingInfos;
    @DelayedCopy
    private List<CollectionGroup> subCollections;
    private CollectionGroupBuilder collectionGroupBuilder;
    private int displayCollectionSize = -1;
    private boolean highlightNewItems = true;
    private boolean highlightAddItem = true;
    private String newItemsCssClass;
    private String addItemCssClass;
    private boolean renderAddBlankLineButton;
    private Action addBlankLineAction;
    private String addLinePlacement = "TOP";
    private boolean renderSaveLineActions;
    private boolean editWithDialog;
    private boolean customEditLineDialog;
    private DialogGroup editLineDialogPrototype;
    private Action editWithDialogActionPrototype;
    private Action editInDialogSaveActionPrototype;
    private List<DialogGroup> lineDialogs;
    private boolean addWithDialog;
    private Action addWithDialogAction;
    private DialogGroup addLineDialog;
    private boolean useServerPaging = false;
    private int pageSize;
    private int displayStart = -1;
    private int displayLength = -1;
    private int filteredCollectionSize = -1;
    private int totalCollectionSize = -1;
    private List<String> totalColumns;

    public CollectionGroupBase() {
        this.lineActions = Collections.emptyList();
        this.addLineItems = Collections.emptyList();
        this.addLineActions = Collections.emptyList();
        this.subCollections = Collections.emptyList();
        this.lineDialogs = Collections.emptyList();
    }

    @Override
    public void performInitialization(Object model) {
        View view = ViewLifecycle.getView();
        this.setFieldBindingObjectPath(this.getBindingInfo().getBindingObjectPath());
        super.performInitialization(model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
        if (this.addLineBindingInfo != null && StringUtils.isNotBlank((String)this.addLinePropertyName)) {
            this.addLineBindingInfo.setDefaults(view, this.getPropertyName());
            this.addLineBindingInfo.setBindingName(this.addLinePropertyName);
            if (StringUtils.isNotBlank((String)this.getFieldBindByNamePrefix())) {
                this.addLineBindingInfo.setBindByNamePrefix(this.getFieldBindByNamePrefix());
            }
        }
        if (this.addLineItems == null || this.addLineItems.isEmpty()) {
            this.addLineItems = this.getItems();
        }
        if (this.addWithDialog) {
            if (this.addLineDialog == null) {
                this.addLineDialog = (DialogGroup)ComponentFactory.getNewComponentInstance("Uif-AddLineDialog");
            }
            ((CollectionLayoutManager)this.getLayoutManager()).setAddLineGroup(this.addLineDialog);
            if (!this.addLineDialog.getItems().isEmpty()) {
                this.addLineItems = this.addLineDialog.getItems();
            }
        }
        if (this.editWithDialog) {
            if (this.editLineDialogPrototype == null) {
                this.editLineDialogPrototype = (DialogGroup)ComponentUtils.copy(ComponentFactory.getNewComponentInstance("Uif-EditLineDialog"));
            } else if (this.editLineDialogPrototype.getItems() != null && !this.editLineDialogPrototype.getItems().isEmpty()) {
                this.customEditLineDialog = true;
            }
            if (this.editWithDialogActionPrototype == null) {
                this.editWithDialogActionPrototype = (Action)ComponentUtils.copy(ComponentFactory.getNewComponentInstance("Uif-EditLineInDialogAction"));
            }
            if (this.editInDialogSaveActionPrototype == null) {
                this.editInDialogSaveActionPrototype = ComponentUtils.copy((Action)ComponentFactory.getNewComponentInstance("Uif-EditLineInDialogSaveAction"));
            }
        }
        if (this.activeCollectionFilter == null) {
            this.activeCollectionFilter = new ActiveCollectionFilter();
        }
        Object collectionPath = "";
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getCollectionPath())) {
            collectionPath = (String)collectionPath + this.getBindingInfo().getCollectionPath() + ".";
        }
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getBindByNamePrefix()) && StringUtils.isNotBlank((String)this.getBindingInfo().getCollectionPath()) && this.getBindingInfo().getBindByNamePrefix().startsWith(this.getBindingInfo().getCollectionPath())) {
            collectionPath = this.getBindingInfo().getBindByNamePrefix() + ".";
        } else if (StringUtils.isNotBlank((String)this.getBindingInfo().getBindByNamePrefix())) {
            collectionPath = (String)collectionPath + this.getBindingInfo().getBindByNamePrefix() + ".";
        }
        collectionPath = (String)collectionPath + this.getBindingInfo().getBindingName();
        List<DataField> collectionFields = ComponentUtils.getNestedNonCollectionComponents(this.getItems(), DataField.class);
        List<DataField> addLineCollectionFields = ComponentUtils.getNestedNonCollectionComponents(this.addLineItems, DataField.class);
        if (addLineCollectionFields != null) {
            collectionFields.addAll(addLineCollectionFields);
        }
        for (DataField collectionField : collectionFields) {
            collectionField.getBindingInfo().setCollectionPath((String)collectionPath);
            if (!StringUtils.isBlank((String)collectionField.getDictionaryObjectEntry())) continue;
            collectionField.setDictionaryObjectEntry(this.collectionObjectClass.getName());
        }
        for (CollectionGroup collectionGroup : this.getSubCollections()) {
            collectionGroup.getBindingInfo().setCollectionPath((String)collectionPath);
        }
        if (!view.getObjectPathToConcreteClassMapping().containsKey(collectionPath)) {
            view.getObjectPathToConcreteClassMapping().put((String)collectionPath, this.getCollectionObjectClass());
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        ViewModel viewModel = (ViewModel)model;
        View view = ViewLifecycle.getView();
        if (this.isUseServerPaging()) {
            Iterator<Object> displayLength;
            Object displayStart = ViewLifecycle.getViewPostMetadata().getComponentPostData(this.getId(), "displayStart");
            if (displayStart != null) {
                this.setDisplayStart((Integer)displayStart);
            }
            if ((displayLength = ViewLifecycle.getViewPostMetadata().getComponentPostData(this.getId(), "displayLength")) != null) {
                this.setDisplayLength((Integer)((Object)displayLength));
            }
        }
        if (viewModel.isCollectionPagingRequest() && StringUtils.equals((String)viewModel.getUpdateComponentId(), (String)this.getId())) {
            ((CollectionLayoutManager)this.getLayoutManager()).processPagingRequest(model, this);
        }
        if (StringUtils.isNotBlank((String)this.getId()) && viewModel.getViewPostMetadata() != null && viewModel.getViewPostMetadata().getAddedCollectionObjects().get(this.getId()) != null) {
            List<Object> newLines = viewModel.getViewPostMetadata().getAddedCollectionObjects().get(this.getId());
            if (newLines.isEmpty()) {
                this.initializeNewCollectionLine(view, model, this, true);
            }
            for (Object newLine : newLines) {
                ViewLifecycle.getHelper().applyDefaultValuesForCollectionLine(this, newLine);
            }
        }
        if (this.renderAddBlankLineButton) {
            if (this.addBlankLineAction == null) {
                this.addBlankLineAction = (Action)ComponentFactory.getNewComponentInstance("Uif-AddBlankLineAction");
            }
            if (this.addLinePlacement.equals(UifConstants.Position.BOTTOM.name())) {
                this.addBlankLineAction.setOnClickScript("writeCurrentPageToSession(this, 'last');");
            } else {
                this.addBlankLineAction.setOnClickScript("writeCurrentPageToSession(this, 'first');");
            }
        } else if (this.addWithDialog) {
            this.setupAddLineDialog();
        }
        this.pushCollectionGroupToReference();
        ArrayList<Component> allComponents = new ArrayList<Component>(this.getItems());
        allComponents.addAll(this.getAddLineItems());
        ArrayList<Component> allActionComponents = new ArrayList<Component>(this.getLineActions());
        allActionComponents.addAll(this.getAddLineActions());
        this.setupLineActionValidationScripts(allComponents, allActionComponents);
        if (this.isRender()) {
            this.getCollectionGroupBuilder().build(view, model, this);
        }
    }

    protected void setupLineActionValidationScripts(List<Component> components, List<Component> actionComponents) {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (Component component : components) {
            if (!(component instanceof InputField)) continue;
            inputFields.add((InputField)component);
        }
        String script = this.buildInputFieldValidationActionScript(inputFields, null);
        for (Component actionComponent : actionComponents) {
            if (!(actionComponent instanceof Action)) continue;
            Action action = (Action)actionComponent;
            String onClickScript = action.getOnClickScript();
            if (StringUtils.isNotEmpty((String)onClickScript)) {
                script = ScriptUtils.appendScript(script, onClickScript);
            }
            action.setOnClickScript(script);
        }
    }

    protected void setupAddLineDialog() {
        if (this.addWithDialogAction == null) {
            this.addWithDialogAction = (Action)ComponentFactory.getNewComponentInstance("Uif-AddWithDialogAction");
        }
        String sessionPage = "first";
        if (this.addLinePlacement.equals(UifConstants.Position.BOTTOM.name())) {
            sessionPage = "last";
        }
        Object dialogId = this.addLineDialog.getId();
        if (StringUtils.isNotBlank((String)this.getContainerIdSuffix())) {
            dialogId = (String)dialogId + this.getContainerIdSuffix();
        }
        String additionalData = "{ 'actionParameters[selectedCollectionPath]' : '" + this.propertyName + "', 'actionParameters[selectedLineIndex]' : '0', 'actionParameters[dialogId]' : '" + (String)dialogId + "' }";
        Object actionScript = "writeCurrentPageToSession(this, '" + sessionPage + "');";
        actionScript = ScriptUtils.appendScript(this.addWithDialogAction.getActionScript(), (String)actionScript);
        String showDialogScript = "showDialog('" + (String)dialogId + "', " + additionalData + ");";
        actionScript = ScriptUtils.appendScript((String)actionScript, showDialogScript);
        this.addWithDialogAction.setActionScript((String)actionScript);
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        this.addCollectionPostMetadata();
        if (this.addWithDialog && this.addLineDialog != null && this.addLineDialog.getFooter() != null) {
            ArrayList<String> fieldsToSend = new ArrayList<String>();
            fieldsToSend.add("#" + this.addLineDialog.getId());
            for (Component component : this.addLineDialog.getFooter().getItems()) {
                if (!(component instanceof Action)) continue;
                ((Action)component).setFieldsToSend(fieldsToSend);
            }
        }
    }

    protected void addCollectionPostMetadata() {
        boolean hasBindingPath;
        if (this.getCollectionLookup() != null) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "collectionLookup.fieldConversions", this.getCollectionLookup().getFieldConversions());
        }
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "collectionObjectClass", this.getCollectionObjectClass());
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "bindingInfo", (Object)this.getBindingInfo());
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "addLineBindingInfo", (Object)this.getAddLineBindingInfo());
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "addLinePlacement", (Object)this.getAddLinePlacement());
        if (this.getHeader() != null) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "collectionLabel", (Object)this.getCollectionLabel());
        }
        if (this.getDuplicateLinePropertyNames() != null) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "duplicateLinePropertyNames", this.getDuplicateLinePropertyNames());
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "duplicateLineLabelString", (Object)this.getDuplicateLineLabelString(this.getDuplicateLinePropertyNames()));
        }
        boolean bl = hasBindingPath = this.getBindingInfo() != null && this.getBindingInfo().getBindingPath() != null;
        if (hasBindingPath) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "bindingPath", (Object)this.getBindingInfo().getBindingPath());
        }
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "displayStart", (Object)this.getDisplayStart());
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "displayLength", (Object)this.getDisplayLength());
    }

    @Override
    public void pushCollectionGroupToReference() {
        Collection<LifecycleElement> components = ViewLifecycleUtils.getElementsForLifecycle(this).values();
        ContextUtils.pushObjectToContextDeep(components, "collectionGroup", (Object)this);
        List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(components, Action.class);
        for (Action action : actions) {
            action.addActionParameter("selectedCollectionPath", this.getBindingInfo().getBindingPath());
            action.addActionParameter("selectedCollectionId", this.getId());
        }
    }

    protected String getCollectionLabel() {
        String collectionLabel = this.getHeaderText();
        if (StringUtils.isBlank((String)collectionLabel)) {
            String propertyName = this.getPropertyName();
            collectionLabel = KRADServiceLocatorWeb.getUifDefaultingService().deriveHumanFriendlyNameFromPropertyName(propertyName);
        }
        return collectionLabel;
    }

    protected String getDuplicateLineLabelString(List<String> duplicateLinePropertyNames) {
        ArrayList<String> duplicateLineLabels = new ArrayList<String>();
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (Component component : this.getAddLineItems()) {
            if (component instanceof DataField) {
                fields.add((DataField)component);
                continue;
            }
            if (!(component instanceof FieldGroup)) continue;
            Group group = ((FieldGroup)component).getGroup();
            List<DataField> nestedAddLineItems = ViewLifecycleUtils.getElementsOfTypeDeep(group, DataField.class);
            fields.addAll(nestedAddLineItems);
        }
        for (DataField dataField : fields) {
            if (!duplicateLinePropertyNames.contains(dataField.getPropertyName())) continue;
            String label = dataField.getLabel();
            String shortLabel = dataField.getShortLabel();
            duplicateLineLabels.add(StringUtils.isNotBlank((String)label) ? label : shortLabel);
        }
        return StringUtils.join(duplicateLineLabels, (String)", ");
    }

    @Override
    public void initializeNewCollectionLine(View view, Object model, CollectionGroup collectionGroup, boolean clearExistingLine) {
        this.getCollectionGroupBuilder().initializeNewCollectionLine(view, model, collectionGroup, clearExistingLine);
    }

    @Override
    public boolean isProcessRemoteFieldHolders() {
        return false;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getItems() {
        return super.getItems();
    }

    @Override
    @BeanTagAttribute
    public Class<?> getCollectionObjectClass() {
        return this.collectionObjectClass;
    }

    @Override
    public void setCollectionObjectClass(Class<?> collectionObjectClass) {
        this.collectionObjectClass = collectionObjectClass;
    }

    @Override
    @BeanTagAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    @BeanTagAttribute
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getLineActions() {
        return this.lineActions;
    }

    @Override
    public void setLineActions(List<? extends Component> lineActions) {
        this.lineActions = lineActions;
    }

    @Override
    @BeanTagAttribute
    public String getAddLineEnterKeyAction() {
        return this.addLineEnterKeyAction;
    }

    @Override
    public void setAddLineEnterKeyAction(String addLineEnterKeyAction) {
        this.addLineEnterKeyAction = addLineEnterKeyAction;
    }

    @Override
    @BeanTagAttribute
    public String getLineEnterKeyAction() {
        return this.lineEnterKeyAction;
    }

    @Override
    public void setLineEnterKeyAction(String lineEnterKeyAction) {
        this.lineEnterKeyAction = lineEnterKeyAction;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderLineActions() {
        return this.renderLineActions;
    }

    @Override
    public void setRenderLineActions(boolean renderLineActions) {
        this.renderLineActions = renderLineActions;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderAddLine() {
        if (this.useServerPaging && this.renderAddLine) {
            return this.displayStart == 0;
        }
        return this.renderAddLine;
    }

    @Override
    public void setRenderAddLine(boolean renderAddLine) {
        this.renderAddLine = renderAddLine;
    }

    @Override
    @BeanTagAttribute
    public String getAddLabel() {
        if (this.getAddLineLabel() != null) {
            return this.getAddLineLabel().getMessageText();
        }
        return null;
    }

    @Override
    public void setAddLabel(String addLabelText) {
        if (this.getAddLineLabel() != null) {
            this.getAddLineLabel().setMessageText(addLabelText);
        }
    }

    @Override
    @BeanTagAttribute
    public Message getAddLineLabel() {
        return this.addLineLabel;
    }

    @Override
    public void setAddLineLabel(Message addLineLabel) {
        this.addLineLabel = addLineLabel;
    }

    @Override
    @BeanTagAttribute
    public String getAddLinePropertyName() {
        return this.addLinePropertyName;
    }

    @Override
    public void setAddLinePropertyName(String addLinePropertyName) {
        this.addLinePropertyName = addLinePropertyName;
    }

    @Override
    @BeanTagAttribute
    public BindingInfo getAddLineBindingInfo() {
        return this.addLineBindingInfo;
    }

    @Override
    public void setAddLineBindingInfo(BindingInfo addLineBindingInfo) {
        this.addLineBindingInfo = addLineBindingInfo;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getAddLineItems() {
        return this.addLineItems;
    }

    @Override
    public void setAddLineItems(List<? extends Component> addLineItems) {
        this.addLineItems = addLineItems;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getAddLineActions() {
        return this.addLineActions;
    }

    @Override
    public void setAddLineActions(List<? extends Component> addLineActions) {
        this.addLineActions = addLineActions;
    }

    @Override
    @BeanTagAttribute
    public boolean isIncludeLineSelectionField() {
        return this.includeLineSelectionField;
    }

    @Override
    public void setIncludeLineSelectionField(boolean includeLineSelectionField) {
        this.includeLineSelectionField = includeLineSelectionField;
    }

    @Override
    @BeanTagAttribute
    public String getLineSelectPropertyName() {
        return this.lineSelectPropertyName;
    }

    @Override
    public void setLineSelectPropertyName(String lineSelectPropertyName) {
        this.lineSelectPropertyName = lineSelectPropertyName;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.BYTYPE)
    public QuickFinder getCollectionLookup() {
        return this.collectionLookup;
    }

    @Override
    public void setCollectionLookup(QuickFinder collectionLookup) {
        this.collectionLookup = collectionLookup;
    }

    @Override
    @BeanTagAttribute
    public boolean isShowInactiveLines() {
        return this.showInactiveLines;
    }

    @Override
    public void setShowInactiveLines(boolean showInactiveLines) {
        this.showInactiveLines = showInactiveLines;
    }

    @Override
    @BeanTagAttribute
    public CollectionFilter getActiveCollectionFilter() {
        return this.activeCollectionFilter;
    }

    @Override
    public void setActiveCollectionFilter(CollectionFilter activeCollectionFilter) {
        this.activeCollectionFilter = activeCollectionFilter;
    }

    @Override
    @BeanTagAttribute
    public List<CollectionFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void setFilters(List<CollectionFilter> filters) {
        this.filters = filters;
    }

    @Override
    @BeanTagAttribute
    public List<String> getDuplicateLinePropertyNames() {
        return this.duplicateLinePropertyNames;
    }

    @Override
    public void setDuplicateLinePropertyNames(List<String> duplicateLinePropertyNames) {
        this.duplicateLinePropertyNames = duplicateLinePropertyNames;
    }

    @Override
    public List<BindingInfo> getUnauthorizedLineBindingInfos() {
        return this.unauthorizedLineBindingInfos;
    }

    @Override
    public void setUnauthorizedLineBindingInfos(List<BindingInfo> unauthorizedLineBindingInfos) {
        this.unauthorizedLineBindingInfos = unauthorizedLineBindingInfos;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<CollectionGroup> getSubCollections() {
        return this.subCollections;
    }

    @Override
    public void setSubCollections(List<CollectionGroup> subCollections) {
        this.subCollections = subCollections;
    }

    @Override
    public CollectionGroupSecurity getCollectionGroupSecurity() {
        return (CollectionGroupSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof CollectionGroupSecurity)) {
            throw new RiceRuntimeException("Component security for CollectionGroup should be instance of CollectionGroupSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected void initializeComponentSecurity() {
        if (this.getComponentSecurity() == null) {
            this.setComponentSecurity(KRADUtils.createNewObjectFromClass(CollectionGroupSecurity.class));
        }
    }

    @Override
    @BeanTagAttribute
    public boolean isEditLineAuthz() {
        this.initializeComponentSecurity();
        return this.getCollectionGroupSecurity().isEditLineAuthz();
    }

    @Override
    public void setEditLineAuthz(boolean editLineAuthz) {
        this.initializeComponentSecurity();
        this.getCollectionGroupSecurity().setEditLineAuthz(editLineAuthz);
    }

    @Override
    @BeanTagAttribute
    public boolean isViewLineAuthz() {
        this.initializeComponentSecurity();
        return this.getCollectionGroupSecurity().isViewLineAuthz();
    }

    @Override
    public void setViewLineAuthz(boolean viewLineAuthz) {
        this.initializeComponentSecurity();
        this.getCollectionGroupSecurity().setViewLineAuthz(viewLineAuthz);
    }

    @Override
    @BeanTagAttribute
    public CollectionGroupBuilder getCollectionGroupBuilder() {
        if (this.collectionGroupBuilder == null) {
            this.collectionGroupBuilder = new CollectionGroupBuilder();
        }
        return this.collectionGroupBuilder;
    }

    @Override
    public void setCollectionGroupBuilder(CollectionGroupBuilder collectionGroupBuilder) {
        this.collectionGroupBuilder = collectionGroupBuilder;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderInactiveToggleButton() {
        return this.renderInactiveToggleButton;
    }

    @Override
    public void setRenderInactiveToggleButton(boolean renderInactiveToggleButton) {
        this.renderInactiveToggleButton = renderInactiveToggleButton;
    }

    @Override
    @BeanTagAttribute
    public int getDisplayCollectionSize() {
        return this.displayCollectionSize;
    }

    @Override
    public void setDisplayCollectionSize(int displayCollectionSize) {
        this.displayCollectionSize = displayCollectionSize;
    }

    @Override
    @BeanTagAttribute
    public boolean isHighlightNewItems() {
        return this.highlightNewItems;
    }

    @Override
    public void setHighlightNewItems(boolean highlightNewItems) {
        this.highlightNewItems = highlightNewItems;
    }

    @Override
    @BeanTagAttribute
    public String getNewItemsCssClass() {
        return this.newItemsCssClass;
    }

    @Override
    public void setNewItemsCssClass(String newItemsCssClass) {
        this.newItemsCssClass = newItemsCssClass;
    }

    @Override
    @BeanTagAttribute
    public String getAddItemCssClass() {
        return this.addItemCssClass;
    }

    @Override
    public void setAddItemCssClass(String addItemCssClass) {
        this.addItemCssClass = addItemCssClass;
    }

    @Override
    @BeanTagAttribute
    public boolean isHighlightAddItem() {
        return this.highlightAddItem;
    }

    @Override
    public void setHighlightAddItem(boolean highlightAddItem) {
        this.highlightAddItem = highlightAddItem;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderAddBlankLineButton() {
        return this.renderAddBlankLineButton;
    }

    @Override
    public void setRenderAddBlankLineButton(boolean renderAddBlankLineButton) {
        this.renderAddBlankLineButton = renderAddBlankLineButton;
    }

    @Override
    @BeanTagAttribute
    public Action getAddBlankLineAction() {
        return this.addBlankLineAction;
    }

    @Override
    public void setAddBlankLineAction(Action addBlankLineAction) {
        this.addBlankLineAction = addBlankLineAction;
    }

    @Override
    @BeanTagAttribute
    public String getAddLinePlacement() {
        return this.addLinePlacement;
    }

    @Override
    public void setAddLinePlacement(String addLinePlacement) {
        this.addLinePlacement = addLinePlacement;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderSaveLineActions() {
        return this.renderSaveLineActions;
    }

    @Override
    public void setRenderSaveLineActions(boolean renderSaveLineActions) {
        this.renderSaveLineActions = renderSaveLineActions;
    }

    @Override
    @BeanTagAttribute
    public boolean isAddWithDialog() {
        return this.addWithDialog;
    }

    @Override
    public void setAddWithDialog(boolean addWithDialog) {
        this.addWithDialog = addWithDialog;
    }

    @Override
    @BeanTagAttribute
    public Action getAddWithDialogAction() {
        return this.addWithDialogAction;
    }

    @Override
    public void setAddWithDialogAction(Action addWithDialogAction) {
        this.addWithDialogAction = addWithDialogAction;
    }

    @Override
    @BeanTagAttribute
    public DialogGroup getAddLineDialog() {
        return this.addLineDialog;
    }

    @Override
    public void setAddLineDialog(DialogGroup addLineDialog) {
        this.addLineDialog = addLineDialog;
    }

    @Override
    @BeanTagAttribute
    public boolean isUseServerPaging() {
        return this.useServerPaging;
    }

    @Override
    public void setUseServerPaging(boolean useServerPaging) {
        this.useServerPaging = useServerPaging;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int getDisplayStart() {
        return this.displayStart;
    }

    @Override
    public void setDisplayStart(int displayStart) {
        this.displayStart = displayStart;
    }

    @Override
    public int getDisplayLength() {
        return this.displayLength;
    }

    @Override
    public void setDisplayLength(int displayLength) {
        this.displayLength = displayLength;
    }

    @Override
    public int getFilteredCollectionSize() {
        return this.filteredCollectionSize;
    }

    @Override
    public void setFilteredCollectionSize(int filteredCollectionSize) {
        this.filteredCollectionSize = filteredCollectionSize;
    }

    public int getTotalCollectionSize() {
        return this.totalCollectionSize;
    }

    public void setTotalCollectionSize(int totalCollectionSize) {
        this.totalCollectionSize = totalCollectionSize;
    }

    @BeanTagAttribute
    protected List<String> getTotalColumns() {
        return this.totalColumns;
    }

    protected void setTotalColumns(List<String> totalColumns) {
        this.totalColumns = totalColumns;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getCollectionObjectClass() == null && Validator.checkExpressions(this, "collectionObjectClass")) {
            String[] currentValues = new String[]{"collectionObjectClass = " + String.valueOf(this.getCollectionObjectClass())};
            tracer.createWarning("CollectionObjectClass is not set (disregard if part of an abstract)", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    @BeanTagAttribute
    public boolean isEditWithDialog() {
        return this.editWithDialog;
    }

    @Override
    public void setEditWithDialog(boolean editWithDialog) {
        this.editWithDialog = editWithDialog;
    }

    @Override
    @BeanTagAttribute
    public boolean isCustomEditLineDialog() {
        return this.customEditLineDialog;
    }

    @Override
    public void setCustomEditLineDialog(boolean customEditLineDialog) {
        this.customEditLineDialog = customEditLineDialog;
    }

    @Override
    @BeanTagAttribute
    public DialogGroup getEditLineDialogPrototype() {
        return this.editLineDialogPrototype;
    }

    @Override
    public void setEditLineDialogPrototype(DialogGroup editLineDialogPrototype) {
        this.editLineDialogPrototype = editLineDialogPrototype;
    }

    @Override
    @BeanTagAttribute
    public Action getEditWithDialogActionPrototype() {
        return this.editWithDialogActionPrototype;
    }

    @Override
    public void setEditWithDialogActionPrototype(Action editWithDialogActionPrototype) {
        this.editWithDialogActionPrototype = editWithDialogActionPrototype;
    }

    @Override
    @BeanTagAttribute
    public Action getEditInDialogSaveActionPrototype() {
        return this.editInDialogSaveActionPrototype;
    }

    @Override
    public void setEditInDialogSaveActionPrototype(Action editInDialogSaveActionPrototype) {
        this.editInDialogSaveActionPrototype = editInDialogSaveActionPrototype;
    }

    @Override
    public List<DialogGroup> getLineDialogs() {
        return this.lineDialogs;
    }

    @Override
    public void setLineDialogs(List<DialogGroup> dialogGroups) {
        this.lineDialogs = dialogGroups;
    }
}

