/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.repository.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.repository.type.KewAttributeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeAttribute;
import org.kuali.rice.kew.api.repository.type.KewTypeAttributeContract;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="KEWType")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KEWTypeType", propOrder={"id", "name", "namespace", "serviceName", "active", "attributes", "versionNumber", "_futureElements"})
public final class KewTypeDefinition
extends AbstractDataTransferObject
implements KewTypeDefinitionContract {
    private static final long serialVersionUID = -8314397393380856301L;
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="name", required=true)
    private String name;
    @XmlElement(name="namespace", required=true)
    private String namespace;
    @XmlElement(name="serviceName", required=false)
    private String serviceName;
    @XmlElement(name="active", required=false)
    private boolean active;
    @XmlElement(name="attribute", required=false)
    private List<KewTypeAttribute> attributes;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KewTypeDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.serviceName = null;
        this.active = false;
        this.attributes = null;
        this.versionNumber = null;
    }

    private KewTypeDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespace = builder.getNamespace();
        this.serviceName = builder.getServiceName();
        this.active = builder.isActive();
        ArrayList<KewTypeAttribute> attrList = new ArrayList<KewTypeAttribute>();
        if (builder.attributes != null) {
            for (KewTypeAttribute.Builder b : builder.attributes) {
                attrList.add(b.build());
            }
        }
        this.attributes = Collections.unmodifiableList(attrList);
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<KewTypeAttribute> getAttributes() {
        return this.attributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public KewAttributeDefinition getAttributeDefinitionByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name was a null or blank value");
        }
        if (CollectionUtils.isNotEmpty(this.getAttributes())) {
            for (KewTypeAttribute attribute : this.getAttributes()) {
                if (!name.equals(attribute.getAttributeDefinition().getName())) continue;
                return attribute.getAttributeDefinition();
            }
        }
        return null;
    }

    public static class Builder
    implements KewTypeDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -3469525730879441547L;
        private String id;
        private String name;
        private String namespace;
        private String serviceName = "";
        private boolean active;
        private List<KewTypeAttribute.Builder> attributes;
        private Long versionNumber;

        private Builder(String id, String name, String namespace) {
            this.setId(id);
            this.setName(name);
            this.setNamespace(namespace);
            this.setActive(true);
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder attributes(List<KewTypeAttribute.Builder> attributes) {
            this.setAttributes(attributes);
            return this;
        }

        public static Builder create(String id, String name, String namespace) {
            return new Builder(id, name, namespace);
        }

        public static Builder create(KewTypeDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getId(), contract.getName(), contract.getNamespace());
            builder.setNamespace(contract.getNamespace());
            builder.setActive(contract.isActive());
            builder.setServiceName(contract.getServiceName());
            ArrayList<KewTypeAttribute.Builder> attrBuilderList = new ArrayList<KewTypeAttribute.Builder>();
            if (contract.getAttributes() != null) {
                for (KewTypeAttributeContract kewTypeAttributeContract : contract.getAttributes()) {
                    KewTypeAttribute.Builder myBuilder = KewTypeAttribute.Builder.create(kewTypeAttributeContract);
                    attrBuilderList.add(myBuilder);
                }
            }
            builder.setAttributes(attrBuilderList);
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String id) {
            if (id != null && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace is blank");
            }
            this.namespace = namespace;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public void setAttributes(List<KewTypeAttribute.Builder> attributes) {
            if (attributes == null || attributes.isEmpty()) {
                this.attributes = Collections.unmodifiableList(new ArrayList());
                return;
            }
            this.attributes = Collections.unmodifiableList(attributes);
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getServiceName() {
            return this.serviceName;
        }

        public List<KewTypeAttribute.Builder> getAttributes() {
            return this.attributes;
        }

        public boolean isActive() {
            return this.active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public KewTypeDefinition build() {
            return new KewTypeDefinition(this);
        }
    }

    public static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String NAMESPACE = "namespace";
        static final String SERVICENAME = "serviceName";
        static final String ACTIVE = "active";
        static final String ATTRIBUTE = "attribute";
        static final String ATTRIBUTES = "attributes";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "KEWType";
        static final String TYPE_NAME = "KEWTypeType";

        Constants() {
        }
    }
}

