/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs;

import com.terracottatech.frs.GettableAction;
import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionFactory;
import com.terracottatech.frs.compaction.Compactor;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.util.ByteBufferUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;

public class PutAction
implements GettableAction {
    public static final long PUT_ACTION_OVERHEAD = 20L;
    public static final ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer> FACTORY = new ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer>(){

        @Override
        public Action create(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ActionCodec codec, ByteBuffer[] buffers) {
            int idLength = ByteBufferUtils.getInt(buffers);
            int keyLength = ByteBufferUtils.getInt(buffers);
            int valueLength = ByteBufferUtils.getInt(buffers);
            long invalidatedLsn = ByteBufferUtils.getLong(buffers);
            ByteBuffer id = ByteBufferUtils.getBytes(idLength, buffers);
            ByteBuffer key = ByteBufferUtils.getBytes(keyLength, buffers);
            ByteBuffer value = ByteBufferUtils.getBytes(valueLength, buffers);
            return new PutAction(objectManager, null, id, key, value, invalidatedLsn);
        }
    };
    private static final int HEADER_SIZE = 20;
    private final ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager;
    private final ByteBuffer id;
    private final ByteBuffer key;
    private final ByteBuffer value;
    private final Compactor compactor;
    private long markedLsn;
    private long invalidatedLsn;
    private Closeable disposable;

    PutAction(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, Compactor compactor, ByteBuffer id, ByteBuffer key, ByteBuffer value, boolean recovery) {
        this(objectManager, compactor, id, key, value, objectManager.getLsn(id, key));
        if (this.invalidatedLsn == -1L && recovery) {
            throw new IllegalStateException("Put over an unrecovered key is unsupported during recovery.");
        }
    }

    protected PutAction(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, Compactor compactor, ByteBuffer id, ByteBuffer key, ByteBuffer value, long invalidatedLsn) {
        this.objectManager = objectManager;
        this.compactor = compactor;
        this.id = id;
        this.key = key;
        this.value = value;
        this.invalidatedLsn = invalidatedLsn;
    }

    @Override
    public ByteBuffer getIdentifier() {
        return this.id;
    }

    @Override
    public ByteBuffer getKey() {
        return this.key;
    }

    @Override
    public ByteBuffer getValue() {
        return this.value;
    }

    @Override
    public long getLsn() {
        return this.markedLsn;
    }

    @Override
    public Set<Long> getInvalidatedLsns() {
        return Collections.singleton(this.invalidatedLsn);
    }

    @Override
    public void setDisposable(Closeable c) {
        this.disposable = c;
    }

    @Override
    public void dispose() {
        try {
            this.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.disposable != null) {
            this.disposable.close();
            this.disposable = null;
        }
    }

    @Override
    public void record(long lsn) {
        this.markedLsn = lsn;
        this.objectManager.put(this.getIdentifier(), this.getKey(), this.getValue(), lsn);
        if (this.invalidatedLsn != -1L) {
            this.compactor.generatedGarbage(this.invalidatedLsn);
        }
    }

    @Override
    public void replay(long lsn) {
        this.objectManager.replayPut(this.getIdentifier(), this.getKey(), this.getValue(), lsn);
    }

    @Override
    public int replayConcurrency() {
        return this.objectManager.replayConcurrency(this.getIdentifier(), this.getKey());
    }

    @Override
    public ByteBuffer[] getPayload(ActionCodec codec) {
        ByteBuffer header = ByteBuffer.allocate(20);
        header.putInt(this.id.remaining());
        header.putInt(this.key.remaining());
        header.putInt(this.value.remaining());
        header.putLong(this.invalidatedLsn).flip();
        return new ByteBuffer[]{header, this.id.slice(), this.key.slice(), this.value.slice()};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutAction putAction = (PutAction)o;
        return this.id.equals(putAction.id) && this.key.equals(putAction.key) && this.value.equals(putAction.value) && this.invalidatedLsn == putAction.invalidatedLsn;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

