/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.log.BufferListWrapper;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRegionPacker;
import com.terracottatech.frs.log.Signature;
import java.nio.ByteBuffer;
import java.util.Collections;

public class CopyingPacker
extends LogRegionPacker {
    private final BufferSource pool;
    private static final int FUTURE_SPACER = 64;

    public CopyingPacker(Signature sig, String forceLogRegionFormat, BufferSource copyInto) {
        super(sig, forceLogRegionFormat);
        this.pool = copyInto;
    }

    @Override
    protected Chunk writeRecords(Iterable<LogRecord> records) {
        Chunk base = super.writeRecords(records);
        ByteBuffer grp = this.pool.getBuffer((int)base.length() + 128);
        grp.position(64);
        for (ByteBuffer b : base.getBuffers()) {
            grp.put(b);
        }
        grp.flip();
        grp.position(64);
        return new BufferListWrapper(Collections.singletonList(grp), this.pool);
    }
}

