/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.personnel;

import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;

public class TbnPersonMaintainableImpl
extends KraMaintainableImpl {
    private transient ParameterService parameterService;

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List<Section> sections = super.getCoreSections(document, oldMaintainable);
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "All", "SALARY_ON_TBN_PERSON") != false ? sections : this.filterSalarySections(sections);
    }

    private List<Section> filterSalarySections(List<Section> sections) {
        sections.forEach(s -> s.setRows(this.filterSalaryRows(s.getRows())));
        return sections;
    }

    private List<Row> filterSalaryRows(List<Row> rows) {
        return rows.stream().filter(r -> r.getFields().stream().map(Field::getPropertyName).noneMatch("salary"::equals)).collect(Collectors.toList());
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

