/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.loaderwriter;

import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.AbstractWrapperStoreProvider;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.loaderwriter.LocalLoaderWriterStore;
import org.ehcache.impl.internal.store.loaderwriter.LocalWriteBehindLoaderWriterStore;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterProvider;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import org.ehcache.spi.loaderwriter.WriteBehindProvider;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;

@ServiceDependencies(value={CacheLoaderWriterProvider.class, WriteBehindProvider.class})
public class LoaderWriterStoreProvider
extends AbstractWrapperStoreProvider {
    private volatile WriteBehindProvider writeBehindProvider;

    public LoaderWriterStoreProvider() {
        super(new Class[]{CacheLoaderWriterConfiguration.class});
    }

    protected int wrapperRank() {
        return 2;
    }

    protected <K, V> Store<K, V> wrap(Store<K, V> store, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        LocalLoaderWriterStore<K, V> loaderWriterStore;
        WriteBehindConfiguration writeBehindConfiguration = (WriteBehindConfiguration)ServiceUtils.findSingletonAmongst(WriteBehindConfiguration.class, (Object[])serviceConfigs);
        if (writeBehindConfiguration == null) {
            loaderWriterStore = new LocalLoaderWriterStore<K, V>(store, storeConfig.getCacheLoaderWriter(), storeConfig.useLoaderInAtomics(), storeConfig.getExpiry());
        } else {
            CacheLoaderWriter writeBehindLoaderWriter = this.writeBehindProvider.createWriteBehindLoaderWriter(key -> {
                try {
                    store.remove(key);
                }
                catch (StoreAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }, storeConfig.getCacheLoaderWriter(), writeBehindConfiguration);
            loaderWriterStore = new LocalWriteBehindLoaderWriterStore<K, V>(store, writeBehindLoaderWriter, storeConfig.useLoaderInAtomics(), storeConfig.getExpiry());
        }
        return loaderWriterStore;
    }

    public void releaseStore(Store<?, ?> resource) {
        try {
            if (resource instanceof LocalWriteBehindLoaderWriterStore) {
                this.writeBehindProvider.releaseWriteBehindLoaderWriter(((LocalWriteBehindLoaderWriterStore)resource).getCacheLoaderWriter());
            }
        }
        finally {
            super.releaseStore(resource);
        }
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        super.start(serviceProvider);
        this.writeBehindProvider = (WriteBehindProvider)serviceProvider.getService(WriteBehindProvider.class);
    }

    public void stop() {
        this.writeBehindProvider = null;
        super.stop();
    }
}

