-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
DROP TABLE IF EXISTS COI_DISCLOSURE
/

CREATE TABLE COI_DISCLOSURE ( 
    COI_DISCLOSURE_ID DECIMAL(12,0) NOT NULL, 
    COI_DISCLOSURE_NUMBER VARCHAR(20) NOT NULL, 
    SEQUENCE_NUMBER DECIMAL(6,0) NOT NULL, 
    DOCUMENT_NUMBER    VARCHAR(40) NOT NULL,
    PERSON_ID VARCHAR(40) NOT NULL, 
    CERTIFICATION_TEXT LONGTEXT, 
    CERTIFIED_BY VARCHAR(20), 
    CERTIFICATION_TIMESTAMP DATE, 
    DISCLOSURE_DISPOSITION_CODE DECIMAL(3,0) NOT NULL, 
    DISCLOSURE_STATUS_CODE DECIMAL(3,0) NOT NULL, 
    EXPIRATION_DATE DATE NOT NULL, 
    UPDATE_TIMESTAMP DATE NOT NULL, 
    UPDATE_USER VARCHAR(60) NOT NULL, 
    EVENT_TYPE_CODE VARCHAR(3), 
    MODULE_ITEM_KEY VARCHAR(20), 
    REVIEW_STATUS_CODE DECIMAL(3,0), 
    DISC_ACTIVE_STATUS DECIMAL(1,0) DEFAULT 1, 
    VER_NBR DECIMAL(8,0) DEFAULT 1 NOT NULL, 
    OBJ_ID VARCHAR(36) NOT NULL) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/
ALTER TABLE COI_DISCLOSURE 
ADD CONSTRAINT PK_COI_DISCLOSURE 
PRIMARY KEY (COI_DISCLOSURE_ID)
/

DELIMITER ;
