/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.ConstructorHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PkEnumeration
implements Enumeration {
    static final long serialVersionUID = -834955711995869884L;
    protected boolean hasCalledCheck = false;
    protected boolean hasNext = false;
    protected PersistenceBroker broker;
    protected ResultSetAndStatement resultSetAndStatment;
    protected ClassDescriptor classDescriptor;
    protected Constructor constructor;

    public PkEnumeration(Query query, ClassDescriptor classDescriptor, Class clazz, PersistenceBroker persistenceBroker) {
        this.resultSetAndStatment = persistenceBroker.serviceJdbcAccess().executeQuery(query, classDescriptor);
        this.classDescriptor = classDescriptor;
        this.broker = persistenceBroker;
        try {
            Class[] classArray = new Class[]{Identity.class};
            this.constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoggerFactory.getDefaultLogger().error(clazz.getName() + " must implement a Constructor with one argument of type org.apache.ojb.broker.Identity");
            throw new PersistenceBrokerException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            LoggerFactory.getDefaultLogger().error(securityException);
            throw new PersistenceBrokerException(securityException);
        }
    }

    private Identity getIdentityFromResultSet() {
        try {
            Constructor constructor = this.classDescriptor.getZeroArgumentConstructor();
            Object object = ConstructorHelper.instantiate(constructor);
            FieldDescriptor[] fieldDescriptorArray = this.classDescriptor.getPkFields();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                Object object2 = fieldDescriptor.getJdbcType().getObjectFromColumn(this.resultSetAndStatment.m_rs, fieldDescriptor.getColumnName());
                fieldDescriptor.getPersistentField().set(object, object2);
            }
            return this.broker.serviceIdentity().buildIdentity(this.classDescriptor, object);
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerSQLException("Error reading object from column", sQLException);
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Error reading Identity from result set", exception);
        }
    }

    @Override
    public boolean hasMoreElements() {
        try {
            if (!this.hasCalledCheck) {
                this.hasCalledCheck = true;
                this.hasNext = this.resultSetAndStatment.m_rs.next();
            }
        }
        catch (SQLException sQLException) {
            LoggerFactory.getDefaultLogger().error(sQLException);
            this.hasNext = false;
        }
        finally {
            if (!this.hasNext) {
                this.releaseDbResources();
            }
        }
        return this.hasNext;
    }

    private void releaseDbResources() {
        this.resultSetAndStatment.close();
        this.resultSetAndStatment = null;
    }

    public Object nextElement() {
        try {
            if (!this.hasCalledCheck) {
                this.hasMoreElements();
            }
            this.hasCalledCheck = false;
            if (this.hasNext) {
                Identity identity = this.getIdentityFromResultSet();
                Object[] objectArray = new Identity[]{identity};
                return this.constructor.newInstance(objectArray);
            }
            throw new NoSuchElementException();
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().error(exception);
            throw new NoSuchElementException();
        }
    }

    protected void finalize() {
        if (this.resultSetAndStatment != null) {
            LoggerFactory.getDefaultLogger().error("[" + PkEnumeration.class.getName() + "] Found unclosed resources while finalize");
            this.releaseDbResources();
        }
    }
}

