/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.StatementsForClassIF;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlGeneratorFactory;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ExceptionHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class StatementsForClassImpl
implements StatementsForClassIF {
    private Logger log = LoggerFactory.getLogger(StatementsForClassImpl.class);
    protected final ClassDescriptor classDescriptor;
    protected final SqlGenerator sqlGenerator;
    protected final Platform platform;
    protected final Class clazz;
    protected final int fetchSize;
    private String deleteSql;
    private String insertSql;
    private String updateSql;
    private String selectByPKSql;
    protected boolean FORCEJDBC1_0 = false;

    public StatementsForClassImpl(JdbcConnectionDescriptor jdbcConnectionDescriptor, ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.clazz = classDescriptor.getClassOfObject();
        this.platform = PlatformFactory.getPlatformFor(jdbcConnectionDescriptor);
        this.sqlGenerator = SqlGeneratorFactory.getInstance().createSqlGenerator(this.platform);
        ConnectionPoolDescriptor connectionPoolDescriptor = jdbcConnectionDescriptor.getConnectionPoolDescriptor();
        this.fetchSize = connectionPoolDescriptor.getFetchSize();
        double d = jdbcConnectionDescriptor.getJdbcLevel();
        this.FORCEJDBC1_0 = d == 1.0;
    }

    protected boolean usePreparedDeleteStatement() {
        return this.classDescriptor.getDeleteProcedure() == null || !this.classDescriptor.getDeleteProcedure().hasReturnValues();
    }

    @Override
    public PreparedStatement getDeleteStmt(Connection connection) throws SQLException {
        if (this.deleteSql == null) {
            this.deleteSql = this.sqlGenerator.getPreparedDeleteStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(connection, this.deleteSql, false, this.usePreparedDeleteStatement(), -1);
        }
        catch (SQLException sQLException) {
            this.log.error("Can't prepare delete statement: " + this.deleteSql, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement getGenericStmt(Connection connection, boolean bl) throws PersistenceBrokerSQLException {
        Statement statement;
        try {
            statement = this.createStatement(connection, bl, 0);
        }
        catch (SQLException sQLException) {
            throw ExceptionHelper.generateException("Can't prepare statement:", sQLException, null, this.log);
        }
        return statement;
    }

    protected boolean usePreparedInsertStatement() {
        return this.classDescriptor.getInsertProcedure() == null || !this.classDescriptor.getInsertProcedure().hasReturnValues();
    }

    @Override
    public PreparedStatement getInsertStmt(Connection connection) throws SQLException {
        if (this.insertSql == null) {
            this.insertSql = this.sqlGenerator.getPreparedInsertStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(connection, this.insertSql, false, this.usePreparedInsertStatement(), -1);
        }
        catch (SQLException sQLException) {
            this.log.error("Can't prepare insert statement: " + this.insertSql, sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement getPreparedStmt(Connection connection, String string, boolean bl, int n, boolean bl2) throws PersistenceBrokerSQLException {
        PreparedStatement preparedStatement;
        try {
            preparedStatement = this.prepareStatement(connection, string, bl, !bl2, n);
        }
        catch (SQLException sQLException) {
            throw ExceptionHelper.generateException("Can't prepare statement:", sQLException, string, this.log);
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement getSelectByPKStmt(Connection connection) throws SQLException {
        if (this.selectByPKSql == null) {
            this.selectByPKSql = this.sqlGenerator.getPreparedSelectByPkStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(connection, this.selectByPKSql, false, true, 1);
        }
        catch (SQLException sQLException) {
            this.log.error(sQLException);
            throw sQLException;
        }
    }

    protected boolean usePreparedUpdateStatement() {
        return this.classDescriptor.getUpdateProcedure() == null || !this.classDescriptor.getUpdateProcedure().hasReturnValues();
    }

    @Override
    public PreparedStatement getUpdateStmt(Connection connection) throws SQLException {
        if (this.updateSql == null) {
            this.updateSql = this.sqlGenerator.getPreparedUpdateStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(connection, this.updateSql, false, this.usePreparedUpdateStatement(), -1);
        }
        catch (SQLException sQLException) {
            this.log.error("Can't prepare update statement: " + this.updateSql, sQLException);
            throw sQLException;
        }
    }

    protected PreparedStatement prepareStatement(Connection connection, String string, boolean bl, boolean bl2, int n) throws SQLException {
        PreparedStatement preparedStatement;
        try {
            if (!this.FORCEJDBC1_0) {
                if (bl2) {
                    preparedStatement = connection.prepareStatement(string, bl ? 1004 : 1003, 1007);
                    this.afterJdbc2CapableStatementCreate(preparedStatement, n);
                } else {
                    preparedStatement = connection.prepareCall(string, bl ? 1004 : 1003, 1007);
                }
            } else {
                preparedStatement = bl2 ? connection.prepareStatement(string) : connection.prepareCall(string);
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            this.log.warn("Used driver seems not JDBC 2.0 compatible, use the JDBC 1.0 mode", abstractMethodError);
            preparedStatement = bl2 ? connection.prepareStatement(string) : connection.prepareCall(string);
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                this.log.warn("JDBC 2.0 problems with this interbase driver, we use the JDBC 1.0 mode");
                preparedStatement = bl2 ? connection.prepareStatement(string) : connection.prepareCall(string);
                this.FORCEJDBC1_0 = true;
            }
            throw sQLException;
        }
        try {
            if (!ProxyHelper.isNormalOjbProxy(preparedStatement)) {
                this.platform.afterStatementCreate(preparedStatement);
            }
        }
        catch (PlatformException platformException) {
            this.log.error("Platform dependend failure", (Throwable)((Object)platformException));
        }
        return preparedStatement;
    }

    private Statement createStatement(Connection connection, boolean bl, int n) throws SQLException {
        Statement statement;
        try {
            if (!this.FORCEJDBC1_0) {
                statement = connection.createStatement(bl ? 1004 : 1003, 1007);
                this.afterJdbc2CapableStatementCreate(statement, n);
            } else {
                statement = connection.createStatement();
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            this.log.warn("Used driver seems not JDBC 2.0 compatible, use the JDBC 1.0 mode", abstractMethodError);
            statement = connection.createStatement();
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                this.log.warn("JDBC 2.0 problems with this interbase driver, we use the JDBC 1.0 mode");
                this.FORCEJDBC1_0 = true;
                statement = connection.createStatement();
            }
            throw sQLException;
        }
        try {
            this.platform.afterStatementCreate(statement);
        }
        catch (PlatformException platformException) {
            this.log.error("Platform dependend failure", (Throwable)((Object)platformException));
        }
        return statement;
    }

    private void afterJdbc2CapableStatementCreate(Statement statement, int n) throws SQLException {
        int n2;
        if (statement != null && (n2 = n == -1 ? -1 : (n != 0 ? n : this.fetchSize)) > 0) {
            statement.setFetchSize(this.fetchSize);
        }
    }
}

