/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;

public class PreparedModel {
    private Database _schema;
    private TreeMap _elementToTable = new TreeMap();
    private HashMap _elementToClassDescriptors = new HashMap();
    private HashMap _elementToColumnMap = new HashMap();
    private HashMap _elementToRequiredAttributesMap = new HashMap();

    public PreparedModel(DescriptorRepository descriptorRepository, Database database) {
        this._schema = database;
        this.prepareModel(descriptorRepository);
    }

    public Iterator getElementNames() {
        return this._elementToTable.keySet().iterator();
    }

    public Iterator getAttributeNames(String string) {
        Map map = this.getColumnsFor(string);
        return map == null ? null : map.keySet().iterator();
    }

    public Map getRequiredAttributes(String string) {
        return (Map)this._elementToRequiredAttributesMap.get(string);
    }

    public boolean isRequired(String string, String string2) {
        Map map = this.getRequiredAttributes(string);
        if (map == null) {
            return false;
        }
        Boolean bl = (Boolean)map.get(string2);
        return bl == null ? false : bl;
    }

    public Table getTableFor(String string) {
        return (Table)this._elementToTable.get(string);
    }

    public DynaBean createBeanFor(String string) {
        return this._schema.createDynaBeanFor(this.getTableFor(string));
    }

    public List getClassDescriptorsMappingTo(String string) {
        return (List)this._elementToClassDescriptors.get(string);
    }

    public Map getColumnsFor(String string) {
        return (Map)this._elementToColumnMap.get(string);
    }

    public Column getColumnFor(String string, String string2) {
        Map map = this.getColumnsFor(string);
        if (map == null) {
            return null;
        }
        return (Column)map.get(string2);
    }

    private void prepareModel(DescriptorRepository descriptorRepository) {
        TreeMap treeMap = new TreeMap();
        for (ClassDescriptor classDescriptor : descriptorRepository.getDescriptorTable().values()) {
            if (classDescriptor.getFullTableName() == null) continue;
            String string = this.getElementName(classDescriptor);
            Table table = this.getTableFor(string);
            TreeMap treeMap2 = this.getColumnsFor(string);
            HashMap hashMap = this.getRequiredAttributes(string);
            ArrayList<ClassDescriptor> arrayList = this.getClassDescriptorsMappingTo(string);
            if (table == null) {
                table = this._schema.findTable(classDescriptor.getFullTableName());
                if (table == null) continue;
                treeMap2 = new TreeMap();
                hashMap = new HashMap();
                arrayList = new ArrayList<ClassDescriptor>();
                this._elementToTable.put(string, table);
                this._elementToClassDescriptors.put(string, arrayList);
                this._elementToColumnMap.put(string, treeMap2);
                this._elementToRequiredAttributesMap.put(string, hashMap);
            }
            arrayList.add(classDescriptor);
            this.extractAttributes(classDescriptor, table, treeMap2, hashMap);
        }
        this.extractIndirectionTables(descriptorRepository, this._schema);
    }

    private void extractAttributes(ClassDescriptor classDescriptor, Table table, Map map, Map map2) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        if (fieldDescriptorArray != null) {
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                Column column = table.findColumn(fieldDescriptorArray[i].getColumnName());
                if (column == null) continue;
                boolean bl = false;
                Object object = map.values().iterator();
                while (object.hasNext()) {
                    if (!column.equals(object.next())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object = this.getShortAttributeName(fieldDescriptorArray[i].getAttributeName());
                map.put(object, column);
                map2.put(object, fieldDescriptorArray[i].isPrimaryKey() ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    private void extractIndirectionTables(DescriptorRepository descriptorRepository, Database database) {
        Object object6;
        Object object2;
        HashMap hashMap = new HashMap();
        for (Object object3 : descriptorRepository.getDescriptorTable().values()) {
            for (Object object4 : ((ClassDescriptor)object3).getCollectionDescriptors()) {
                object2 = ((CollectionDescriptor)object4).getIndirectionTable();
                if (object2 == null || ((String)object2).length() <= 0) continue;
                object6 = (Set)hashMap.get(object2);
                if (object6 == null) {
                    object6 = new HashSet<String>();
                    hashMap.put(object2, object6);
                }
                object6.addAll(Arrays.asList(((CollectionDescriptor)object4).getFksToThisClass()));
                object6.addAll(Arrays.asList(((CollectionDescriptor)object4).getFksToItemClass()));
            }
        }
        if (hashMap.isEmpty()) {
            return;
        }
        for (Object object3 : hashMap.keySet()) {
            Object object5;
            Object object4;
            Set set = (Set)hashMap.get(object3);
            object4 = object3;
            for (Object object6 : descriptorRepository.getDescriptorTable().values()) {
                if (!((String)object3).equals(((ClassDescriptor)object6).getFullTableName())) continue;
                object4 = this.getElementName((ClassDescriptor)object6);
                object5 = ((ClassDescriptor)object6).getFieldDescriptions();
                if (object5 == null) continue;
                for (int i = 0; i < ((FieldDescriptor[])object5).length; ++i) {
                    set.remove(object5[i].getColumnName());
                }
            }
            object2 = this.getTableFor((String)object4);
            object6 = this.getColumnsFor((String)object4);
            object5 = this.getRequiredAttributes((String)object4);
            if (object2 == null) {
                object2 = database.findTable((String)object4);
                if (object2 == null) continue;
                object6 = new TreeMap<String, Column>();
                object5 = new HashMap();
                this._elementToTable.put(object4, object2);
                this._elementToColumnMap.put(object4, object6);
                this._elementToRequiredAttributesMap.put(object4, object5);
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Column column = object2.findColumn(string);
                if (column == null) continue;
                object6.put(string, column);
                object5.put(string, Boolean.TRUE);
            }
        }
    }

    private String getElementName(ClassDescriptor classDescriptor) {
        String string = classDescriptor.getClassNameOfObject().replace('$', '_');
        string = string.substring(string.lastIndexOf(46) + 1);
        Table table = this.getTableFor(string);
        int n = 0;
        while (table != null && !table.getName().equals(classDescriptor.getFullTableName())) {
            table = this.getTableFor(string + "-" + ++n);
        }
        if (n > 0) {
            string = string + "-" + n;
        }
        return string;
    }

    private String getShortAttributeName(String string) {
        return string.substring(string.lastIndexOf(58) + 1);
    }
}

