/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Collection;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockEntry;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockStrategyFactory;

public class RemoteLockMapImpl
implements LockMap,
Configurable {
    private Logger log = LoggerFactory.getLogger(RemoteLockMapImpl.class);
    private static URL lockservlet = null;

    private PersistenceBroker getBroker() {
        return TxManagerFactory.instance().getCurrentTransaction().getBroker();
    }

    @Override
    public LockEntry getWriter(Object object) {
        PersistenceBroker persistenceBroker = this.getBroker();
        Identity identity = new Identity(object, persistenceBroker);
        LockEntry lockEntry = null;
        try {
            lockEntry = this.getWriterRemote(identity);
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
        }
        return lockEntry;
    }

    private LockEntry getWriterRemote(Identity identity) throws MalformedURLException, IOException, ProtocolException, ClassNotFoundException {
        byte by = 119;
        byte[] byArray = this.buildRequestArray(identity, by);
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        LockEntry lockEntry = (LockEntry)objectInputStream.readObject();
        objectInputStream.close();
        httpURLConnection.disconnect();
        return lockEntry;
    }

    private HttpURLConnection getHttpUrlConnection() throws MalformedURLException, IOException, ProtocolException {
        URL uRL = this.getLockserverUrl();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setUseCaches(false);
        return httpURLConnection;
    }

    private byte[] buildRequestArray(Object object, byte by) throws IOException {
        byte[] byArray = this.serialize(object);
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, 1, n);
        return byArray2;
    }

    private URL getLockserverUrl() throws MalformedURLException {
        return lockservlet;
    }

    @Override
    public Collection getReaders(Object object) {
        Collection collection = null;
        try {
            Identity identity = new Identity(object, this.getBroker());
            byte by = 114;
            byte[] byArray = this.buildRequestArray(identity, by);
            HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
            bufferedOutputStream.write(byArray, 0, byArray.length);
            bufferedOutputStream.flush();
            InputStream inputStream = httpURLConnection.getInputStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            collection = (Collection)objectInputStream.readObject();
            objectInputStream.close();
            bufferedOutputStream.close();
            httpURLConnection.disconnect();
        }
        catch (Throwable throwable) {
            throw new PersistenceBrokerException(throwable);
        }
        return collection;
    }

    @Override
    public boolean addReader(TransactionImpl transactionImpl, Object object) {
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(object), LockEntry.LOCK_READ);
            this.addReaderRemote(lockEntry);
            return true;
        }
        catch (Throwable throwable) {
            this.log.error("Cannot store LockEntry for object " + object + " in transaction " + transactionImpl, throwable);
            return false;
        }
    }

    private void addReaderRemote(LockEntry lockEntry) throws IOException, ClassNotFoundException {
        byte by = 97;
        byte[] byArray = this.buildRequestArray(lockEntry, by);
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Boolean bl = (Boolean)objectInputStream.readObject();
        objectInputStream.close();
        bufferedOutputStream.close();
        httpURLConnection.disconnect();
        if (!bl.booleanValue()) {
            throw new PersistenceBrokerException("could not add reader!");
        }
    }

    public byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    @Override
    public void removeReader(TransactionImpl transactionImpl, Object object) {
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID());
            this.removeReaderRemote(lockEntry);
        }
        catch (Throwable throwable) {
            this.log.error("Cannot remove LockEntry for object " + object + " in transaction " + transactionImpl);
        }
    }

    private void removeReaderRemote(LockEntry lockEntry) throws IOException, ClassNotFoundException {
        byte by = 101;
        byte[] byArray = this.buildRequestArray(lockEntry, by);
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Boolean bl = (Boolean)objectInputStream.readObject();
        objectInputStream.close();
        bufferedOutputStream.close();
        httpURLConnection.disconnect();
        if (!bl.booleanValue()) {
            throw new PersistenceBrokerException("could not remove reader!");
        }
    }

    @Override
    public void removeWriter(LockEntry lockEntry) {
        try {
            this.removeWriterRemote(lockEntry);
        }
        catch (Throwable throwable) {
            this.log.error("Cannot remove LockEntry", throwable);
        }
    }

    private void removeWriterRemote(LockEntry lockEntry) throws IOException, ClassNotFoundException {
        byte by = 109;
        byte[] byArray = this.buildRequestArray(lockEntry, by);
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Boolean bl = (Boolean)objectInputStream.readObject();
        objectInputStream.close();
        bufferedOutputStream.close();
        httpURLConnection.disconnect();
        if (!bl.booleanValue()) {
            throw new PersistenceBrokerException("could not remove writer!");
        }
    }

    @Override
    public boolean upgradeLock(LockEntry lockEntry) {
        try {
            this.upgradeLockRemote(lockEntry);
            lockEntry.setLockType(LockEntry.LOCK_WRITE);
            return true;
        }
        catch (Throwable throwable) {
            this.log.error("Cannot upgrade LockEntry " + lockEntry, throwable);
            return false;
        }
    }

    private void upgradeLockRemote(LockEntry lockEntry) throws IOException, ClassNotFoundException {
        byte by = 117;
        byte[] byArray = this.buildRequestArray(lockEntry, by);
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Boolean bl = (Boolean)objectInputStream.readObject();
        objectInputStream.close();
        bufferedOutputStream.close();
        httpURLConnection.disconnect();
        if (!bl.booleanValue()) {
            throw new PersistenceBrokerException("could not remove writer!");
        }
    }

    @Override
    public boolean setWriter(TransactionImpl transactionImpl, Object object) {
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(object), LockEntry.LOCK_WRITE);
            this.setWriterRemote(lockEntry);
            return true;
        }
        catch (Throwable throwable) {
            this.log.error("Cannot set LockEntry for object " + object + " in transaction " + transactionImpl);
            return false;
        }
    }

    private void setWriterRemote(LockEntry lockEntry) throws IOException, ClassNotFoundException {
        byte by = 115;
        byte[] byArray = this.buildRequestArray(lockEntry, by);
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Boolean bl = (Boolean)objectInputStream.readObject();
        objectInputStream.close();
        bufferedOutputStream.close();
        httpURLConnection.disconnect();
        if (!bl.booleanValue()) {
            throw new PersistenceBrokerException("could not set writer!");
        }
    }

    @Override
    public boolean hasReadLock(TransactionImpl transactionImpl, Object object) {
        try {
            LockEntry lockEntry = new LockEntry(new Identity(object, this.getBroker()).toString(), transactionImpl.getGUID());
            boolean bl = this.hasReadLockRemote(lockEntry);
            return bl;
        }
        catch (Throwable throwable) {
            this.log.error("Cannot check read lock for object " + object + " in transaction " + transactionImpl, throwable);
            return false;
        }
    }

    private boolean hasReadLockRemote(LockEntry lockEntry) throws IOException, ClassNotFoundException {
        byte by = 104;
        byte[] byArray = this.buildRequestArray(lockEntry, by);
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Boolean bl = (Boolean)objectInputStream.readObject();
        objectInputStream.close();
        bufferedOutputStream.close();
        httpURLConnection.disconnect();
        return bl;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        String string = configuration.getString("LockServletUrl", "http://127.0.0.1:8080/ojb-lockserver");
        try {
            lockservlet = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException("Invalid LockServlet Url was specified: " + string, malformedURLException);
        }
    }
}

