/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.sys.impl.monitor;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.HttpUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.UserSession;

public class MonitoringFilter
implements Filter {
    private static final String KIM_MONITORING_VIEW_ID = "monitoring";
    private PermissionService permissionService;
    private GlobalVariableService globalVariableService;
    private boolean monitoringEnabled;

    public void init(FilterConfig filterConfig) {
        this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        this.permissionService = KcServiceLocator.getService(PermissionService.class);
        ConfigurationService configurationService = (ConfigurationService)KcServiceLocator.getService("kualiConfigurationService");
        this.monitoringEnabled = configurationService.getPropertyValueAsBoolean("kc.monitoring.enabled");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserSession session;
        UserSession userSession = session = this.getGlobalVariableService().getUserSession() != null ? this.getGlobalVariableService().getUserSession() : (UserSession)((HttpServletRequest)request).getSession().getAttribute("UserSession");
        if (session == null || !this.getPermissionService().isAuthorizedByTemplate(session.getPrincipalId(), "KR-KRAD", "Open View", Collections.singletonMap("viewId", KIM_MONITORING_VIEW_ID), Collections.emptyMap())) {
            HttpUtils.disableCache((HttpServletResponse)response);
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        if (!this.monitoringEnabled) {
            HttpUtils.disableCache((HttpServletResponse)response);
            response.getWriter().write("Monitoring has been disabled.");
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.globalVariableService = null;
        this.permissionService = null;
        this.monitoringEnabled = false;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setMonitoringEnabled(boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }
}

