/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.bo.CostShareType;
import org.kuali.rice.core.api.util.AbstractKeyValue;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.springframework.stereotype.Component;

@Component(value="costShareTypeValuesFinder")
public class CostShareTypeValuesFinder
extends UifKeyValuesFinderBase {
    private BusinessObjectService businessObjectService;

    public List<KeyValue> getKeyValues() {
        Collection costSharetypes = this.getBusinessObjectService().findMatching(CostShareType.class, Collections.singletonMap("active", "true"));
        return Stream.concat(Stream.of(ValuesFinderUtils.getSelectOption()), costSharetypes.stream().map(costShareType -> new ConcreteKeyValue(costShareType.getCostShareTypeCode().toString(), costShareType.getDescription())).sorted(Comparator.comparing(AbstractKeyValue::getValue, String.CASE_INSENSITIVE_ORDER))).collect(Collectors.toList());
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

